// Copyright 1995 Barbara Liskov

#ifndef _LEX_INPUT_H
#define _LEX_INPUT_H

#ifdef __cplusplus
extern "C" {
#endif
#include <stdio.h>

extern void cmp_start_lex_input_file(FILE *f, int *lineno);
extern void cmp_start_lex_input_string(char *s, int *lineno);
/* Called from user to specify where input should come from.
   Only one user is allowed at one time; "finish_lex_input"
   must be called to release the resource. */

extern char cmp_file_input();
extern char cmp_string_input();
extern char cmp_lex_input();

extern void cmp_file_unput(char c);
extern void cmp_string_unput(char c);
extern void cmp_lex_unput(char c);

extern void cmp_finish_lex_input();   /* See above. */

extern void cmpyy_restart_file(FILE *f);   /* See above. */
extern void cmpyy_restart(FILE *f);   /* See above. */
extern void cmpyy_restart_string(char *s);   /* See above. */
extern void cmpyy__scan_string(char *s);

#define FLEX_SCANNER

#ifdef __cplusplus
 }
#endif

#endif /* _LEX_INPUT_H */
