/* Copyright 1995 Barbara Liskov */

#ifdef STANDALONE
#ifndef _STRING_H
#define _STRING_H

#ifdef __cplusplus
extern "C" {
#endif

#include <string.h>
#include <malloc.h>
#include <stdlib.h>

// These declare equivalents for the Thor string functions to let us compile
//  without the FE present

typedef char *string;

#define string_charp(s) s

#define string_new(s)  strcpy((char *)malloc(strlen(s) + 1), s)

#define string_equal(s1, s2)  !strcmp(s1, s2)

#ifdef __cplusplus
}
#endif

#endif /* _STRING_H */
#else
#include "types/str.h"
#include "types/string_class.h"
#define ccp const char*
#include <malloc.h>
#include <stdlib.h>
#endif
