// ======================= Modules ==============================
NODE(Module, ParseNode, `SpecModuleT, ImplModuleT', );

NODE(SpecModule, Module, ,
     LIST(SpecElt), specs);

NODE(SpecElt, ParseNode, `TypeIntfT, RoutineSpecT, SpecEquateT' );

NODE(TypeIntf, SpecElt, ,
     Id*, id,
     LIST(Parm), parms, 
     LIST(SuperInfo), supers,	
     LIST(Restriction), wheres,
     LIST(RoutineIntf), methods);

NODE(RoutineIntf, ParseNode, `ProcHeaderT, IterHeaderT, MakeHeaderT',
     Id*, id,
     Signature*, signature);

NODE(Signature, ParseNode, `ProcSigT, IterSigT, MakeSigT',
     LIST(Parm), parms,
     LIST(Decl), args,
     LIST(TypeSpec), returns,
     LIST(Exception), signals,
     LIST(Restriction), where);

NODE(RoutineSpec, SpecElt, ,
     RoutineIntf*, routine);

NODE(SpecEquate, SpecElt, ,
     Equate *, equate);

NODE(Equate,ParseNode, `TypeEquateT, ExprEquateT' ,);

NODE(ExprEquate, Equate,,
     Id*, id,
     Expr*, expr);

NODE(TypeEquate, Equate,,
     Id*, id,
     TypeSpec*, typ);

NODE(ImplModule, Module, ,
     LIST(Id), exports,
     LIST(Equate), equates,
     LIST(ImplElt), impls);

NODE(ImplElt, ParseNode, `RoutineDefT, ClassDefT, ImplEquateT', );

NODE(RoutineDef, ImplElt,  ,
     RoutineIntf*, routineIntf,
     Body*, body,
     ClassDef*, cdef);

NODE(ImplEquate, ImplElt, ,
     Equate *, equate);

NODE(ClassDef, ImplElt, ,
     Id*, classId,
     TypeSpec*, deftype,
     LIST(Parm), parms, 
     LIST(Restriction), wheres,
     Inherit*, inherits,
     LIST(Id), provides,
     LIST(Id), hides,
     int, immutable,
     LIST(Equate), equates,
     LIST(Decl), decl,
     LIST(ClassElt), classElts);

NODE(ClassElt, ParseNode, `MethodOrOpDefT, EquateT' );

NODE(Inherit, ParseNode,,
     TypeSpec*, classSpec);

NODE(Renaming, ParseNode,, Expr*, from, Id*, to);

// unused
NODE(Export, ParseNode,,
     LIST(Id), exported);

NODE(MethodOrOpDef, ParseNode,,
     int, isOp,
     int, IsConstr,
     RoutineDef*,routineDef);

NODE(Parm, ParseNode,, LIST(Id), ids);

// unused
NODE(Formal, ParseNode,, Id*, id, TypeSpec*, typeSpec);

NODE(Exception, ParseNode,,
     Id*, id,
     LIST(TypeSpec), typeSpec);

NODE(Restriction, ParseNode,,
     Id*, TypeId,
     LIST(RoutineIntf), operations);

NODE(TypeSpec, ParseNode,`SimpleTypeSpecT, ParamTypeSpecT, TaggedTypeSpecT,
	RoutineTypeSpecT',);

NODE(TypeName, ParseNode,,
     Id*, name);
      
NODE(TypeObject, ParseNode,,
     TypeInterface*, leaf_type);

NODE(SimpleTypeSpec, TypeSpec,,
     TypeName*, name);

NODE(ParamTypeSpec, TypeSpec,,
     TypeName*, name,
     LIST(ActualParm), actualParms);

NODE(TaggedTypeSpec, TypeSpec,,
     TypeName*, name,
     LIST(Field), fields);

NODE(RoutineTypeSpec, TypeSpec,,
     Signature*, signature);

NODE(ActualParm, ParseNode,, 
     TypeSpec*, typeSpec,
     LIST(ParmOp), newNames);

NODE(ParmOp, ParseNode,, Expr*, primary, Id*, id);

// ======================= Statements ===========================

/* Stmt */


// DeclT doesn't belong in the following list
NODE(Stmt, ParseNode, `DeclStmtT, InitVarExprT, InitVarInvokeT, DeclT,
AssignInvokeT, AssignExprStmtT, AssignExprT, InvokeStmtT,
WhileStmtT, IfStmtT, TagcaseT, TypecaseT, ReturnStmtT,
YieldT, SignalStmtT, ExitT, BreakT, ContinueT, BlockStmtT,
ResignalStmtT, ExceptStmtT, InitT, DeclForStmtT, ForStmtT', );

NODE(DeclStmt, Stmt,,
     Decl*, decl);

NODE(Decl,ParseNode,`RegDeclT, ImplDeclT',);

NODE(RegDecl, Decl,,
     LIST(Id), ids,
     TypeSpec*, typeSpec);

NODE(ImplDecl,Decl,,
     Id*, id,
     TypeSpec*, typeSpec,
     Id*, get,
     Id*, set);

NODE(InitVarExpr, Stmt,,
	Decl*, decl,
	Expr*, expr);

NODE(InitVarInvoke, Stmt,,
     LIST(Decl), decls,
     Invoc*, invoc);


// unused
NODE(AssignInvoke, Stmt,,
     LIST(IdOrIvar), idOrIvars,
     Invoc*, invoc);

NODE(AssignExprStmt, Stmt,,
     LIST(Expr), ids,
     LIST(Expr), exprs);


// unused
NODE(AssignExpr, Stmt,,
     Expr*, primary,
     Expr*, primaryExpr,
     Expr*, expr);

NODE(InvokeStmt, Stmt,, Invoc*, invoc);

NODE(WhileStmt, Stmt,, Expr*, expr,  Body*, body);

NODE(IfStmt, Stmt,,
     Expr*, expr,
     Body*, body,
     LIST(ElseIf), elseifs,
     Body*, elsebody);

NODE(DeclForStmt, Stmt,,
     LIST(Decl), decls,
     Invoc*, invoc,
     Body*, body);

NODE(ForStmt, Stmt,,
     LIST(Id), ids,
     Invoc*, invoc,
     Body*, body);

NODE(Tagcase, Stmt,,
     Expr*, expr,
     LIST(TagWhenArm), tagWhenArms,
     Body*, body);


NODE(Typecase, Stmt,,
     Expr*, expr,
     LIST(TypeWhenArm), typeWhenArms,
     Body*, body);

NODE(TypeWhenArm, ParseNode,,
     TypeSpec*, typ,
     Id*, id,
     Body*, body);

NODE(ReturnStmt, Stmt,,
     LIST(Expr), exprs);

NODE(Yield, Stmt,,
     LIST(Expr), exprs);

NODE(SignalStmt, Stmt,,
     Id*, id,
     LIST(Expr), exprs);

NODE(Exit, Stmt,,
     Id*, id,
     LIST(Expr), exprs);

NODE(BlockStmt, Stmt,,
     Body*, body);

NODE(ResignalStmt, Stmt,,
     Stmt*, stmt,
     LIST(Id), ids);

NODE(ExceptStmt, Stmt,,
     Stmt*, stmt,
     LIST(ExWhenArm), exWhenArm,
     Decl*, decl,
     Body*, body);

NODE(Init, Stmt,,
     LIST(FieldInit), fieldInits,
     Invoc*, invoc,
     Body*, body,
     ClassDef*, cdef);

NODE(IdOrIvar, ParseNode,,
     Expr*, primary,		/* null if no primary */
     Id*, id);

NODE(Body, ParseNode,,
     LIST(Equate), equates,
     LIST(Stmt), statements);

NODE(ElseIf, ParseNode,,
     Expr*, expr,
     Body*, body);

NODE(TagWhenArm, ParseNode,,
     LIST(Id), ids,
     Decl*, decl,
     Body*, body);

NODE(ExWhenArm, ParseNode,,
     LIST(Id), names,
     LIST(Decl), decls,
     Body*, body);

// apparently unused
NODE(OthersHandler, ParseNode,,
     Id*, id,
     TypeSpec*, typeSpec,
     Body*, body);

NODE(FieldInit, ParseNode,, 
     Id*, id,
     Expr*, expr);


// ======================= Expressions ==========================
NODE(Expr, ParseNode, `NilT, LiteralT, InstantiationT,
      DotExprT, SuperIdT, SelfT, NewT, ArrayRefT, InvocExprT,
      BindingExprT, SelectorConstrT, ArrayConstrT, IdExprT, BinaryT,
      UnaryT, BracketRefT, BraceRefT, IllegalExprT',);

NODE(BracketRef, Expr,,
     Expr*, primary,
     LIST(Expr), exprs);

NODE(BraceRef, Expr,,
     Expr*, primary,
     LIST(Expr), exprs);

NODE(Binary, Expr, `PlusT, MinusT, TimesT, DividesT, ModuloT, PowerT, AndT,
OrT, LTT, LTET, GTT, GTET, EqualT, ConcatT, NLTT, NLTET, NGTET, NGTT,
NotEqualT, EqualEqualT, NotEqualEqualT', Expr*, op1, Expr*, op2);

NODE(Unary, Expr,`NotT, MinusT', Expr*, op);

NODE(Literal, Expr, `IntLiteralT, BoolLiteralT, CharLiteralT, 
	StringLiteralT, RealLiteralT',);

NODE(IntLiteral, Literal,,
     int, i);

NODE(BoolLiteral, Literal,,
     int, b);	/* Make proper boolean type! */

NODE(CharLiteral, Literal,,
     char, c);

NODE(RealLiteral, Literal,,
     double, r);

NODE(StringLiteral, Literal,,
     string, s);

NODE(Instantiation, Expr,,
     TypeSpec*, otypeSpec,
     Id*, id,
     LIST(ActualParm), actualParms);

NODE(DotExpr, Expr,,
     Expr*, primary,
     Expr*, id);

NODE(SuperId, Expr,,
     Id*, id);

NODE(IdExpr, Expr,,
     Id*, id);

NODE(ArrayRef, Expr,,
     Expr*, primary,
     Expr*, expr);

NODE(InvocExpr, Expr,,
     Invoc*, invoc);

NODE(BindingExpr, Expr,,
     Binding*, binding);

NODE(SelectorConstr, Expr,,
     TypeSpec*, typeSpec,
     LIST(FieldInit), fields,
     Invoc*, invoc);

NODE(ArrayConstr, Expr,,
     TypeSpec*, typeSpec,
     Expr*, size,
     LIST(Expr), exprs);

NODE(Invoc, ParseNode,,
     RoutineId*, routineId,
     LIST(Expr), exprs,
     LIST(Expr), lastarg,
     Expr*, lastargType);

NODE(RoutineId, ParseNode, `SimpleRoutineIdT, ComplexRoutineIdT, SuperClassRoutineIdT',);

NODE(SimpleRoutineId, RoutineId,,
     Expr*, primary);

NODE(ComplexRoutineId, RoutineId,,
     Expr*, primary,
     LIST(ActualParm), parms);

NODE(SuperClassRoutineId, RoutineId,,
     Id*, id);

NODE(SuperInfo, ParseNode,,
     TypeSpec*, typespec,
     LIST(Renaming), renamings);

NODE(Binding, ParseNode,,
     Expr*, proc,
     LIST(BindingArg), args,
     LIST(Expr), lastarg,
     Expr*, lastargType);

NODE(BindingArg, ParseNode,,  Expr*, expr); /* if expr is null, indicates "*" */

NODE(Field, ParseNode,, LIST(Id*),ids, TypeSpec*, typeSpec);

NODE(Id, ParseNode,, string, id);

