// A Compiler Parse Tree Format, based on the reference grammar in the
// draft Theta Reference Manual

#include "xlist.h"
#include "my_string.h"
#include "traverse.h"
#include "environment.h"
#include <stdio.h>
extern int cmpyy_lineno;
include(`parseMacrosCC.m4')

// We first declare all of the node classes used in the parse tree

DECLARE_NODES(Module,SpecModule,RoutineSpec,ProcHeader,IterHeader,MakeHeader,EquateModule,
    Decl, Equate,TypeEquate,ConstEquate,ImplModule,Impl,RoutineDef,ClassDef,
    Renaming,Export,MethodOrOpDef,Parm,Formal,Exception,Restriction,
    TypeSpec,BasicTypeSpec,ComplexTypeSpec,ActualParm,ParmOp,Stmt,DeclStmt,
    InitVarExpr,InitVarInvoke,AssignInvoke,AssignExprStmt,AssignExpr,
    InvokeStmt,WhileStmt,IfStmt,Tagcase,Typecase,ReturnStmt,Yield,SignalStmt,Exit,
    BlockStmt,ResignalStmt,ExceptStmt,IdOrIvar,Body,ElseIf,TagWhenArm,ExWhenArm,
    OthersHandler,FieldInit,Expr,Binary,Unary,Literal,Instantiation,
    DotExpr,SuperId,ArrayRef,BracketRef,BraceRef,InvocExpr,BindingExpr,
    SelectorConstr,ArrayConstr,Invoc,RoutineId,SimpleRoutineId,
    ComplexRoutineId,Binding,BindingArg,Field,Id,
    Signature, TypeWhenArm, Inherit, RoutineSpecModule, SuperInfo, 
    IntLiteral, CharLiteral, StringLiteral, RealLiteral, IdExpr,
    TypeExtModule, Id,
    Dummy)

// The "Node" macro is used to automatically create a class for a 
// parse tree node with tags, a constructor, and fields.
//
// See parseMacros.h for details of what node expands to.

// ParseNode is the superclass of all Parse node classes.  If the superclass
// argument in `NODE' is left blank, ParseNode will be used.


#define DEBUG_FLAG  0
// If debug_flag is nonzero, each object prints itself out after being created

class ParseNode {
  public:
    enum Tag { SignatureT, ImplEltT, InheritT, RenamingT, ExportT,
		   MethodOrOpDefT, ParmT, FormalT, ExceptionT,
		   RestrictionT, TypeSpecT, TypeNameT, ActualParmT,
		   ParmOpT, IdOrIvarT, BodyT, ElseIfT, TagWhenArmT,
		   ExWhenArmT, OthersHandlerT, FieldInitT, InvocT,
		   RoutineIdT, SuperInfoT, BindingT, BindingArgT,
		   FieldT, IdT, ModuleT, SpecEltT, RoutineIntfT, StmtT, ExprT,
		   EquateT, DeclT, TypeWhenArmT, TypeObjectT, ClassEltT};
    Tag tag_;
    TypeInterface *type_;
    int line;
    tag();
    TypeInterface *get_type();
    int get_line();

    ParseNode(Tag tag ) :  tag_(tag),  type_(new TypeInterface()),
		line(cmpyy_lineno) {} 

    ParseNode(int lineno, Tag tag) :  tag_(tag),  type_(new TypeInterface()),
		line(lineno) {} 

    virtual void print(int spaces)=0;
    virtual ParseNode* traverse(TraverseObj *tobj)=0;
};

    ParseNode::tag() { return tag_; }
    TypeInterface *ParseNode::get_type() { return type_; }
    int ParseNode::get_line() { return line; }

typedef xlist<ParseNode*> ParseNodeList;


#define put_spaces(count) {int i=count; while (i--) putchar(' ');}
void print_parsenode_list(ParseNodeList *lp, int spaces)
{
    ParseNodeList l = *lp;	/* for readability */
    for (Pix p = l.first(); p; l.next(p)) {
	l(p)->print(spaces);
    }}


ParseNodeList* traverse_parsenode_list(ParseNodeList *lp, TraverseObj *tobj)
{
    ParseNodeList l = *lp;
    ParseNodeList *new_list = new ParseNodeList();
    
    for (Pix p = l.first(); p; l.next(p)) {
	ParseNode *new_node = l(p)->traverse(tobj);
	new_list->append(new_node);
    }

    return new_list;
}

include(`parse.m4')

END_NODES
