// ========================= M4 stuff ===========================
//
// The `TAG' macro is used to add a tag to the class. The usage is
// `TAG(CLASS, `tag1, tag2, tag3 ...')'. The tag of an object of this
// class can be accessed using the "tag" method. The possible
// tag values are named "CLASS::tag1", "CLASS::tag2", etc.
// A constructor "CLASS(CLASS::Tag)" is also created. It initializes
// only the tag.

// This next bit looks like a comment, but m4 notices it just fine.
// It's commented to allow "grind" to do the right thing.
/* 
 define(`TAG', 
`public:			 
    enum Tag { `$2' };
    tag();
   private:		
    Tag tag_')
*/
    
// The "Node" macro is used to automatically _define a class for a 
// parse tree node with tags, a constructor, and fields.
//
// The usage is  "Node(CLASSNAME, SUPERCLASS, `tag1, tag2, ...',
//		       TYPE1, FIELDNAME1,
//		       TYPE2, FIELDNAME2,
//		       ...
// (The SUPERCLASS, tags, and fields arguments can be left blank to omit them.)
//
// This expands to:
//
//   class CLASSNAME : SUPERCLASS {
//     public:	
//      [enum Tag {CLASS::tag1, ...};]   // here if tags are not empty
//	[tag() { return tag_;}]
//	
//      TYPE1 get_FIELDNAME1() {...}  	   		// get method
//      void set_FIELDNAME1(TYPE1 val) {...}		// set method
//      ...<the same thing for all of the other fields>...
//
//      CLASSNAME([Tag tag], TYPE1 FIELDNAME1, ...) :             // constructor
//	  [SUPERCLASS(SUPERCLASS::CLASSNAMET) ,]
//        [_tag(tag),]
//	  FIELDNAME1_(FIELDNAME1)
//	  ... {};
//
//      CLASSNAME(const CLASSNAME& o) : ...:  		          // copy constr.
//
//     private:
//	 Tag tag_;
//	 TYPE1 FIELDNAME1_;
//       ...;
//   };

// Pardon the grunge below... Nicely formatted m4 output requires weird m4
// macro formatting.

define(`NODE',
`class $1 ifelse(`$2', `', `: public ParseNode' ,`: public `$2'') {
   ifelse(`$3', `',,`TAG(`$1',`$3');IMPL_TAG($1)')
   ifelse(`$4', `',,
` private:
 VARS(shift(shift(shift($@))))')
    public: PRINT_METHOD($1, `shift(shift(shift($@)))')
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
ifelse(`$4', `', , `ACCESSORS($1, `shift(shift(shift($@)))')')
// Constructors
      $1(ifelse(`$3', `',,`Tag tag ifelse(`$4', `',,`,')')CONSTARGS(shift(shift(shift($@))))); IMPL_CONSTR($@)

      $1(int lineno ifelse(`$3',`', `ifelse(`$4',`',,`,')',`,') ifelse(`$3', `',,` Tag tag ifelse(`$4', `',,`,')')CONSTARGS(shift(shift(shift($@))))); IMPL_LCONSTR($@)

// Copy Constructors
      $1(const $1& o); IMPL_COPY($@)
   
}')

// VARS: declare instance variables for each (type,name) pair
 define(`VARS', `ifelse($#, 0,, $#, 1,,
`     $1 $2_; 
 VARS(shift(shift($@)))')')

// ACCESSORS: declare get and set methods for each (type,name) pair       
define(ACCESSORS, `divert(1) 
// Accessor Implementations
IMPL_ACCESSORS($1, $2)
divert(0)
DECL_ACCESSORS($2)
')

define(IMPL_TAG, `divert(1) $1::tag() {return tag_;} divert(0)')

define(DECL_ACCESSORS, `ifelse(`$#', 0,, `$#', 1,, `      $1 get_$2();
      void set_$2($1 val);
DECL_ACCESSORS(shift(shift($@)))')')

define(IMPL_ACCESSORS,
`ifelse(`$#', 0,, `$#', 1,, `$#', 2,, `
$2 $1::get_$3() {return $3_;}
void $1::set_$3($2 val) {$3_ = val;}
IMPL_ACCESSORS($1, shift(shift(shift($@))))')'
)

define(PRINT_METHOD, 
`divert(1)
void $1::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("$1:\n");
   if (type_) {put_spaces(spaces+11); type_->print(0);}
PRINT_FIELDS($2)
}

ParseNode* $1::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    $1* new_node = new $1(*this);
TRAVERSE_FIELDS($2)
    return new_node;
}


divert(0)')

define(CONSTR_NEW_NODE, `ifelse($#, 0,, $#, 1,,
`new_$2 ifelse($#, 2, ,``,'') CONSTR_NEW_NODE(shift(shift($@)))')')

    
define(`PRINT_FIELDS', `ifelse($#, 0,, $#, 1,,
`  ifelse($1, int, `put_spaces(spaces+11); printf("$1:%d\n",$2_);',
       $1, char,  `put_spaces(spaces+11); printf("$1:%c\n",$2_);',
       $1, real, `put_spaces(spaces+11); printf("$1:%f\n",$2_);',
       $1, double, `put_spaces(spaces+11); printf("$1:%lf\n",$2_);',
       $1, string, `put_spaces(spaces+11); printf("\"%s\"\n", string_charp($2_));',
       $1, bool, `put_spaces(spaces+11); printf("%s\n",$2_ ? "TRUE" :
FALSE);',
       index($2, `leaf_'), -1, 
       ifelse(index($1, `ParseNodeList'), -1, 
       ` if ($2_) {$2_->print(spaces+3);}; ',
       ` if ($2_) {print_parsenode_list($2_, spaces+3);};'))
PRINT_FIELDS(shift(shift($@)))')')

define(`TRAVERSE_FIELDS', `ifelse($#, 0,, $#, 1,,
`   ifelse($1, int, ``new_node->$2_ = $2_;'',
        $1, char,  ``new_node->$2_ = $2_;'',
        $1, real, ``new_node->$2_ = $2_;'',
        $1, double, ``new_node->$2_ = $2_;'',
        $1, string, ``new_node->$2_ = $2_;'',
        $1, bool, ``new_node->$2_ = $2_;'',
        index($2, `leaf_'), -1, 
        ifelse(index($1, `ParseNodeList'), -1, 
        ` new_node->$2_ = $2_ ? ($1)$2_->traverse(tobj) : 0; ',
        ` new_node->$2_ = $2_ ? traverse_parsenode_list($2_,tobj):0;'))
TRAVERSE_FIELDS(shift(shift($@)))')')

// CONSTARGS: declare  constructor arguments for each (type,name) pair	      
define(`CONSTARGS', `ifelse($#, 0, , $#, 1, , `$1 $2 ifelse($#, 2, ,``,'') CONSTARGS(shift(shift($@)))')')

// CONSTBODY: the body of the constructor
define(`CONSTBODY', `ifelse($#, 0, , $#, 1, ,`$2_($2)ifelse($#, 2, ,``,'') CONSTBODY(shift(shift($@)))')')

// CONSTBODY: the body of the copy constructor
define(`CONSTBODY2', `ifelse($#, 0, , $#, 1, ,`$2_(o.$2_)ifelse($#, 2, ,``,'') CONSTBODY2(shift(shift($@)))')')
    
define(`DECLARE_NODES', `ifelse($#,0,, $#,1,, 
`     class $1; 
 DECLARE_NODES(shift($@))')')

// Normal Constructor Implementation
define(IMPL_CONSTR, `divert(1)
// Constructor Implementations

$1::$1(ifelse(`$3', `',,`Tag tag ifelse(`$4', `',,`,')')CONSTARGS(shift(shift(shift($@))))) : ifelse(`$2',`',,`$2($2::$1T),') ifelse(`$3',`',,`tag_(tag)ifelse(`$4', `',,`,')') CONSTBODY(shift(shift(shift($@)))) 
	{}
divert(0)')

// Line-Number Preserving Constructor Implementation
define(IMPL_LCONSTR, `divert(1)
$1::$1(int lineno ifelse(`$3',`', `ifelse(`$4',`',,`,')',`,') ifelse(`$3', `',,` Tag tag ifelse(`$4', `',,`,')')CONSTARGS(shift(shift(shift($@))))) : ifelse(`$2',`',,`$2(lineno, $2::$1T),') ifelse(`$3',`',,`tag_(tag)ifelse(`$4', `',,`,')') CONSTBODY(shift(shift(shift($@)))) 
	{line = lineno;}
divert(0)')

// Copy Constructor Implementation
define(IMPL_COPY, `divert(1)
$1::$1(const $1& o) : ifelse(`$2',`',,`$2($2::$1T),') ifelse(`$3',`',,`tag_(o.tag_) ifelse(`$4', `',,`,')') CONSTBODY2(shift(shift(shift($@))))
	{line = o.line; type_ = o.type_; }
divert(0)')
   
define(`LIST', `ParseNodeList*')

// The end of the file must have END_NODES so that the print methods can be generated.    
define(END_NODES, `undivert(1)')

