/* Copyright 1995 Barbara Liskov */

%{
#include "my_string.h"
#include "theta.tab.h"
#include <ctype.h>
extern int yylineno;

#undef input
#undef unput
#undef output

#define output(c)
#define input() cmp_lex_input()
#define unput(c) cmp_lex_unput(c)

char cmp_file_input()
{
	return input();
	}

void cmp_file_unput(char c)
{
	unput(c);
	}

#define MAX_STRING 16384
#define DEBUG_FLAG 0

int lexstr(char *s);
int lexchar(char *c);
int  lexhex(char *s);
char *slower(char *s);

extern void yyerror();

void yydocomment();

#define text ((char *)yytext)

%}

special [_]
S [ \t\r]
letter [A-Za-z]
decimal [0-9]
octal [0-7]
uptohex [0-9a-fA-F]
decint {decimal}+
id (({letter}|{special})({letter}|{decimal}|{special})*)
charac (\'([^\'\n\\]|{bscombos})\')
string (\"([^\"\n\\]|{bscombos})*\")
bscombos (\\\\|\\[ntrfbv]|\\\"|\\\'|\\{octal}{octal}{octal})
uptohexnum ({decint}_{uptohexstuff})
uptohexstuff ({uptohex}+)
real (({decint}\.{decint}({exp}?))|(\.{decint}({exp}?))|({decint}{exp})|({decint}\.{exp}))
unreal ({decint}\./[ \t\r\n~*+\-\/<=>,.()[\]&|])
exp ([Ee][+-]?{decint})
       
comment %[^\n]*
handle (#{intstr})
dot (\.)

%%

{S}+            ;
{comment}       ;
"\n"	yylineno++;
