#ifndef _THETA_H
#define _THETA_H

/*
    PUBLIC_THETA_OR defines the name of the node on which the compiler's
    OR (Object Repository) is running.  The format is 

	THOR=<nodename>:<portnumber>

    where nodename is installation specific, i.e., you NEED TO CHANGE
    "note" to something else.
*/

#define PUBLIC_THETA_OR "chord:42"
#define PRIVATE_THETA_OR "chord:97"

enum Action {NONE, PARSE, CHECK, XCHECK, COMPILE, INIT, SHOW, EXPUNGE};
enum ErrorOption {MINIMAL, ONE, SURROUND};
enum Version {THOR_0, THOR_0_1, THOR_1};

/*
#include "binary_veneer.h"
#include "th_Compiler.h"
#include "th_list.h"
#include "th_Class.h"
#include "th_string.h"
#include <unistd.h>
*/
#include "th_Compiler.h"
#include "common/truefalse.h"

typedef char *Token;
typedef char *Result;

class Executor {
public:
	int expunge();
	int show();
	int compile(Token fname);
	int parse(Token fname);
	int check(Token fname);
	int xcheck(Token fname);
	void done();
	int init(char *fe_spec);
	void set_err_opt(ErrorOption eopt) { err_opt = eopt; }
	void set_version(Version v) { version = v; }
	Executor() {
		initted = FALSE;
		err_opt = MINIMAL;
		version = THOR_1;
		}
private:
	void select_version();
	int handle_fname(Token fname, char * &th_fname);
	int process_result(Result result, char *fname);
	Compiler *cmp;
	bool initted;
	ErrorOption err_opt;
	Version version;
};

class Processor {
public:
	int done();
	int process_token(Token t);
	Processor() {
		executor = new Executor();
		action = NONE;
		}
private:
	Executor *executor;
	Action action;
};

class UserIo {
public:
	int get_next_token(Token *tp);

	UserIo(int argc_, char **argv_) {
		argc = argc_;
		argv = argv_;
		argindex = 1;
		}
private:
	int argc;
	char **argv;
	int argindex;
};

#endif /* _THETA_H */
