/* Copyright 1995 Barbara Liskov */
%{
#include <malloc.h>
#include "parse.h"
#include "compiler.h"
#include "string.h"
    
extern void save_where_id(Id *i);
extern Id *get_where_id();
extern void tsl2dl_init();
extern ParseNodeList* tsl2dl(ParseNodeList* pnl);
extern TypeSpec *ex2ts(Expr *ex);
extern Invoc *ex2inv(Expr *ex);
extern Id *exl2id(ParseNodeList *pnl);
extern ParseNodeList* exl2idl(ParseNodeList *pnl);
extern ParseNodeList* exl2lhs(ParseNodeList *pnl);
extern ParseNodeList* exl2apl(ParseNodeList *pnl);
extern ParseNodeList* pl2apl(ParseNodeList *pnl);
extern ParseNodeList* apl2pl(ParseNodeList *pnl);
extern ParseNodeList *apl2exl(ParseNodeList *apl);
extern Id *ex2id(Expr *ex);
extern Expr *ex2deid(Expr *ex);
extern Id *pts_get_name(TypeSpec *pts);
extern ParseNodeList *pts_get_aparms(TypeSpec *pts);
extern TypeWhenArm *ex2twa(Expr *ex, Body *b);
extern RoutineId *ex2rid(Expr *ex);
extern Expr *ts2ex(TypeSpec *ts);
extern bool invalid_field_init(FieldInit *fi);
ParseNodeList *parse_tree;
string err_list;
extern "C" {
extern string int_unparse(int i);
}
%}

/* essentially the same as before.... */
%token MODULE END TYPE CLASS ID EQ INHERITS HIDES PROVIDES
%token LPAREN RPAREN LBRACK RBRACK LCURLY RCURLY
%token YIELDS RETURNS SIGNALS MAKES COLON SEMI COMMA WHERE
%token IMPLEMENTS OP FOR HAS DOTS MAKE BIND ASSIGN CARET
%token IF THEN ELSEIF ELSE WHILE DO IN TAGCASE OTHERS TYPECASE WHEN
%token BEGIN_ RETURN YIELD SIGNAL EXIT BREAK CONTINUE RESIGNAL EXCEPT
%token RECORD STRUCT ONEOF VARIANT
%token SELF DOT
%token PROC ITER
%token TILDE MINUS PLUS STAR EXP MOD DIV CONCAT 
%token LT LE EQ GT GE NEQ CAND COR
%token NIL TRUE_ FALSE_ CHAR STRING REAL INT LexErr
%token CONST_IVARS

%union {
#ifdef  _COMPILER_PARSE_H
     Module* module; 
     ParseNodeList* moduleList; 
     SpecElt* specElt;
     ParseNodeList* specEltList;
     RoutineSpec* routineSpec; 
     RoutineIntf* routineIntf;
     ParseNodeList* routineIntfList; 
     ProcHeader* procHeader; 
     ParseNodeList* procHeaderList; 
     IterHeader* iterHeader; 
     ParseNodeList* iterHeaderList; 
     SuperInfo* superInfo;
     ParseNodeList* superInfoList;
     Decl* decl; 
     ParseNodeList* declList; 
     Equate* equate; 
     ParseNodeList* equateList; 
     TypeEquate* typeEquate; 
     ParseNodeList* typeEquateList; 
     ConstEquate* constEquate; 
     ParseNodeList* constEquateList; 
     ImplModule* implModule; 
     ImplElt* implElt; 
     ParseNodeList* implEltList; 
     RoutineDef* routineDef; 
     ParseNodeList* routineDefList; 
     ClassDef* classDef; 
     ParseNodeList* classDefList;
     Inherit* inherit;
     Renaming* renaming; 
     ParseNodeList* renamingList; 
     Export* export; 
     ParseNodeList* exportList; 
     MethodOrOpDef* methodOrOpDef; 
     ParseNodeList* methodOrOpDefList; 
     Parm* parm; 
     ParseNodeList* parmList; 
     Exception* exception; 
     ParseNodeList* exceptionList; 
     Restriction* restriction; 
     ParseNodeList* restrictionList; 
     TypeSpec* typeSpec; 
     ParamTypeSpec *paramTypeSpec;
     ParseNodeList* typeSpecList; 
     TypeName* typeName;
     ActualParm* actualParm; 
     ParseNodeList* actualParmList; 
     Stmt* stmt; 
     ParseNodeList* stmtList; 
     DeclStmt* declStmt; 
     ParseNodeList* declStmtList; 
     InitVarExpr* initVarExpr; 
     ParseNodeList* initVarExprList; 
     InitVarInvoke* initVarInvoke; 
     ParseNodeList* initVarInvokeList; 
     AssignInvoke* assignInvoke; 
     ParseNodeList* assignInvokeList; 
     AssignExprStmt* assignExprStmt; 
     ParseNodeList* assignExprStmtList; 
     AssignExpr* assignExpr; 
     ParseNodeList* assignExprList; 
     InvokeStmt* invokeStmt; 
     ParseNodeList* invokeStmtList; 
     WhileStmt* while_; 
     ParseNodeList* whileList; 
     IfStmt* ifStmt; 
     ParseNodeList* ifList; 
     Tagcase* tagcase; 
     ParseNodeList* tagcaseList; 
     Typecase* typecase; 
     ParseNodeList* typecaseList; 
     ReturnStmt* returnStmt; 
     ParseNodeList* returnList; 
     Yield* yield; 
     ParseNodeList* yieldList; 
     SignalStmt* signalStmt; 
     ParseNodeList* signalStmtList; 
     Exit* exit; 
     ParseNodeList* exitList; 
     BlockStmt* blockStmt; 
     ParseNodeList* blockStmtList; 
     ResignalStmt* resignalStmt; 
     ParseNodeList* resignalStmtList; 
     ExceptStmt* exceptStmt; 
     ParseNodeList* exceptStmtList; 
     IdOrIvar* idOrIvar; 
     ParseNodeList* idOrIvarList; 
     Body* body; 
     ParseNodeList* bodyList; 
     ElseIf* elseIf; 
     ParseNodeList* elseIfList; 
     TagWhenArm* tagWhenArm; 
     ParseNodeList* tagWhenArmList; 
     ParseNodeList* exWhenArmList; 
     ExWhenArm* exWhenArm; 
     ParseNodeList* whenArmList; 
     OthersHandler* othersHandler; 
     ParseNodeList* othersHandlerList; 
     Init* init;
     FieldInit* fieldInit; 
     ParseNodeList* fieldInitList; 
     Expr* expr;
     IdExpr* idExpr; 
     ParseNodeList* exprList; 
     Binary* binary; 
     Unary* unary; 
     Literal* literal; 
     IntLiteral* intLiteral;
     CharLiteral* charLiteral;
     StringLiteral* stringLiteral;
     DotExpr* dotExpr; 
     ArrayRef* arrayRef; 
     ParseNodeList* arrayRefList; 
     InvocExpr* invocExpr; 
     BindingExpr* bindingExpr; 
     SelectorConstr* selectorConstr; 
     ArrayConstr* arrayConstr; 
     Invoc* invoc; 
     RoutineId* routineId; 
     ParseNodeList* routineIdList; 
     SimpleRoutineId* simpleRoutineId; 
     ParseNodeList* simpleRoutineIdList; 
     ComplexRoutineId* complexRoutineId; 
     SuperClassRoutineId* superClassRoutineId;
     ParseNodeList* complexRoutineIdList; 
     Binding* binding; 
     ParseNodeList* bindingList; 
     BindingArg* bindingArg; 
     ParseNodeList* bindingArgList; 
     Field* field; 
     ParseNodeList* fieldList; 
     Id* id_; 
     ParseNodeList* idList; 
     Signature* signature; 
     ParseNodeList* signatureList; 
     TypeWhenArm* typeWhenArm; 
     ParseNodeList* typeWhenArmList; 
     ParseNodeList* parseNodeList;
#endif
  real r;
  string s;
  char c;
  int i;
}

%type <module> module spec_mod impl_mod
%type <moduleList> module_list
%type <specElt> spec_elt type_intf routine_spec
%type <routineIntf> proc_header iter_header routine_intf make_intf
	make_header
	nf_non_param_routine_header nf_non_param_proc_header
	nf_non_param_iter_header
%type <routineIntfList> routine_list
%type <decl> decl adecl odecl sdecl ivar_decl
%type <declList> decl_list adecl_list sdecl_list args oadecl_list
	ivar_decl_list nf_args
%type <equate> equate
%type <equateList> equate_list
%type <implElt> impl_elt
%type <implEltList> impl_elt_list
%type <routineDef> routine_def
%type <classDef> class_def class_def_rest class_def_end
%type <superInfo> super_info
%type <superInfoList> super_info_list supers osupers
%type <inherit> oinherits
%type <methodOrOpDef> method_or_op_def
%type <methodOrOpDefList> cdef_elts
%type <parm> param
%type <parmList> param_list oparms parms
%type <exception> exception
%type <exceptionList> exception_list osignals
%type <restriction> where_subclause
%type <restrictionList> owhere where_list where_clause_list 
	where_subclause_list
%type <typeSpec> routine_type tagged_type_spec oreltype reltype
%type <typeSpecList> type_spec_list yields makes oreturns oparent_list 
%type <typeName> taggedtype_id
%type <actualParm> actual_param
%type <actualParmList> actual_param_list actual_params
%type <stmt> statement /* assignmnt */ 
%type <stmtList> statement_list ostatements
%type <blockStmt> begin_end
%type <body> body
%type <elseIf> else_if
%type <elseIfList> else_if_list oelse_ifs
%type <tagWhenArm> tag_when_arm
%type <tagWhenArmList> tag_when_arm_list
%type <exWhenArmList> ex_when_arms oex_when_arms
%type <exWhenArm> ex_when_arm
%type <fieldInit> field_init
%type <fieldInitList> field_init_list
%type <init> field_inits
%type <expr> expr primary simple_expr
%type <exprList> expr_list oparen_expr_list oparen_expr_list2
		oparen_expr_list2_contents primaries btrail insides
		mod_export_list
%type <literal> literal int_literal bool_literal char_literal 
	string_literal real_literal
%type <invoc> invoc simple_invoc oinv_args inv_args
%type <routineId>
%type <binding> binding
%type <bindingArg>  bind_arg
%type <bindingArgList> bind_arg_list
%type <field> field
%type <fieldList> field_list
%type <idList> ohides oprovides id_list
%type <id_> id ID where_id
%type <signature> non_param_proc_sig non_param_iter_sig non_param_make_sig
%type <typeWhenArm> type_when_arm
%type <typeWhenArmList> type_when_arm_list


/* Resolve the "dangling else" problem */

%nonassoc THEN
%nonassoc ELSE

/* Operator precedence */

%right DUMMY
%left COR
%left CAND
%left NEQ LT LE EQ GT GE
%left CONCAT PLUS MINUS  
%left MOD STAR DIV
%left EXP
%right TILDE UMINUS CARET
%right LBRACK LCURLY LPAREN
%left DOT

/* RPAREN precedence needed for type_when rule... */

%start module_list

%%

module_list	:	/* empty */
  				{ $$ = new ParseNodeList();
				  parse_tree = $$;
				}
		|	module_list module 
				{ $$ = $1; $$->append($2); }
		;

module		:	spec_mod
				{ $$ = $1; }
		|	impl_mod
				{ $$ = $1; }
		;

spec_mod	:	spec_elt
				{ 
				  $$ = new SpecModule(new ParseNodeList($1));
				}

spec_elt	:	routine_spec
				{ $$ = $1; }
		|	type_intf
				{ $$ = $1; }
		|	equate
				{ $$ = new SpecEquate($1); }
		;

/* specs for makers have been excluded... */
routine_spec	:	routine_intf
				{ $$ = new RoutineSpec($1); }
		;

type_intf	: id EQ TYPE oparms osupers owhere routine_list END id 
				{ if (!match_ids($1, $9))
				  $$ = new TypeIntf($1, $4, $5, $6, $7);
				  else {yyerror("mismatching ids"); YYABORT;}
				}
		| id EQ TYPE oparms osupers owhere END id 
				{ if (!match_ids($1, $8))
				  $$ = new TypeIntf($1, $4, $5, $6, 0);
				  else {yyerror("mismatching ids"); YYABORT;}
				}
		;

routine_list	:	routine_intf
                                { $$ = new ParseNodeList($1); }
		|	routine_list routine_intf
                                { $$ = $1; $$->append($2); }
		;

routine_intf	:	proc_header
				{ $$ = $1; }				
		| 	iter_header
				{ $$ = $1; }
		;

make_intf	:	make_header
				{ $$ = $1; }				
		;

proc_header	:	id parms args oreturns osignals where_list
				{ $$ = new RoutineIntf(
					RoutineIntf::ProcHeaderT, 
					$1,
					new Signature(
					Signature::ProcSigT,
					$2, $3, $4, $5, $6));
				}

		|	id parms args oreturns osignals
				{ $$ = new RoutineIntf(
					RoutineIntf::ProcHeaderT, 
					$1,
					new Signature(
					Signature::ProcSigT,
					$2, $3, $4, $5, 0));
				}
		|	id non_param_proc_sig owhere
				{ $2->set_where($3);
				  $$ = new RoutineIntf(
					RoutineIntf::ProcHeaderT, $1, $2);}
		;

iter_header	:	id parms args yields osignals where_list
				{ $$ = new RoutineIntf(
					RoutineIntf::IterHeaderT, 
					$1,
					new Signature(
					Signature::IterSigT,
					$2, $3, $4, $5, $6));
				}
		|	id parms args yields osignals
				{ new RoutineIntf(
					RoutineIntf::IterHeaderT, 
					$1,
					new Signature(
					Signature::IterSigT,
					$2, $3, $4, $5, 0));
				}
		|	id non_param_iter_sig
				{ $$ = new RoutineIntf(
					RoutineIntf::IterHeaderT, $1, $2); }
		;

make_header	:	id parms args makes osignals where_list
				{ $$ = new RoutineIntf(
					RoutineIntf::MakeHeaderT, 
					$1,
					new Signature(
					Signature::MakeSigT,
					$2, $3, $4, $5, $6));
				}
		|	id parms args makes osignals
				{ new RoutineIntf(
					RoutineIntf::MakeHeaderT, 
					$1,
					new Signature(
					Signature::MakeSigT,
					$2, $3, $4, $5, 0));
				}
		|	id non_param_make_sig
				{ $$ = new RoutineIntf(
					RoutineIntf::MakeHeaderT, $1, $2); }
		;

nf_non_param_routine_header:	nf_non_param_proc_header
				{ $$ = $1; }
		|	nf_non_param_iter_header
				{ $$ = $1; }
		;

non_param_proc_sig:	args oreturns osignals
				{ $$ = new Signature(
					Signature::ProcSigT,
					0, $1, $2, $3, 0);
				}
		;

nf_non_param_proc_header:	nf_args oreturns osignals
				{ $$ = new RoutineIntf(
					RoutineIntf::ProcHeaderT, 0,
					new Signature(
					Signature::ProcSigT,
					0, $1, $2, $3, 0));
				}
		;

nf_non_param_iter_header:	nf_args yields osignals
				{ $$ = new RoutineIntf(
					RoutineIntf::IterHeaderT, 0,
					new Signature(
					Signature::IterSigT,
					0, $1, $2, $3, 0));
				}
		;

non_param_iter_sig:	args yields osignals
				{ $$ = new Signature(
					Signature::IterSigT,
					0, $1, $2, $3, 0);
				}
		;

non_param_make_sig:	args makes osignals
				{ $$ = new Signature(
					Signature::MakeSigT,
					0, $1, $2, $3, 0);
				}
		;


/* primaries s.b. idns, ielts must have at least one cdef or rdef */
/* impl_mod	:	MODULE IMPLEMENTS primaries impl_elt_list END
				{ ParseNodeList *ids = exl2idl($3);
				  if (!ids) {yyerror("id list expected");YYABORT;}
				  $$ = new ImplModule(ids, 0, $4); 
				}
*/
impl_mod	:	MODULE IMPLEMENTS mod_export_list impl_elt_list END
				{ 
				  ParseNodeList *ids = exl2idl($3);
				  if (!ids) {yyerror("id list expected");
						YYABORT;}
				  $$ = new ImplModule(ids, 0, $4); 
				}
		|	MODULE impl_elt_list END
				{ 
				  $$ = new ImplModule(0, 0, $2); 
				}
		;

mod_export_list :	primaries
		;

impl_elt_list	:	impl_elt
				{ $$ = new ParseNodeList($1); }
		|	equate
				{ $$ = new ParseNodeList(new ImplEquate($1)); }
		|	impl_elt_list impl_elt
				{ $$ = $1;
				  $$->append($2);
				}
		|	impl_elt_list equate
				{ $$ = $1;
				  $$->append(new ImplEquate($2));
				}
		;

impl_elt	:	routine_def
				{ $$ = $1; }
		|	class_def
				{ $$ = $1; }
		;

class_def	:	id EQ CLASS oparms oreltype oinherits owhere oprovides ohides class_def_rest
				{ if (!match_ids($1, $10->get_classId())) {
				  $$ = $10;
				  /*
				  TypeSpec *ts = ex2ts($5);
				  if (ts) { $10->set_deftype($5); }
				  */
				  $10->set_parms($4);
				  $10->set_deftype($5);
				  $10->set_inherits($6);
				  $10->set_wheres($7);
				  $10->set_provides($8);
				  $10->set_hides($9);
				  $10->set_immutable(0);
					}
				  else {yyerror("mismatching ids"); YYABORT;}
				}
		;

class_def	:	id EQ CONST_IVARS CLASS oparms oreltype oinherits owhere oprovides ohides class_def_rest
				{ if (!match_ids($1, $11->get_classId())) {
				  $$ = $11;
				  /*
				  TypeSpec *ts = ex2ts($5);
				  if (ts) { $10->set_deftype($5); }
				  */
				  $11->set_parms($5);
				  $11->set_deftype($6);
				  $11->set_inherits($7);
				  $11->set_wheres($8);
				  $11->set_provides($9);
				  $11->set_hides($10);
				  $11->set_immutable(1);
					}
				  else {yyerror("mismatching ids"); YYABORT;}
				}
		;

ohides		:	HIDES id_list
				{ $$ = $2; }
		|	/* empty */
				{ $$ = 0; }
		;

/* note that methodOrOpDefs now may include some equates... */
class_def_rest	:	equate_list ivar_decl_list cdef_elts class_def_end
				{ $$ = $4;
				  $4->set_equates($1);
				  $4->set_decl($2);
				  $4->set_classElts($3);
				}
		|	equate_list ivar_decl_list class_def_end
				{ $$ = $3;
				  $3->set_equates($1);
				  $3->set_decl($2);
				}
		|	ivar_decl_list cdef_elts class_def_end
				{ $$ = $3;
				  $3->set_decl($1);
				  $3->set_classElts($2);
				}
		|	ivar_decl_list class_def_end
				{ $$ = $2;
				  $2->set_decl($1);
				}
		|	equate_list method_or_op_def cdef_elts class_def_end
				{ $$ = $4;
				  $3->prepend($2);
				  $4->set_equates($1);
				  $4->set_classElts($3);
				}
		|	equate_list method_or_op_def class_def_end
				{ $$ = $3;
				  $3->set_equates($1);
				  $3->set_classElts(new ParseNodeList($2));
				}
		|	equate_list class_def_end
				{ $$ = $2;
				  $2->set_equates($1);
				}
/*
		|	method_or_op_def cdef_elts class_def_end
				{ $$ = $3;
				  $2->prepend($1);
				  $3->set_classElts($2);
				}
		|	equate_list cdef_elts class_def_end
				{ $$ = $3;
				  $2->prepend($1);
				  $3->set_classElts($2);
				}
*/
		|	method_or_op_def cdef_elts class_def_end
				{ $$ = $3;
				  $2->prepend($1);
				  $3->set_classElts($2);
				}
		|	method_or_op_def class_def_end
				{ $$ = $2;
				  $2->set_classElts(new ParseNodeList($1));
				}
		|	class_def_end
				{ $$ = $1; }
		;

class_def_end	:	END id
				{ $$ = new ClassDef($2,0,0,0,0,0,0,0,0,0,0); }
		;

cdef_elts	:	method_or_op_def
                                { $$ = new ParseNodeList($1); }
		|	equate
                                { $$ = new ParseNodeList($1); }
		|	cdef_elts method_or_op_def
                                { $$ = $1;
                                  $$->append($2);
                                }
		|	cdef_elts equate
                                { $$ = $1;
                                  $$->append($2);
                                }
		;

oreltype	:
				{ $$ = 0; }
		|	reltype
				{ $$ = $1; }
		;

reltype		:	FOR expr
				{ TypeSpec *ts = ex2ts($2);
				  if (!ts) {yyerror("typespec expected");YYABORT;}
				  $$ = ts; }
		;

ivar_decl	:	primaries COLON expr
				{ ParseNodeList *ids = exl2idl($1);
				  if (!ids) {yyerror("id list expected");YYABORT;}
				  TypeSpec *ts = ex2ts($3);
				  if (!ts) {yyerror("typespec expected");YYABORT;}
				  $$ = new RegDecl(ids, ts); }
		|	primaries COLON routine_type
				{ ParseNodeList *ids = exl2idl($1);
                                  if (!ids) {yyerror("id list expected");YYABORT
;}
				  $$ = new RegDecl(ids, $3); }
		|	primaries COLON tagged_type_spec
				{ ParseNodeList *ids = exl2idl($1);
                                  if (!ids) {yyerror("id list expected");YYABORT
;}
				  $$ = new RegDecl(ids, $3); }
		|	primaries COLON expr IMPLEMENTS id
				{ Id *temp = exl2id($1);
				  if (!temp) {yyerror("id expected");YYABORT;}
				  TypeSpec *ts = ex2ts($3);
				  if (!ts) {yyerror("typespec expected");YYABORT;}
				  $$ = new ImplDecl(temp, ts, $5, 0); }
		|	primaries COLON routine_type IMPLEMENTS id
				{ Id *temp = exl2id($1);
				  if (!temp) {yyerror("id expected");YYABORT;}
				  $$ = new ImplDecl(temp, $3, $5, 0); }
		|	primaries COLON tagged_type_spec IMPLEMENTS id
	 			{ Id *temp = exl2id($1);
				  if (!temp) {yyerror("id expected");YYABORT;}
				  $$ = new ImplDecl(temp, $3, $5, 0); }
		|	primaries COLON expr IMPLEMENTS id COMMA id
				{ Id *temp = exl2id($1);
				  if (!temp) {yyerror("id expected");YYABORT;}
				  TypeSpec *ts = ex2ts($3);
				  if (!ts) {yyerror("typespec expected");YYABORT;}
				  $$ = new ImplDecl(temp, ts, $5, $7); }
		|	primaries COLON routine_type IMPLEMENTS id COMMA id
				{ Id *temp = exl2id($1);
				  if (!temp) {yyerror("id expected");YYABORT;}
				  $$ = new ImplDecl(temp, $3, $5, $7); }
		|	primaries COLON tagged_type_spec IMPLEMENTS id COMMA id
				{ Id *temp = exl2id($1);
				  if (!temp) {yyerror("id expected");YYABORT;}
                                  $$ = new ImplDecl(temp, $3, $5, $7); }
		;

ivar_decl_list	:	ivar_decl
				{ $$ = new ParseNodeList($1); }
		|	ivar_decl_list ivar_decl
				{ $$ = $1;
				  $$->append($2);
				}
		;

oprovides	:	/* empty */
				{ $$ = 0; }
		|	PROVIDES id_list
				{ $$ = $2;
				}
		;

oinherits	:	/* empty */
				{ $$ = 0; }				
		|	INHERITS expr
				{ TypeSpec *ts = ex2ts($2);
				  if (!ts) {yyerror("typespec expected");YYABORT;}
				  $$ = new Inherit(ts); }
		;

method_or_op_def:	routine_def
				{ $$ = new MethodOrOpDef(FALSE, FALSE, $1); }
		|	OP routine_def
				{ $$ = new MethodOrOpDef(TRUE, FALSE, $2);
				}
		;

routine_def	:	routine_intf body END id
				{ if (!match_ids($1->get_id(), $4))
				  	$$ = new RoutineDef($1, $2, 0);
				  else {yyerror("mismatching ids");YYABORT;}
				}
		|	make_intf body END id
				{ if (!match_ids($1->get_id(), $4))
				  	$$ = new RoutineDef($1, $2, 0);
				  else {yyerror("mismatching ids");YYABORT;}
				}
		;

body		:	equate_list ostatements
				{ $$ = new Body($1, $2);
				}
		|	ostatements
				{ $$ = new Body(0, $1);
				}
		;

ostatements	:	/* empty */
				{ $$ = 0; }
		|	statement_list
				{ $$ = $1; }
		;

statement_list	:	statement
				{ $$ = new ParseNodeList($1); 
				  /* $1->print(3); */
				}
		|	statement_list statement
				{ $$ = $1;
				  $$->append($2);
				}
		;

statement	:	sdecl
				{ $$ = new DeclStmt($1);}
		|	sdecl_list ASSIGN expr
				{ Expr *ex;
				  ParseNodeList l = *$1;

				/* decl [,decl]* := invoc */
				  if ($3->tag() == Expr::InvocExprT) {
				      ex = $3;
				      $$ = new InitVarInvoke
					($1, ((InvocExpr*) ex)->get_invoc());
					}
	
				/* id : type_spec := expr */
				  else {
				    RegDecl *d = (RegDecl *) l(l.first());

				    if (l.length() > 1)
				      {yyerror("Illegal initialization");
				       YYABORT;}
				    else {
				      if (d->get_ids()->length() > 1)
					{yyerror("Illegal initialization");
					YYABORT;}
				      else
					$$ = new InitVarExpr(d, $3); 
				    }
				  }
				}

		|	primaries ASSIGN expr_list
			/* If expr_list has only 1 element, and it is an invoc,
			   this could be <id_or_ivar_list ASSIGN invoc> rule! 
			*/
				{ ParseNodeList *lhs = exl2lhs($1);
				  $$ = new AssignExprStmt(lhs, $3); }
		|	primary
				{ Invoc *inv = ex2inv($1);
				  if (!inv) {yyerror("inv expected");YYABORT;}
				  $$ = new InvokeStmt(inv);}
		|	WHILE expr DO body END
				{ $$ = new WhileStmt($2, $4); }
		|	IF expr THEN body oelse_ifs END
				{ $$ = new IfStmt($2, $4, $5, 0); }
		|	IF expr THEN body oelse_ifs ELSE body END
				{ $$ = new IfStmt($2, $4, $5, $7); }
		|	FOR id_list IN invoc DO body END 
				{  $$ = new ForStmt($2, $4, $6); }
		|	FOR decl_list IN invoc DO body END 
				{ $$ = new DeclForStmt($2, $4, $6); }
		|	RETURN oparen_expr_list2
				{ $$ = new ReturnStmt($2); }
		|	YIELD  LPAREN expr_list RPAREN
				{ $$ = new Yield($3); }
		|	SIGNAL id oparen_expr_list
				{ $$ = new SignalStmt($2, $3); }
		|	EXIT id	oparen_expr_list
				{ $$ = new Exit($2, $3); }
		|	BREAK
				{ $$ = new Stmt(Stmt::BreakT); }
		|	CONTINUE
				{ $$ = new Stmt(Stmt::ContinueT); }
		|	begin_end
				{ $$ = $1; }
		|	statement RESIGNAL id_list
				{ $$ = new ResignalStmt($1, $3); }
		|	statement EXCEPT oex_when_arms OTHERS odecl 
					COLON body END
				{ $$ = new ExceptStmt($1, $3, $5, $7); }
		|	statement EXCEPT oex_when_arms END
				{ $$ = new ExceptStmt($1, $3, 0, 0); }
		|	TAGCASE expr tag_when_arm_list OTHERS COLON body END
				{ $$ = new Tagcase($2, $3, $6); }
		|	TAGCASE expr tag_when_arm_list END
				{ $$ = new Tagcase($2, $3, 0); }
		|	TYPECASE expr type_when_arm_list OTHERS COLON body END
				{ $$ = new Typecase($2, $3, $6); }
		|	TYPECASE expr type_when_arm_list END
				{ $$ = new Typecase($2, $3, 0); }
/* may need to ensure that ofield_inits is not empty */
 		|	MAKE field_inits
  				{ $$ = $2; }
		|	MAKE field_inits THEN body END 
  				{ $$ = $2; $2->set_body($4); 	}
		;

sdecl_list	:	sdecl
  				{ $$ = new ParseNodeList($1); }
		|	sdecl_list COMMA sdecl
  				{ $$ = $1; $$->append($3); }
		;

/* sdecl is a decl and ensures that lhs is NOT an ivar */
sdecl		:	primaries COLON expr
  				{   /* ParseNodeList l = *$1;
				    ParseNodeList *idList = new ParseNodeList();
				    for (Pix p = l.first(); p; l.next(p)) {
					IdOrIvar *iv = (IdOrIvar *) l(p);
					if (iv->get_primary() != 0) 
					    {yyerror("Ivar given where id expected");
					     YYABORT;}
					idList->append(iv->get_id());
				    } */
				    ParseNodeList *idl = exl2idl($1);
				    if (!idl) {yyerror("idl expected");YYABORT;}
				    TypeSpec *ts = ex2ts($3);
				    if (!ts) {yyerror("typespec expected");YYABORT;}
				    $$ = new RegDecl(idl, ts);
				}
		|	primaries COLON tagged_type_spec
  				{   /* ParseNodeList l = *$1;
				    ParseNodeList *idList = new ParseNodeList();
				    for (Pix p = l.first(); p; l.next(p)) {
					IdOrIvar *iv = (IdOrIvar *) l(p);
					if (iv->get_primary() != 0) 
					    {yyerror("Ivar given where id expected");
					     YYABORT;}
					idList->append(iv->get_id());
				    } */
				    ParseNodeList *idl = exl2idl($1);
				    if (!idl) {yyerror("idl expected");YYABORT;}
				    $$ = new RegDecl(idl, $3);
				}
		|	primaries COLON routine_type
  				{   /* ParseNodeList l = *$1;
				    ParseNodeList *idList = new ParseNodeList();
				    for (Pix p = l.first(); p; l.next(p)) {
					IdOrIvar *iv = (IdOrIvar *) l(p);
					if (iv->get_primary() != 0) 
					    {yyerror("Ivar given where id expected");
					     YYABORT;}
					idList->append(iv->get_id());
				    } */
				    ParseNodeList *idl = exl2idl($1);
				    if (!idl) {yyerror("idl expected");YYABORT;}
				    $$ = new RegDecl(idl, $3);
				}
		;

field_inits	:	LCURLY field_init_list RCURLY
				{ $$ = new Init($2, 0, 0, 0); }
		|	LCURLY field_init_list SEMI simple_invoc RCURLY
				{ $$ = new Init($2, $4, 0, 0); }
		|	LCURLY simple_invoc RCURLY
				{ $$ = new Init(0, $2, 0, 0); }
		|	LCURLY RCURLY
				{ $$ = new Init(0, 0, 0, 0); }
		;

/*
				  if (invalid_field_init($1)) {
					yyerror("Invalid Field Initializer");
					YYABORT;
					}
*/

field_init_list	:	field_init
				{ $$ = new ParseNodeList($1); }
		|	field_init_list COMMA field_init
				{ $$ = $1;
				  $$->append($3);
				}
		;

field_init	:	id ASSIGN expr
				{ $$ = new FieldInit($1, $3); }
		/* This form helps cover the module_exports_list. */
		/* It is *not* a legit FieldInit. */
		|	id
				{ $$ = new FieldInit($1, 
					new Expr(Expr::IllegalExprT)); }
		;

begin_end	:	BEGIN_ body END
				{ $$ = new BlockStmt($2); }
		;

oex_when_arms	:	/* empty */
				{ $$ = 0; }
		|	ex_when_arms
				{ $$ = $1; }
		;

ex_when_arms	:	ex_when_arm
				{ $$ = new ParseNodeList($1); }
		|	ex_when_arms ex_when_arm
				{ $$ = $1; $$->append($2);}
		;

ex_when_arm	:	WHEN id_list COLON body
				{ $$ = new ExWhenArm($2, 0, $4); }
		|	WHEN id_list LPAREN decl_list RPAREN COLON body
				{ $$ = new ExWhenArm($2, $4, $7); }
		;

odecl		:	 /* empty */
				{ $$ = 0; }
		|	LPAREN id COLON expr RPAREN
				{ TypeSpec *ts = ex2ts($4);
				  if (!ts) {yyerror("typespec expectedd");YYABORT;}
				  $$ = new RegDecl(new ParseNodeList($2),
					 ts); }
		|	LPAREN id COLON routine_type RPAREN
				{ $$ = new RegDecl(new ParseNodeList($2), 
					$4); }
		|	LPAREN id COLON tagged_type_spec RPAREN
				{ $$ = new RegDecl(new ParseNodeList($2),
					 $4); }

		;

/* storage leak in parm_type arms */
/* invoc wants routineid, not primary... */
invoc		:	expr LPAREN oinv_args RPAREN
				{ RoutineId *rid = ex2rid($1);
				  if (!rid) {yyerror("rid expected");YYABORT;}
				  $$ = $3; $3->set_routineId(rid);}
		;

tag_when_arm_list	:	tag_when_arm
  				{ $$ = new ParseNodeList($1); }
		|	tag_when_arm_list tag_when_arm
  				{ $$ = $1;
				  $$->append($2);
				}
		;

type_when_arm_list	:	type_when_arm
  				{ $$ = new ParseNodeList($1); }
		|	type_when_arm_list type_when_arm
  				{ $$ = $1;
				  $$->append($2);
				}
		;

type_when_arm	:	WHEN expr COLON body
			/* expr should be id or id LPAREN id RPAREN */
  				{ TypeSpec *ts = ex2ts($2);
				  if (ts) $$ = new TypeWhenArm(ts, 0, $4); 
				  else { $$ = ex2twa($2, $4); }
				}
		|	WHEN routine_type LPAREN id RPAREN COLON body
  				{ $$ = new TypeWhenArm($2, $4, $7); }
		|	WHEN tagged_type_spec LPAREN id RPAREN COLON body
				{ $$ = new TypeWhenArm($2, $4, $7); }
		|	WHEN routine_type COLON body
  				{ $$ = new TypeWhenArm($2, 0, $4); }
		|	WHEN tagged_type_spec COLON body
				{ $$ = new TypeWhenArm($2, 0, $4); }
		;

tag_when_arm	:	WHEN id_list odecl COLON body
  				{ $$ = new TagWhenArm($2, $3, $5); }
		;

oelse_ifs	:	/* empty */
  				{ $$ = 0; }
		|	else_if_list
  				{ $$ = $1; }
		;

else_if_list	:	else_if
  				{ $$ = new ParseNodeList($1); }
		|	else_if_list else_if
  				{ $$ = $1;
				  $$->append($2);
				}
		;

else_if		:	ELSEIF expr THEN body
  				{ $$ = new ElseIf($2, $4); }
		;

oparen_expr_list2:	 /* empty */
  				{ $$ = 0; }
		|	 LPAREN oparen_expr_list2_contents RPAREN
  				{ $$ = $2; }
		;

oparen_expr_list2_contents:
				{ $$ = 0; }
		|	expr_list
				{ $$ = $1; }
		;

oparen_expr_list:	 /* empty */
  				{ $$ = 0; }
		|	 LPAREN expr_list RPAREN
  				{ $$ = $2; }
		;

expr_list	:	expr
  				{ $$ = new ParseNodeList($1); }
		|	expr_list COMMA expr
  				{ $$ = $1;
				  $$->append($3);
				}
		;

args		:	LPAREN oadecl_list RPAREN
  				{ $$ = $2; }
		;

nf_args		:	LPAREN type_spec_list RPAREN
  				{ $$ = tsl2dl($2); }
		|	LPAREN RPAREN
				{ $$ = 0; }
		;

oadecl_list	:	/* empty */
  				{ $$ = 0; }
		|	adecl_list
  				{ 
				   ParseNodeList l = *$1;
				  /* 
				   for (Pix p = l.first(); p; l.next(p)) {
				     if (l(p) == l.rear()) continue;
				     Decl *d = (Decl *) l(p);
				     if (d->tag() == Decl::VarArgsDeclT) 
				       {yyerror("Variable arguments may only appear at the end of the argument list");
				        YYABORT;}
				    }
				  */
				  $$ = $1; 
				}
		;

adecl_list	:	adecl
  				{ $$ = new ParseNodeList($1); }
		|	adecl_list COMMA adecl
  				{ $$ = $1;
				  $$->append($3);
				}
		;

decl_list	:	decl
  				{ $$ = new ParseNodeList($1); }
		|	decl_list COMMA decl
  				{ $$ = $1;
				  $$->append($3);
				}
		;

decl		:	id_list COLON expr
  				{ TypeSpec *ts = ex2ts($3);
				  if (!ts) {yyerror("typespec expected");YYABORT;}
				  $$ = new RegDecl($1, ts); }
		|	id_list COLON routine_type
  				{ $$ = new RegDecl($1, $3); }
		|	id_list COLON tagged_type_spec
				{ $$ = new RegDecl($1, $3); }
		;

adecl		:	primaries COLON expr
  				{ TypeSpec *ts = ex2ts($3);
				  if (!ts) {yyerror("typespec expected");YYABORT;}
				  ParseNodeList *ids = exl2idl($1);
                                  if (!ids) {yyerror("id list expected");YYABORT
;}
				  $$ = new RegDecl(ids, ts); }
		|	primaries COLON routine_type
  				{ ParseNodeList *ids = exl2idl($1);
                                  if (!ids) {yyerror("id list expected");YYABORT
;}
				  $$ = new RegDecl(ids, $3); }
		|	primaries COLON tagged_type_spec
				{ ParseNodeList *ids = exl2idl($1);
                                  if (!ids) {yyerror("id list expected");YYABORT
;}
				  $$ = new RegDecl(ids, $3); }
		;

oreturns	:	/* empty */
  				{ $$ = 0; }
		|	RETURNS LPAREN type_spec_list RPAREN
  				{ $$ = $3; }
		;

yields		:	YIELDS LPAREN type_spec_list RPAREN
  				{ $$ = $3; }
		;

makes		:	MAKES LPAREN expr RPAREN
  				{ TypeSpec *ts = ex2ts($3);
				  if (!ts) {yyerror("typespec expected");YYABORT;}
				  $$ = new ParseNodeList(ts); }
		|	MAKES LPAREN routine_type RPAREN
  				{ $$ = new ParseNodeList($3); }
		;

osignals	:	/* empty */
  				{ $$ = 0; }
		|	SIGNALS LPAREN exception_list RPAREN
  				{ $$ = $3; }
		;

exception_list	:	exception
  				{ $$ = new ParseNodeList($1); }
		|	exception_list COMMA exception
  				{ $$ = $1;
				  $$->append($3);
				}
		;

exception	:	id oparent_list
  				{ $$ = new Exception($1, $2); }
		;

oparent_list	:	LPAREN type_spec_list RPAREN
  				{ $$ = $2; }
		| 	/* empty */
  				{ $$ = 0; }
		;

type_spec_list	:	expr
  				{ TypeSpec *ts = ex2ts($1);
                                  if (!ts) {yyerror("typespec expected"); 
					    YYABORT;}
				  $$ = new ParseNodeList(ts); }
		|	tagged_type_spec
  				{ $$ = new ParseNodeList($1); }
		|	routine_type
  				{ $$ = new ParseNodeList($1); }
		|	type_spec_list COMMA expr
  				{ TypeSpec *ts = ex2ts($3);
                                  if (!ts) {yyerror("typespec expected"); 
                                            YYABORT;}
				  $$ = $1; $$->append(ts); }
		|	type_spec_list COMMA tagged_type_spec
  				{ $$ = $1; $$->append($3); }
		|	type_spec_list COMMA routine_type
  				{ $$ = $1; $$->append($3); }
		;

owhere		:	/* empty */
  				{ $$ = 0; }
		|	where_list
  				{ $$ = $1; }
		;

where_list	:	WHERE where_clause_list
				{ $$ = $2; }
		;

where_clause_list:	where_id id nf_non_param_routine_header
				{ $$ = new ParseNodeList(new Restriction($1,
					new ParseNodeList($3)));
				  $3->set_id($2);
				}
		|	where_id id nf_non_param_routine_header
					where_subclause_list
				{ $$ = $4;
				  $4->prepend(new Restriction($1,
					new ParseNodeList($3)));
				  $3->set_id($2);
				}
		;

where_subclause_list:	where_subclause
				{ $$ = new ParseNodeList($1); }
		|	where_subclause_list where_subclause
				{ $$ = $1; $1->append($2); }
		;

where_subclause	:	COMMA id nf_non_param_routine_header
				{ $$ = new Restriction(get_where_id(),
					new ParseNodeList($3));
				  $3->set_id($2);
				}
		|	COMMA where_id id nf_non_param_routine_header
				{ $$ = new Restriction($2,
					new ParseNodeList($4));
				  $4->set_id($3);
				}
		;

where_id	: 	id HAS
				{ $$ = $1 ; save_where_id($1); }
		;


osupers		:	supers
				{ $$ = $1; }
		|	/* empty */
				{ $$ = 0; }
		;

supers		:	LT super_info_list
				{ $$ = $2; }
		;

super_info_list	:	super_info
				{ $$ = new ParseNodeList($1); }
		|	super_info_list COMMA super_info
				{ $$ = $1;
				  $$->append($3);
				}
		;

super_info	:	id
				{ $$ = new SuperInfo(new SimpleTypeSpec(new TypeName($1)), 0); }
		|	id actual_params
				{ $$ = new SuperInfo(new ParamTypeSpec(
						new TypeName($1), $2), NULL);}
		;

equate_list	:	equate
				{ $$ = new ParseNodeList($1); }
		|	equate_list equate
				{ $$ = $1;
				  $$->append($2);
				}
		;

equate		:	id EQ expr
				{ TypeSpec *ts = ex2ts($3);
				  if (ts) $$ = new TypeEquate($1, ts);
				  else $$ = new ExprEquate($1, $3); }
		|	id EQ tagged_type_spec
				{ $$ = new TypeEquate($1, $3); }
		|	id EQ routine_type
				{ $$ = new TypeEquate($1, $3); }
		;

/* Yes, Virginia, these parms are only idns... */
oparms          :       parms
                                { $$ = $1; }
                |       /* empty */
                                { $$ = 0; }
                ;

parms           :       LBRACK param_list RBRACK
                                { $$ = $2; }
                ;

param_list      :       param
                                { $$ = new ParseNodeList($1); }
                |       param_list COMMA param
                                { $$ = $1;
                                  $$->append($3);
                                }

                ;

param           :       id
                                { $$ = new Parm(new ParseNodeList($1)); }
                ;


id_list		:	id
				{ $$ = new ParseNodeList($1); }
		|	id_list COMMA id
				{ $$ = $1;
				  $$->append($3);
				}
		;

tagged_type_spec:	taggedtype_id LBRACK field_list RBRACK
				{ $$ = new TaggedTypeSpec($1, $3); }
		;

routine_type	:	PROC non_param_proc_sig
				{ $$ = new RoutineTypeSpec($2); }
		|	PROC actual_params non_param_proc_sig
				{ $$ = new RoutineTypeSpec($3); }
		|	ITER non_param_iter_sig
				{ $$ = new RoutineTypeSpec($2); }
		|	ITER actual_params non_param_iter_sig
				{ $$ = new RoutineTypeSpec($3); }
		;


field_list	:	field
				{ $$ = new ParseNodeList($1); }
		|	field_list COMMA field
				{ $$ = $1;
				  $$->append($3); }
		;

field		:	id_list COLON expr
				{ TypeSpec *ts = ex2ts($3);
				  if (!ts) {yyerror("typespec expected");YYABORT;}
				  $$ = new Field($1, ts); }
		|	id_list COLON tagged_type_spec
				{ $$ = new Field($1, $3); }
		|	id_list COLON routine_type
				{ $$ = new Field($1, $3); }
		;

actual_params	:	LBRACK actual_param_list RBRACK
				  { $$ = $2; }
		;

actual_param_list:	actual_param
				{ $$ = new ParseNodeList($1); }
		|	actual_param_list COMMA actual_param
				{ $$ = $1;
				  $$->append($3);
				}
		;

actual_param	:	expr
				{ TypeSpec *ts = ex2ts($1);
				  if (!ts) {yyerror("typespec expected");YYABORT;}
				  $$ = new ActualParm(ts, 0); }
		;


expr		:	simple_expr
				{ $$ = $1;}
		|	expr DOT expr
				{ Expr *tempid = ex2deid($3);
				  if (!tempid) {yyerror("id or super id expected");YYABORT;}
				  $$ = new DotExpr($1, tempid); }
		|	expr LPAREN oinv_args RPAREN
				{ RoutineId *rid = ex2rid($1);
				  if (!rid) {yyerror("rid expected");YYABORT;}
				  $3->set_routineId(rid);
				  $$ = new InvocExpr($3);}
		|	expr LBRACK expr_list RBRACK
				{ $$ = new BracketRef($1, $3);}
		|	expr LBRACK expr_list RBRACK field_inits
				{ $$ = new SelectorConstr(
					new ParamTypeSpec(
						new TypeName(ex2id($1)), 
						exl2apl($3)),
					$5->get_fieldInits(),
					$5->get_invoc());}
		|	LPAREN expr RPAREN 
				{ $$ = $2; }
		|	TILDE expr
				{ $$ = new Unary(Unary::NotT, $2); }
		|	MINUS expr	%prec UMINUS
				{ $$ = new Unary(Unary::MinusT, $2); }
		|	expr EXP expr
				{  $$ = new Binary(Binary::PowerT, $1, $3); }
		|	expr MOD expr
				{  $$ = new Binary(Binary::ModuloT, $1, $3); }
		|	expr DIV expr
				{  $$ = new Binary(Binary::DividesT, $1, $3); }
		|	expr STAR expr
				{  $$ = new Binary(Binary::TimesT, $1, $3); }
		|	expr CONCAT expr
				{  $$ = new Binary(Binary::ConcatT, $1, $3); }
		|	expr PLUS expr
				{  $$ = new Binary(Binary::PlusT, $1, $3); }
		|	expr MINUS expr
				{  $$ = new Binary(Binary::MinusT, $1, $3); }
		|	expr LT expr
				{  $$ = new Binary(Binary::LTT, $1, $3); }
		|	expr LE expr
				{  $$ = new Binary(Binary::LTET, $1, $3); }
		|	expr EQ expr
				{  $$ = new Binary(Binary::EqualT, $1, $3); }
		|	expr NEQ expr
				{  $$ = new Binary(Binary::NotEqualT, $1, $3); }
		|	expr GE expr
				{  $$ = new Binary(Binary::GTET, $1, $3); }
		|	expr GT expr
				{  $$ = new Binary(Binary::GTT, $1, $3); }
		|	expr CAND expr
				{  $$ = new Binary(Binary::AndT, $1, $3); }
		|	expr COR expr
				{  $$ = new Binary(Binary::OrT, $1, $3); }
		;

primaries	:	primary		%prec DUMMY
				{ $$ = new ParseNodeList($1); }
		|	primaries COMMA primary		%prec DUMMY
				{ $$ = $1;
				  $$->append($3);
				}
		;

primary		:	simple_expr
				{ $$ = $1; }
/*
		|	pts
				{ $$ = ts2ex($1); }
		|	pts field_inits
				{ $$ = new SelectorConstr($1,
					$2->get_fieldInits()); }
*/
		|	simple_invoc
				{ $$ = new InvocExpr($1);} 
		|	primary DOT expr
				{ Expr *temp = ex2deid($3);
				  if (!temp) {yyerror("id or super idexpected");YYABORT;}
				  $$ = new DotExpr($1, temp); }
		|	primary LBRACK insides RBRACK
				{ $$ = new BracketRef($1, $3); }

		|	primary LBRACK insides RBRACK field_inits
				{ $$ = new SelectorConstr(
					new ParamTypeSpec(
						new TypeName(ex2id($1)), 
						exl2apl($3)),
					$5->get_fieldInits(),
					$5->get_invoc());}
		;

insides		:	expr
				{ $$ = new ParseNodeList($1); }
		|	insides COMMA expr
				{ $$ = $1;
				  $$->append($3);
				}
		;

simple_expr	:	NIL
				{ $$ = new Expr(Expr::NilT); }
		|	literal
				{ $$ = $1; }
		|	id				%prec DUMMY
				{ $$ = new IdExpr($1); }
		|	CARET id
				{ $$ = new SuperId($2); }
		|	SELF
				{ $$ = new Expr(Expr::SelfT); }
		|	tagged_type_spec LCURLY field_init_list RCURLY
				{ $$ = new SelectorConstr($1, $3, 0); }
		|	id field_inits 
				{ $$ = new SelectorConstr(
				new SimpleTypeSpec(new TypeName($1)), 
					$2->get_fieldInits(),
					$2->get_invoc()); }
		|	binding
				{ $$ = new BindingExpr($1); }
		;

/*
	Do not do this stuff: just fix where BracketRefs are made...
pts		:	id actual_params
				{ $$ = new ParamTypeSpec(new TypeName($1), $2);}
		;
*/
		
binding		: BIND LPAREN expr RPAREN
				{ 
				  $$ = new Binding($3, 0, 0, 0);
				}
		| BIND LPAREN expr bind_arg_list RPAREN
				{ 
				  $$ = new Binding($3, $4, 0, 0);
				}
		| BIND LPAREN expr COMMA btrail RPAREN
				{ 
				  $$ = new Binding($3, 0, $5, 0);
				}
		| BIND LPAREN expr bind_arg_list COMMA btrail RPAREN
				{ 
				  $$ = new Binding($3, $4, $6, 0);
				}
		;

bind_arg_list	:	COMMA bind_arg
				{ $$ = new ParseNodeList($2); }
		|	bind_arg_list COMMA bind_arg
				{ $$ = $1;
				  $$->append($3);
				}
		;

bind_arg	:	STAR
				{ $$ = new BindingArg(0); }
		|	expr
				{ $$ = new BindingArg($1); }
		;

btrail		:	DOTS
				{ $$ = 0; }
		|	DOTS expr_list
				{ $$ = $2; }
		;

simple_invoc	:   primary LPAREN oinv_args RPAREN
				{ RoutineId *rid = ex2rid($1);
				  if (!rid) {yyerror("rid expected");YYABORT;}
				  $3->set_routineId(rid);
				  $$ = $3; }
        	;

oinv_args	:
				{ $$ = new Invoc(0,0,0,0); }
	        |       inv_args
				{ $$ = $1; }
       		;

inv_args	:       expr_list
				{ $$ = new Invoc(0, $1, 0, 0); }
        	|       expr_list COMMA DOTS
				{ $$ = new Invoc(0, $1, new ParseNodeList(), 0); }
        	|       expr_list COMMA DOTS expr_list
				{ $$ = new Invoc(0, $1, $4, 0); }
	        |       DOTS
				{ $$ = new Invoc(0, 0, new ParseNodeList(), 0); }
       		|       DOTS expr_list
				{ $$ = new Invoc(0, 0, $2, 0); }
        	;


literal		:	int_literal
				{ $$ = $1; }
		|	char_literal
				{ $$ = $1; }
		|	bool_literal
				{ $$ = $1; }
		|	real_literal
				{ $$ = $1; }
		|	string_literal
				{ $$ = $1; }
		;

int_literal	:	INT
				{ $$ = new IntLiteral(yylval.i); }
		;

real_literal	:	REAL
  				{ $$ = new RealLiteral(yylval.r); }
		;

bool_literal	:	TRUE_
  				{ $$ = new BoolLiteral(1); }
		|	FALSE_
  				{ $$ = new BoolLiteral(0); }
		;

char_literal	:	CHAR
  				{ $$ = new CharLiteral(yylval.c); }
		;

string_literal	:	STRING
  				{ $$ = new StringLiteral(yylval.s); }
		;

id		:	ID
  				{ $$ = new Id(yylval.s); }
		;

taggedtype_id	:	RECORD 
				{ $$ = new TypeName(new Id(string_new("record"))); }
		| 	STRUCT
				{ $$ = new TypeName(new Id(string_new("struct"))); }
		| 	ONEOF
				{ $$ = new TypeName(new Id(string_new("oneof"))); }
		|	VARIANT
				{ $$ = new TypeName(new Id(string_new("variant"))); }
		;

%%

void yyinit()
{
	tsl2dl_init();
	}

Id *where_saved_id = 0;

void save_where_id(Id *i)
{
	/* printf("saving %X\n", i); */
	where_saved_id = i;
	}

Id *get_where_id()
{
	/* printf("returning %X\n", where_saved_id); */
	return where_saved_id;
	}

/* needs to handle Parmd types */
TypeSpec *ex2ts(Expr *ex)
{
	// printf("entering ex2ts\n");
	// if (ex) ex->print(3);
	switch (ex->tag()) {
	    case (Expr::IdExprT): {
		IdExpr *tempid = (IdExpr *)ex;
		return
		   new SimpleTypeSpec(
			 new TypeName(tempid->get_id()));
		}
	    case (Expr::BracketRefT): {
		/* insist that ex be a bracket ref...
		   primary s.b. idexpr
		   exprs s.b. idns or bracerefs
		*/
		BracketRef *br = (BracketRef *)ex;
		Expr *prim = br->get_primary();
		if (prim->tag() != Expr::IdExprT) break;
		IdExpr *tempid = (IdExpr *)prim;
		ParseNodeList *newl = new ParseNodeList();
		ParseNodeList *el = br->get_exprs();
		for (Pix p = el->first(); p ; el->next(p)) {
		   Expr *ex = (Expr *)(*el)(p);
		   switch (ex->tag()) {
			case Expr::IdExprT: {
				newl->append(new ActualParm(
					new SimpleTypeSpec(
						new TypeName(ex2id(ex))),
					new ParseNodeList()));
				continue;
				}
			case Expr::BracketRefT: {
				newl->append(new ActualParm(ex2ts(ex),
					new ParseNodeList()));
				continue;
				}
			case Expr::BraceRefT: {
				// needs work
				continue;
				}
			}
		   printf("bouncing due to:i\n");
		   ex->print(3);
		   break;
		   }
		return new ParamTypeSpec(
			 new TypeName(tempid->get_id()), newl);
		}
	} // end switch
	// NOTE: this error occurs normally
	// yyerror("expected typespec\n");
	// if (ex) ex->print(3);
	return 0;
}

/* convert expression to routine id */
RoutineId *ex2rid(Expr *ex)
{
	if (!ex) {yyerror("missing expr"); return 0;}
	switch (ex->tag()) {
		case (Expr::IdExprT): return new SimpleRoutineId(ex);
		case (Expr::DotExprT): return new SimpleRoutineId(ex);
		case (Expr::BindingT): return new SimpleRoutineId(ex);
		case (Expr::InvocExprT): return new SimpleRoutineId(ex);
		case (Expr::SuperIdT): {
			SuperId *sid = (SuperId *)ex;
			return new SuperClassRoutineId(sid->get_id());
			}
		case (Expr::BracketRefT): {
			BracketRef *br = (BracketRef *)ex;
			return new ComplexRoutineId(br->get_primary(),
					exl2apl(br->get_exprs()));
			}
		} // end switch
	yyerror("expecting routine id");
	if (ex) ex->print(3);
	return 0;
	}

Id *ex2id(Expr *ex)
{
	if (ex->tag() != Expr::IdExprT) {
		yyerror("expecting Id\n");
		if (ex) ex->print(3);
		return 0;
		}
	else {
		IdExpr *tempid = (IdExpr *)ex;
		return tempid->get_id();
		}
	}

Expr *ex2deid(Expr *ex)
{
        if (ex->tag() != Expr::IdExprT &&
		ex->tag() != Expr::SuperIdT) {
                yyerror("expecting Id or Super Class Id\n");
                if (ex) ex->print(3);
                return 0;
                }
        else {
                return ex;
                }
        }


Invoc *ex2inv(Expr *ex)
{
	if (ex->tag() != Expr::InvocExprT) {
		yyerror("expecting Invoc\n");
		return 0;
		}
	else {
		InvocExpr *tempinv = (InvocExpr *)ex;
		return tempinv->get_invoc();
		}
	}

TypeWhenArm *ex2twa(Expr *ex, Body *b)
{
	// printf("entering ex2twa\n");
	// ex->print(3);
	if (ex->tag() != Expr::InvocExprT) {
		yyerror("expecting typespec (id)\n");
		return 0;
		}
	else {
		InvocExpr *tempinv = (InvocExpr *)ex;
		RoutineId *rid = tempinv->get_invoc()-> get_routineId();
		TypeSpec *ts = 0;
		switch (rid->tag()) {
			case RoutineId::SimpleRoutineIdT: {
				SimpleRoutineId *srid = (SimpleRoutineId *)rid;
				ts = ex2ts(srid->get_primary());
				break;
				}
			case RoutineId::ComplexRoutineIdT: {
				ComplexRoutineId *crid = (ComplexRoutineId *)rid;
				Expr *prim = crid->get_primary();
				ParseNodeList *apl = crid->get_parms();
				ParseNodeList *exl = apl2exl(apl);
				ts = ex2ts(new BracketRef(prim,exl));
				break;
				}
			case RoutineId::SuperClassRoutineIdT: {
				yyerror("expecting typespec (id)\n");
				return 0;
				}
			}
		if (!ts) {yyerror("expecting typespec (id)\n"); return 0;}
		ParseNodeList *exl = tempinv->get_invoc()->get_exprs();
		Pix p = exl->first();
		Id *tempid = ex2id((Expr*)(*exl)(p));
		if (!tempid) {yyerror("expecting typespec (id)\n"); return 0;}
		return new TypeWhenArm(ts, tempid, b);
		}
	}

Id *exl2id(ParseNodeList *pnl)
{
	int size = pnl->length();
	if (size != 1) {
		yyerror("Expecting single identifier\n");
		return 0;
		}
	Pix p = pnl->first();
	return ex2id((Expr*)(*pnl)(p));
	}

/* convert primary list to idn list (for statement decls) (no ivars) */
ParseNodeList* exl2idl(ParseNodeList *pnl)
{
	if (!pnl) {yyerror("missing id list"); return 0;}
	ParseNodeList *nl = new ParseNodeList();
	for (Pix p = pnl->first(); p ; pnl->next(p)) {
		Expr *ex = (Expr *) (*pnl)(p);
		switch (ex->tag()) {
			case Expr::IdExprT: {
				IdExpr *ide = (IdExpr *)ex;
				nl->append(ide->get_id());
				break;
				}
			default: {
				yyerror("exl2idl: expecting id");
				if (ex) ex->print(3);
				return 0;
				}
			}
		}
	return nl;
	}

/* convert primaries (expr list) to lhs (legal left hand side)
	 (for assignment statements) */

ParseNodeList* exl2lhs(ParseNodeList *pnl)
{
	if (!pnl) {yyerror("missing id list"); return 0;}
	ParseNodeList *nl = new ParseNodeList();
	for (Pix p = pnl->first(); p ; pnl->next(p)) {
		Expr *ex = (Expr *) (*pnl)(p);
		switch (ex->tag()) {
			case Expr::IdExprT: {
				IdExpr *ide = (IdExpr *)ex;
				nl->append(ide);
				break;
				}
			case Expr::DotExprT: {
				nl->append(ex);
				break;
				}
			case Expr::BracketRefT: {
				nl->append(ex);
				break;
				}
			default: {
				yyerror("exl2lhs: expecting id or dotexpr");
				if (ex) ex->print(3);
				return 0;
				}
			}
		}
	return nl;
	}

static int dummy_count = 0;
static string dummy_name = 0;

void tsl2dl_init()
{
	if (dummy_count == 0) dummy_name = string_new("dummy_");
	dummy_count = 0;
	}

ParseNodeList* tsl2dl(ParseNodeList* pnl)
{
	ParseNodeList *nl = new ParseNodeList();
	for (Pix p = pnl->first(); p ; pnl->next(p)) {
		TypeSpec *ts = (TypeSpec *)(*pnl)(p);
		nl->append(new RegDecl(
				new ParseNodeList(new Id(
					string_concat(dummy_name,
					int_unparse(dummy_count)))), 
				ts));
		dummy_count++;
		}
	return nl;
	}

ParseNodeList* pl2apl(ParseNodeList* pl)
{
ParseNodeList *newl = new ParseNodeList();

	if (!pl) return NULL;
	for (Pix p = pl->first() ; p ; pl->next(p)) {
		Parm *pm = (Parm *)(*pl)(p);
		ParseNodeList *l = pm->get_ids();
		for (Pix p2 = l->first(); p2; l->next(p2)) {
			Id *id = (Id *)(*l)(p2);
			newl->append(new ActualParm(new SimpleTypeSpec
				(new TypeName(id)), 0));
		}
	}
	return newl;
}

ParseNodeList* apl2pl(ParseNodeList* pl)
{

	if (!pl) return NULL;

	ParseNodeList *newl = new ParseNodeList();

	for (Pix p = pl->first() ; p ; pl->next(p)) {
		ActualParm *ap = (ActualParm *)(*pl)(p);
		ap->print(1);
		TypeSpec *ts = ap->get_typeSpec();
		switch (ts->tag()) {
			case TypeSpec::SimpleTypeSpecT: {
				SimpleTypeSpec *sts = (SimpleTypeSpec*)ts;
				Id *id = sts->get_name()->get_name();
				newl->append(new Parm(new ParseNodeList(id)));
				break;
				}
			default: {
				yyerror("apl2pl: expecting simple typespec/id");
				}
			}
	}
	return newl;
}


ParseNodeList *exl2apl(ParseNodeList* exl)
{
ParseNodeList *newl = new ParseNodeList();

	if (!exl) return NULL;
	for (Pix p = exl->first() ; p ; exl->next(p)) {
		Expr *ex = (Expr *)(*exl)(p);
		TypeSpec *ts = ex2ts(ex);
		newl->append(new ActualParm(ts, 0));
		}
	return newl;
}

Id *pts_get_name(TypeSpec *ts)
{
	switch (ts->tag()) {
		case TypeSpec::ParamTypeSpecT: {
			ParamTypeSpec *pts = (ParamTypeSpec *)ts;
			return pts->get_name()->get_name();
			break;
			}
		default: {
			yyerror("pts_get_name: expecting paramtypespec");
			}
		}
	}

ParseNodeList *pts_get_aparms(TypeSpec *ts)
{
	switch (ts->tag()) {
		case TypeSpec::ParamTypeSpecT: {
			ParamTypeSpec *pts = (ParamTypeSpec *)ts;
			return pts->get_actualParms();
			break;
			}
		default: {
			yyerror("pts_get_name: expecting paramtypespec");
			}
		}
	}

ParseNodeList *apl2exl(ParseNodeList *apl)
{
ParseNodeList *newl = new ParseNodeList();

	if (!apl) return NULL;
	for (Pix p = apl->first(); p ; apl->next(p)) {
		ActualParm *ap = (ActualParm *)(*apl)(p);
		newl->append(ts2ex(ap->get_typeSpec()));
		}
	return newl;
	}

Expr *ts2ex(TypeSpec *ts)
{
	switch (ts->tag()) {
		case TypeSpec::ParamTypeSpecT: {
			ParamTypeSpec *pts = (ParamTypeSpec *)ts;
			Id *id = pts->get_name()->get_name();
			ParseNodeList *aparms = pts->get_actualParms();
			return new BracketRef(new IdExpr(id),
					apl2exl(aparms));
			break;
			}
		case TypeSpec::SimpleTypeSpecT: {
			SimpleTypeSpec *sts = (SimpleTypeSpec *)ts;
			Id *id = sts->get_name()->get_name();
			return new IdExpr(id);
			break;
			}
		default: {
			yyerror("pts_get_name: expecting simple or param typespec");
			}
		}
	}

bool invalid_field_init(FieldInit *fi)
{
	if (fi->get_expr() == 0) return TRUE;
	return FALSE;
	}
