// Copyright 1995 Barbara Liskov

#ifndef _TRAVERSE_H
#define _TRAVERSE_H

class ParseNode;

/*----------------------------------------------------------------

     A TraverseObj is a class that contains a method (xmogrify)
     that takes a ParseNode and returns a (potentially new) ParseNode.
     The TraverseObj also contains additional state, e.g. a naming
     environment.
    
     It is passed as an argument to the "traverse" method of a
     ParseNode.  The traverse method first calls the
     TraverseObj.xmogrify method on itself.  If the method returns a
     non-null ParseNode*, the method immediately returns that as the
     value for the traverse method call.
    
     If the method returns NULL, traverse recursively traverses all of
     the subnodes and returns a new object based on the result of
     those traversals.
    
----------------------------------------------------------------*/
    
class TraverseObj {

  public:
    virtual ParseNode* xmogrify(ParseNode *pn) = 0;
    virtual ParseNode* setup(ParseNode *pn) = 0;
};

#endif /* _TRAVERSE_H */




