// copyright 1995 Barbara Liskov

#include "types/str.h"
#include "parse.h"
#include "types/class_class.h"
#include "types/any.h"
#include "types/vec.h"
#include "types/ptype.h"
#include "type_chk.h"
#include "types/type.h"
#include "types/type_def.h"
#include "types/class.h"
#include "types/objtype_class.h"
#include "types/pclass.h"
#include "types/pclass_class.h"
#include "types/method.h"
#include "types/vec_instns.h"
#include "types/param.h"
#include "types/param_class.h"

#define DEBUG 0
#define DEBUG1 0

extern string err_list;

char cmp_err_buf[1000];
void cmp_err_check_point();
void cmp_err_return_to_checkpoint();
extern "C" {
extern string simple_type_name(string type_name);
	}

void check_spec_mod(SpecModule *sm, TypeCheckObj *tco);
void check_impl_mod(ImplModule *im, TypeCheckObj *tco);
void check_type_intf(TypeIntf *tin, TypeCheckObj *tco);
void check_routine_spec(RoutineSpec *rs, TypeCheckObj *tco);
void check_routine_def(RoutineDef *rd, TypeCheckObj *tco);
void check_class_def(ClassDef *cd, TypeCheckObj *tco);
void check_routine_intf(RoutineIntf *ri, TypeCheckObj *tco);
void check_mopdef(MethodOrOpDef *mopd, TypeCheckObj *tco);
void check_body(Body *b, TypeCheckObj *tco);
void check_method_intf(RoutineIntf *ri, TypeCheckObj *tco);
void check_signature(Signature *sig, TypeCheckObj *tco);
void check_stmt(Stmt *stmt, TypeCheckObj *tco);
void check_ivars(ParseNodeList *decls, TypeCheckObj *tco);
void check_decl_stmt(DeclStmt *d, TypeCheckObj *tco);
void check_ive(InitVarExpr *iveistmt, TypeCheckObj *tco);
void check_ivi(InitVarInvoke *ivistmt, TypeCheckObj *tco);
void check_aes(AssignExprStmt *aesstmt, TypeCheckObj *tco);
void check_inv_stmt(InvokeStmt *invstmt, TypeCheckObj *tco);
void check_if(IfStmt *ifstmt, TypeCheckObj *tco);
void check_while(WhileStmt *whilestmt, TypeCheckObj *tco);
void check_tagc(Tagcase *tagcstmt, TypeCheckObj *tco);
void check_typec(Typecase *typecstmt, TypeCheckObj *tco);
void check_ret(ReturnStmt *retstmt, TypeCheckObj *tco);
void check_yield(Yield *yieldstmt, TypeCheckObj *tco);
void check_sig(SignalStmt *sigstmt, TypeCheckObj *tco);
void check_exit(Exit *exitstmt, TypeCheckObj *tco);
void check_break(Stmt *stmt, TypeCheckObj *tco);
void check_cont(Stmt *stmt, TypeCheckObj *tco);
void check_resig(ResignalStmt *resigstmt, TypeCheckObj *tco);
void check_excpt(ExceptStmt *excptstmt, TypeCheckObj *tco);
void check_init(Init *initstmt, TypeCheckObj *tco);
void check_declfor(DeclForStmt *declforstmt, TypeCheckObj *tco);
void check_for(ForStmt *forstmt, TypeCheckObj *tco);
void check_decls(ParseNodeList *dl, TypeCheckObj *tco);
void check_decl(Decl *decl, TypeCheckObj *tco);
void check_inv(Invoc *inv, TypeCheckObj *tco);
void check_routine_id(RoutineId *rid, TypeCheckObj *tco);
void check_bool(Expr *ex, TypeCheckObj *tco);
void check_ids(ParseNodeList *idl, TypeCheckObj *tco);
void check_id(Id *id, TypeCheckObj *tco);
void check_field_inits(ParseNodeList *fs, TypeCheckObj *tco);
void check_field_init(FieldInit *f, TypeCheckObj *tco);
void check_fields(ParseNodeList *fs, TypeCheckObj *tco);
void check_field(Field *f, TypeCheckObj *tco);
void check_exprs(ParseNodeList *el, TypeCheckObj *tco);
void check_expr(Expr *ex, TypeCheckObj *tco);
void check_typespec(TypeSpec *ts, TypeCheckObj *tco);
void check_subclassing_info(ImplModule *im, TypeCheckObj *tco);
void check_not_maker(Expr *ex, TypeCheckObj *tco);
void full_scs(ImplModule *im, TypeCheckObj *tco);


/*
	This is the type checker.  It is has been rewritten in
	a recursive-descent fashion.

*/

// Omitted nodes: InheritT ExportT
// Omitted nodes: ExprEquateT

bool repeat(TypeCheckObj *tco)
{
	// Check if we've already done a 2nd pass...
	if (tco->allow_redefs == TRUE) return FALSE;
	
	if (err_list != 0 && tco->redef_count == 0) return TRUE;
	else return FALSE;
	}

void begin_1st_pass(TypeCheckObj *tco)
{
//	tco->pass = 1;
	cmp_err_check_point();
	tco->allow_redefs = FALSE;
	}

bool begin_2nd_pass(TypeCheckObj *tco)
{
	// Since we haven't done a 2nd pass, see if it's worth it.
	if (repeat(tco)) {
//		tco->pass = 2;
		cmp_err_return_to_checkpoint();
		tco->allow_redefs = TRUE;
		return TRUE;
		}

	// Not worth a 2nd pass: either no errors, or errors that
	//	won't be fixed on another pass.
	return FALSE;
	}

void type_checker(ParseNodeList *pnl, TypeCheckObj *tco)
{

	if (pnl) for (Pix p = pnl->first(); p ; pnl->next(p)) {
		Module *m = (Module *)(*pnl)(p);
		begin_1st_pass(tco);
		while (TRUE) {
			switch (m->tag()) {
				case Module::SpecModuleT: {
					SpecModule *sm = (SpecModule *)m;
					check_spec_mod(sm, tco);
					break;
					}
				case Module::ImplModuleT: {
					ImplModule *im = (ImplModule *)m;
					check_impl_mod(im, tco);
					break;
					}
				}
			// See if there are any errors that a 2nd pass could
			// 	clear up...
			if (begin_2nd_pass(tco)) continue;
			else break;
			}
		// Internal type checking is complete for this module.
		// If type checking succeded, promote subclassing info
		//	to outer environment.
		if (m->tag() == Module::ImplModuleT) {
			ImplModule *im = (ImplModule *)m;
			if (!err_list) check_subclassing_info(im, tco);
			else cmp_err("Not creating subclass info for"
					" classes in this module because"
					" there are errors in this module."
					" May need to put superclass and"
					" subclass in separate modules for"
				  	" typechecking to work.",
					im->get_line());
			}
		}
	// The purpose here is to change the superclasses from classes
	// appropriate for type checking to superclasses appropriate for
	// code generation, so that the superclasses will have all their
	// hidden methods so that the DVs can be generated appropriately.
	if (pnl) for (Pix p = pnl->first(); p ; pnl->next(p)) {
		Module *m = (Module *)(*pnl)(p);
		switch (m->tag()) {
			case Module::ImplModuleT: {
				ImplModule *im = (ImplModule *)m;
				full_scs(im, tco);
				break;
				}
			}
		}
	}

void check_spec_mod(SpecModule *sm, TypeCheckObj *tco)
{
	ParseNodeList *specs = sm->get_specs();
	if (specs) for (Pix p = specs->first(); p; specs->next(p)) {
		SpecElt *spec = (SpecElt *)(*specs)(p);
		switch (spec->tag()) {
			case SpecElt::TypeIntfT: {
				TypeIntf *tin = (TypeIntf*)spec;
				check_type_intf(tin, tco);
				break;
				}
			case SpecElt::RoutineSpecT: {
				RoutineSpec *rs = (RoutineSpec *)spec;
				check_routine_spec(rs, tco);
				break;
				}
			case SpecElt::SpecEquateT: {
				SpecEquate *seq = (SpecEquate *)spec;
				handle_equates(seq->get_equate(), TRUE, tco);
				break;
				}
			}
		}
				
	}

void check_type_intf(TypeIntf *tin, TypeCheckObj *tco)
{
objtype nt;
ptype pt;
ParseNodeList *parms = tin->get_parms();
ParseNodeList *restricts = tin->get_wheres();
ParseNodeList *methods = tin->get_methods();
string nm = tin->get_id()->get_id();
bool exists = FALSE;

	if (tco->env->look_up(nm)) exists = TRUE;
	if (!exists || tin->get_type()->tag() == TypeInterface::NullT) {
	   if (parms) {
		pt = new_ptype();
		nt = &pt->hdr.inh;
	     }
	   else {
		if (restricts) {
			sprintf(cmp_err_buf, "Extraneous where clauses in "
				"non-parameterized type",
				string_charp(nm));
			cmp_err(cmp_err_buf, tin->get_line());
		}
		nt = new_objtype();
	     }
	  nt->name = nm;
	  }
	else {
		nt = type_as_objtype(tin->get_type()->get_type());
		if (parms) {
			pt = type_as_ptype(nt);
			}
		}
	if (exists && !tco->allow_redefs) {
		sprintf(cmp_err_buf, "Redefinition of %.50s occurred",
				string_charp(nm));
		cmp_err(cmp_err_buf, tin->get_line());
		tco->redef_count++;
		}
	else {
		if (!exists) {
		   TypeInterface *ti = new TypeInterface( objtype_as_type(nt));
		   tin->type_ = ti;
		   tco->env = tco->env->add_type_binding(nm, ti);
		   }
		}
	tco->env = tco->env->add_mark();
	if (parms) {
		// Really need to have parms added to env after mark
		int count = count_parms(parms);
		pt->params = parms2vec(parms, pt, restricts, count, tco);
		}
	type ntt = objtype_as_type(nt);
	nt->methods_ = make_vec_Method(0, FALSE);
	nt->supertypes_ = make_vec_Method(0, FALSE);
	nt->methods_ = methods_from_def(tin, ntt, ntt, tco);
	nt->supertypes_ = supertypes_from_intf(tin, tco);
	bool ok = check_type_against_supertypes(nt, tin->get_line(), tco->env);
	if (!ok) nt->supertypes_ = make_vec_Method(0, FALSE);
	tco->inside_type_intf = TRUE;

	if (methods) for (Pix p = methods->first(); p; methods->next(p)) {
		RoutineIntf *ri = (RoutineIntf *)(*methods)(p);
		check_routine_intf(ri, tco);
		}

	tco->env = tco->env->clear_mark();
	tco->inside_type_intf = FALSE;
	}

void check_routine_spec(RoutineSpec *rs, TypeCheckObj *tco)
{
RoutineIntf *ri = rs->get_routine();
Signature* sig = ri->get_signature();
ParseNodeList *parms = sig->get_parms();
ParseNodeList *restricts = sig->get_where();

	tco->env = tco->env->add_mark();
	int count = parms? count_parms(parms) : 0;
	if (parms) parms2vec(parms, 0, restricts, count, tco);
	check_routine_intf(ri, tco);
        TypeInterface *ti = rs->get_routine()->get_type();

        tco->env =   tco->env->clear_mark();
        string nm = rs->get_routine()->get_id()->get_id();
        if (tco->env->look_up(nm)) {
                if (!tco->allow_redefs) {
                        sprintf(cmp_err_buf, "Attempted redefinition of "
				"%.50s foiled",
                                string_charp(nm));
                        cmp_err(cmp_err_buf, rs->get_line());
                        tco->redef_count++;
                        }
                else tco->env->update_binding(nm, ti);
                }
        else {
                // 9/25/95 dwc: changed from type to var binding...
                tco->env = tco->env->add_var_binding(nm, ti);
                }

	}

void check_impl_mod(ImplModule *im, TypeCheckObj *tco)
{
    tco->current_module = im;
    // Only set mark at beginning of 1st pass
    if (!tco->allow_redefs) {
  	tco->env = tco->env->add_mark();
	}
    ParseNodeList *eqs = im->get_equates();
    if (eqs) for (Pix p = eqs->first(); p; eqs->next(p)) {
	Equate *eq = (Equate *)(*eqs)(p);
	handle_equates(eq, TRUE, tco);
	}
    ParseNodeList *exports = im->get_exports();
    ParseNodeList *impls = im->get_impls();
    if (impls) for (Pix p = impls->first(); p; impls->next(p)) {
	ImplElt *ie = (ImplElt*)(*impls)(p);
	switch (ie->tag()) {
		case ImplElt::ImplEquateT: {
			ImplEquate *ieq = (ImplEquate *)ie;
			Equate *eq = ieq->get_equate();
			handle_equates(eq, TRUE, tco);
			break;
			}
		case ImplElt::RoutineDefT:{
			RoutineDef *rd = (RoutineDef *)ie;
			RoutineIntf* ri = rd->get_routineIntf();
			check_routine_def(rd, tco);
			break;
			}
		case ImplElt::ClassDefT:{
			ClassDef *cd = (ClassDef *)ie;
			check_class_def(cd, tco);
			break;
			}
		}
	}

      if (exports) for (Pix p = exports->first(); p ; exports->next(p)) {
        Id *id = (Id *)(*exports)(p);
        // TypeInterface *ti = get_type(id->get_id(), tco->env);
        find_var(id->get_id(), id, tco->env, TRUE);
        TypeInterface *ti = id->get_type();
        if (!ti) {
                sprintf(cmp_err_buf, "Module claims to implement %s"
                                     " but definition is missing",
                                string_charp(id->get_id()));
                cmp_err(cmp_err_buf, im->get_line());
                }
        else {
            switch (ti->tag()) {
                case TypeInterface::MethodT: break;
                case TypeInterface::PMethodT: break;
                default: {
                    sprintf(cmp_err_buf, "Module implements %s"
                                     " but %s is not a routine",
                                string_charp(id->get_id()),
                                string_charp(id->get_id()));
                    cmp_err(cmp_err_buf, im->get_line());
                    }
                }
            }
        }
      tco->current_module = 0;
      // only clear mark if this is the last pass
      if (!repeat(tco)) tco->env = tco->env->clear_mark();

    }

void check_routine_def(RoutineDef *rd, TypeCheckObj *tco)
{
	RoutineIntf* ri = rd->get_routineIntf();
	bool make = ri->tag() == RoutineIntf::MakeHeaderT;
	tco->inside_maker = make;
	tco->inside_maker_and_before_mkstmt = make;
	string nm = ri->get_id()->get_id();
	Signature *sig = ri->get_signature();
	ParseNodeList *parms = sig->get_parms();
	ParseNodeList *restricts = sig->get_where();
	tco->env = tco->env->add_mark();
	int count = parms? count_parms(parms) : 0;
	if (!parms && restricts) add_optional_restrictions(restricts, tco);
	if (parms) parms2vec(parms, 0, restricts, count, tco);

	check_routine_intf(ri, tco);
	rd->set_cdef((ClassDef*)tco->maker_class);
	if (make) {
		tco->inside_make_body = TRUE;
		tco->have_make_stmt = FALSE;
		}
	Body* b = rd->get_body();
	check_body(b, tco);
	if (make) {
		tco->inside_make_body = FALSE;
		if (!tco->have_make_stmt)
			cmp_err("Maker lacks make statement", ri->get_line());
		}
	else {
		if (tco->have_make_stmt)
			cmp_err("Make statement not inside a maker.",
				ri->get_line());
		}
      tco->have_make_stmt = FALSE;

      string nm2 = string_concat(nm, string_const("_IMPL"));
      TypeInterface *ti = ri->get_type();
      rd->type_ = ti;
      // for each restriction on a parameter see if param_ORIG exists
      //    if so, update the methods field in the globally accessible
      //    param to reflect the methods_ in param_ORIG
      ParseNodeList *rl = ri->get_signature()->get_where();
      if (rl) for (Pix p = rl->first(); p ; rl->next(p)) {
        Restriction *r = (Restriction *)(*rl)(p);
        Id *id = r->get_TypeId();
        string save_nm = string_concat(id->get_id(),
                                string_new("_ORIG"));
        NameBinding *b = tco->env->look_up (save_nm);
        if (b && b->tag() == NameBinding::TypeBindingT) {
           type savet = b->get_type()->get_type();
           if (savet) {
                b = tco->env->look_up (id->get_id());
                type globt = b->get_type()->get_type();
                param save_param = type_as_param(savet);
                param global_param = type_as_param(globt);
                global_param->methods_ = save_param->methods_;
                }
           }
        }
      tco->env = tco->env->clear_mark();
      // check def against spec for stand-alone routines
      //        (methods have already been checked against type specs)
      if (!tco->inside_class_def) {
	// 2/6/97: dwc: changed from type to var for consistency with
	//		next clause and rtn spec...
        TypeInterface *spec_ti = get_var(nm, tco->env);
        if (spec_ti == 0) { 
                tco->env = tco->env->add_var_binding(nm, ti);
                }
        else {
                method m1 = ti->get_method();
                method m2 = spec_ti->get_method();
                check_rtn_against_rtn_spec(m1, m2, rd->get_line());
                }
        }
	tco->maker_class = 0;
	tco->inside_maker = FALSE;

	}

void check_method_def(RoutineDef *rd, TypeCheckObj *tco)
{
	check_routine_def(rd, tco);
//	RoutineIntf* ri = rd->get_routineIntf();
//	ParseNodeList *parms = sig->get_parms();
//	ParseNodeList *restricts = sig->get_where();
//	tco->env = tco->env->add_mark();
//	int count = parms? count_parms(parms) : 0;
//	if (!parms && restricts) add_optional_restrictions(restricts, tco);
//	if (parms) parms2vec(parms, 0, restricts, count, tco);
//	check_method_intf(ri, tco);
//	Body* b = rd->get_body();
//	check_body(b, tco);
//	tco->env = tco->env->clear_mark();
	}

void check_class_def(ClassDef *cd, TypeCheckObj *tco)
{
ParseNodeList *parms = cd->get_parms();
ParseNodeList *restricts = cd->get_wheres();
bool exists;
TypeInterface *ti;
type nt;
pclass pc;
class_ c = 0;
string nm;

	tco->current_class = cd;
	tco->inside_class_def = TRUE;

	// Build a class_ Object
        if (parms) {
                nm = string_concat(cd->get_classId()->get_id(),
                                        parms2nm(parms));
                exists = FALSE;
                if (tco->env->look_up(nm)) exists = TRUE;
                if (exists) {
                        ti = cd->get_type();
                        nt = cd->get_type()->get_type();
			pc = ptype_as_pclass(type_as_ptype(nt));
                        c = type_as_class(nt);
                        }
                else {
                        pc = new_pclass();
                        pc->hdr.inh.hdr.inh.name = cd->get_classId()->get_id();
                        pc->special = FALSE;
                        pc->specialText = string_empty();
                        pc->superclass = superclass_from_inherits(
                                cd->get_inherits(), tco);
                        nt = ptype_as_type(pclass_as_ptype(pc));
                        c = type_as_class(nt);
                        ti = new TypeInterface(nt);
                        }
                }
        else {
                nm = cd->get_classId()->get_id();
                exists = FALSE;
                if (tco->env->look_up(nm)) exists = TRUE;
                if (exists) {
                        ti = cd->get_type();
                        nt = cd->get_type()->get_type();
                        // recompute fields (and their types)
                        if (nt) {
                                c = type_as_class(nt);
                                c->fields = formals_from_decls(cd->get_decl(), tco);
                        	c->superclass = superclass_from_inherits(
                               		 cd->get_inherits(), tco);
                                }
                        }
                else {
                        c = new_class();
                        c->hdr.inh.name = cd->get_classId()->get_id();
                        c->fields = formals_from_decls(cd->get_decl(), tco);
                        c->special = FALSE;
                        c->specialText = string_empty();
                        c->superclass = superclass_from_inherits(
                                cd->get_inherits(), tco);
                        nt = class_as_type(c);
                        ti = new TypeInterface(nt);
                        }
                }
	if (exists && !tco->allow_redefs) {
                sprintf(cmp_err_buf, "Attempted redefinition "
                        "of %.50s foiled", string_charp(nm));
                cmp_err(cmp_err_buf, cd->get_line());
                tco->redef_count++;
                return;
                }
        else {
                cd->type_ = ti;
                if (exists) tco->env->update_binding(nm, ti);
                else tco->env = tco->env->add_type_binding(nm, ti);
                }
        tco->env = tco->env->add_mark();

        // We are now inside the mark.  Need to get the parms, if any,
        // into the environment.  (Don't want parms in outer scope.)
        // Then set current_type, which will need an instantiation to
        // happen, in the parmd case.

        if (parms) {
            int count = count_parms(parms);
            vec v = parms2vec(parms, pclass_as_ptype(pc), restricts,
                                        count, tco);
                // 2/20/96: dwc: relocated from earlier context:
                //      it needs to have the parms in the environment
            c->fields = formals_from_decls(cd->get_decl(), tco);
            if (!exists) {
                init_instn_name(pclass_as_ptype(pc),
                        type_as_objtype(ptype_as_type(pclass_as_ptype(pc))),
                        v);
                }
             }

        // Set up current_type in this
	TypeSpec *dt = cd->get_deftype();
	if (dt) {
		set_node_type(dt, dt, tco, TRUE);
        	tco->set_current_deftype(dt);
		}
	else tco->set_current_deftype(NULL);
	type dtt = dt? dt->get_type()->get_type(): 0;

	// reordered so that defining type info is available for def_type
	// field of methods.
        if (!exists) {
           if (parms) {
                pc->hdr.inh.hdr.inh.methods_ = make_vec_Method(0, FALSE);
                pc->hdr.inh.hdr.inh.methods_ = methods_from_def(cd, nt,dtt,tco);
	       }
	   else {
                c->hdr.inh.methods_ = make_vec_Method(0, FALSE);
                c->hdr.inh.methods_ = methods_from_def(cd, nt, dtt, tco);
		}
	    }

        string dtnm = string_empty();
        if (dt) switch (dt->tag()) {
           case TypeSpec::SimpleTypeSpecT: {
                dtnm = ts2nm(dt, cd->get_line());
                break;
                }
           case TypeSpec::ParamTypeSpecT: {
                ParamTypeSpec *pts = (ParamTypeSpec *)dt;
                set_node_type(pts, pts, tco, TRUE);
                dtnm = pts->get_name()->get_name()->get_id();
                dtnm = string_concat(dtnm, parms2nm(parms));
                break;
                }
           }
        tco->set_current_type(get_type(dtnm, tco->env));
        if (tco->get_current_type() == 0) {
                // Used to complain here if there was no defining type
                // but that isn't Theta.  Can have private types.
                tco->set_current_type(new TypeInterface());
                }

        // Now do supertypes.  Well actually put current type as supertype.
        // It will get undone later.
        objtype objtnt = type_as_objtype(nt);
        vec sprs;
        if (tco->get_current_type() == 0 ||
                tco->get_current_type()->get_type() == 0) {
                sprs = make_vec_simple(Type, 0);
                }
        else {
                sprs = make_vec_simple(Type, 1);
                vec_store(sprs, 0, PV(tco->get_current_type()->get_type()));
                }
        handleSupertypes(objtnt, sprs);

        // Create the same_object routine and add it to the environment
        TypeInterface *so_ti = make_same_object_interface(nt);
        string so_nm = method_name(so_ti->get_method());
        tco->env = tco->env->add_var_binding(so_nm, so_ti);

        int i;
	// Add superclass methods to the environment, if any
	objtype sc = (c->superclass && vec_length(c->superclass))? 
			UNPV(objtype, vec_fetch(c->superclass, 0)) : 0;
	if (sc) {
        	int vsize = sc->methods_? vec_length(sc->methods_) : 0;
        	for (i = 0; i < vsize; i++) {
               	 	method m = UNPV(method, (vec_fetch(sc->methods_, i)));
                	tco->env = tco->env->add_var_binding(m->name,
                       		 new TypeInterface(m, 0));
                	}
		}
	
        // Add the class methods to the environment
        int vsize = vec_length(objtnt->methods_);
        for (i = 0; i < vsize; i++) {
                method m = UNPV(method, (vec_fetch(objtnt->methods_, i)));
                tco->env = tco->env->add_var_binding(m->name,
                        new TypeInterface(m, 0));
                }

        // Check Class Definition against itself, its type interface,
        //      its superclass
        check_def_against_type(nt, tco->get_current_type()->get_type(),
                                        cd->get_line(), tco->env);


	ParseNodeList *decls = cd->get_decl();
	check_ivars(decls, tco);

	ParseNodeList *eqs = cd->get_equates();
    	if (eqs) for (Pix p = eqs->first(); p; eqs->next(p)) {
		Equate *eq = (Equate *)(*eqs)(p);
		handle_equates(eq, TRUE, tco);
		}

	ParseNodeList *celts = cd->get_classElts();
	if (celts) for (Pix p = celts->first(); p; celts->next(p)) {
		ParseNode *pn = (*celts)(p);
		switch (pn->tag()) {
		case ParseNode::EquateT: {
			Equate *eq = (Equate *)pn;
			handle_equates(eq, TRUE, tco);
			break;
			}
		case ParseNode::MethodOrOpDefT:{
			MethodOrOpDef *mopd = (MethodOrOpDef *)pn;
			check_mopdef(mopd, tco);
			break;
			}
		}
	}

// Do some work here???

// Clean up
	tco->env = tco->env->clear_mark();
	handle_equates(cd, FALSE, tco);
	tco->inside_class_def = FALSE;
	tco->current_class = NULL;
    }


void check_routine_intf(RoutineIntf *ri, TypeCheckObj *tco)
{
    if (tco->inside_type_intf) tco->env = tco->env->add_mark();
    check_signature(ri->get_signature(), tco);
    TypeInterface *ti = ri->get_signature()->get_type();
    method m = 0;
    switch (ti->tag()) {
    	case TypeInterface::MethodT: {
      		m = ti->get_method();
      		break;
      		}
    	case TypeInterface::PMethodT: {
      		m = ti->get_pmethod();
      		break;
      		}
    	}
    if (m) m->name = ri->get_id()->get_id();
    if (m && ri->tag() == RoutineIntf::MakeHeaderT) m->mkr = TRUE;
    ri->type_ = ti;
    if (tco->inside_type_intf) tco->env = tco->env->clear_mark();
    }

// possibly add name as arg so that method can be built properly...
void check_signature(Signature *sig, TypeCheckObj *tco)
{
    ParseNodeList *parms = sig->get_parms();
    ParseNodeList *rl = sig->get_where();
    vec p = 0;
    if (parms) {
        int nparms = count_parms(parms);
        p = parms2vec(parms, 0, rl, nparms, tco);
    }
    check_decls(sig->get_args(), tco);
    method m = method_from_signature(sig, tco);
    tco->set_current_method(m);
    if (parms) sig->type_ = new TypeInterface(m, p);
    else sig->type_ = new TypeInterface(m, 0);
    if (tco->inside_maker) {
    	ParseNodeList *rets = sig->get_returns();
	if (!rets || rets->length() != 1) {
		cmp_err("Invalid maker: should return exactly one type.",				sig->get_line());
		return;
		}
	TypeSpec *ts = (TypeSpec *)rets->front();
	set_node_type(ts, ts, tco, TRUE);
	string nm = ts2short_nm(ts, ts->get_line());
	ClassDef *cd = tco->current_module? 
		find_class(nm, (ImplModule *)tco->current_module): 0;
	if (!cd) {
		cmp_err("Invalid maker: return type does not match any class"
			" in current module.", sig->get_line());
		return;
		}
	tco->maker_class = cd;
	m->self_type = cd->get_type()->get_type();
	TypeSpec *tsd = cd->get_deftype();
	m->def_type = tsd? tsd->get_type()->get_type(): 0;
	}
    }

void check_method_intf(RoutineIntf *ri, TypeCheckObj *tco)
{
	check_routine_intf(ri, tco);
	}

void check_ivars(ParseNodeList *decls, TypeCheckObj *tco)
{
	check_decls(decls, tco);
	}

void check_mopdef(MethodOrOpDef *mopd, TypeCheckObj *tco)
{
	RoutineDef *rd = mopd->get_routineDef();
	if (mopd->get_isOp()) check_routine_def(rd, tco); // is this used??
	else check_method_def(rd, tco);
	}

void check_body(Body *b, TypeCheckObj *tco)
{
	if (b) {
		ParseNodeList *eqs = b->get_equates();
		if (eqs) for (Pix p = eqs->first(); p; eqs->next(p)) {
			Equate *eq = (Equate *)(*eqs)(p);
			handle_equates(eq, TRUE, tco);
			}
		ParseNodeList *stmts = b->get_statements();
		if (stmts) for (Pix p = stmts->first(); p; stmts->next(p)) {
			Stmt *stmt = (Stmt *)(*stmts)(p);
			check_stmt(stmt, tco);
			}
		}
	}

void check_stmt(Stmt *stmt, TypeCheckObj *tco)
{
    switch (stmt->tag()) {
	case Stmt::DeclStmtT: {
		DeclStmt *declstmt =  (DeclStmt *)stmt;
		check_decl_stmt(declstmt, tco);
		break;
		}
	case Stmt::InitVarExprT: {
		InitVarExpr *ivestmt =  (InitVarExpr *)stmt;
		check_ive(ivestmt, tco);
		break;
		}
	case Stmt::InitVarInvokeT: {
		InitVarInvoke *ivistmt =  (InitVarInvoke *)stmt;
		check_ivi(ivistmt, tco);
		break;
		}
	case Stmt::AssignInvokeT: {
		// unused
		break;
		}
	case Stmt::AssignExprStmtT: {
		AssignExprStmt *aesstmt =  (AssignExprStmt *)stmt;
		check_aes(aesstmt, tco);
		break;
		}
	case Stmt::AssignExprT: {
		// unused
		break;
		}
	case Stmt::InvokeStmtT: {
		InvokeStmt *invstmt =  (InvokeStmt *)stmt;
		check_inv_stmt(invstmt, tco);
		break;
		}
	case Stmt::WhileStmtT: {
		WhileStmt *whilestmt =  (WhileStmt *)stmt;
		check_while(whilestmt, tco);
		break;
		}
	case Stmt::IfStmtT: {
		IfStmt *ifstmt =  (IfStmt *)stmt;
		check_if(ifstmt, tco);
		break;
		}
	case Stmt::TagcaseT: {
		Tagcase *tagcstmt =  (Tagcase *)stmt;
		check_tagc(tagcstmt, tco);
		break;
		}
	case Stmt::TypecaseT: {
		Typecase *typecstmt =  (Typecase *)stmt;
		check_typec(typecstmt, tco);
		break;
		}
	case Stmt::ReturnStmtT: {
		ReturnStmt *retstmt =  (ReturnStmt *)stmt;
		check_ret(retstmt, tco);
		break;
		}
	case Stmt::YieldT: {
		Yield *yieldstmt =  (Yield *)stmt;
		check_yield(yieldstmt, tco);
		break;
		}
	case Stmt::SignalStmtT: {
		SignalStmt *sigstmt =  (SignalStmt *)stmt;
		check_sig(sigstmt, tco);
		break;
		}
	case Stmt::ExitT: {
		Exit *exitstmt =  (Exit *)stmt;
		check_exit(exitstmt, tco);
		break;
		}
	case Stmt::BreakT: {
		check_break(stmt, tco);
		break;
		}
	case Stmt::ContinueT: {
		check_cont(stmt, tco);
		break;
		}
	case Stmt::BlockStmtT: {
		BlockStmt *blockstmt =  (BlockStmt *)stmt;
		Body *body = blockstmt->get_body();
		check_body(body, tco);
		break;
		}
	case Stmt::ResignalStmtT: {
		ResignalStmt *resigstmt =  (ResignalStmt *)stmt;
		check_resig(resigstmt, tco);
		break;
		}
	case Stmt::ExceptStmtT: {
		ExceptStmt *excptstmt =  (ExceptStmt *)stmt;
		check_excpt(excptstmt, tco);
		break;
		}
	case Stmt::InitT: {
		Init *initstmt =  (Init *)stmt;
		check_init(initstmt, tco);
		break;
		}
	case Stmt::DeclForStmtT: {
		DeclForStmt *declforstmt =  (DeclForStmt *)stmt;
		check_declfor(declforstmt, tco);
		break;
		}
	case Stmt::ForStmtT: {
		ForStmt *forstmt =  (ForStmt *)stmt;
		check_for(forstmt, tco);
		break;
		}
	}
   }

void check_if(IfStmt *ifstmt, TypeCheckObj *tco)
{
   Expr *ex = ifstmt->get_expr();
   check_bool(ex, tco);
   Body* b = ifstmt->get_body();
   check_body(b, tco);
   ParseNodeList *elseifs = ifstmt->get_elseifs();
   if (elseifs) for (Pix p = elseifs->first(); p ; elseifs->next(p)) {
   	ElseIf *ei = (ElseIf *)(*elseifs)(p);
   	ex = ei->get_expr();
   	check_bool(ex, tco);
   	b = ei->get_body();
   	check_body(b, tco);
	}
   b = ifstmt->get_elsebody();
   if (b) {
   	check_body(b, tco);
	}
   int elses = elseifs?elseifs->length():0;
   for (int i = 0; i < elses ; i++) {
	}
      Expr *e = ifstmt->get_expr();
      type et = get_one_type(e->get_type(), e->get_line());
      type bt = tco->env->look_up(string_const("bool"))->get_type()->get_type();
      if (!(et && isSubtype(et, bt)))
      cmp_err("Invalid If Statement: the expression is not a boolean.",
                ifstmt->get_line());
   }

void check_decl_stmt(DeclStmt *declstmt, TypeCheckObj *tco)
{
   check_decl(declstmt->get_decl(), tco);
   }

void check_ive(InitVarExpr *ivestmt, TypeCheckObj *tco)
{
   Decl *decl = ivestmt->get_decl();
   Expr *ex = ivestmt->get_expr();
   int lineno = ivestmt->get_line();
      check_expr(ex, tco);
      check_decl(decl, tco);
      switch (decl->tag()) {
      case Decl::RegDeclT: {
        RegDecl *d = (RegDecl *) decl;
        type dt = d->get_type()->get_type();
        type et = get_one_type(ex->get_type(), lineno);
        if (!(dt && et && isSubtype(et, dt))) {
		sprintf(cmp_err_buf, 
			"Invalid assignment due to type mismatch (IVE)."
			" %s is not a subtype of %s",
			et? string_charp(type_name(et)) : "NONE",
			dt? string_charp(type_name(dt)) : "NONE");
		cmp_err(cmp_err_buf, lineno);
                }
        break;
      }
      case Decl::ImplDeclT: {
        cmp_err("Unexpected ImplDecl in InitVarExpr.", lineno);
        break;
      }
//      case Decl::VarArgsDeclT: {
//       cmp_err("Unexpected VarArgsDecl in InitVarExpr.", lineno);
//      break;
//      }
      }
   }

void check_ivi(InitVarInvoke *ivistmt, TypeCheckObj *tco)
{
Invoc *inv = ivistmt->get_invoc();
int line = ivistmt->get_line();

      ParseNodeList *dl  = ivistmt->get_decls();

      check_decls(dl, tco);
      check_inv(inv, tco);

      TypeInterface *ti = ivistmt->get_invoc()->get_type();
      int nids = count_lhs(ivistmt->get_decls());
      switch (ti->tag()) {
      case TypeInterface::MultipleT: {
      // Check numbers of types
      if (vec_length(ti->get_mult()) != nids) {
                cmp_err("Invalid assigment because number of return"
		        " values differs from number needed.", line);
                }
      // iterate matching types
      Pix pe, pi;
      int i = 0;
      for (pi = dl->first(); pi; dl->next(pi)) {
        type dlt = (*dl)(pi)->get_type()->get_type();
        ParseNode *pnd = (*dl)(pi);
        // Assumes regdecl...
        ParseNodeList *pnl = ((RegDecl*)pnd)->get_ids();
          for (int j = 0; j < pnl->length(); j++) {
          type pet = (type)vec_fetch(ti->get_mult(), i);
          if (!(pet && dlt && isSubtype(pet, dlt))) {
            	sprintf(cmp_err_buf,
                        "Invalid assignment due to type mismatch (IVI)."
                        " %s is not a subtype of %s",
                        pet? string_charp(type_name(pet)) : "NONE",
                        dlt? string_charp(type_name(dlt)) : "NONE");
                cmp_err(cmp_err_buf, line);}
         i++;
         }
      }
      break;
      } // end mult

      case TypeInterface::SingleT: {
      if (nids != 1) {
                cmp_err("Invalid assigment because number of"
			" return values differs from number needed.",
			line);
                break;
                }
      else {
        Pix p = dl->first();
        type t = ti->get_type();
        type dlt = (*dl)(p)->get_type()->get_type();
        if (!(t && dlt && isSubtype(t, dlt))) {
            	sprintf(cmp_err_buf,
                        "Invalid assignment due to type mismatch (IVI)."
                        " %s is not a subtype of %s",
                        t? string_charp(type_name(t)) : "NONE",
                        dlt? string_charp(type_name(dlt)) : "NONE");
                cmp_err(cmp_err_buf, line);}
        }
      break;
      } // end single
      default: {
        cmp_err("Invalid assignment due to type mismatch (IVI).", line);
        }

      } // end switch

   }

void check_aes(AssignExprStmt *aesstmt, TypeCheckObj *tco)
{
   int line = aesstmt->get_line();
   // check store statement
   // note: a[i], b[i] := 1,3 needs to be suppressed somewhere
   // note: a[i,j,k] shouldn't be allowed somewhere

      ParseNodeList *el  = aesstmt->get_exprs();
      check_exprs(el, tco);
      ParseNodeList *lhs  = aesstmt->get_ids();
      check_exprs(lhs, tco);
      int ecount = el->length();
      bool invocation = FALSE;
      TypeInterface *ti;
      if (ecount == 1) {
                Expr *e = (Expr*)el->front();
                ti = e->get_type();
                if (ti->tag() == TypeInterface::MultipleT) {
                        invocation = TRUE;
                        ecount = vec_length(ti->get_mult());
                        }
                }
      if (ecount != count_lhs(aesstmt->get_ids())) {
                cmp_err("Invalid assigment because number of"
			" return values differs from number needed.", line);
                return;
                }

      // Handle invocation case a, b := foo()
      if (invocation) {
      Pix pe, pi;
      int i;
      for (i = 0, pi = lhs->first(); pi; i++, lhs->next(pi)) {
        ParseNode *lhselt = (*lhs)(pi);
        TypeInterface *lti = lhselt->get_type();
        type lhst = ((IdOrIvar*)(*lhs)(pi))->get_type()->get_type();
        if (!lhst && lti->tag() == TypeInterface::MultipleT) {
                vec v  = lti->get_mult();
                if (vec_length(v) == 1) {
                        lhst = UNPV(type, vec_fetch(v, 0));
                        }
                }
        type pet = (type)vec_fetch(ti->get_mult(), i);
        if (!pet || !lhst || !isSubtype(pet, lhst)) {
             sprintf(cmp_err_buf,
                        "Invalid assignment due to type mismatch (AES)."
                        " %s is not a subtype of %s",
                        pet? string_charp(type_name(pet)) : "NONE",
                        lhst? string_charp(type_name(lhst)) : "NONE");
                   cmp_err(cmp_err_buf, line);}
      }
      return;
     }
      // Handle non-invocation case  a, b := 1, 2
      Pix pe, pi;
      int i;
      for (i = 1, pe = el->first(), pi = lhs->first();
           pe && pi; i++, el->next(pe), lhs->next(pi)) {
        Expr *e = (Expr*)(*el)(pe);
        ParseNode *lhselt = (*lhs)(pi);
        TypeInterface *lti = lhselt->get_type();
        type lhst = lti->get_type();
        type pet = ((Expr*)(*el)(pe))->get_type()->get_type();
        if (!lhst && lti->tag() == TypeInterface::MultipleT) {
                vec v  = lti->get_mult();
                if (vec_length(v) == 1) {
                        lhst = UNPV(type, vec_fetch(v, 0));
                        }
                }
        if (!pet || !lhst || !isSubtype(pet, lhst)) {
             sprintf(cmp_err_buf,
                        "Invalid assignment due to type mismatch (AES)."
                        " %s is not a subtype of %s",
                        pet? string_charp(type_name(pet)) : "NONE",
                        lhst? string_charp(type_name(lhst)) : "NONE");
                   cmp_err(cmp_err_buf, line);}
      }

   }

void check_inv_stmt(InvokeStmt *invstmt, TypeCheckObj *tco)
{
   Invoc *inv = invstmt->get_invoc();
   check_inv(inv, tco);
   }

void check_while(WhileStmt *ws, TypeCheckObj *tco)
{
      check_bool(ws->get_expr(), tco);
      tco->active_loops += 1;
      Body *body = ws->get_body();
      check_body(body, tco);
      tco->active_loops -= 1;
   }

// NOT IMPLEMENTED
void check_tagc(Tagcase *tagcstmt, TypeCheckObj *tco)
{
   cmp_err("Tagcase not implemented.", tagcstmt->get_line());
   Body* body = tagcstmt->get_body();
   check_body(body, tco);
   }

void check_typec(Typecase *typecstmt, TypeCheckObj *tco)
{
int line = typecstmt->get_line();
Expr *ex = typecstmt->get_expr();
ParseNodeList *arms = typecstmt->get_typeWhenArms();

	check_expr(ex, tco);
	if (arms) for (Pix p = arms->first() ; p ; arms->next(p)) {
		tco->env = tco->env->add_mark();
		TypeWhenArm *arm = (TypeWhenArm *)(*arms)(p);
       		TypeSpec *ts = arm->get_typ();
		check_typespec(ts, tco);
		Id *id = arm->get_id();
		if (id) {
                	RESET_EXC
                	tco->env = tco->env->add_var_binding(
				id->get_id(), ts->get_type());
                	CATCH_EXC(exc_duplicate) {
                   	sprintf(cmp_err_buf, "Duplicate name: %.50s",
                           	string_charp(id->get_id()));
                   	cmp_err(cmp_err_buf, id->get_line());
                	}
		    id->type_ = ts->type_;
		    }
		check_body(arm->get_body(), tco);
		tco->env = tco->env->clear_mark();
	}
   	Body* body = typecstmt->get_body();
   	if (body) {
   		check_body(body, tco);
		}

        type et  = get_one_type(ex->get_type(), line);
      type lastt = et;
      int index = 0;
      for (Pix p = arms->first(); p ; arms->next(p), index++) {
        TypeWhenArm *twa = (TypeWhenArm *)(*arms)(p);
        type armt = get_one_type(twa->get_typ()->get_type(), twa->get_line());

        // each arm's expr's type must be a proper(?) subtypes of expr's type
        if (!(armt && et && isSubtype(armt, et) && !isSubtype(et, armt))) {
        	sprintf(cmp_err_buf,
               	 "Invalid typecase statement due to type mismatch: "
               	 " %s is not a subtype of %s",
               	 armt? string_charp(type_name(armt)) : "NONE",
               	 et? string_charp(type_name(et)) : "NONE");
               cmp_err(cmp_err_buf, ex->line);
               break;
               }

        // order of types must be from narrowest to widest
        if (armt && lastt && !isSubtype(lastt, armt)) lastt = armt;
        else { sprintf(cmp_err_buf,
                "Invalid typecase statement due to type narrowing: "
                " %s is a subtype of %s",
                lastt? string_charp(type_name(lastt)) : "NONE",
                armt? string_charp(type_name(armt)) : "NONE");
               cmp_err(cmp_err_buf, ex->line);
               break;
              }
        // types enumerated in arms must be distinct
        int index2 = 0;
        for (Pix p2 = arms->first(); p2 ; arms->next(p2), index2++) {
           if (index == index2) continue;
           TypeWhenArm *twai = (TypeWhenArm *)(*arms)(p2);
           type ati = twai->get_typ()->get_type()->get_type();
           if (armt && ati && isSubtype(armt, ati) && isSubtype(ati, armt)) {
               sprintf(cmp_err_buf,
                "Invalid typecase statement due type arms "
		"types not being distinct: "
                " %s is not a subtype of %s",
                armt? string_charp(type_name(armt)) : "NONE",
                ati? string_charp(type_name(ati)) : "NONE");
               cmp_err(cmp_err_buf, ex->line);
               break;
               }
           }
        }

   }

void check_ret(ReturnStmt *retstmt, TypeCheckObj *tco)
{
   int size = 0;
   int line = retstmt->get_line();
   if (tco->inside_maker) {
	cmp_err("No return statements allowed inside a maker", line);
	return;
	}
   ParseNodeList *el = retstmt->get_exprs();
   check_exprs(el, tco);
   if (el) size = el->length();
   method m = tco->get_current_method();

   // If iter, return stmt is ok, but must have no values
   if (m->iter) {
        if (el != NULL) {
             cmp_err("Invalid return statement: no"
		     " return values allowed in an iterator.", line);
                        }
        }

   // Handle return in procedure
   else {
        // Handle zero returns
        if (el == NULL) {
                if (vec_length(m->returns) != 0) {
                  	cmp_err("Invalid return: needs values.", line);
			return;
                        }
                }
        // Check counts
        else {
                int ecount = el->length();
                if (ecount != vec_length(m->returns)) {
                	cmp_err("Invalid return: wrong number of values.",
                                line);
                        }
        // Iterate through lists
                else {
                        int i = 0;
                        for (Pix p = el->first(); p ; el->next(p), i++) {
                             Expr *e = (Expr *)(*el)(p);
                             TypeInterface *ti = e->get_type();
                             type et = get_one_type(e->get_type(),
                                                        e->get_line());
                             type rt = UNPV(type, vec_fetch(m->returns, i));
                             if (!et || !rt || !isSubtype(et, rt)) {
                                  sprintf(cmp_err_buf,
                                     "Invalid return statment due to "
				     "type mismatch: expected %.50s, "
				     "got %.50s.",
                                     rt?string_charp(type_name(rt)):" NONE",
                                     et?string_charp(type_name(et)):" NONE");
                                  cmp_err(cmp_err_buf, retstmt->get_line());
                                        }
                                }
                        }
                }
        }

   }

// NOT IMPLEMENTED
void check_yield(Yield *yieldstmt, TypeCheckObj *tco)
{
int line = yieldstmt->get_line();

      // cmp_err("Yield not implemented.", yieldstmt->get_line());
      // this code may be right.  code gen may not exist...
      ParseNodeList *el = yieldstmt->get_exprs();
      check_exprs(el, tco);
      method m = tco->get_current_method();
      // must be iter
      if (!m->iter) {
        cmp_err("Invalid yield statement: yield not allowed within procedure.",
                line);
        }
      else {
        // Handle zero yields
        if (el == NULL) {
                if (vec_length(m->returns) != 0) {
                  cmp_err("Invalid yield: needs values.", line);
                        }
                }
        // Check counts
        else {
                int ecount = el->length();
                if (ecount != vec_length(m->returns)) {
                  cmp_err("Invalid return: wrong number of values.", line);
                        }
        // Iterate through lists
                else {
                        int i = 0;
                        for (Pix p = el->first(); p ; el->next(p), i++) {
                                Expr *e = (Expr *)(*el)(p);
                                type et = get_one_type(e->get_type(), line);
                                type rt = UNPV(type, vec_fetch(m->returns, i));
                                if (!et || !rt || !isSubtype(et, rt)) {
                                        cmp_err("Invalid yield due to type "
						"mismatch", line);
                                        }
                                }
                        }
                }
        }

   }

void check_sig(SignalStmt *sigstmt, TypeCheckObj *tco)
{
   int line = sigstmt->get_line();
   ParseNodeList *el = sigstmt->get_exprs();
   check_exprs(el, tco);
   int size = 0;
   if (el) size = el->length();
   Id *id = sigstmt->get_id();
   string nm = id->get_id();
   method m = tco->get_current_method();

   // Handle the failure signal first
   if (string_equal(nm, string_const("failure"))) {
        if (el == NULL) {
            cmp_err("Invalid signal statement: "
	    "failure value missing.", line);
	    return;
            }
        if (el->length() != 1) {
            cmp_err("Invalid signal statement: "
		    "too many values for failure.", line);
	    return;
            }
        Pix p = el->first();
        Expr *e = (Expr *)(*el)(p);
        type et = e->get_type()->get_type();
        if (!et || !isSubtype(et, class_as_type(String))) {
                   cmp_err("Invalid failure signal: "
			   "argument should be a string", line);
		   }
	return;
	}

   // Find signal in signal list
   signal_ sig;
   int scount = vec_length(m->signals);
   if (scount == 0) {
                cmp_err("Invalid signal statement: no signals "
			"in current signature", line);
		return;
                }
   else {
        int found = 0;
        int i;
        for (i = 0; i < scount ; i++ ) {
                signal_ isig =  UNPV(signal_, vec_fetch(m->signals, i));
                if (string_equal(nm, isig->name)) {
                        found = 1;
                        sig = isig;
                        }
                    }
        if (found == 0) {
                cmp_err("Invalid signal statement: "
			"no such signal in current signature.", line);
                }
        else {
      // Check Exprs against expected types
          int vcount = vec_length(sig->returns);
      // Handle no values case
          if (el == NULL) {
                  if (vcount == 0) {}
                  else {
                          cmp_err("Invalid signal statement: "
					"values missing", line);
                          }
                  }
      // Check counts
          else {
                  if (el->length() != vcount) {
                          cmp_err("Invalid signal statement: "
					"wrong number of values.", line);
                          }
                  else {
      // Iterate over lists
                          int i = 0;
                          for (Pix p = el->first(); p ; el->next(p), i++){
                                  Expr *e = (Expr *)(*el)(p);
                                  type et = e->get_type()->get_type();
                                  type rt = UNPV(type, vec_fetch(sig->returns, i));
                                  if (!et || !rt || !isSubtype(et, rt)) {
                                          cmp_err("Invalid signal due "
						  "to type mismatch", line);
                          }
                        }
                    }
                }
            }
        }

   }

void check_exit(Exit *exitstmt, TypeCheckObj *tco)
{
   // Id *id = exitstmt->get_id();
   // string nm = id->get_id();
   if (tco->active_loops == 0)
	cmp_err("Invalid exit statement: not within a loop", 
		exitstmt->get_line());
   }

void check_break(Stmt *stmt, TypeCheckObj *tco)
{
   if (tco->active_loops == 0)
	cmp_err("Invalid break statement: not within a loop", 
		stmt->get_line());
   }

void check_cont(Stmt *stmt, TypeCheckObj *tco)
{
   if (tco->active_loops == 0)
	cmp_err("Invalid continue statement: not within a loop", 
		stmt->get_line());
   }

// void check_block(BlockStmt *bs, TypeCheckObj *tco)
// {
//    tco->env = tco->env->add_mark();
//    check_body(bs->get_body(), tco);
//    tco->env = tco->env->clear_mark();
//    }

void check_resig(ResignalStmt *resigstmt, TypeCheckObj *tco)
{
   int line = resigstmt->get_line();
   Stmt *stmt = resigstmt->get_stmt();
   check_stmt(stmt, tco);

   method m = tco->get_current_method();
   int scount = vec_length(m->signals);
   if (scount == 0) {
        cmp_err("Invalid resignal statement: "
		"no signals in current signature", line);
	return;
        }

   ParseNodeList * pnl = resigstmt->get_ids();
   for (Pix p = pnl->first(); p ; pnl->next(p)) {
     string nm = ((Id *)(*pnl)(p))->get_id();
     // Find signal in signal list
     int found = 0;
     for (int i = 0; i < scount ; i++ ) {
             signal_ isig =  UNPV(signal_, vec_fetch(m->signals, i));
             if (string_equal(nm, isig->name)) found = 1;
             }
     if (found == 0) {
	     sprintf(cmp_err_buf, "Invalid resignal statement: "
		"signal %s not found in current signature.", string_charp(nm));
	     cmp_err(cmp_err_buf, line);
             }
     }
   }

void check_excpt(ExceptStmt *excptstmt, TypeCheckObj *tco)
{
   Stmt *stmt = excptstmt->get_stmt();
   check_stmt(stmt, tco);
   ParseNodeList *arms = excptstmt->get_exWhenArm();
   if (arms) for (Pix p = arms->first(); p ; arms->next(p)) {
	tco->env = tco->env->add_mark();
	ExWhenArm *ewa = (ExWhenArm *)(*arms)(p);
   	ParseNodeList *ids = ewa->get_names();
	ParseNodeList *decls = ewa->get_decls();
	check_decls(decls, tco);
	Body *b = ewa->get_body();
	check_body(b, tco);
	tco->env = tco->env->clear_mark();
      	}
   Decl *d = excptstmt->get_decl();
   Body *b = excptstmt->get_body();
   if (d || b) {
	tco->env = tco->env->add_mark();
	if (d) {
		check_decl(d, tco);
		}
	if (b) check_body(b, tco);
	tco->env = tco->env->clear_mark();
	}
   }

void check_init(Init *initstmt, TypeCheckObj *tco)
{
   ParseNodeList *fis = initstmt->get_fieldInits();
   tco->have_make_stmt = TRUE;
   ClassDef *cd = (ClassDef *)tco->get_maker_class();
   initstmt->set_cdef(cd);
   check_field_inits(fis, tco);
   type t = cd? cd->get_type()->get_type(): 0;
   class_ c = t? type_as_class(t): (class_)NULL;
   int iv_count = c? vec_length(c->fields): 0;
   int fi_count = 0;
   int mcount = 0;
   if (fis) for (Pix p = fis->first(); p; fis->next(p)) {
        FieldInit *fi = (FieldInit *)(*fis)(p);
	fi_count++;
	string finm = fi->get_id()->get_id();
	type fit = get_one_type(fi->get_type(), fi->get_line());
	bool found = FALSE;
	for (int i = 0; i < iv_count; i++) {
		formal f = UNPV(formal, vec_fetch(c->fields, i));
		if (string_equal(finm, f->name)) {
			found = TRUE;
			type ivt = f->t;
			mcount++;
			if (!ivt || !fit || !isSubtype(fit, ivt)) {
			    sprintf(cmp_err_buf,
				"Invalid field init"
				" for field %.50s:"
				" %.50s is not a subtype of %.50s.",
				string_charp(f->name),
				ivt?string_charp(type_name(ivt)):"NONE",
				fit?string_charp(type_name(fit)):"NONE");
			    cmp_err(cmp_err_buf, initstmt->get_line());
			    break;
			    }
			}
		}
	if (found == FALSE) {
		sprintf(cmp_err_buf,
			"Invalid field init:"
			" class %.50s has no field named %.50s.",
			c? string_charp(type_name(t)): "NONE",
			string_charp(finm));
		cmp_err(cmp_err_buf, fi->get_line());
		}
	}
   if (fi_count != iv_count) {
	sprintf(cmp_err_buf,
	    	"Invalid field init:"
	    	" class %.50s has %d fields but there are"
	    	" %d field inits.",
		c? string_charp(type_name(t)): "NONE", iv_count, fi_count);
	cmp_err(cmp_err_buf, initstmt->get_line());
	}
   Invoc *inv = initstmt->get_invoc();
   if (inv) {
	string cname = cd? cd->get_classId()->get_id(): 0;
	TypeInterface *ti = cd? get_type(cname, tco->env): 0;
	type t = ti? ti->get_type(): 0;
	class_ sprc = t? get_super_class(t) : 0;
	if (sprc) check_maker_inv(sprc, inv, tco);
	else cmp_err("No superclass in which to find this maker.",
			inv->get_line());
	}
   Body* body = initstmt->get_body();
   tco->inside_maker_and_before_mkstmt = FALSE;
   if (body) {
   	tco->set_current_class(cd);
   	tco->env = tco->env->add_mark();
	if (cd) check_ivars(cd->get_decl(), tco);
	check_body(body, tco);
   	tco->env = tco->env->clear_mark();
   	tco->set_current_class(NULL);
	}
   }

void check_declfor(DeclForStmt *declforstmt, TypeCheckObj *tco)
{
   int line = declforstmt->get_line();
   // cmp_err("This for statement is not supported in version 0.",
   // 		declforstmt->get_line());
   // return;

   tco->env = tco->env->add_mark();
   tco->active_loops += 1;

   ParseNodeList *dl  = declforstmt->get_decls();
   check_decls(dl, tco);
   Invoc *inv = declforstmt->get_invoc();
   check_inv(inv, tco);
   Body* body = declforstmt->get_body();
   check_body(body, tco);

   tco->env = tco->env->clear_mark();
   tco->active_loops -= 1;

   method m = inv->get_routineId()-> get_type()->get_method();
   TypeInterface *ti = inv->get_type();
   vec v = ti->get_mult();

   // Check that invoc is an iter
   if (!m || !m->iter) {
         cmp_err("Invalid for statement: needs an iterator.", line);
	 return;
         }
   // Check result count vs. count of ids
   int vcount = vec_length(m->returns);
   int icount = count_lhs(dl);
   if (icount != vcount) {
           cmp_err("Invalid for statement: wrong number of identifiers.",
		line);
		return;
                }
   // Match id types with result types
   if (v && vcount != 0) {
         int i = 0;
	 // Loop through decls
         for (Pix p = dl->first(); p ; dl->next(p)) {
             type idlt = (*dl)(p)->get_type()->get_type();
             ParseNode *pnd = (*dl)(p);
	     // Loop through ids in each decl
             ParseNodeList *pnl = ((RegDecl*)pnd)->get_ids();
             for (int j = 0; j < pnl->length(); j++) {
		// Note that we do not need to fetch the type associated
		// with each id, as it is the same as the decl...
                 type rt = UNPV(type, vec_fetch(v, i));
                 if (!(rt && idlt && isSubtype(rt, idlt))) {
                          sprintf(cmp_err_buf,
                             "Invalid for statement due to type mismatch."
                             " %s is not a subtype of %s",
                             rt ? string_charp(type_name(rt)) : "NONE",
                             idlt ? string_charp(type_name(idlt)) : "NONE");
                             cmp_err(cmp_err_buf, declforstmt->get_line());
                             }
                 i++;
                 }
             }
          }
     else {
          cmp_err("Insufficient type information "
		  "to check for statement.", line);
          }

   }

void check_for(ForStmt *forstmt, TypeCheckObj *tco)
{
   int line = forstmt->get_line();
   tco->env = tco->env->add_mark();  // seems unnecessary...
   tco->active_loops += 1;

   ParseNodeList *idl  = forstmt->get_ids();
   check_ids(idl, tco);
   Invoc *inv = forstmt->get_invoc();
   check_inv(inv, tco);
   Body* body = forstmt->get_body();
   check_body(body, tco);

   tco->env = tco->env->clear_mark();
   tco->active_loops -= 1;

   TypeInterface *ti = inv->get_type();
   vec v = ti->get_mult();
   method m = inv->get_routineId()->get_type()->get_method();

   // Check that invoc is an iter
   if (!m || !m->iter) {
             cmp_err("Invalid for statement: needs an iterator.", line);
	     return;
             }
   // Check result count vs. count of ids
   int vcount = vec_length(m->returns);
   int icount = count_lhs(idl);
   if (icount != vcount) {
            cmp_err("Invalid for statement: wrong number of identifiers.",
                        line);
	    return;
            }
    // Match id types with result types
    if (v && vcount != 0) {
          int i = 0;
          for (Pix p = idl->first(); p ; idl->next(p), i++) {
              type idlt = (*idl)(p)->get_type()->get_type();
              type rt = UNPV(type, vec_fetch(ti->get_mult(), i));
              if (!(rt && idlt && isSubtype(rt, idlt))) {
                     sprintf(cmp_err_buf,
                        "Invalid for statement due to type mismatch."
                        " %s is not a subtype of %s",
                        rt ? string_charp(type_name(rt)) :"NONE",
                        idlt ? string_charp(type_name(idlt)):"NONE");
                        cmp_err(cmp_err_buf, forstmt->get_line());
			}
              }
           }
     else {
          cmp_err("Insufficient type information to "
	          "check for statement.", line);
                }
   }

void check_typespec(TypeSpec *ts, TypeCheckObj *tco)
{
   set_node_type(ts, ts, tco, TRUE);
   }

void check_decls(ParseNodeList *dl, TypeCheckObj *tco)
{
      if (dl) for (Pix p = dl->first(); p; dl->next(p)) {
	Decl *d = (Decl *)(*dl)(p);
	check_decl(d, tco);
	}
   }

void check_decl(Decl *decl, TypeCheckObj *tco)
{
    switch (decl->tag()) {

    case Decl::RegDeclT: {
          RegDecl *r = (RegDecl *)decl;
          TypeSpec *ts = r->get_typeSpec();
          set_node_type(ts, ts, tco, TRUE);
	  r->type_ = ts->type_;
          // iterate over ids in decl
          ParseNodeList l = *(r->get_ids());
          for (Pix p = l.first(); p ; l.next(p)) {
                Id *id = (Id*)l(p);
                string nm = id->get_id();
		if (tco->inside_maker_and_before_mkstmt && tco->maker_class) {
			ClassDef *cd = (ClassDef *)tco->maker_class;
			type t = cd->get_type()->get_type();
			class_ c = t? type_as_class(t): (class_)NULL;
			int iv_count = c? vec_length(c->fields) :0;
			int i;
			for (i = 0; i < iv_count; i++) {
				formal f = UNPV(formal, vec_fetch(c->fields,i));
				if (string_equal(f->name, nm)) {
                   			sprintf(cmp_err_buf, "Declaration for "
						"\"%.50s\" conflicts with "
						"instance variable.",
                           		string_charp(id->get_id()));
                   			cmp_err(cmp_err_buf, id->get_line());
					}
				}
			}
                RESET_EXC
                tco->env = tco->env->add_var_binding(nm, decl->type_);
                CATCH_EXC(exc_duplicate) {
                   sprintf(cmp_err_buf, "Duplicate name: %.50s",
                           string_charp(id->get_id()));
                   cmp_err(cmp_err_buf, id->get_line());
                }
		id->type_ = decl->type_;
        }
      break;
    }

    case Decl::ImplDeclT: {
          ImplDecl *imd = (ImplDecl *)decl;
          TypeSpec *ts = imd->get_typeSpec();
          set_node_type(ts, ts, tco, TRUE);
          set_node_type(ts, imd, tco, TRUE);
          // set type for id
          Id *id = imd->get_id();
          string nm = id->get_id();
          RESET_EXC
          tco->env = tco->env->add_var_binding(nm, decl->type_);
          CATCH_EXC(exc_duplicate) {
                  sprintf(cmp_err_buf, "Duplicate name: %.50s",
                   string_charp(id->get_id()));
                  cmp_err(cmp_err_buf, id->get_line());
           }
      break;
    }

// varargs needs work
//    case Decl::VarArgsDeclT: {
//        cmp_err("Unexpected VarArgsDecl in InitVarExpr.", lineno);
//	VarArgsDecl *vd = (VarArgsDecl *)decl;
//      break;
//    }
      break;
    }

   }

// void check_id_or_ivar(IdOrIvar *id, TypeCheckObj *tco)
// {
//   find_var(id->get_id()->get_id(), id, tco->env, TRUE);
//   }

void check_ids(ParseNodeList *idl, TypeCheckObj *tco)
{
   if (idl) for (Pix p = idl->first(); p; idl->next(p)) {
	Id *id = (Id *)(*idl)(p);
	check_id(id, tco);
	}
   }

void check_id(Id *id, TypeCheckObj *tco)
{
   // turned on verbose here, just see how much trouble it causes...
   find_var(id->get_id(), id, tco->env, TRUE);
   }

// void check_field_init(FieldInit *fi, TypeCheckObj *tco)
// {
//       Expr *fiex = fi->get_expr();
//      if (fiex->tag() == Expr::IllegalExprT) {
//        cmp_err("Badly formed field initializer.", fiex->get_line());
//        }
//      fi->type_ = fi->get_expr()->get_type();
//   }

void check_inv(Invoc *inv, TypeCheckObj *tco)
{
RoutineId *rid = inv->get_routineId();
	check_routine_id(rid, tco);
	check_inv_guts(inv, tco);
	}

void check_inv_guts(Invoc *inv, TypeCheckObj *tco)
{
int line = inv->get_line();
Pix p;
int i;
method m;
RoutineId *rid = inv->get_routineId();
ParseNodeList *l = inv->get_exprs();
ParseNodeList *last = inv->get_lastarg();
int lcount = l? l->length(): 0;
int lastcount = last? 1: 0;
int acount = 0;

	check_exprs(l, tco);
	check_exprs(last, tco);
        TypeInterface *iti = rid->get_type();
        // dwc: 7/31/95: reworked to disallow types here, only methods now
        if (!iti) {
                cmp_err("No type information for routine.", line);
                return;
                }

        m = iti->get_method();
        // Handle no method
        if (m == NULL) {
                cmp_err("No type information (or inappropriate type)"
			" for invocation.", line);
                return;
                }

	if (m->arguments) acount = vec_length(m->arguments);
        // Handle no arguments
        if (l == NULL && last == NULL) {
                if (acount != 0) {
                        cmp_err("Argument count mismatch.", inv->get_line());
                        }
                else {
                        if (vec_length(m->returns) > 0)
                                inv->type_ = new TypeInterface(m->returns);
                        }
                return;
                }

        // Check argument count
        if (!(m->arguments) || 
		(acount != lcount + lastcount)) {
                cmp_err("Argument count mismatch.", inv->get_line());
                return;
                }

        // Normal case
        if (l) for (i = 0, p = l->first(); p; l->next(p), i++) {
                formal f = UNPV(formal, vec_fetch(m->arguments, i));
                Expr *act = (Expr*)(*l)(p);
                type arg_type = get_one_type(act->get_type(), act->get_line());
                if (!arg_type || !f->t || !isSubtype(arg_type, f->t)) {
                        sprintf(cmp_err_buf,
                                "Invalid invocation on argument %.50s to %.50s:"
				" %.50s is not a subtype of %.50s.",
                                string_charp(f->name),
                                string_charp(method_name(m)),
                                arg_type?string_charp(type_name(arg_type)):"NONE",
                                f->t?string_charp(type_name(f->t)):"NONE");
                        cmp_err(cmp_err_buf, inv->get_line());
                        break;
                        }
                }
	// if there is a varying argument list, make that
	//	each of its members is a subtype of T, where the formal
	//	argument has type sequence[T]
	if (last) {
		formal f = UNPV(formal, vec_fetch(m->arguments, acount-1));
		type formalt = f->t;
		class_instn ci = formalt? type_as_class_instn(formalt) :0;
		vec v = ci? class_instn_get_pargs(ci): 0;
		type ft = v? UNPV(type, vec_fetch(v, 0)) : 0;
		if (ft) for (Pix p1 = last->first(); p1 ; last->next(p1)) {
			Expr *ex = (Expr*)(*last)(p1);
			type et = get_one_type(ex->get_type(), ex->get_line());
			if (!et || !ft || !isSubtype(et, ft)) {
				sprintf(cmp_err_buf,
					"Invalid invocation on (varying)"
					" argument %.50s to %.50s:"
					" %.50s is not a subtype of %.50s.",
					string_charp(f->name),
					string_charp(method_name(m)),
					et?string_charp(type_name(et)):"NONE",
					ft?string_charp(type_name(ft)):"NONE");
				cmp_err(cmp_err_buf, inv->get_line());
				break;
				}
			}
		else {
			sprintf(cmp_err_buf,
				"Invalid invocation of %.50s: caller has"
				" unexpected varying last argument.",
				string_charp(method_name(m)));
			cmp_err(cmp_err_buf, inv->get_line());
			}
		Expr *dummy = new Expr(Expr::NilT);
		dummy->type_ = new TypeInterface(formalt);
		inv->set_lastargType(dummy);
		}

        if (vec_length(m->returns) > 0)
                        inv->type_ = new TypeInterface(m->returns);

   }

void check_routine_id(RoutineId *rid, TypeCheckObj *tco)
{
    switch (rid->tag()) {

    case RoutineId::SimpleRoutineIdT: {
      SimpleRoutineId *sr = (SimpleRoutineId *)rid;
      Expr *ex = sr->get_primary();
      check_expr(ex, tco);
      check_not_maker(ex, tco);
      TypeInterface *ti = ex->get_type();
      if (ti->tag() != TypeInterface::MethodT) {
        cmp_err("Expected procedure or method type here",
                        sr->get_line());
        break;
        }
      sr->type_ = ex->get_type();
      rid->type_ = sr->type_;
      break;
    }

    case RoutineId::ComplexRoutineIdT:  {
      ComplexRoutineId *crid = (ComplexRoutineId *)rid;
      Expr *ex = crid->get_primary();
      check_expr(ex, tco);
      TypeInterface *ti = ex->get_type();
      if (ti->tag() != TypeInterface::PMethodT) {
        cmp_err("Expected parameterized procedure or method type here",
                        crid->get_line());
        break;
        }
      ParseNodeList *parms = crid->get_parms();
      vec pargs = tis2vec(parms, crid->get_line(), tco);
      if (!pargs) {
        cmp_err("Insufficient information to do instantiation",
                        crid->get_line());
        break;
        }
      method m = ti->get_pmethod();
      vec v = ti->get_parms();
      // possibly this 0 should be something else if inside a class...
      method instm = method_instantiate(m, 0, v, pargs);
      crid->type_ = new TypeInterface(instm, 0);
      rid->type_ = crid->type_;
      break;
    }

    case RoutineId::SuperClassRoutineIdT: {
      SuperClassRoutineId *sr = (SuperClassRoutineId *)rid;
      Id *id = sr->get_id();
      sr->type_ = new TypeInterface();
      rid->type_ = sr->type_;
      if (!tco->get_current_class()) break;
      ClassDef *cd = (ClassDef *) tco->get_current_class();
      type ctype = get_type(cd->get_classId()->get_id(), tco->env)->get_type();
      class_ cc = type_as_class(ctype);
      RESET_EXC;
      class_ sc = class_superclass(cc);
      CATCH { exc = EXC_NONE; break; }
      type sct = class_as_type(sc);
      RESET_EXC;
      fevalue tgm_ret[2];
      getTypeMethod(sct, tgm_ret, id->get_id());
      CATCH { exc = EXC_NONE; break; }
      method m  = (method) tgm_ret[0].o;
      sr->type_ = new TypeInterface(m,0);
      rid->type_ = sr->type_;
      break;
    }
  }

   }

void check_field_inits(ParseNodeList *fs, TypeCheckObj *tco)
{
   if (fs) for (Pix p = fs->first(); p; fs->next(p)) {
	FieldInit *f = (FieldInit *)(*fs)(p);
	check_field_init(f, tco);
	}
   }

void check_field_init(FieldInit *f, TypeCheckObj *tco)
{
Expr *ex = f->get_expr();
Id *id = f->get_id();

   check_expr(ex, tco);
   id->type_ = ex->type_;
   f->type_ = ex->type_;
   }

void check_fields(ParseNodeList *fs, TypeCheckObj *tco)
{
   if (fs) for (Pix p = fs->first(); p; fs->next(p)) {
	Field *f = (Field *)(*fs)(p);
	check_field(f, tco);
	}
   }

void check_field(Field *f, TypeCheckObj *tco)
{
TypeSpec *ts = f->get_typeSpec();
ParseNodeList *idl = f->get_ids();

   check_typespec(ts, tco);
   if (idl) for (Pix p = idl->first(); p; idl->next(p)) {
	Id *id = (Id *)(*idl)(p);
	id->type_ = ts->type_;
	}
   }

void check_exprs(ParseNodeList *el, TypeCheckObj *tco)
{
   if (el) for (Pix p = el->first(); p; el->next(p)) {
	Expr *ex = (Expr *)(*el)(p);
	check_expr(ex, tco);
	}
   }

void check_bool(Expr *ex, TypeCheckObj *tco)
{
   int line = ex->get_line();
   check_expr(ex, tco);
   type et = get_one_type(ex->get_type(), line);
   if (!(et && isSubtype(et, class_as_type(Bool))))
	cmp_err("Expected boolean expression not found.", line);
   }

void check_expr(Expr *ex, TypeCheckObj *tco)
{
    switch (ex->tag()) {

    case Expr::NilT: {
      ex->type_ = tco->env->look_up(string_const("null"))->get_type();
      break;
    }

    case Expr::LiteralT: {
      Literal *l = (Literal *) ex;

      switch (l->tag()) {
      case Literal::IntLiteralT: {
        ex->type_ = tco->env->look_up(string_const("int"))->get_type();
        break;
      }
      case Literal::BoolLiteralT:  {
        ex->type_ = tco->env->look_up(string_const("bool"))->get_type();
        break;
      }
      case Literal::CharLiteralT:  {
        ex->type_ = tco->env->look_up(string_const("char"))->get_type();
        break;
      }

      case Literal::StringLiteralT:  {
        ex->type_ = tco->env->look_up(string_const("string"))->get_type();
        break;
      }

      case Literal::RealLiteralT: {
        ex->type_ = tco->env->look_up(string_const("real"))->get_type();
        break;
      }
        break;
      } // end switch on lit's tag
      break;
    } // end litT

    case Expr::BinaryT: {
      // The only cases we should have to handle are AndT and OrT.
      // The others should have been handled in desugar
      // Note: these are really cand and cor (only eval 2nd arg if nec.)
      type t1, t2;
      Binary *bin = (Binary *)ex;
      check_bool(bin->get_op1(), tco);
      check_bool(bin->get_op2(), tco);
      switch (bin->tag()) {
        case Binary::AndT:
        case Binary::OrT:
             // both exprs should be boolean; if so set result type to boolean.
                t1 = get_one_type(bin->get_op1()->get_type(), bin->get_line());
                t2 = get_one_type(bin->get_op2()->get_type(), bin->get_line());
                break; // end  AndT/OrT case
        default:
                cmp_err("Unexpected binary op.", ex->get_line());
      } // end of bin tag switch
      // if both types are boolean then set bin type to boolean
      if (t1 && t2 && isSubtype(t1, class_as_type(Bool)) && 
			isSubtype(t2, class_as_type(Bool))) 
                bin->type_ = bin->get_op1()->get_type();
      else cmp_err("Type problems in binary expression.", bin->get_line());
      break;
    }
    case Expr::BracketRefT: {
      // This code assumes that the primary of a bracket ref
      //        has both fetch and store and that these methods
      //        are symmetric, i.e., that the storable and fetchable
      //        values have the same types and that a single expression
      //        is used as an index.
      // Now that typechecker has been re-organized, some rhs vs lhs
      // 	info could be available so that the "store" method
      //	is checked for the lhs situation.  This would be
      //	good for catching assignments to sequences.
      BracketRef *br = (BracketRef *)ex;
      Expr *prim = br->get_primary();
      check_expr(prim, tco);
      ParseNodeList *exprs = br->get_exprs();
      check_exprs(exprs, tco);
      // Try to see if this is a sugar ref for get or set.
      int size = exprs->length();
      if (size == 1) {
        TypeInterface *ti = prim->get_type();
        type t = get_one_type(ti, 97);
        fevalue tgm_ret[2];
        if (t) {
           RESET_EXC
           getTypeMethod(t, tgm_ret,
                                string_const("fetch"));
           CATCH {
                exc = EXC_NONE;
		cmp_err("Invalid bracket expression: no fetch method.",
			br->get_line());
                return;
                }
           method m  = (method) tgm_ret[0].o;
           // needs to take a single argument
           if (vec_length(m->arguments) != 1) {
		cmp_err("Invalid bracket expression: too many arguments"
			" to fetch method.",
			br->get_line());
		return;
		}
           // first elt of exprs needs to be a subtype of that argument
           formal f = UNPV(formal, vec_fetch(m->arguments, 0));
           type at = get_one_type(exprs->front()->get_type(), prim->get_line());
           if (!at || !f->t || !isSubtype(at, f->t)) {
                sprintf(cmp_err_buf, " %s is not a subtype of %s",
                                at?string_charp(type_name(at)):"NONE",
                                f->t?string_charp(type_name(f->t)):"NONE");
                cmp_err(cmp_err_buf, prim->get_line());
                return;
                }
           // needs to return one value
           if (vec_length(m->returns) != 1) {
                cmp_err("Too many return values for a fetch method.", prim->get_line());
                return;
                }
           // use that value for type of bracket ref
           //           a little overkill, but analogous to Invoc
           br->type_ = new TypeInterface(m->returns);
           }
        }
      else {
        cmp_err("Too many indexing expressions.", prim->get_line());

        }
      break;
    }
    case Expr::UnaryT: {
      break;
    }

    case Expr::InstantiationT: {
      break;
    }

    case Expr::DotExprT:  {
      fevalue tgm_ret[2];
      DotExpr *de = (DotExpr *)ex;
      int line = de->get_line();
      bool supercm = FALSE;
      Expr *eid = de->get_id();
      string m_name;
      switch (eid->tag()) {
	case Expr::IdExprT: {
		IdExpr *ide = (IdExpr *)eid;
		m_name = ide->get_id()->get_id();
		break;
		}
	case Expr::SuperIdT: {
		SuperId *sid = (SuperId *)eid;
		supercm = TRUE;
		m_name = sid->get_id()->get_id();
		break;
		}
	}
      Expr *prim = de->get_primary();
      check_expr(prim, tco);
      TypeInterface *ti = prim->get_type();
      type t = 0;
      switch (ti->tag()){
        case TypeInterface::SingleT: {
        	t = ti->get_type();
		break;
		}
       case TypeInterface::MultipleT: {
        	vec v  = ti->get_mult();
        	if (vec_length(v) != 1) {
               		 cmp_err("Invalid Dot Expression", line); 
			 return;
                	}
        	else {
               		 t = UNPV(type, vec_fetch(v, 0));
			break;
			}
		}
        default: {
		cmp_err("Dot Expr: unexpected TypeInterface.", line);
		return;
		}
	}
	if (supercm) {
		class_ c  = type_as_class(t);
		if (c->superclass && vec_length(c->superclass)) {
			c = UNPV(class_, vec_fetch(c->superclass, 0));
			t = class_as_type(c);
			}
		else {
			cmp_err("Dot Expr: attempting to invoke a superclass"
				" method with no superclass", line);
			return;
			}
		}

        RESET_EXC
        getTypeMethod(t, tgm_ret, m_name);
        CATCH {
	   // No method m_name found in for this type, look at ivars...
           exc = EXC_NONE;
           type ctype = 0;
           if (tco->get_current_class()) {
                    ClassDef *cd = (ClassDef *) tco->get_current_class();
                    // 2/19/96: dwc: revised s.t. there is no crash if
                    //          cd's name is not in env.
                    //          currently this only  happens if cd is
                    //          parmd, which needs to be fixed properly
                    //          sometime.
                    TypeInterface *cti = get_type(cd->get_classId()->get_id(),
                                                tco->env);
                    if (cti) ctype = cti->get_type();
                   }
           if (t && ctype && t == ctype) {
                Decl *d = find_ivar_decl(m_name, tco);
                if (d) {
                        de->type_ = d->get_type();
                        break;
                        }
                }
           if (t) {  // try other types' ivars
                RESET_EXC
                class_ c = type_as_class(t);
                if (exc == EXC_NONE) {
                   type itype = c->fields? class_get_field_type(c, m_name): 0;
                   if (itype) {
                        de->type_ = new TypeInterface(itype);
                        break;
                        }
                   }
                }
	   if (supercm) {
              sprintf(cmp_err_buf, "Type \"%.50s\" has no superclass method"
                   " \"%.50s\".",
                   string_charp(type_name(t)),
                   string_charp(m_name));
			}
	   else {
              sprintf(cmp_err_buf, "Type \"%.50s\" has no method (or ivar)"
                   " \"%.50s\".",
                   string_charp(type_name(t)),
                   string_charp(m_name));
		}
           cmp_err(cmp_err_buf, de->get_line());
           de->type_ = new TypeInterface();
         }
         else {
                method m  = (method) tgm_ret[0].o;
                TypeInterface *mti = new TypeInterface(m, 0);
                de->type_ = mti;
                }
	break;
   }

    case Expr::SelfT:  {
      // should check inside_make_body if inside_maker, unless
      // 	current_class exactly describes that situation...
      if (tco->current_class) {
                TypeInterface *ct = tco->current_class->get_type(); 
                ex->type_ = ct;
                }
      break;
    }
    case Expr::NewT:  {
      // needs inside maker test
      TypeInterface *ct = tco->current_type;         // TypeInterface *
      ex->type_ = ct;
      break;
    }
    case Expr::InvocExprT:  {
      InvocExpr *inve = (InvocExpr *)ex;
      Invoc *inv = inve->get_invoc();
      check_inv(inv, tco);
      inve->type_ = inv->get_type();
      break;
    }

    case Expr::BindingExprT: {
      break;
    }
    case Expr::ArrayRefT:  {
      break;
    }

    case Expr::SelectorConstrT:  {
      SelectorConstr *sc = (SelectorConstr *)ex;
      TypeSpec *ts = sc->get_typeSpec();
      check_typespec(ts, tco);
      TypeInterface *ti = ts->get_type();
      type t = ti->get_type();
      class_ sprc = get_super_class(t);
      ParseNodeList *sc_fields = sc->get_fields();
      check_field_inits(sc_fields, tco);
      Invoc *inv = sc->get_invoc();
      int nfields = count_lhs(sc_fields);
      int line = sc->get_line();
      switch (ts->tag()) {
        case TypeSpec::TaggedTypeSpecT: {
		if (inv != NULL) {
			cmp_err("No invocation allowed in this constructor",
			line);
			}
                TaggedTypeSpec *tts = (TaggedTypeSpec *)ts;
                string tts_name = tts->get_name()->get_name()->get_id();
                bool one = string_equal(tts_name, string_const("oneof"));
                bool rec = string_equal(tts_name, string_const("record"));
                string nm = ts2nm(tts, line);
                if (!one && !rec) {
                        sprintf(cmp_err_buf,
                                "Constructors not yet supported for %s",
                                string_charp(tts_name));
                        cmp_err(cmp_err_buf, line);
                        break;
                        }
                if (one && nfields != 1) {
                                sprintf(cmp_err_buf,
                                        "Wrong number of field initializers");
                                cmp_err(cmp_err_buf, line);
                                break;
                                }
                // create name for maker and look it up
                string nm2 = string_concat(nm, string_const("_MAKE"));
                type ft = 0;
                if (one) {FieldInit *fi = (FieldInit *) (sc_fields->front());
                        string fnm = fi->get_id()->get_id();
                        ft = fi->get_type()->get_type();
                        nm2 = string_concat(nm2, string_const("_"));
                        nm2 = string_concat(nm2, fnm);
                        }
                find_type(nm2, sc, tco->env, TRUE);
                TypeInterface *ti = sc->get_type();
                switch (ti->tag()) {
                  case TypeInterface::MethodT: {
                        method m = ti->get_method();
                        type at = UNPV(type, vec_fetch(m->arguments, 0));
                        if (one && !isSubtype(ft, at)) {
                                        sprintf(cmp_err_buf,
                                        "Invalid constructor due to "
                                        "type mismatch: %s is not "
                                        "a subtype of %s",
                                        ft?string_charp(type_name(ft))
                                                :"NONE",
                                        at?string_charp(type_name(at))
                                                :"NONE");
                                        cmp_err(cmp_err_buf, line);
                                        }
                                    }
                                } // end switch
                set_node_type(ts, ts, tco, TRUE);
                set_node_type(ts, sc, tco, TRUE);
                break;
                }
        case TypeSpec::ParamTypeSpecT:
        case TypeSpec::SimpleTypeSpecT: {
                // we hope this is an equated name
                // actually we're coming through here with init exprs
                //      i.e. any-old-type{...}
                // SimpleTypeSpec *sts = (SimpleTypeSpec *)ts;
                set_node_type(ts, ts, tco, FALSE);
                type t = ts->get_type()->get_type();
                if (!t) {
                        sprintf(cmp_err_buf, "Insufficient information "
                                "to check constructor");
                        cmp_err(cmp_err_buf, line);
                        break;
                        }
                else {
                   vec fields = type_as_class(t)->fields;
                   int fcount = vec_length(fields);
                   int index;
                   ParseNodeList *scfields = sc->get_fields();
                   int found_fields = 0;
                   int scount = scfields?scfields->length():0;
                   const char *snm = string_charp(simple_type_name(type_name(t)));
                   if (!strcmp(snm, "maybe")) {
			if (inv != NULL) {
			   cmp_err("No invocation allowed in this constructor",
			   line);}
                        // Handle maybes separately...
                        //    scount should be 1
                        if (scount != 1) {
                           cmp_err("Wrong number of initializers for maybe", line);
                           }
                        else {
                           //    field name should be full or empty
                           FieldInit *fi = (FieldInit*)scfields->front();
                           string fi_name = fi->get_id()->get_id();
                           TypeInterface *ti = fi->get_expr()->get_type();
                           type et = get_one_type(ti, line);
			   int fline = fi->get_line();
                           if (string_equal(fi_name, string_const("full"))) {
                              //    full value should have correct type
                              //              per field named value
                              formal f = UNPV(formal, vec_fetch(fields, 0));
                              type ft = f->t;
                              //    also decorate the id of the field init...
                              fi->get_id()->type_ = new TypeInterface(ft);
                              if (!(et && ft && isSubtype(et, ft))) {
                                  sprintf(cmp_err_buf,
                                     "Invalid field initialization"
                                     " for field %s due to type"
                                     " mismatch."
                                     " %s is not a subtype of %s",
                                     string_charp(fi_name),
                                     et ? string_charp(type_name(et))
                                     :"NONE",
                                     ft ? string_charp(type_name(ft))
                                     :"NONE");
                                  cmp_err(cmp_err_buf, fline);
                                  }
                              }
                           else {
                              if (string_equal(fi_name, string_const("empty"))) {
                                 //    empty value should be nil (or type null)
                                 type ft = class_as_type(Null);
                                 //    also decorate the id of the field init...
                                 fi->get_id()->type_ = new TypeInterface(ft);
                                 if (!(et && ft && isSubtype(et, ft))) {
                                     sprintf(cmp_err_buf,
                                        "Invalid field initialization"
                                        " for field %s due to type"
                                        " mismatch."
                                        " %s is not a subtype of %s",
                                        string_charp(fi_name),
                                        et ? string_charp(type_name(et))
                                        :"NONE",
                                        ft ? string_charp(type_name(ft))
                                        :"NONE");
                                     cmp_err(cmp_err_buf, fline);
                                     }
                                  }
                               else {
                                  cmp_err("Wrong field name for maybe", line);
                                  }
                               }
                          }
                        }
                   else {
			// Regular Constructor
                        if (fcount != scount) {
                                sprintf(cmp_err_buf,
                                    "Wrong number of initializers for type %s "
                                        "constructor", snm);
                                cmp_err(cmp_err_buf, line);
                                }
                        else {
                              if (scfields) for (Pix p = scfields->first(); p ;
                                                        scfields->next(p)) {
                                FieldInit *fi = (FieldInit*)(*scfields)(p);
                                string fi_name = fi->get_id()->get_id();
				int fline = fi->get_line();
                                TypeInterface *ti = fi->get_expr()->get_type();
                                type et = get_one_type(ti, line);
                                for (index = 0; index < scount; index++) {
                                        formal f = UNPV(formal,
                                                vec_fetch(fields, index));
                                        if (!string_equal(f->name, fi_name))
                                                continue;
                                        type ft = f->t;
                                        // as a side effect also decorate
                                        //  id of field init with appropriate
                                        //      type
                                        fi->get_id()->type_ =
                                                new TypeInterface(ft);
                                        if (!(et && ft && isSubtype(et, ft))) {
                                            sprintf(cmp_err_buf,
                                            "Invalid field initialization"
                                            " for field %s due to type"
                                            " mismatch."
                                            " %s is not a subtype of %s",
                                            string_charp(fi_name),
                                            et ? string_charp(type_name(et))
                                                :"NONE",
                                            ft ? string_charp(type_name(ft))
                                                :"NONE");
                                            cmp_err(cmp_err_buf, fline);
                                            }
                                        else found_fields++;
                                }
                              }
			    // The following clause is most certainly in the
			    // wrong place at this time...
                            if ((!strcmp(snm, "oneof") && found_fields != 1)
                                || (found_fields != scount) ) {
                                cmp_err("Incorrect number of field initializers",
                                        line);
                                }
			    // If this class has a super class it must
			    // have an invocation of a maker of its superclass
			    // otherwise it must *not* have an invoc!
			    if (sprc) {
				if (inv == NULL) {
					cmp_err("Maker invocation required in "
						"subclass constructor", line);
					}
				else {
					check_maker_inv(sprc, inv, tco);
					}
				}
			    else if (inv) {
					cmp_err("No invocation allowed in "
						"this constructor", line);
				}
                            }
                         }
                      }
                set_node_type(ts, ts, tco, TRUE);
                set_node_type(ts, sc, tco, TRUE);
                break;
                }
        default: {
                sprintf(cmp_err_buf, "Unexpected type for SelectorConstr");
                cmp_err(cmp_err_buf, line);
                }
        }
     break;
     }

    case Expr::ArrayConstrT:  {
      break;
    }

    case Expr::IdExprT: {
      IdExpr *ie = (IdExpr *)ex;
      Id *id = ie->get_id();
      check_id(id, tco);
      ie->type_ = id->type_;
      // 9/25/95 dwc: changed from find_var_or_type
      //        so that x: int := int wouldn't work...
      // find_var(nm, ex, tco->env, TRUE);
      break;
    }

    case Expr::IllegalExprT: {
      cmp_err("Illegal expression.", ex->get_line());
      break;
    }

   }
   }


extern string err_list;
#define MAX_ERR 50
int err_count = 0;
void cmp_err(const char *msg, int lineno)
{
char buf[1000];

	if (err_count >= MAX_ERR) return;
        // sprintf(buf, "Error: Line %4.d: %.800s\n", lineno, msg);
        sprintf(buf, "Error: line %d: %.800s\n", lineno, msg);
        // sprintf(buf, "%.10d: error: %.800s\n", lineno, msg);
        if (err_list == NULL) err_list = string_new(buf);
        else err_list = string_concat(err_list, string_new(buf));
	err_count++;
        }

#define MAX_CHECKPOINTS 10
static string save_err_list[MAX_CHECKPOINTS];
int save_err_count[MAX_CHECKPOINTS];
static int nchkpts = 0;

void cmp_err_check_point()
{
        save_err_list[nchkpts] = err_list;
	save_err_count[nchkpts] = err_count;
        nchkpts++;
        }

void cmp_err_return_to_checkpoint()
{
        nchkpts--;
        err_list = save_err_list[nchkpts];
	err_count = save_err_count[nchkpts];
        }


int count_lhs(ParseNodeList *lp)
{
int count = 0;

      if (lp == NULL) return 0;
      ParseNodeList l = *lp;
      for (Pix p = l.first(); p ; l.next(p)) {
        ParseNode *pn = l(p);
        switch (pn->tag()) {
        case ParseNode::DeclT: {
          Decl *arg = (Decl *)pn;
          switch (arg->tag()) {
            case Decl::RegDeclT: {
               RegDecl *r = (RegDecl *)arg;
               count += r->get_ids()->length();
               break;
               }
            case Decl::ImplDeclT: {
               count++;
               break;
               }
            }
          break;
          }
       case ParseNode::IdOrIvarT: {
         count++;
         break;
         }
       case ParseNode::FieldInitT: {
         count++;
         break;
         }
       case ParseNode::FieldT: {
         Field *f = (Field *)pn;
         count += f->get_ids()->length();
         break;
         }
       case ParseNode::IdT: {
         count++;
         break;
         }
       case ParseNode::ExprT: {
         /* this case may or may not be used... */
         count++;
         break;
         }
       default: {
        cmp_err("count_lhs not handling some node", pn->get_line());
          }
        }
      }
        return count;
}


/* During typechecking, classes have had the type they implement as their
        supertype.  This is not really kosher, so we clean it up here.
*/
void fix_class_supertypes(ParseNodeList *pnl)
{
    for (Pix p = pnl->first(); p ; pnl->next(p)) {
    ParseNode *pn = (*pnl)(p);
    switch (pn->tag()) {
        case ParseNode::ModuleT: {
            Module *m = (Module *) pn;
            switch (m->tag()) {
                case Module::ImplModuleT: {
                    ImplModule *im = (ImplModule *)m;
                    ParseNodeList *impls = im->get_impls();
                    for (Pix p2 = impls->first(); p2 ; impls->next(p2)) {
                        ImplElt *ie = (ImplElt*)(*impls)(p2);
                        switch (ie->tag()) {
                            case ImplElt::ClassDefT: {
                                ClassDef *cd = (ClassDef*)ie;
                                TypeInterface *ti = cd->get_type();
                                type t = ti->get_type();
                                objtype objt = type_as_objtype(t);
                                handleSupertypes(objt,
                                        make_vec_simple(Type, 0));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
 }
