// Copyright 1995 Barbara Liskov

#include "types/str.h"
#include "parse.h"
#include "types/class_class.h"
#include "types/any.h"
#include "types/vec.h"
#include "types/ptype.h"
#include "type_chk.h"
#include "types/type.h"
#include "types/type_def.h"
#include "types/class.h"
#include "types/objtype_class.h"
#include "types/pclass.h"
#include "types/pclass_class.h"
#include "types/method.h"
#include "types/vec_instns.h"
#include "types/param.h"
#include "types/param_class.h"

extern string err_list;

void check_subclassing_info(ImplModule *im, TypeCheckObj *tco);
bool check_provides(ClassDef *cd, ImplModule *im, ParseNodeList *p, 
			ParseNodeList *h);
vec inh_methods(type t, class_ c, ParseNodeList *p, ParseNodeList *h);
void inh_rtns_mkrs(ImplModule *im, ParseNodeList *provides, 
		vec *rtns, vec *mkrs);
bool impl_rtn_member(string nm, ImplModule *im);
bool cd_method(string nm, ClassDef *cd);
bool cd_public_method(string nm, ClassDef *cd);
bool cd_refined_method(string nm, ClassDef *cd);
bool impl_mkr_member(string nm, ImplModule *im);
method find_meth(string nm, type t);
RoutineDef *find_rtn(string nm, ImplModule *im);
method find_method(string nm, ClassDef *cd);
method find_public_method(string nm, ClassDef *cd);
ClassDef *find_class(string nm, ImplModule *im);
bool method_equal(method m1, method m2);
void insert_c_methods(vec v, int *index, class_ c, ParseNodeList *provides);
void insert_t_methods(vec v, int *index, objtype t, ParseNodeList *hides);
// int count_t_methods(objtype t, ParseNodeList *hides);
// int count_c_methods(class_ c, type t, ParseNodeList *provides);
bool idnlist_member(string nm, ParseNodeList *idl);

void check_subclassing_info(ImplModule *im, TypeCheckObj *tco)
{
    ParseNodeList *exports = im->get_exports();
    ParseNodeList *impls = im->get_impls();
    if (impls) for (Pix p = impls->first(); p; impls->next(p)) {
        ImplElt *ie = (ImplElt*)(*impls)(p);
        switch (ie->tag()) {
                case ImplElt::ClassDefT:{
                        ClassDef *cd = (ClassDef *)ie;
			ParseNodeList *provides = cd->get_provides();
			ParseNodeList *hides = cd->get_hides();
			bool doable = check_provides(cd, im, provides, hides);
			if (!doable) continue;

			TypeInterface *cti = cd->get_type();
			class_ c = type_as_class(cti->get_type());
			TypeSpec *ts = cd->get_deftype();
			type t = ts ? ts->get_type()->get_type() : 0;
			class_ sc = new_class();
			sc->hdr.inh.name = c->hdr.inh.name;
			sc->fields = make_vec_Formal(0, FALSE);
			sc->special = c->special;
			sc->specialText = c->specialText;
			sc->superclass = c->superclass;
			sc->hdr.inh.methods_ = make_vec_Method(0, FALSE);
			sc->hdr.inh.methods_ = inh_methods(t, c, 
							provides, hides);
			objtype scot = type_as_objtype(class_as_type(sc));
			objtype cot = type_as_objtype(class_as_type(c));
			scot->supertypes_ = cot->supertypes_;
			vec rtns = make_vec_Method(0, FALSE);
			vec mkrs = make_vec_Method(0, FALSE);
			inh_rtns_mkrs(im, provides, &rtns, &mkrs);

			TypeInterface *scti = new TypeInterface(sc, c,
							mkrs, rtns);
			string nm = cd->get_classId()->get_id();
			tco->env = tco->env->add_inhcl_binding(nm, scti);
                        break;
                        }
                }
        }
}

// See if this provides and hides clauses are satisfiable
bool check_provides(ClassDef *cd, ImplModule *im, ParseNodeList *provides,
		ParseNodeList *hides)
{
int line = cd->get_line();
string cnm = cd->get_classId()->get_id();

	// We're done if there is no provides clause.
	if (!provides && !hides) return FALSE;

	// Make sure that hides is empty only if provides is empty.
	if (hides && !provides) {
		cmp_err("Hides clause without provides clause.", line);
		return FALSE;
		}

	// Make sure the intersection between provides and hides is empty
	for (Pix p = provides->first(); p ; provides->next(p)) {
		Id *pid = (Id *)(*provides)(p);
		string pnm = pid->get_id();
		if (idnlist_member(pnm, hides)) {
			sprintf(cmp_err_buf, "Invalid subclass info: "
				" %s occurs in both hides and provides"
				" clauses.", string_charp(pnm));
			cmp_err(cmp_err_buf, line);
			return FALSE;
			}
		}
	// Make sure each idn in provides names a method in cd or a rtn in im
	//	and that, in the method case, the method is private or
	//	has a different signature from the public method.
	//	Also, ensure that each provides name names either a method
	//	or a rtn, but not both.
	for (Pix p = provides->first(); p ; provides->next(p)) {
		Id *pid = (Id *)(*provides)(p);
		string nm = pid->get_id();
		bool found = FALSE;
		if (impl_rtn_member(nm, im)) {
			found = TRUE;
			if (cd_method(nm, cd)) {
				sprintf(cmp_err_buf,"Invalid provides clause: "
				   "%s names both a method and a routine.",
					string_charp(nm));
				cmp_err(cmp_err_buf, line);
				}
			}
		if (cd_method(nm, cd)) {
			found = TRUE;
			if (impl_rtn_member(nm, im)) {
				sprintf(cmp_err_buf,"Invalid provides clause: "
				   "%s names both a method and a routine.",
					string_charp(nm));
				cmp_err(cmp_err_buf, line);
				}
			if (cd_public_method(nm, cd)) {
				if (!cd_refined_method(nm, cd)) {
					sprintf(cmp_err_buf,"Invalid provides"
					  " clause: %s names a public "
					  "method.", string_charp(nm));
					cmp_err(cmp_err_buf, line);
					}
				}
			}
		if (!found) {
			sprintf(cmp_err_buf, "Invalid provides clause: "
				"%s does not name a method or routine.",
					string_charp(nm));
			cmp_err(cmp_err_buf, line);
			}
		}

	// Make sure each idn in hides names a public method in cd.
	if (hides) for (Pix p = hides->first(); p ; hides->next(p)) {
		Id *hid = (Id *)(*hides)(p);
		string hnm = hid->get_id();
		if (!cd_public_method(hnm, cd)) {
			sprintf(cmp_err_buf, "Invalid hides clause: "
				"%s does not name a public method "
				"in class %s", string_charp(hnm),
				string_charp(cnm));
			cmp_err(cmp_err_buf, line);
			}
		}

	// Make sure that provides includes at least one maker
	bool found = FALSE;
	for (Pix p = provides->first(); p ; provides->next(p)) {
		Id *pnm = (Id *)(*provides)(p);
		if (impl_mkr_member(pnm->get_id(), im)) {
			found = TRUE;
			break;
			}
		}
	if (!found) {
		cmp_err("No maker in provides clause.", line);
		return FALSE;
		}
	return TRUE;
	}

bool cd_method(string nm, ClassDef *cd)
{
	method m = find_method(nm, cd);
	if (m) return TRUE;
	else return FALSE;
	}


bool cd_refined_method(string nm, ClassDef *cd)
{
	method pubm = find_public_method(nm, cd);
	method privm = find_method(nm, cd);
	if (method_equal(privm, pubm)) return FALSE;
	else return TRUE;
	}

bool cd_public_method(string nm, ClassDef *cd)
{
	method m = find_public_method(nm, cd);
	if (m) return TRUE;
	else return FALSE;
	}

method find_method(string nm, ClassDef *cd)
{
TypeInterface *ti = cd->get_type();
type t = ti->get_type();

	method m = find_meth(nm, t);
	return m;
	}

method find_public_method(string nm, ClassDef *cd)
{
TypeSpec *ts = cd->get_deftype();
type t = ts? ts->get_type()->get_type() : 0;

	if (!t) return NULL;
	method m = find_meth(nm, t);
	return m;
	}

method find_meth(string nm, type t)
{
fevalue tgm_ret[2];

	if (!t) return NULL;
	RESET_EXC
	getTypeMethod(t, tgm_ret, nm);
	CATCH {
		exc = EXC_NONE;
		return NULL;
		}
	else {
		method m  = (method) tgm_ret[0].o;
		return m;
		}
	}

bool impl_mkr_member(string nm, ImplModule *im)
{
	RoutineDef *rd = find_rtn(nm, im);
	RoutineIntf *ri = rd? rd->get_routineIntf() : 0;
	if (ri && ri->tag() == RoutineIntf::MakeHeaderT) return TRUE;
	else return FALSE;
	}

bool impl_rtn_member(string nm, ImplModule *im)
{
	RoutineDef *rd = find_rtn(nm, im);
	RoutineIntf *ri = rd? rd->get_routineIntf() : 0;
	if (ri) return TRUE;
	else return FALSE;
	}

ClassDef *find_class(string nm, ImplModule *im)
{
ParseNodeList *impls = im->get_impls();
	if (impls) for (Pix q = impls->first(); q; impls->next(q)) {
		ImplElt *ie = (ImplElt *)(*impls)(q);
		if (ie->tag() == ImplElt::ClassDefT) {
			ClassDef *cd = (ClassDef *)(ie);
			if (string_equal(cd->get_classId()->get_id(), nm)) 
				return cd;
			}
		}
	return NULL;
	}

RoutineDef *find_rtn(string nm, ImplModule *im)
{
ParseNodeList *impls = im->get_impls();
	if (impls) for (Pix q = impls->first(); q; impls->next(q)) {
		ImplElt *ie = (ImplElt *)(*impls)(q);
		if (ie->tag() == ImplElt::RoutineDefT) {
			RoutineDef *rd = (RoutineDef *)(ie);
			RoutineIntf *ri = rd->get_routineIntf();
			Id *rid = ri->get_id();
			if (string_equal(rid->get_id(), nm)) return rd;
			}
		}
	return NULL;
	}

bool method_equal(method m1, method m2)
{
	cmp_err("Method equal not implemented.", 0);
	return TRUE;
	}

vec inh_methods(type t, class_ c, ParseNodeList *provides, ParseNodeList *hides)
{
objtype oc = class_as_objtype(c);
int newcount = 0;
int index = 0;

	int mcount = vec_length(oc->methods_);
	for (int i = 0; i < mcount; i++) {
		method m = UNPV(method, vec_fetch(oc->methods_, i));
		if (find_meth(m->name, t)) {
			if (idnlist_member(m->name, hides)) continue;
			newcount++;
			}
		else {
			if (idnlist_member(m->name, provides)) newcount++;
			}
		}
        vec v = make_vec_Method(newcount, FALSE);
	for (int i = 0; i < mcount; i++) {
		method m = UNPV(method, vec_fetch(oc->methods_, i));
		if (find_meth(m->name, t)) {
			if (idnlist_member(m->name, hides)) continue;
			vec_store(v, index, PV(m));
			index++;
			}
		else {
			if (idnlist_member(m->name, provides)) {
				vec_store(v, index, PV(m));
				index++;
				}
			}
		}
	
        return v;
        }

// vec inh_methods(type t, class_ c, ParseNodeList *p, ParseNodeList *h)
// {
// vec v;
// int index = 0;
// 
// 	int mcount = t? count_t_methods(type_as_objtype(t), h) :0;
// 	mcount += count_c_methods(c, t, p);
// 	v = make_vec_Method(mcount, FALSE);
// 	if (t) insert_t_methods(v, &index, type_as_objtype(t), h);
// 	insert_c_methods(v, &index, c, p);
// 	return v;
// 	}

void inh_rtns_mkrs(ImplModule *im, ParseNodeList *provides, vec *prtns,
		vec *pmkrs)
{
int pass = 0;
int mcount = 0;
int rcount = 0;
vec mkrs;
vec rtns;
int mindex = 0;
int rindex = 0;

	ParseNodeList *impls = im->get_impls();
	while (impls && pass < 2) {
	for (Pix p = impls->first(); p ; impls->next(p)) {
		ImplElt *ie = (ImplElt *)(*impls)(p);
		if (ie->tag() == ImplElt::RoutineDefT) {
			RoutineDef *rd = (RoutineDef *)ie;
			RoutineIntf *ri = rd->get_routineIntf();
			bool mkr = (ri->tag() == RoutineIntf::MakeHeaderT);
			string rnm = ri->get_id()->get_id();
			for (Pix q = provides->first(); q; provides->next(q)) {
				Id *prid = (Id *)(*provides)(q);
				string pnm = prid->get_id();
				if (string_equal(pnm, rnm)) {
					if (pass == 0) {
						if (mkr) mcount ++;
						else rcount++;
						}
					else {
						method m = ri->get_type()->
							get_method();
						if (!m) m = ri->get_type()->
							get_pmethod();
						if (mkr) {
							vec_store(mkrs, mindex,
								PV(m));
							mindex++;
							}
						else {
							vec_store(rtns, rindex,
								PV(m));
							rindex++;
							}
						}
					}
				}
			}
		}
	if (pass == 0) {
		if (mcount) mkrs = make_vec_Method(mcount, 0);
		if (rcount) rtns = make_vec_Method(rcount, 0);
		}
	pass++;
	}
   if (mcount) *pmkrs = mkrs;
   if (rcount) *prtns = rtns;
   }

// int count_t_methods(objtype t, ParseNodeList *hides)
// {
// int result = 0;
// 
// 	int mcount = vec_length(t->methods_);
// 	for (int i = 0; i < mcount; i++) {
// 		method m = UNPV(method, vec_fetch(t->methods_, i));
// 		if (idnlist_member(m->name, hides)) continue;
// 		result++;
// 		}
// 	int nst = vec_length(t->supertypes_);
// 	for (i = 0; i<nst; i++) {
// 		result += count_t_methods(UNPV(objtype, 
// 				vec_fetch(t->supertypes_, i)), hides);
// 		}
// 	return result;
// 	}

bool idnlist_member(string nm, ParseNodeList *idl)
{
	if (idl) for (Pix q = idl->first(); q; idl->next(q)) {
		Id *id = (Id*)(*idl)(q);
		string inm = id->get_id();
		if (string_equal(nm, inm)) return TRUE;
		}
	return FALSE;
	}

// int count_c_methods(class_ c, type t, ParseNodeList *provides)
// {
// int result = 0;
// 
// 	for (Pix p = provides->first(); p ; provides->next(p)) {
// 		Id *id = (Id *)(*provides)(p);
// 		string pnm = id->get_id();
// 		method m = t? find_meth(pnm, t): 0;
// 		if (m) continue;
// 		m = find_meth(pnm, class_as_type(c));
// 		if (m) result++;
// 		}
//         return result;
//         }
// 
// void insert_t_methods(vec v, int *index, objtype t, ParseNodeList *hides)
// {
//         int mcount = vec_length(t->methods_);
//         for (int i = 0; i < mcount; i++) {
//                 method m = UNPV(method, vec_fetch(t->methods_, i));
//                 if (idnlist_member(m->name, hides)) continue;
// 		vec_store(v, *index, PV(m));
// 		*index += 1;
//                 }
//         int nst = vec_length(t->supertypes_);
//         for (i = 0; i<nst; i++) {
//                 insert_t_methods(v, index, 
// 			UNPV(objtype, vec_fetch(t->supertypes_, i)), hides);
//                 }
//         }
// 
// void insert_c_methods(vec v, int *index, class_ c, ParseNodeList *provides)
// {
// int result = 0;
// 
//         for (Pix p = provides->first(); p ; provides->next(p)) {
//                 Id *id = (Id *)(*provides)(p);
//                 string pnm = id->get_id();
//                 method m = find_meth(pnm, class_as_type(c));
//                 if (!m) continue;
// 		// check if this method should override one from the type.
// 		bool override = FALSE;
// 		for (int i = 0; i < *index; i++) {
// 			method vm = UNPV(method, vec_fetch(v, i));
// 			if (string_equal(vm->name, m->name)) {
// 				vec_store(v, i, PV(m));
// 				override = TRUE;
// 				}
// 			}
// 		if (override) continue;
// 		vec_store(v, *index, PV(m));
// 		*index += 1;
//                 }
//         }

class_ get_super_class(type t)
{
	if (t) {
		class_ c = type_as_class(t);
		if (c->superclass && vec_length(c->superclass)) {
			class_ sprc = UNPV(class_, vec_fetch(c->superclass, 0));
			return sprc;
			}
		}
	return NULL;
	}

void check_maker_inv(class_ sprc, Invoc *inv, TypeCheckObj *tco)
{
string cname = sprc->hdr.inh.name;
const char *csname = string_charp(cname);
int line = inv->get_line();
RoutineId *rid = inv->get_routineId();
SimpleRoutineId *srid = 0;

	// The idea here is to decorate the routine_id of the inv and then use
	// check_inv_guts to see if the inv in general is ok.

	// Note that while the primary of a (Simple) Routine Id can
	// be a general expression, here it is limited to an idn!
	// (Parms not implemented here yet.)

	vec mkrs = 0;
	// look up sprc as inheritable class
        NameBinding *bind = tco->env->look_up (cname);
        if (bind && bind->tag() == NameBinding::InhClBindingT) {
               TypeInterface *ti = bind->get_type();
               mkrs = ti->get_makers();
               }
	else {
		sprintf(cmp_err_buf, "Subclassable class named %s not found",
			csname);
		cmp_err(cmp_err_buf, line);
		return;
		}

	if (!mkrs || !vec_length(mkrs)) {
		sprintf(cmp_err_buf, "No makers found in class %s.",
			csname);
		cmp_err(cmp_err_buf, line);
		return;
		}

	string mkname = 0;
	switch (rid->tag()) {
		case RoutineId::SimpleRoutineIdT: {
			srid = (SimpleRoutineId *)rid;
			Expr *prim = srid->get_primary();
			if (prim->tag() == Expr::IdExprT) {
				IdExpr *ide = (IdExpr *)prim;
				Id *id = ide->get_id();
				mkname = id->get_id();
				}
			else {
				cmp_err("Only identifiers allowed to name "
					"makers.", line);
				return;
				}
			break;
			}
		case RoutineId::ComplexRoutineIdT: {
			cmp_err("Complex Routine Ids not "
				"yet supported in maker invocations.", line);
			return;
			}
		case RoutineId::SuperClassRoutineIdT: {
			cmp_err("SuperClass Routine Ids not "
				"allowed as maker invocations.", line);
			return;
			break;
			}
		}

	// mkname *really* should be valid here...	
	int nmkrs = vec_length(mkrs);
	method ithm = 0;
	bool found = FALSE;
	for (int i = 0; i < nmkrs; i++) {
		ithm = UNPV(method, vec_fetch(mkrs, i));
		if (string_equal(mkname, ithm->name)) {
			found = TRUE;
			break;
			}
		}

	if (!found) {
		sprintf(cmp_err_buf, "No maker named %s found in class %s.",
			string_charp(mkname), csname);
		cmp_err(cmp_err_buf, line);
		return;
		}

	// ok, just put the method on the srid and rid and we'll be
	// ready for the invocation check.
	srid->type_ = new TypeInterface(ithm, 0);
	rid->type_ = srid->type_;

	// check the invocation itself
	check_inv_guts(inv, tco);
	}

// The purpose of this routine is to check that a maker is *not* being
// called outside a make statement.  It emits an error message if a
// maker is being called outside a make statement.
void check_not_maker(Expr *ex, TypeCheckObj *tco)
{
	TypeInterface *ti = ex->get_type();
	method m = ti->get_method();
	if (m && m->mkr) {
		sprintf(cmp_err_buf,  "Invocation of"
			" maker %s outside a make statement"
			" not allowed.", string_charp(m->name));
		cmp_err(cmp_err_buf, ex->get_line());
		}
	}
//	if (!tco->current_class) return;
//	ClassDef *cd = (ClassDef *)tco->current_class;
//        type t = get_type(cd->get_classId()->get_id(), tco->env)->get_type();
//        class_ sprc = t? get_super_class(t) : 0;
//        if (!sprc) return;
//	string cname = sprc->hdr.inh.name;
//	vec mkrs = 0;
//	// look up sprc as inheritable class
//        NameBinding *bind = tco->env->look_up (cname);
//        if (bind && bind->tag() == NameBinding::InhClBindingT) {
//               TypeInterface *ti = bind->get_type();
//               mkrs = ti->get_makers();
//               }
//	if (!mkrs || !vec_length(mkrs)) return;
//	if (ex->tag() == Expr::IdExprT) {
//		IdExpr *ide = (IdExpr *)ex;
//		Id *id = ide->get_id();
//		string nm = id->get_id();
//		int nmkrs = vec_length(mkrs);
//		for (int i = 0; i < nmkrs; i++) {
//			method ithm = UNPV(method, vec_fetch(mkrs, i));
//			if (string_equal(nm, ithm->name)) {
//				sprintf(cmp_err_buf,  "Invocation of"
//					" maker %s outside a maker"
//					" not allowed.", string_charp(nm));
//				cmp_err(cmp_err_buf, ex->get_line());
//				}
//			}
//		}
//	}

void full_sc(class_ c, TypeCheckObj *tco);

void full_scs(ImplModule *im, TypeCheckObj *tco)
{
    ParseNodeList *impls = im->get_impls();
    if (impls) for (Pix p = impls->first(); p; impls->next(p)) {
        ImplElt *ie = (ImplElt*)(*impls)(p);
        switch (ie->tag()) {
                case ImplElt::ClassDefT:{
                        ClassDef *cd = (ClassDef *)ie;
			TypeInterface *cti = cd->get_type();
			class_ c = type_as_class(cti->get_type());
                        full_sc(c, tco);
                        break;
                        }
                }
        }

   }

void full_sc(class_ c, TypeCheckObj *tco)
{
class_ sprc = NULL;
string cname;
const char *csname;
class_ fullsc;

	if (c->superclass && vec_length(c->superclass)) {
		sprc = UNPV(class_, vec_fetch(c->superclass, 0));
		}
	else return;
	if (!sprc) return;

 	cname = sprc->hdr.inh.name;
	csname = string_charp(cname);
	// look up sprc as inheritable class
        NameBinding *bind = tco->env->look_up (cname);
        if (bind && bind->tag() == NameBinding::InhClBindingT) {
               TypeInterface *ti = bind->get_type();
               fullsc = ti->get_inh_full_class();
               }
	else return;
	vec_store(c->superclass, 0, PV(fullsc));
	// recurse to fix the superclass's superclass, etc.
	full_sc(fullsc, tco);
	}
