// Copyright 1995 Barbara Liskov

#ifndef _TYPE_REPLACE_H
#define _TYPE_REPLACE_H

#include "traverse.h"
#include "environment.h"


/*----------------------------------------------------------------

     A TypeReplaceObj is a type of TraverseObj, who's xmogrify method
     when invoked on a ParseNode, returns a new ParseNode in which all
     type names have been replaced with pointers to the respective type
     interfaces specified in the type environment.
    
----------------------------------------------------------------*/
    
class TypeReplaceObj : public TraverseObj {

  public: 
    enum Mission { Add, Replace };
    TypeReplaceObj(Environment *e, Mission m) { env = e; mission_ = m; }
    ParseNode* xmogrify(ParseNode *pn);
    ParseNode* setup(ParseNode *pn);

  private:
    Environment *env;
    Mission mission_;
};

Environment *my_basic_env();

#endif /* _TYPE_REPLACE_H */




