// Copyright 1995 Barbara Liskov

#include "parse.h"
#include "types/class_class.h"
#include "types/any.h"
#include "types/vec.h"
#include "types/ptype.h"
#include "type_chk.h"
#include "types/type.h"
#include "types/type_def.h"
#include "types/class.h"
#include "types/objtype_class.h"
#include "types/method.h"
#include "types/vec_instns.h"
#include "types/param.h"
#include "types/param_class.h"
#include "cg.h"

void remove_equate(Equate *eq, TypeCheckObj *tco);
void process_equate(Equate *eq, TypeCheckObj *tco);
void remove_teq(TypeEquate *teq);
void resolve_teq(TypeCheckObj *tco);
void save_teq(TypeEquate *teq);
void cmp_err_check_point();
void cmp_err_return_to_checkpoint();


#define DEBUG 0

void handle_equates(ParseNode *pn, bool add, TypeCheckObj *tco)
{
    switch (pn->tag()) {
	case ParseNode::BodyT: {
		Body *b = (Body *)pn;
		ParseNodeList *eqs = b->get_equates();
		if (add) process_equates(eqs, tco);
		else remove_equates(eqs, tco);
		break;
		}
	case ParseNode::ModuleT: {
	    Module *m = (Module *)pn;
	    switch (m->tag()) {
	    case Module::SpecModuleT: {
		SpecModule *sm = (SpecModule *)pn;
		ParseNodeList *specs = sm->get_specs();
		if (add) {
			process_equates(specs, tco);
			}
		else {
			remove_equates(specs, tco);
			}
		break;
		}
	case Module::ImplModuleT: {
		ImplModule *im = (ImplModule *)pn;
		ParseNodeList *eqs = im->get_equates();
		ParseNodeList *impls = im->get_impls();
		if (add) {
			process_equates(eqs, tco);
			process_equates(impls, tco);
			}
		else {
			remove_equates(eqs, tco);
			remove_equates(impls, tco);
			}
		break;
		}
		}
		break;
		}
	case ParseNode::EquateT: {
	    Equate *eq = (Equate *)pn;
		if (add) {
			process_equate(eq, tco);
			}
		else {
			remove_equate(eq, tco);
			}
		break;
		}
	case ParseNode::ImplEltT: {
	    ImplElt *ie = (ImplElt*)pn;
	    switch (ie->tag()) {
	    case ImplElt::ClassDefT: {
		ClassDef *cd = (ClassDef *)pn;
		ParseNodeList *eqs = cd->get_equates();
		ParseNodeList *elts = cd->get_classElts();
		if (add) {
			process_equates(eqs, tco);
			process_equates(elts, tco);
			}
		else {
			remove_equates(eqs, tco);
			remove_equates(elts, tco);
			}
		break;
		}
	    }
	    break;
	    }
	default: {
		sprintf(cmp_err_buf, "Time to fix handle equates");
		cmp_err(cmp_err_buf, pn->get_line());
		if (DEBUG) pn->print(2);
		}
	    }
	}

