// Copyright 1995 Barbara Liskov

#include "types/str.h"
#include "parse.h"
#include "types/class.h"
#include "types/objtype_class.h"
#include "client/gen-include.h"
#include "cg.h"

extern void v0_spec_mod(SpecModule *sm);
extern void v0_type_intf(TypeIntf *tin);
extern void v0_routine_spec(RoutineSpec *rs);
extern void v0_equates(ParseNodeList *eqs);
extern void v0_equate(Equate *eq);
extern void v0_impl_mod(ImplModule *im);
extern void v0_class_def(ClassDef *cd);
extern void v0_routine_def(RoutineDef *rd);
extern void v0_method_def(RoutineDef *rd);
extern void v0_routine_intf(RoutineIntf *ri);
extern void v0_method_intf(RoutineIntf *ri);
extern void v0_body(Body *body);
extern void v0_stmt(Stmt *stmt);
extern void v0_ivars(ParseNodeList *pnl);
extern void v0_mopdef(MethodOrOpDef *mopd);
extern void v0_if(IfStmt *ifstmt);
extern void v0_decls(ParseNodeList *decls);
extern void v0_decl(Decl *decl);
extern void v0_ive(InitVarExpr *ivestmt);
extern void v0_ivi(InitVarInvoke *ivistmt);
extern void v0_aes(AssignExprStmt *aesstmt);
extern void v0_inv(InvokeStmt *invstmt);
extern void v0_while(WhileStmt *whilestmt);
extern void v0_tagc(Tagcase *tagcstmt);
extern void v0_typec(Typecase *typecstmt);
extern void v0_ret(ReturnStmt *retstmt);
extern void v0_yield(Yield *yieldstmt);
extern void v0_sig(SignalStmt *sigstmt);
extern void v0_exit(Exit *exitstmt);
extern void v0_break();
extern void v0_cont();
extern void v0_resig(ResignalStmt *resigstmt);
extern void v0_excpt(ExceptStmt *excptstmt);
extern void v0_init(Init *initstmt);
extern void v0_declfor(DeclForStmt *declforstmt);
extern void v0_for(ForStmt *forstmt);
extern void v0_exprs(ParseNodeList *exprs);
extern void v0_expr(Expr *expr);
extern void v0_invoc(Invoc *inv);
extern void v0_rid(RoutineId *rid);
extern void v0_signals(ParseNodeList *types);
extern void v0_typespecs(ParseNodeList *sigs);
extern void v0_typespec(TypeSpec *ts);

#define DEBUG 0

/*
	These procedures try to bounce any modules containing
	features not in Theta.0
*/

void v0_compliance(ParseNodeList *pnl)
{
    if (pnl) for (Pix p = pnl->first(); p; pnl->next(p)) {
        Module *m = (Module *)(*pnl)(p);
	if (DEBUG) m->print(2);
	switch (m->tag()) {
		case Module::SpecModuleT: {
    			SpecModule *sm = (SpecModule *)m;
	 		v0_spec_mod(sm);
			break;
			}
		case Module::ImplModuleT: {
    			ImplModule *im = (ImplModule *)m;
	 		v0_impl_mod(im);
			break;
			}
	 	} // end switch
    }
}

void v0_spec_mod(SpecModule *sm)
{
	ParseNodeList *specs = sm->get_specs();
	if (specs) for (Pix p = specs->first(); p; specs->next(p)) {
            SpecElt *spec = (SpecElt *)(*specs)(p);
	    switch (spec->tag()) {
		case SpecElt::TypeIntfT: {
			TypeIntf *tin = (TypeIntf*)spec;
			v0_type_intf(tin);
			break;
			}
		case SpecElt::RoutineSpecT: {
			RoutineSpec *rs = (RoutineSpec *)spec;
			v0_routine_spec(rs);
			break;
			}
		case SpecElt::SpecEquateT: {
			SpecEquate *eq = (SpecEquate *)spec;
			v0_equate(eq->get_equate());
			break;
			}
		}
	    }
	}

void v0_type_intf(TypeIntf *tin)
{
   if (tin->get_parms() && tin->get_parms()->length()) {
	cmp_err("User Defined Parameterized Types not supported in theta.0",
		tin->get_line());
	}
   if (tin->get_wheres() && tin->get_wheres()->length()) {
	cmp_err("User Defined Parameterized Types not supported in theta.0",
		tin->get_line());
	}
   if (tin->get_supers() && tin->get_supers()->length()) {
	if (tin->get_supers()->length() > 1) {
	    cmp_err("More than one supertype not supported in theta.0",
		tin->get_line());
	    }
	}
   ParseNodeList *meths = tin->get_methods();
   if (meths) for (Pix p = meths->first() ; p ; meths->next(p)) {
	RoutineIntf *ri = (RoutineIntf *)(*meths)(p);
	v0_routine_intf(ri);
	}
   }

void v0_routine_spec(RoutineSpec *rs)
{
   v0_routine_intf(rs->get_routine());
   }

void v0_equate(Equate *eq)
{
   switch (eq->tag()) {
	case Equate::ExprT: {
		ExprEquate *eeq = (ExprEquate *)eq;
		Expr *ex = eeq->get_expr();
		switch (ex->tag()) {
			case Expr::NilT: break;
			case Expr::LiteralT: break;
			default: {
				cmp_err("Equates to complex exprs not "
					"supported in theta.0",
					eq->get_line());
				}
			}
		break;
		}
	case Equate::TypeEquateT: {
		TypeEquate *te = (TypeEquate *)eq;
		v0_typespec(te->get_typ());
		}
	}
   }

void v0_equates(ParseNodeList *eqs)
{
   if (eqs) for (Pix p = eqs->first() ; p ; eqs->next(p)) {
	Equate *eq = (Equate *)(*eqs)(p);
        v0_equate(eq);
	}
   }

void v0_impl_mod(ImplModule *impl_mod)
{
    ParseNodeList *impls = impl_mod->get_impls();
    if (impls) for (Pix p = impls->first(); p; impls->next(p)) {
	ImplElt *ie = (ImplElt*)(*impls)(p);
	switch (ie->tag()) {
		case ImplElt::RoutineDefT:{
			RoutineDef *rd = (RoutineDef *)ie;
			v0_routine_def(rd);
			break;
			}
		case ImplElt::ClassDefT:{
			ClassDef *cd = (ClassDef *)ie;
			v0_class_def(cd);
			break;
			}
		}
	}
    }

void v0_routine_def(RoutineDef *rd)
{
   
   RoutineIntf* ri = rd->get_routineIntf();
   v0_routine_intf(ri);
   Body* b = rd->get_body();
   v0_body(b);
   }

void v0_method_def(RoutineDef *rd)
{
   RoutineIntf* ri = rd->get_routineIntf();
   v0_method_intf(ri);
   Body* b = rd->get_body();
   v0_body(b);
   }

void v0_class_def(ClassDef *cd)
{

   if (cd->get_parms() && cd->get_parms()->length()) {
		cmp_err("User defined class parameters not supported"
			" in theta.0", cd->get_line());
		}
   if (cd->get_wheres() && cd->get_wheres()->length()) {
		cmp_err("User defined class parameters not supported"
			" in theta.0", cd->get_line());
		}
   if (cd->get_inherits()) {
		cmp_err("Inheritance not supported"
			" in theta.0", cd->get_line());
		}
   if (cd->get_provides()) {
		cmp_err("Inheritance not supported"
			" in theta.0", cd->get_line());
		}
   if (cd->get_hides() && cd->get_hides()->length()) {
		cmp_err("Inheritance not supported"
			" in theta.0", cd->get_line());
		}

   TypeSpec *ts = cd->get_deftype();
   if (ts) v0_typespec(ts);

   ParseNodeList *eqs = cd->get_equates();
   v0_equates(eqs);

   ParseNodeList *decls = cd->get_decl();
   v0_ivars(decls);

   ParseNodeList *celts = cd->get_classElts();
   if (celts) for (Pix p = celts->first(); p; celts->next(p)) {
	ParseNode *pn = (*celts)(p);
	switch (pn->tag()) {
		case ParseNode::MethodOrOpDefT:{
			MethodOrOpDef *mopd = (MethodOrOpDef *)pn;
			v0_mopdef(mopd);
			break;
			}
		}
	}
   }

void v0_routine_intf(RoutineIntf *ri)
{
   switch(ri->tag()) {
	case RoutineIntf::MakeHeaderT: {
		cmp_err("Makers not supported in theta.0", ri->get_line());
		break;
		}
	}
   if (!strcmp(string_charp(ri->get_id()->get_id()), "array_new")) return;
   if (!strcmp(string_charp(ri->get_id()->get_id()), "vector_fill")) return;
   if (!strcmp(string_charp(ri->get_id()->get_id()), "vector_create")) return;
   if (!strcmp(string_charp(ri->get_id()->get_id()), "sequence_create")) return;
   if (!strcmp(string_charp(ri->get_id()->get_id()), "maybe_make_value")) return;
   if (!strcmp(string_charp(ri->get_id()->get_id()), "maybe_make_none")) return;
   Signature *sig = ri->get_signature();
   if (sig->get_parms()) {
	cmp_err(" Parameterized Routines not supported in theta.0",
		ri->get_line());
	}
   if (sig->get_where()) {
	cmp_err(" Parameterized Routines not supported in theta.0",
		ri->get_line());
	}
   v0_decls(sig->get_args());
   ParseNodeList *rets = sig->get_returns();
   if (rets && rets->length() > 1) {
	cmp_err("Multiple return values not supported in theta.0",
		ri->get_line());
	}
   v0_typespecs(rets);
   v0_signals(sig->get_signals());
   }

void v0_method_intf(RoutineIntf *ri)
{
   Signature *sig = ri->get_signature();
   if (sig->get_parms()) {
	cmp_err(" Parameterized Methods not supported in theta.0",
		ri->get_line());
	}
   if (sig->get_where()) {
	cmp_err(" Parameterized Methods not supported in theta.0",
		ri->get_line());
	}
   v0_decls(sig->get_args());
   ParseNodeList *rets = sig->get_returns();
   if (rets && rets->length() > 1) {
	cmp_err("Multiple return values not supported in theta.0",
		ri->get_line());
	}
   v0_typespecs(rets);
   v0_signals(sig->get_signals());
   }

void v0_ivars(ParseNodeList *decls)
{
int i;
   v0_decls(decls);
   }

void v0_mopdef(MethodOrOpDef *mopd)
{
  RoutineDef *rd = mopd->get_routineDef();
  if (mopd->get_isOp()) v0_routine_def(rd);
  else v0_method_def(rd);
  }

void v0_body(Body *b)
{
   if (b) {
   ParseNodeList *stmts = b->get_statements();
   if (stmts) for (Pix p = stmts->first(); p; stmts->next(p)) {
	Stmt *stmt = (Stmt *)(*stmts)(p);
	v0_stmt(stmt);
	}
     }
   }

void v0_stmt(Stmt *stmt)
{
   switch (stmt->tag()) {
	case Stmt::DeclStmtT: {
		DeclStmt *declstmt =  (DeclStmt *)stmt;
		v0_decl(declstmt->get_decl());
		break;
		}
	case Stmt::InitVarExprT: {
		InitVarExpr *ivestmt =  (InitVarExpr *)stmt;
		v0_ive(ivestmt);
		break;
		}
	case Stmt::InitVarInvokeT: {
		InitVarInvoke *ivistmt =  (InitVarInvoke *)stmt;
		v0_ivi(ivistmt);
		break;
		}
	case Stmt::AssignInvokeT: {
		// unused
		break;
		}
	case Stmt::AssignExprStmtT: {
		AssignExprStmt *aesstmt =  (AssignExprStmt *)stmt;
		v0_aes(aesstmt);
		break;
		}
	case Stmt::AssignExprT: {
		// unused
		break;
		}
	case Stmt::InvokeStmtT: {
		InvokeStmt *invstmt =  (InvokeStmt *)stmt;
		v0_inv(invstmt);
		break;
		}
	case Stmt::WhileStmtT: {
		WhileStmt *whilestmt =  (WhileStmt *)stmt;
		v0_while(whilestmt);
		break;
		}
	case Stmt::IfStmtT: {
		IfStmt *ifstmt =  (IfStmt *)stmt;
		v0_if(ifstmt);
		break;
		}
	case Stmt::TagcaseT: {
		Tagcase *tagcstmt =  (Tagcase *)stmt;
		v0_tagc(tagcstmt);
		break;
		}
	case Stmt::TypecaseT: {
		Typecase *typecstmt =  (Typecase *)stmt;
		v0_typec(typecstmt);
		break;
		}
	case Stmt::ReturnStmtT: {
		ReturnStmt *retstmt =  (ReturnStmt *)stmt;
		v0_ret(retstmt);
		break;
		}
	case Stmt::YieldT: {
		Yield *yieldstmt =  (Yield *)stmt;
		v0_yield(yieldstmt);
		break;
		}
	case Stmt::SignalStmtT: {
		SignalStmt *sigstmt =  (SignalStmt *)stmt;
		v0_sig(sigstmt);
		break;
		}
	case Stmt::ExitT: {
		Exit *exitstmt =  (Exit *)stmt;
		v0_exit(exitstmt);
		break;
		}
	case Stmt::BreakT: {
		v0_break();
		break;
		}
	case Stmt::ContinueT: {
		v0_cont();
		break;
		}
	case Stmt::BlockStmtT: {
		BlockStmt *blockstmt =  (BlockStmt *)stmt;
		Body *body = blockstmt->get_body();
		v0_body(body);
		break;
		}
	case Stmt::ResignalStmtT: {
		ResignalStmt *resigstmt =  (ResignalStmt *)stmt;
		v0_resig(resigstmt);
		break;
		}
	case Stmt::ExceptStmtT: {
		ExceptStmt *excptstmt =  (ExceptStmt *)stmt;
		v0_excpt(excptstmt);
		break;
		}
	case Stmt::InitT: {
		Init *initstmt =  (Init *)stmt;
		v0_init(initstmt);
		break;
		}
	case Stmt::DeclForStmtT: {
		DeclForStmt *declforstmt =  (DeclForStmt *)stmt;
		v0_declfor(declforstmt);
		break;
		}
	case Stmt::ForStmtT: {
		ForStmt *forstmt =  (ForStmt *)stmt;
		v0_for(forstmt);
		break;
		}
	}
   }

void v0_if(IfStmt *ifstmt)
{
   Expr *ex = ifstmt->get_expr();
   v0_expr(ex);
   Body* b = ifstmt->get_body();
   v0_body(b);
   ParseNodeList *elseifs = ifstmt->get_elseifs();
   if (elseifs) for (Pix p = elseifs->first(); p ; elseifs->next(p)) {
   	ElseIf *ei = (ElseIf *)(*elseifs)(p);
   	ex = ei->get_expr();
        v0_expr(ex);
   	b = ei->get_body();
   	v0_body(b);
	}
   b = ifstmt->get_elsebody();
   v0_body(b);
   }

void v0_decls(ParseNodeList *decls)
{
  if (decls) for (Pix p = decls->first(); p; decls->next(p)) {
	Decl *d = (Decl *)(*decls)(p);
	v0_decl(d);
	}
  }

void v0_decl(Decl *decl)
{
   switch(decl->tag()) {
	case Decl::RegDeclT: {
		RegDecl *rd = (RegDecl *)decl;
		v0_typespec(rd->get_typeSpec());
		break;
		}
	case Decl::ImplDeclT: {
		ImplDecl *imd = (ImplDecl *)decl;
		v0_typespec(imd->get_typeSpec());
		break;
		}
//	case Decl::VarArgsDeclT: {
//		cmp_err("Varying Arguments not supported in ttheta.0",
//			decl->get_line());
//		break;
//		}
	}
   }

void v0_ive(InitVarExpr *ivestmt)
{
   Decl *decl = ivestmt->get_decl();
   v0_decl(decl);
   Expr *ex = ivestmt->get_expr();
   v0_expr(ex);
   }

void v0_ivi(InitVarInvoke *ivistmt)
{
   ParseNodeList *decls = ivistmt->get_decls();
   v0_decls(decls);
   Invoc *inv = ivistmt->get_invoc();
   v0_invoc(inv);
   }

void v0_aes(AssignExprStmt *aesstmt)
{
   Pix p,q;
   ParseNodeList *ids = aesstmt->get_ids();
   ParseNodeList *exprs = aesstmt->get_exprs();
   v0_exprs(exprs);
   }

void v0_inv(InvokeStmt *invstmt)
{
   Invoc *inv = invstmt->get_invoc();
   v0_invoc(inv);
   }

void v0_while(WhileStmt *whilestmt)
{
   Expr *ex = whilestmt->get_expr();
   v0_expr(ex);
   Body *body = whilestmt->get_body();
   v0_body(body);
   }

void v0_tagc(Tagcase *tagcstmt)
{
   cmp_err("Tagcase not supported in theta.0", tagcstmt->get_line());
   return;
   Body* body = tagcstmt->get_body();
   v0_body(body);
   }

void v0_typec(Typecase *typecstmt)
{
   // cmp_err("Typecase not supported yet in theta.0", typecstmt->get_line());
   // return;
   Expr *ex = typecstmt->get_expr();
   v0_expr(ex);
   ParseNodeList *arms = typecstmt->get_typeWhenArms();
   bool first = TRUE;
   if (arms) for (Pix p = arms->first() ; p ; arms->next(p)) {
	TypeWhenArm *arm = (TypeWhenArm *)(*arms)(p);
	v0_typespec(arm->get_typ());
	v0_body(arm->get_body());
	}
   Body* body = typecstmt->get_body();
   v0_body(body);
   }

void v0_ret(ReturnStmt *retstmt)
{
   int size = 0;
   ParseNodeList *exprs = retstmt->get_exprs();
   v0_exprs(exprs);
   }

void v0_yield(Yield *yieldstmt)
{
   cmp_err("Yield not supported in theta.0", yieldstmt->get_line());
   }

void v0_sig(SignalStmt *sigstmt)
{
   ParseNodeList *exprs = sigstmt->get_exprs();
   if (exprs) {
   	cmp_err("Values not supported in signal statements in theta.0", 
			sigstmt->get_line());
	}
   v0_exprs(exprs);
   }

void v0_exit(Exit *exitstmt)
{
   ParseNodeList *exprs = exitstmt->get_exprs();
   if (exprs) {
        cmp_err("Values not supported in exit statements in theta.0", 
                        exitstmt->get_line());
        }
   v0_exprs(exprs);
   }

void v0_break()
{
   }

void v0_cont()
{
   }

void v0_resig(ResignalStmt *resigstmt)
{
   Stmt *stmt = resigstmt->get_stmt();
   v0_stmt(stmt);
   ParseNodeList *ids = resigstmt->get_ids();
   for (Pix p = ids->first(); p ; ids->next(p)) {
	}
   }

void v0_excpt(ExceptStmt *excptstmt)
{
   Stmt *stmt = excptstmt->get_stmt();
   v0_stmt(stmt);
   ParseNodeList *arms = excptstmt->get_exWhenArm();
   if (arms) for (Pix p = arms->first(); p ; arms->next(p)) {
 	ExWhenArm *ewa = (ExWhenArm *)(*arms)(p);
    	ParseNodeList *ids = ewa->get_names();
  	for (Pix p1 = ids->first(); p1 ; ids->next(p1)) {
		Id *id = (Id *)(*ids)(p1);
		string nm = id->get_id();
		if (string_equal(nm, string_new("failure"))) {
			cmp_err("Catching the signal failure is not"
				"supported in theta.0",
				ewa->get_line());
			}
 		}
 	// do decls...
	ParseNodeList *decls = ewa->get_decls();
	if (decls && decls->length()) 
		cmp_err("Decls not supported in except statements",
			excptstmt->get_line());
	v0_decls(decls);
 	Body *b = ewa->get_body();
 	v0_body(b);
       	}
    Decl *d = excptstmt->get_decl();
    if (d) cmp_err("Decls not supported in except statements",
		excptstmt->get_line());
    if (d) v0_decl(d);
    Body *b = excptstmt->get_body();
    if (b) {
	v0_body(b);
	}
   return;
   }

void v0_init(Init *initstmt)
{
   // NEED TO LOOK AT THIS
   cmp_err("Make statements not supported in theta.0",
		initstmt->get_line());
   Body* body = initstmt->get_body();
   if (body) {
   	cmp_err("Bodies in init statements not supported in theta.0",
		initstmt->get_line());
	}
   v0_body(body);
   }

void v0_declfor(DeclForStmt *declforstmt)
{
   // cmp_err("For statements not supported in theta.0", declforstmt->get_line());
   return;
   }

void v0_for(ForStmt *forstmt)
{
   // cmp_err("For statements not supported in theta.0", forstmt->get_line());
   return;
   }

void v0_exprs(ParseNodeList *exprs)
{
   if (exprs) for (Pix p = exprs->first() ; p ; exprs->next(p)) {
	Expr *ex = (Expr *)(*exprs)(p);
        v0_expr(ex);
	}
   }

void v0_expr(Expr *ex)
{
   // exclude BraceRef?
   // exclude Reals?
   // exclude Instantiations  (not constructed...)
   // recurse on dots
   // ? SuperId
   // recurse on invocexpr
   // exclude binding
   // selector constr: exclude selectors, allow udts
   switch (ex->tag()) {
	case Expr::NilT: break;
	case Expr::LiteralT: {
		Literal *lit = (Literal *)ex;
		switch (lit->tag()) {
			case Literal::RealLiteralT: {
				cmp_err("Reals are not supported in theta.0",
					ex->get_line());
				break;
				}
			}
		break;
		}
	case Expr::DotExprT: {
		DotExpr *de = (DotExpr *)ex;
		v0_expr(de->get_primary());
		break;
		}
	case Expr::SuperIdT: {
		cmp_err("Inheritance is not supported in theta.0",
					ex->get_line());
		break;
		}
	case Expr::NewT: {
		cmp_err("Makers are not supported in theta.0",
					ex->get_line());
		break;
		}
	case Expr::ArrayRefT: {
		ArrayRef *ar = (ArrayRef *)ex;
		v0_expr(ar->get_primary());
		v0_expr(ar->get_expr());
		break;
		}
	case Expr::InvocExprT: {
		InvocExpr *ie = (InvocExpr *)ex;
		v0_invoc(ie->get_invoc());
		break;
		}
	case Expr::BindingExprT: {
		cmp_err("Binding is not supported in theta.0",
					ex->get_line());
		break;
		}
	case Expr::SelectorConstrT: {
		SelectorConstr *sc = (SelectorConstr *)ex;
		TypeSpec *ts = sc->get_typeSpec();
		v0_typespec(ts);
		ParseNodeList *fields = sc->get_fields();
		if (fields) for (Pix p = fields->first(); p ; fields->next(p)) {
			FieldInit *field = (FieldInit *)(*fields)(p);
			v0_expr(field->get_expr());
			}
		break;
		}
	case Expr::ArrayConstrT: {
		ArrayConstr *ac = (ArrayConstr *)ex;
		v0_typespec(ac->get_typeSpec());
		v0_expr(ac->get_size());
		v0_exprs(ac->get_exprs());
		break;
		}
	case Expr::BinaryT: {
		Binary *bin = (Binary *)ex;
		v0_expr(bin->get_op1());
		v0_expr(bin->get_op2());
		break;
		}
	case Expr::UnaryT: {
		Unary *un = (Unary *)ex;
		v0_expr(un->get_op());
		break;
		}
	case Expr::BracketRefT: {
		BracketRef *br = (BracketRef *)ex;
		v0_expr(br->get_primary());
		v0_exprs(br->get_exprs());
		break;
		}
	case Expr::BraceRefT: {
		cmp_err("Renaming not supported in theta.0", ex->get_line());
		break;
		}
	}
   return;
   }

void v0_invoc(Invoc *inv)
{
   // check routine id and exclude superclass rids ?complex for udts
   v0_rid(inv->get_routineId());
   // check exprs
   v0_exprs(inv->get_exprs());
   // exclude lastarg?
   if (inv->get_lastarg()) {
	cmp_err("Varying args not supported in theta.0", inv->get_line());
	}
   return;
   }

void v0_actuals(ParseNodeList *parms)
{
	if (parms) for (Pix p = parms->first(); p ; parms->next(p)) {
		ActualParm *ap = (ActualParm*)(*parms)(p);
		v0_typespec(ap->get_typeSpec());
		}
  }

void v0_rid(RoutineId *rid)
{
   switch (rid->tag()) {
	case RoutineId::SuperClassRoutineIdT: {
		cmp_err("Inheritance not supported in theta.0", 
				rid->get_line());
		break;
		}
	case RoutineId::ComplexRoutineIdT: {
		ComplexRoutineId *crid = (ComplexRoutineId *)rid;
		v0_actuals(crid->get_parms());
		break;
		}
	}
   }

void v0_signals(ParseNodeList *sigs)
{
   if (sigs) for (Pix p = sigs->first(); p; sigs->next(p)) {
	Exception *ex = (Exception *)(*sigs)(p);
	ParseNodeList *types = ex->get_typeSpec();
	if (types) {
		cmp_err("No values allowed with signals in theta.0",
			ex->get_line());
		}
	v0_typespecs(types);
	}
   }

void v0_typespecs(ParseNodeList *types)
{
   if (types) for (Pix p = types->first(); p; types->next(p)) {
	TypeSpec *ts = (TypeSpec *)(*types)(p);
	v0_typespec(ts);
	}
   }

void v0_typespec(TypeSpec *ts)
{
    switch (ts->tag()) {
	case TypeSpec::SimpleTypeSpecT: {
		SimpleTypeSpec *sts = (SimpleTypeSpec *)ts;
		string nm = sts->get_name()->get_name()->get_id();
		if (string_equal(nm, string_new("real"))) {
    		    cmp_err("Reals are not supported in theta.0",
    			ts->get_line());
			}
		break;
		}
    	case TypeSpec::TaggedTypeSpecT: {
    		cmp_err("Tagged Typespecs are not supported in theta.0",
    			ts->get_line());
    		break;
    		}
    	case TypeSpec::RoutineTypeSpecT: {
    		cmp_err("Routine Typespecs are not supported in theta.0",
    			ts->get_line());
    		break;
    		}
	case TypeSpec::ParamTypeSpecT: {
		ParamTypeSpec *pts = (ParamTypeSpec *)ts;
		ParseNodeList *parms = pts->get_actualParms();
		v0_actuals(parms);
    		break;
		}
    	}
    }
