/* Copyright Barbara Liskov 1995 */

extern "C" {
#include "any.h"
#include "type.h"
#include "runtime/obj.h"
#include "runtime/alloc.h"
#include "class.h"
#include "runtime/obj_class.h"
#include "runtime/same_object.h"
#include "class_class.h"
#include "runtime/surr.h"
#include "bool.h"
#include "int.h"
#include "real.h"
#include "char.h"

#include "boot/type_init.h"
}

#include "config/vdefs/EDGE_MARKING.h"

obj any_as_obj(any a)
{
#if EDGE_MARKING
    FIX(a, any)
#endif
    return (obj)a;
}

class_ get_any_class(any a)
{
    return get_obj_class(any_as_obj(a));
}

obj any_get_obj(any a)
{
    obj o = any_as_obj(a);
    DV dv = *o;
#ifndef NDEBUG
    if (types_initted) {
	class_ c = get_any_class(a);
	assert(c != Int && c != Bool && c != Char && c != Null && c != Real );
    }
#endif 
    return dv->get_address(BUMP(obj, o, dv));
}


struct intany_s : public any_s {
    int i;
};

struct boolany_s : public any_s {
    bool b;
};

struct charany_s : public any_s {
    char c;
};

struct realany_s : public any_s {
    float f;
};

struct dv_s intany_methods = {
    0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class,
};


struct dv_s boolany_methods = {
    0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class,
};

struct dv_s charany_methods = {
    0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class,
};

struct dv_s nullany_methods = {
    0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class,
};

struct dv_s realany_methods = {
    0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class,
};

any int_as_any(int i)
{
    struct intany_s *ret = NEW(intany_s);
    init_obj_hdr_prim(&ret->hdr, 1, 0x0, (DV)&intany_methods);
    ret->i = i;
    return ret;
}

any char_as_any(char c)
{
    struct charany_s *ret = NEW(charany_s);
    init_obj_hdr_prim(&ret->hdr, 1, 0x0, (DV)&charany_methods);
    ret->c = c;
    return ret;
}

any null_as_any(int i)
{
    struct any_s *ret = NEW(any_s);
    init_obj_hdr_prim(&ret->hdr, 0, 0x0, (DV)&nullany_methods);
    return ret;
}

any bool_as_any(bool b)
{
    struct boolany_s *ret = NEW(boolany_s);
    init_obj_hdr_prim(&ret->hdr, 1, 0x0, (DV)&boolany_methods);
    ret->b = b;
    return ret;
}

any real_as_any(real f)
{
    struct realany_s *ret = NEW(realany_s);
    init_obj_hdr_prim(&ret->hdr, 1, 0x0, (DV)&realany_methods);
    ret->f = f;
    return ret;
}

any obj_as_any(obj o)
{
    return (any)o;
}

fevalue any_get_value(any a)
{
    fevalue ret;
    class_ c = get_any_class(a);
    obj o = any_as_obj(a);
    DV dv = (*o);
    o = dv->get_address(BUMP(obj, o, dv));
    if (c->hdr.inh.kind == PRIMITIVE_KIND) {
	if (c == Int) ret.i = ((intany_s *)o)->i;
	else
	if (c == Bool) ret.b =  ((boolany_s *)o)->b;
	else
	if (c == Char) ret.c =  ((charany_s *)o)->c;
	else
	if (c == Real) ret.r =  ((realany_s *)o)->f;
	else
        if (c == Null) ret.i = 0; // Set the null value to be 0
    }
    else
        ret.o = o;
    return ret;
}

bool any_equal(obj dummy, any a1, any a2)
{
    class_ c1 = get_any_class(a1);
    class_ c2 = get_any_class(a2);
    obj o1 = any_as_obj(a1);
    obj o2 = any_as_obj(a2);
    DV __dv1 = (*o1);
    DV __dv2 = (*o2);
    o1 = __dv1->get_address(BUMP(obj, o1, __dv1));
    o2 = __dv2->get_address(BUMP(obj, o2, __dv2));

    if (c1->hdr.inh.kind == PRIMITIVE_KIND && 
		c2->hdr.inh.kind == PRIMITIVE_KIND) {
	if (c1 == Int && c2 == Int) {
		int i1 = ((intany_s *)o1)->i;
		int i2 = ((intany_s *)o2)->i;
		if (i1 == i2) return TRUE;
		else return FALSE;
		}
	if (c1 == Bool && c2 == Bool) {
		bool b1 = ((boolany_s *)o1)->b;
		bool b2 = ((boolany_s *)o2)->b;
		if (b1 == b2) return TRUE;
		else return FALSE;
		}
	if (c1 == Char && c2 == Char) {
		char c1 = ((charany_s *)o1)->c;
		char c2 = ((charany_s *)o2)->c;
		if (c1 == c2) return TRUE;
		else return FALSE;
		}
	if (c1 == Real && c2 == Real) {
		real r1 = ((realany_s *)o1)->f;
		real r2 = ((realany_s *)o2)->f;
		if (r1 == r2) return TRUE;
		else return FALSE;
		}
	if (c1 == Null && c2 == Null) {
		return TRUE;
		}
	return FALSE;
	}
    if (c1->hdr.inh.kind == PRIMITIVE_KIND && 
		c2->hdr.inh.kind != PRIMITIVE_KIND) {
		return FALSE;
		}
    if (c1->hdr.inh.kind != PRIMITIVE_KIND && 
		c2->hdr.inh.kind == PRIMITIVE_KIND) {
		return FALSE;
		}
    return same_object(0, a1, a2);
}

any make_any(type t, fevalue v)
{
    if (t == class_as_type(Int)) return int_as_any(v.i);
    if (t == class_as_type(Char)) return char_as_any(v.c);
    if (t == class_as_type(Bool)) return bool_as_any(v.b);
    if (t == class_as_type(Null)) return null_as_any(0);
    if (t == class_as_type(Real)) return real_as_any(v.r);
    return obj_as_any(v.o);
}

class_ IntAny, BoolAny, CharAny, NullAny, RealAny;

DV IntAny_DH[] = { (DV)&intany_methods };
DV BoolAny_DH[] = { (DV)&boolany_methods };
DV CharAny_DH[] = { (DV)&charany_methods };
DV NullAny_DH[] = { (DV)&nullany_methods };
DV RealAny_DH[] = { (DV)&realany_methods };

void initAnys()
{
    IntAny->dhsize = 1;
    BoolAny->dhsize = 1;
    CharAny->dhsize = 1;
    NullAny->dhsize = 1;
    RealAny->dhsize = 1;
    IntAny->dh = IntAny_DH;
    BoolAny->dh = BoolAny_DH;
    CharAny->dh = CharAny_DH;
    NullAny->dh = NullAny_DH;
    RealAny->dh = RealAny_DH;
    intany_methods.c = Int;
    charany_methods.c = Char;
    boolany_methods.c = Bool;
    nullany_methods.c = Null;
    realany_methods.c = Real;
}
