/* Copyright Barbara Liskov 1995 */

#ifndef _ANY_H
#define _ANY_H

#include "runtime/obj_class.h"
#include "runtime/value.h"
#include "runtime/pval.h"
#include "types/type_def.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Overview: "Any" is the supertype of all types. It supports only the
   "get_type" operation. Every instance of "Any" is also an instance of
   some subtype. There are no pure "Any"s. Note that an "any" can always
   be treated as an object pointer. */

struct any_s {
    struct core_s hdr;
};

pval any_get_obj(any a);
/*
 * Unbundle "a" and convert it to an "obj" if possible. It is a checked
 * run-time error to pass an "any" that cannot be so converted. For example,
 * an "any" containing an integer cannot be unbundled into an "obj".
 */

obj any_as_obj(any a);
/*
 * View "a" as an obj. This is completely different from "any_get_obj".
 * The "obj" returned by this is not guaranteed to behave in the same
 * way as the value that is `inside' the any.
 */

fevalue any_get_value(any a);
/*
 * Extract the value in "a".
 */
     
class_ get_any_class(any a);
/*
 *  Invoke the "get_class" operation on the value "a".
 */

any int_as_any(int);
any bool_as_any(bool);
any char_as_any(char);
any null_as_any(int);
any real_as_any(real);
/*
 * Produce an "any" representing a primitive value.
 */
 
any obj_as_any(obj o);
/*
 * Produce an any representing this object. Works even if "o" is
 * really already an "any" that was viewed as an obj.
 */

bool any_equal(obj dummy, any a1, any a2);
/*
 * Compare two anys for equality...
 *
 */

any make_any(type t, fevalue v);
/*
 * Produce an any representing this value.
 */

extern class_ IntAny, BoolAny, CharAny, RealAny, NullAny;
extern void initAnys();

#ifdef __cplusplus
}
#endif

#endif /* _ANY_H */
