/* Copyright Barbara Liskov 1995 */

#ifndef FE_ARRAY_H
#define FE_ARRAY_H

#include "runtime/obj.h"
#include "runtime/value.h"
#include "runtime/pval.h"
#include "vec.h"

extern pclass Array;

#ifndef ARRAY_DEFNS
#define ARRAY_DEFNS
typedef struct array_s *array_C;
typedef struct arraydv_s **array;
#endif
typedef struct arrayE_s *arrayE;

/*
 * An array is a mutable, extensible sequence of elements. The
 * number of elements in array "a" is "length[a]". The elements
 * are indexed by "[0..length[a] - 1]".
 */

array array_new(obj dummy, class_instn aci);
/* Create a new array containing no elements. */

void array_resizeHint(array a, int size);
/* Hint that "a" will need roughly "size" elements soon. This
   procedure has no semantic effect, but may improve performance
   dramatically. */

pval array_fetch(array a, int i);
/*
 * Raises "bounds" if the index is out of bounds.
 */

void array_store(array a, int i, pval v);
/*
 * Raises "bounds" if the index is out of bounds.
 */

void array_append(array a, pval v);
/*
 * Extend the array by adding "v" as the last element.
 */

pval array_remove(array a);
/*
 * Remove the last element from "a". Raise "bounds" if "a" contains
 * no elements.
 */

int array_length(array a);
/*
 * Return "length[a]".
 */

void array_predict(array am, int size);

DV *array_dhs(class_instn, vec);

class_instn array_ci_get_vci(class_instn aci);
/*
 * Return vector class instantiation corresponding to this array instn.
 */

#endif /* FE_ARRAY_H */
