/* Copyright Barbara Liskov 1995 */

#ifndef _ARRAY_CLASS_H
#define _ARRAY_CLASS_H

#include "types/array.h"
#include "runtime/obj_class.h"

extern pclass Array;

extern struct exception_s exc_bounds;

typedef struct arraydv_s {
    struct dv_s super;
    pval (*fetch)(array a, int i);
    void (*store)(array a, int i, pval);
    int (*length)(array);
    void (*elements)(array a, struct closure cl);
      /* above methods are inherited from vec */
    void (*append)(array a, pval);
    array (*subarray)(array, int first, int length);
    void (*predict)(array a, int s);
    pval (*remove)(array a);
    void (*trim)(array a, int newlb, int newlen);
    array (*extract)(array, int first, int length);
    void (*concat)(array, array);
    bool (*empty)();
    int (*low)();
    int (*high)();
    pval (*bottom)();
    pval (*top)();
    void (*append_low)(array a, pval);
    pval (*remove_low)(array a);
    void (*set_low)(array a, int lb);
    void (*indexes)(array, struct closure cl);
    bool (*equal)(array, array);
    bool (*similar)(array, array);
    array (*copy)(array);
    string (*unparse)(array);
    void (*append_iter)(array, struct closure);
    type t;
    class_instn vci;
}  *arraydv;

struct array_s {
    union {
	struct arraydv_s *methods;
	struct core_s inh;
    } hdr;
    vec elems;
    int internal_size;
    int internal_low;
    int user_size;
    int user_low;
};

typedef struct arrayE_dv_s {
    struct dv_s super;
    array (*new_)();
    class_ array_T;
    vecE vec_info;
} *arrayE_dv;

struct arrayE_s {
    union {
	struct arrayE_dv_s *methods;
	struct core_s hdr;
    } hdr;
};

extern array array_new(obj dummy, class_instn aci);

extern void array_resizeHint(array a, int size);

extern pval array_fetch(array a, int i);

extern pval array_remove(array a);

extern void array_store(array a, int i, pval v);

extern void array_append(array a, pval v);

extern void array_trim(array a, int lb, int len);

extern int array_length(array a);

#endif /* _ARRAY_CLASS_H */
