/* Copyright Barbara Liskov 1995 */

#include "char.h"
#include "str.h"
#include "class_class.h"

bool char_equal(char x, char y)
{
    return x == y;
}

int char_to_int(char x)
{
int temp =  x & 0xff;

    return temp;
}

bool char_lt(char x, char y)
{
	return (unsigned char)x<(unsigned char)y?TRUE:FALSE;
}

bool char_gt(char x, char y)
{
	return (unsigned char)x>(unsigned char)y?TRUE:FALSE;
}

bool char_le(char x, char y)
{
	return (unsigned char)x<=(unsigned char)y?TRUE:FALSE;
}

bool char_ge(char x, char y)
{
	return (unsigned char)x>=(unsigned char)y?TRUE:FALSE;
}

bool char_similar(char x, char y)
{
    return x == y;
}

char char_copy(char x)
{
	return x;
}

struct chardv_s {
    struct dv_s super;
    bool (*equal)(char x, char y);
    string (*unparse)(char x);
    string (*to_string)(char x);
    int (*to_int)(char x);
    bool (*lt)(char x, char y);
    bool (*gt)(char x, char y);
    bool (*le)(char x, char y);
    bool (*ge)(char x, char y);
    bool (*similar)(char x, char y);
    char (*copy)(char x);
} char_methods = {
    {0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class},
    char_equal,
    char_unparse,
    string_ctos,
    char_to_int,
    char_lt,
    char_gt,
    char_le,
    char_ge,
    char_similar,
    char_copy
  };

DV char_DH[] = {
    (DV)&char_methods
  };
    
void initChar()
{
    Char->dh = char_DH;
    Char->dhsize = 1;
    char_methods.super.c = Char;
}
