/* Copyright Barbara Liskov 1995 */

#ifndef _CLASS_CLASS_H
#define _CLASS_CLASS_H

#include "common/iter.h"
#include "types/class.h"
#include "types/objtype_class.h"

#ifdef __cplusplus
extern "C" {
#endif

/* 
    The "superclass" field has length 0 if there is no superclass,
    else length 1.

    The representation of "bitfields" as a vec depends on having
    bitfields be the same size as integers.
*/

extern struct classdv_s {
    struct objtypedv_s super;
    void (*fields)(class_, struct closure);
    class_ (*superclass)(class_);
#if 0
    objtype (*extension_type)(class_);
    class_ (*extension_class)(class_);
    obj (*get_object)(class_);
#endif
    objtype (*create_simple_object)(class_);
} class_methods;

/*
   Don't rearrange these fields without fixing "init_type" in "type.c"
   and "init_class" in "class.c".

   "fields" describes only those fields that are new in this class.
   Fields inherited from the superclass are not listed here.

   The field "methods", inherited from "Type", does not mention
   any methods declared in the superclass.
*/
struct class_s {
    union {
	struct objtype_s inh;
	struct classdv_s *methods;
    } hdr;
    vec fields; /* vec[formal] */
    vec superclass; /* vec[class_] : length 0 or 1 */
#if 0
    vec extension_type; /* vec[objtype] */
    vec extension_obj; /* vec[any] */
#endif
    vec bitfields;
    int slots;
    int dhsize;
    bool visible;
    bool special;
    string specialText;
    vec slottypes; /* vec[objtype] */
    DV *dh;
};

#ifdef __alpha__
#define CLASS_SLOTS (OBJTYPE_SLOTS + 8)
#define CLASS_BITFIELD ((0x67 << OBJTYPE_SLOTS) | OBJTYPE_BITFIELD)
#else
#define CLASS_SLOTS (OBJTYPE_SLOTS + 9)
#define CLASS_BITFIELD ((0xC7 << OBJTYPE_SLOTS) | OBJTYPE_BITFIELD)
#endif

/*
   These two definitions must be kept in sync with the definition of
   "struct class_s". Because of circularities in the bootstrap
   process, they cannot be precomputed.
*/

extern class_ new_class();
/* create a new class object with only header initialized */

extern void init_class(class_);
/* initialize the headers of a completely uninitialized class object */

extern void computeBitfields(class_);
/* Update the "bitfields" field to accord with "fields" for the particular
   FE in use. */

extern vec no_slottypes;

#define computeSlottypes(c, s, b) ((c->slottypes != no_slottypes) ? \
	     (objtype*) c->slottypes->items :  initSlottypes(c,s,b))
extern objtype *initSlottypes (class_, int, Obj_bitfield );
/* Update the "slottype" field to accord with "fields" for the particular
   FE in use. */

void field_offsets(class_, struct closure);
/* yields(int, bool, Type)

   where "int" is the offset just past the end of the particular field, "bool"
   is TRUE iff the field is a pointer occupying a full word,
   and "Type" is the type of the field. Thus, the offset yielded
   never 0, and the last offset yielded is the length of the data
   in bytes.

   Requires: "c" must be an object type.
*/


extern void initClass();
/* Initialize the dispatch header of the object "Class". */

#if 0
void attachExtensionObject(class_ c, class_ extensionClass);
/* Create a extension object for class "c", assuming it doesn't
   already have one. The extension object is of class
   "extensionClass", which must implement "class_extension_type(c)".
   Also, "extensionClass" may not have any fields.

   This function may only be called from within class object
   initializer functions, such as "initClass" or "initInt", etc.
*/
#endif
   
/* For use by subclasses only */
extern void class_fields_(class_, struct closure);
extern class_ class_superclass_(class_ );
extern obj class_get_object_(class_);
extern class_ class_extension_class_(class_);
extern objtype class_extension_type_(class_);

struct rtn_s {
    union {
	struct objtype_s inh;
    } hdr;
};

typedef struct rtn_s *rtn_;

#ifdef __cplusplus
}
#endif

#endif /* _CLASS_CLASS_H */
