/* Copyright Barbara Liskov 1995 */

#include "class_instn_class.h"
#include "pclass.h"
#include "runtime/alloc.h"
#include "vec.h"

class_ ClassInstn;

extern bool class_instn_isSubtype_(type t1, type t2);

/* A "ClassInstn" is unusual in that it has multiple supertypes:
   Class and Instn. For this reason, the dispatch header contain
   2 entries. The primary entry (hdr.methods) points to the full
   dispatch table for "ClassInstn". The secondary entry only points
   to an "Instn" dispatch table.

   This size-2 header is also the reason for the unusual "boffset" and
   "offset" fields in the dispatch tables defined below.
*/

void class_instn_methods_2(type t, struct closure cl)
{
    DV dv = (DV)t->methods;
    objtype_methods_(BUMP(type, t, dv), cl);
}

bool class_instn_isSubtype_2(type t1, type t2)
{
    DV dv = (DV)t1->methods;
    return class_instn_isSubtype_(BUMP(type, t1, dv), t2);
}

string class_instn_name_2(type t)
{
    DV dv = (DV)t->methods;
    return objtype_name_(BUMP(type, t, dv));
}
			 
string class_instn_unparse_2(type t)
{
    DV dv = (DV)t->methods;
    return objtype_unparse_(BUMP(type, t, dv));
}

bool class_instn_equal_2(type t1, type t2)
{
    DV dv = (DV)t1->methods;
    return objtype_equal_(BUMP(type, t1, dv), t2);
}

void class_instn_supertypes_2(type t, struct closure cl)
{
    DV dv = (DV)t->methods;
    objtype_supertypes_(BUMP(type, t, dv), cl);
}

int class_instn_kind_2(type t)
{
    DV dv = (DV)t->methods;
    return objtype_kind_(BUMP(type, t, dv));
}

void class_instn_get_method_2(objtype t, fevalue *__retvals, string name)
{
    DV dv = (DV)t->hdr.methods;
    objtype_get_method_(BUMP(objtype, t, dv), __retvals, name);
}

class_ class_instn_as_class(class_instn ci)
{
    return &ci->hdr.inh;
}

instn class_instn_as_instn(class_instn ci)
{
    return (instn)(((DV *)ci) - 1); /* XXX oog */
}

ptype class_instn_ptype_(class_instn ci)
{
    return pclass_as_ptype(ci->pclass_);
}

ptype class_instn_ptype_2(class_instn ci)
{
    DV dv = (DV)ci->hdr.methods;
    return class_instn_ptype_(BUMP(class_instn, ci, dv));
}

class_instn type_as_class_instn(type t)
{
    objtype ot = type_as_objtype(t);
    if (ot->kind == CLASS_INSTN_KIND) {
        DV dv = (DV)ot->hdr.methods;
	return BUMP(class_instn, ot, dv);
	}
    else {exc = &exc_not_possible; return 0;}
}

bool class_instn_isSubtype_(type t1, type t2)
{
vec pargs1, pargs2;
int i, size;
type parg1, parg2;
pclass pc1, pc2;
class_instn ci1, ci2;
DV dv2;
type t2bumped;

     /* pretty rudimentary: just does equality, not
		really subtyping */

     /* except:  special case t2 being any */
     if (type_kind(t2) != PARAM_KIND && type_as_objtype(t2) == Any)
       return TRUE;

     ci1 = type_as_class_instn(t1);
     if (type_kind(t2) == CLASS_INSTN_KIND) {
	 dv2 = (DV)t2->methods;
	 t2bumped = BUMP(type, t2, dv2);
	 ci2 = type_as_class_instn(t2bumped);
         pc1 = ci1->pclass_;
         pc2 = ci2->pclass_;
         if (pclass_as_ptype(pc1) != pclass_as_ptype(pc2)) return FALSE;
         pargs1 = ci1->pargs;
         pargs2 = ci2->pargs;
         size = vec_length(pargs1);
         if (size != vec_length(pargs2)) return FALSE;
         for (i = 0; i < size ; i++) {
            parg1 = UNPV(type, vec_fetch(pargs1, i));
            parg2 = UNPV(type, vec_fetch(pargs2, i));
            if (!isSubtype(parg1, parg2)) return FALSE;
            if (!isSubtype(parg2, parg1)) return FALSE;
         }
         return TRUE;
     }
     else return FALSE;
}

pclass class_instn_pclass_(class_instn ci)
{
    return ci->pclass_;
}

pclass class_instn_pclass_2(class_instn ci)
{
    DV dv = (DV)ci->hdr.methods;
    return class_instn_pclass_(BUMP(class_instn, ci, dv));
}

void class_instn_pargs_(class_instn ci, struct closure cl)
{
    vec_elements(ci->pargs, cl);
}

void class_instn_pargs_2(class_instn ci, struct closure cl)
{
    DV dv = (DV)ci->hdr.methods;
    class_instn_pargs_(BUMP(class_instn, ci, dv), cl);
}

vec class_instn_get_pargs(class_instn ci)
{
	DV dv = (DV)ci->hdr.methods;
	class_instn ci_bumped = BUMP(class_instn, ci, dv);
	return ci->pargs;
}

struct class_instndv_s class_instn_methods = {
    {{{{-sizeof(DV), 0, STD_FOFFSET, 0, 0, normal_get_address,
	 normal_get_class},
	 objtype_equal_,
	 objtype_supertypes_,
	 class_instn_isSubtype_,
	 objtype_methods_,
	 objtype_name_,
	 objtype_unparse_,
	 objtype_kind_
       },
	   objtype_get_method_
	 },
	     class_fields_,
	     class_superclass_
	   },
	       class_instn_ptype_,
	       class_instn_pargs_,
	       class_instn_pclass_
	     };

struct instndv_s class_instn_methods2 = {
    {{{0, sizeof(DV), STD_FOFFSET+sizeof(DV), 0, 0, normal_get_address,
	 normal_get_class},
	class_instn_equal_2,
	class_instn_supertypes_2,
	class_instn_isSubtype_2,
	class_instn_methods_2,
	class_instn_name_2,
	class_instn_unparse_2,
	class_instn_kind_2,
      },
	  class_instn_get_method_2
	},
	    (ptype (*)(instn))class_instn_ptype_2,
	    (void (*)(instn, struct closure))class_instn_pargs_2,
	    /* These casts are necessary because class_instn_ptype_2
	       and class_instn_pargs are used to implement methods
	       for both "instn" and "class_instn"
	    */
	  };

class_instn new_class_instn()
{
    struct class_instn_full *cif = NEW_META(struct class_instn_full);
    return &cif->obj;
}

void init_class_instn(class_instn ci)
{
    struct class_instn_full *cif =
      (struct class_instn_full *)((DV *)ci - 1);
    core o = &ci->hdr.inh.hdr.inh.hdr.inh;
    assert(&cif->obj == ci);
    init_class(&ci->hdr.inh);
    o->size = CLASS_INSTN_SLOTS;
    o->bitfields = CLASS_INSTN_BITFIELD;
    ci->hdr.inh.hdr.inh.kind = CLASS_INSTN_KIND;
    ci->hdr.methods = &class_instn_methods;
    cif->instn_methods = &class_instn_methods2;
    /* We don't use init_obj_hdr_prim because it can't handle the
       second dispatch header slot (instn_methods). */
}

pclass class_instn_get_pclass(class_instn ci)
{
    return ci->hdr.methods->get_pclass(ci);
}

static DV ClassInstn_dh[] = {(DV)&class_instn_methods2,
			     (DV)&class_instn_methods};

void init_ClassInstn()
{
    ClassInstn->dh = ClassInstn_dh;
    ClassInstn->dhsize = 2;
    class_instn_methods.super.super.super.super.c = ClassInstn;
    class_instn_methods2.super.super.super.c = ClassInstn;
}
