/* Copyright Barbara Liskov 1995 */

#ifndef _CLASS_INSTN_H
#define _CLASS_INSTN_H

#include "types/type_def.h"
#include "vec_def.h"

extern class_ ClassInstn;
extern void init_ClassInstn();

/* Overview:

    A "class_instn" represents an instantiation of a parameterized
    class. It is both a "class" and an "instn", so it has 2 supertypes.
*/
#ifdef __cplusplus
extern "C" {
#endif

class_ class_instn_as_class(class_instn);
/*
   View this object as a "class".
*/

instn class_instn_as_instn(class_instn);
/*
   View this object as an "instn".
*/

class_ class_instn_as_class(class_instn);
/*
   View this object as a "class_"
*/

pclass class_instn_get_pclass(class_instn ci);
/*
   Get the pclass that this is an instantiation of.
*/

bool class_instn_equal(class_instn, class_instn);
/*
   Use pclass and pargs to check equality...
*/

class_instn type_as_class_instn(type t);
/*
   Convert t to class_instn, if it is actually a class_instn.
*/

vec class_instn_get_pargs(class_instn ci);
/*
  Return vec of pargs...
*/

#ifdef __cplusplus
}
#endif

#endif /* _CLASS_INSTN_H */
