/* Copyright Barbara Liskov 1995 */

#ifndef _CLASS_INSTN_CLASS_H
#define _CLASS_INSTN_CLASS_H

#include "types/ptype_class.h"
#include "types/class_instn.h"
#include "types/class_class.h"

typedef struct class_instndv_s {
    struct classdv_s super;
/* instn methods */
    ptype (*get_ptype)(class_instn);
    void (*pargs)(class_instn, struct closure);
    pclass (*get_pclass)(class_instn);
} *class_instndv;
  

extern struct class_instndv_s class_instn_methods;

struct class_instn_s {
    union {
	struct class_s inh;
	class_instndv methods; /* Primary entry in the dispatch header */
    } hdr;
    pclass pclass_;
    vec pargs;      /* vec[Type] */
    bool valid;
};

struct class_instn_full {
    instndv instn_methods;     /* Secondary entry in the dispatch header */
    struct class_instn_s obj;
};

#define CLASS_INSTN_SLOTS (3 + CLASS_SLOTS)
#define CLASS_INSTN_BITFIELD ((0x3 << CLASS_SLOTS) | CLASS_BITFIELD)

extern class_instn new_class_instn();
/* Produces a "class_instn_full" and returns a pointer to the
   member "obj". This routine MUST be used for allocating space
   for a "class_instn". The macro "NEW" may NOT be used. */
   
extern void init_class_instn(class_instn ci);
/* Initialize a new class instantiation. For use by subclasses and
   other privileged clients.
*/

extern pclass class_instn_get_pclass_(class_instn);

#endif /* _CLASS_INSTN_CLASS_H */
