/* Copyright Barbara Liskov 1995 */

#include "dict.h"
#include "stdlib.h"
#include "str.h"
#include "any.h"
#include "runtime/alloc.h"
#include "runtime/obj_class.h"
#include <stdio.h>

typedef struct entry_s *entry;
struct entry_s {
    string key;
    any val;
    entry next;
};

struct dict_s {
    entry first;
};

dict dict_new()
{
    dict ret = NEW(struct dict_s);
    ret->first = 0;
    return ret;
}

void delete_dict(dict d)
{
    entry prev = 0;
    entry e = d->first;
    while (e->next) {
	entry n = e->next;
	e->next = prev;
	e = n;
    }
    while (e) {
	entry p = e->next;
	THOR_FREE(e);
	e = p;
    }
    THOR_FREE(d);
}

void dict_add(dict d, string key, any val)
{
    if (!dict_contains(d, key)) {
	entry new_entry = NEW(struct entry_s);
	new_entry->key = key;
	new_entry->val = val;
	new_entry->next = d->first;
	d->first = new_entry;
    } else {
	exc = &exc_duplicate;
    }
}

any dict_remove(dict d, string key)
{
    entry e = d->first;
    if (string_equal(e->key, key)) {
	any ret = e->val;
	d->first = e->next;
	THOR_FREE(e);
	return ret;
    }
    while (e && !string_equal(e->next->key, key)) e = e->next;
    if (e) {
	any ret = e->next->val;
	THOR_FREE(e->next);
	e->next = e->next->next;
	return ret;
    }
    exc = &exc_not_found;
}

bool dict_contains(dict d, string key)
{
    entry e = d->first;
    while (e) {
	if (string_equal(e->key, key)) return TRUE;
	e = e->next;
    }
    return FALSE;
}

any dict_fetch(dict d, string key)
{
    entry e = d->first;
    while (e) {
	if (string_equal(e->key, key)) return e->val;
	e = e->next;
    }
    exc = &exc_not_found;
}

void dict_keys(dict d, struct closure cl)
{
    entry e = d->first;
    while (e) {
        cl.f(cl.env, e->key);
        e = e->next;
    }
}

void dict_print(dict d)
{
    entry e = d->first;
    while (e) {
        fprintf(stderr, "%s -> 0x%lx\n", string_charp(e->key), e->val);
	e = e->next;
    }
}


