/* Copyright Barbara Liskov 1995 */

#ifndef _INT_H
#define _INT_H

#include "runtime/obj.h"
#include "type_def.h"
#include "str.h"

extern string int_unparse(int);
extern void initInt();

extern class_ Int_get_class(obj);

/* The following int ops are always be inlined */

#define int_copy(x) (x)
#define int_equal(x,y) ((x)==(y))
#define int_similar(x,y) ((x)==(y))
#define int_lt(x,y) ((x)<(y))
#define int_le(x,y) ((x)<=(y))
#define int_gt(x,y) ((x)>(y))
#define int_ge(x,y) ((x)>=(y))
#define int_min(x,y) ((x)<(y)?(x):(y))
#define int_max(x,y) ((x)>(y)?(x):(y))


/* The following int ops may be inlined for performance comparison only,
   at the expense of robustness */

#if 0
#define int_add(x,y) ((x)+(y))
#define int_subtract(x,y) ((x)-(y))
#define int_multiply(x,y) ((x)*(y))
#define int_divide(x,y) ((x)/(y))
#define int_mod(x,y) ((x)%(y))
#define int_negate(x) (-(x))
#define int_abs(x) ((x>0)?(x):-(x))
#else
#define int_add(x,y) int_add_(x,y)
#define int_subtract(x,y) int_subtract_(x,y)
#define int_multiply(x,y) int_multiply_(x,y)
#define int_divide(x,y) int_divide_(x,y)
#define int_mod(x,y) (((x)>0 && (y)>0) ? (x)%(y) : int_mod_((x),(y)))
#define int_negate(x) int_negate_(x)
#define int_abs(x) int_abs_(x)
#endif

/* The following int ops are never inlined */

#define int_to_real(x) int_to_real_(x)
#define int_to_char(x) int_to_char_(x)
#define int_power(x,y) int_power_(x,y)
#define int_to(x,y,z) int_to_(x,y,z)
#define int_to_by(x,y,z) int_to_by_(x,y,z)



#endif /* _INT_H */
