/* Copyright Barbara Liskov 1995 */

#ifndef _LIST_H
#define _LIST_H

#include "types/any.h"
#include "runtime/except.h"

typedef struct list_s *list;

/* Overview: list is a singly-linked mutable list type.
   A typical non-empty list is (in Prolog notation) "[H|T]", where "H" is
   the first item in the list and "T" is the remainder of the list.
*/


any first(list x);
/* Return H[x]. Signal "empty" if the list is empty.
*/

list rest(list x);
/* Return T[x]. Signal "empty" if the list is empty.
*/

void set_first(list x, any a);
/* Set  H[x] to be a. Signal "empty" if the list is empty.
*/

void set_rest(list x, list y);
/* Set  T[x] to be y. Signal "empty" if the list is empty.
*/


#endif /* _LIST_H */
