/* Copyright Barbara Liskov 1995 */

#include "maybe.h"
#include "runtime/except.h"
#include "runtime/obj_class.h"
#include "runtime/value.h"
#include "maybe_class.h"
#include "common/th_assert.h"
#include "common/other_unix.h"
#include <string.h>
#include "class_instn.h"
#include "class_instn_class.h"
#include "types/type.h"
#include "types/pclass.h"
#include "types/any.h"
#include "types/class_class.h"
#include "boot/wellknown.h"
#include "types/vec_instns.h"
#include "cache/gc_register.h"

pclass Maybe;
pclass EmptyMaybe;

extern struct exception_s exc_wrong_tag;
struct parg_env {
        type t;
        };
extern void get_parg_type(struct parg_env *env, type t);

maybe maybe_none(obj dummy, class_instn mi)
{
maybe_C ret = NEW(struct maybe_s);
bool prim = FALSE;
struct closure cl;
struct parg_env env;
class_ c = class_instn_as_class(mi);
int bf;
struct maybedv_s *mm;

    cl.env = &env;
    cl.f = (ifunc)get_parg_type;
    mi->hdr.methods->pargs(mi, cl);
    /* Now, env.t has the type of the object in the maybe... */
    if (type_kind(env.t) == PRIMITIVE_KIND) prim = TRUE;

    bf = UNPV(int, vec_fetch(c->bitfields, 0));
    init_obj_hdr_prim(&ret->hdr.inh, 1, bf,
                (DV)(*(class_instn_as_class(mi)->dh)));

    /* initialize instance variables */
    ret->value = null_as_any(0);

    return (maybe)ret;
}

maybe maybe_make(obj dummy, class_instn mi, pval value)
{
maybe_C ret = NEW(struct maybe_s);
bool prim = FALSE;
struct closure cl;
struct parg_env env;
class_ c = class_instn_as_class(mi);
int bf;
struct maybedv_s *mm;
obj o;
fevalue fv;

    cl.env = &env;
    cl.f = (ifunc)get_parg_type;
    mi->hdr.methods->pargs(mi, cl);
    /* Now, env.t has the type of the object in the maybe... */
    if (type_kind(env.t) == PRIMITIVE_KIND) prim = TRUE;

    bf = UNPV(int, vec_fetch(c->bitfields, 0));
    init_obj_hdr_prim(&ret->hdr.inh, 1, bf,
                (DV)(*(class_instn_as_class(mi)->dh)));

    /* initialize instance variables */
    o = UNPV(obj, value);
    fv.o = o;
    ret->value = make_any(env.t, fv);

    return (maybe)ret;
}


bool maybe_is_full(maybe mm)
{
maybe_C m = (maybe_C)mm;
class_ c;

	FIXUPREAD(&m->hdr.inh);
	return TRUE;
	}

bool empty_maybe_is_full(maybe mm)
{
maybe_C m = (maybe_C)mm;
class_ c;

	FIXUPREAD(&m->hdr.inh);
	return FALSE;
	}

bool maybe_is_empty(maybe mm)
{
maybe_C m = (maybe_C)mm;
class_ c;

	FIXUPREAD(&m->hdr.inh);
	return FALSE;
	}

bool empty_maybe_is_empty(maybe mm)
{
maybe_C m = (maybe_C)mm;
class_ c;

	FIXUPREAD(&m->hdr.inh);
	return TRUE;
	}

pval maybe_value_full(maybe mm)
{
maybe_C m = (maybe_C)mm;
class_ c;
fevalue fv;
	
	FIXUPREAD(&m->hdr.inh);
	DISCOVER(m->value, any);
	fv = any_get_value(m->value);
	return (pval)fv.o;
	}

pval empty_maybe_value_full(maybe mm)
{
maybe_C m = (maybe_C)mm;
	
	FIXUPREAD(&m->hdr.inh);
	exc = &exc_wrong_tag;
	return;
	}

pval maybe_value_empty(maybe mm)
{
maybe_C m = (maybe_C)mm;
	
	FIXUPREAD(&m->hdr.inh);
		exc = &exc_wrong_tag;
		return;
	}

pval empty_maybe_value_empty(maybe mm)
{
maybe_C m = (maybe_C)mm;
	
	FIXUPREAD(&m->hdr.inh);
	return 0;
	}

bool maybe_equal(maybe mm1, maybe mm2)
{
	th_fail("maybe_equal not implemented");
	}

bool maybe_similar(maybe mm1, maybe mm2)
{
	th_fail("maybe_similar not implemented");
	}

maybe maybe_copy(maybe mm)
{
	th_fail("maybe_copy not implemented");
	}

string maybe_unparse(maybe mm)
{
	th_fail("maybe_unparse not implemented");
	}

static vec maybe_superc = 0;
static string mci_prefix = 0;
static string emci_prefix = 0;
struct maybedv_s maybe_methods;
struct maybedv_s empty_maybe_methods;
extern vec no_slottypes;

DV *maybe_dhs(class_instn mci, vec pargs)
{
class_ c = class_instn_as_class(mci);
vec maybe_ivars;
formal f;
string mci_nm, emci_nm;
any a;
class_instn emci;

        bool saved = normal_heap;
        DV *dh = (DV *)malloc(1*sizeof(DV));
        struct maybedv_s *mm = (struct maybedv_s *)malloc
                (sizeof(struct maybedv_s));
        normal_heap = FALSE;
        bcopy((char*)&maybe_methods, (char*)mm, sizeof(struct maybedv_s));
        mm->super.c = class_instn_as_class(mci);
        /* gc_register_root((obj*)&(mm->super.c)); */
        mm->t = UNPV(type, vec_fetch(pargs, 0));
        /* gc_register_root((obj*)&(mm->t)); */
        if (!mci_prefix) {
                mci_prefix = string_new("maybe_OF_");
                gc_register_meta_root((obj*)&mci_prefix);
                }
        mci_nm = string_concat(mci_prefix, typenm2cnm(mm->t));
        a = get_wellknown(mci_nm);
        CATCH {
                mm->mci = 0;
                RESET_EXC;
                }
        else {
                mm->mci = (class_instn)any_get_obj(a);
                /* gc_register_root((obj*)&(mm->mci)); */
             }
        c->special = TRUE;
        c->specialText = string_empty();
        if (!maybe_superc) {
                maybe_superc = make_vec_Type(0, FALSE);
                gc_register_meta_root((obj*)&maybe_superc);
                }
        c->superclass = maybe_superc;
        maybe_ivars = make_vec_Formal(1, FALSE);
        c->fields = maybe_ivars;

        f = new_formal();
        f->name = string_new("value");
        f->t = objtype_as_type(Any);
        vec_store(maybe_ivars, 0, PV(f));

        *dh = (DV)mm;

        if (!emci_prefix) {
                emci_prefix = string_new("empty_maybe_OF_");
                gc_register_meta_root((obj*)&emci_prefix);
                }
        emci_nm = string_concat(emci_prefix, typenm2cnm(mm->t));
        a = get_wellknown(emci_nm);
        CATCH {
                RESET_EXC;
		if (type_kind(mm->t) != PARAM_KIND) {
			emci = pclass_instantiate_(EmptyMaybe, pargs);
                	mm->emci = emci;
                	gc_register_meta_root((obj*)&(mm->emci));
			}
                }
        else {
                mm->emci = (class_instn)any_get_obj(a);
             }

	/* If we don't have lots of good info, just return now */
	/* we are probably in the compiler and the other stuff is not necessary */
	normal_heap = saved;
        if (type_kind(mm->t) == PARAM_KIND || mm->mci == 0) return dh;

	/* continue to do full instn */
        computeBitfields(c);
        if (!no_slottypes) {
            no_slottypes = make_vec_ObjType(0, FALSE);
            gc_register_root((obj*)&no_slottypes);
        }
        c->slottypes = no_slottypes;
        return dh;
}


DV *empty_maybe_dhs(class_instn mci, vec pargs)
{
class_ c = class_instn_as_class(mci);
vec empty_maybe_ivars;
formal f;
string mci_nm;
any a;

        bool saved = normal_heap;
        DV *dh = (DV *)malloc(1*sizeof(DV));
        struct maybedv_s *mm = (struct maybedv_s *)malloc
                (sizeof(struct maybedv_s));
        normal_heap = FALSE;
        bcopy((char*)&empty_maybe_methods, (char*)mm, sizeof(struct maybedv_s));
        mm->super.c = class_instn_as_class(mci);
        /* gc_register_root((obj*)&(mm->super.c)); */
        mm->t = UNPV(type, vec_fetch(pargs, 0));
        /* gc_register_root((obj*)&(mm->t)); */
        if (!emci_prefix) {
                emci_prefix = string_new("empty_maybe_OF_");
                gc_register_meta_root((obj*)&emci_prefix);
                }
        mci_nm = string_concat(emci_prefix, typenm2cnm(mm->t));
        a = get_wellknown(mci_nm);
        CATCH {
                mm->mci = 0;
                RESET_EXC;
                }
        else {
                mm->mci = (class_instn)any_get_obj(a);
                /* gc_register_root((obj*)&(mm->mci)); */
             }
        c->special = TRUE;
        c->specialText = string_empty();
        if (!maybe_superc) {
                maybe_superc = make_vec_Type(0, FALSE);
                gc_register_meta_root((obj*)&maybe_superc);
                }
        c->superclass = maybe_superc;
        empty_maybe_ivars = make_vec_Formal(1, FALSE);
        c->fields = empty_maybe_ivars;

        f = new_formal();
        f->name = string_new("value");
        f->t = objtype_as_type(Any);
        vec_store(empty_maybe_ivars, 0, PV(f));

        *dh = (DV)mm;
	normal_heap = saved;
        if (type_kind(mm->t) == PARAM_KIND
                || mm->mci == 0) return dh;
        computeBitfields(c);
        if (!no_slottypes) {
           no_slottypes = make_vec_ObjType(0, FALSE);
           gc_register_meta_root((obj*)&no_slottypes);
        }
        c->slottypes = no_slottypes;
        return dh;
}

class_instn maybe_ci_get_emci(class_instn mci)
{
	class_ c = class_instn_as_class(mci);
	DV *dh = c->dh;
	struct maybedv_s *mm = (struct maybedv_s *)(*dh);
	return mm->emci;
}


struct maybedv_s maybe_methods = {
    {
        0, 0, STD_FOFFSET, 0,
        0, /* This field needs to be overridden */
        normal_get_address,
        normal_get_class
    },
    maybe_is_full,
    maybe_is_empty,
    maybe_value_full,
    maybe_value_empty,
    maybe_equal,
    maybe_similar,
    maybe_copy,
    maybe_unparse,
    0,/* This field needs to be overridden */
    0 /* This field needs to be overridden */
};

DV Maybe_DH[] = {
    (DV)&maybe_methods
};

struct maybedv_s empty_maybe_methods = {
    {
        0, 0, STD_FOFFSET, 0,
        0, /* This field needs to be overridden */
        normal_get_address,
        normal_get_class
    },
    empty_maybe_is_full,
    empty_maybe_is_empty,
    empty_maybe_value_full,
    empty_maybe_value_empty,
    maybe_equal,
    maybe_similar,
    maybe_copy,
    maybe_unparse,
    0,/* This field needs to be overridden */
    0 /* This field needs to be overridden */
};

DV EmptyMaybe_DH[] = {
    (DV)&empty_maybe_methods
};


