/* Copyright Barbara Liskov 1995 */


#ifndef _MAYBE_H
#define _MAYBE_H

#include "maybe_def.h"
#include "runtime/obj.h"
#include "common/basic.h"
#include "runtime/pval.h"
#include "types/type_def.h"
#include "types/vec_def.h"

extern pclass Maybe;
extern pclass EmptyMaybe;

#ifdef __cplusplus
extern "C" {
#endif

/* A maybe[T] either points to a T or to nil */

extern maybe new_maybe();

extern bool maybe_exists(maybe self);
/* Return true if maybe points to an object of type T. */

extern pval maybe_value(maybe self);
/* Return the value of the maybe, except signal wrong_tag, if the */
/* maybe points to nil. */

extern bool maybe_equal(maybe self, maybe m);

extern bool maybe_similar(maybe self, maybe m);

extern maybe maybe_copy(maybe self);

extern void initmaybe();

extern DV *maybe_dhs(class_instn, vec);

extern DV *empty_maybe_dhs(class_instn, vec);

extern class_instn maybe_ci_get_emci(class_instn mci);

#ifdef __cplusplus
}
#endif

#endif /* _MAYBE_H */
