/* Copyright Barbara Liskov 1995 */

/*

\section{Methods}

   A "method" represents part of an interface to a type and all its
   subtypes. Types contain methods; see the specification for "type".
   A method interface is present in subtypes, and may be
   represented there by the same method object if the arguments and
   return values have exactly the same types, and its name is the same
   there. If method renaming has taken place, or if derived argument/return
   types are different, then a different method object is referenced from
   the subtypes.

   Creation of new method objects is done by the compiler
   through a back-door interface not exposed here.
*/

#ifndef _METHOD_H
#define _METHOD_H

#include "common/basic.h"
#include "common/iter.h"
#include "types/type_def.h"

#ifdef __cplusplus
extern "C" {
#endif
    
string method_name(method);
/*\sl
    Return the name of the method, which is a valid Theta identifier.
*/

void method_args(method, struct closure);
/*\sl
    Report the arguments of the method:\/
    "args() yields(string, type)".
*/

void method_sigs(method, struct closure);
/*\sl
    Yield the exceptions that can be raised by the method:
    "sigs() yields(string, list)" where the list contains only types.
*/

void method_rets(method, struct closure);
/*\sl
    Yield the return values of the method: "rets() yields(type)"
*/

bool method_isIter(method);
/*\sl
    Return whether the method is an iterator.
*/

int method_index(method m);
/* \sl
   Return the index of this method in the type "method_self_type(m)".
*/

string method_spec(method);
/*\sl
   Return the method's spec, which is currently just a textual
   description.
*/

type method_self_type(method);
/*\sl
  Return the apparent type of the receiver of "method"
*/
     
void initMethod();
/*\sl
    Initialize the "Method" class.
*/

#ifdef __cplusplus
}
#endif

#endif /* _METHOD_H */
