/* Copyright Barbara Liskov 1995 */

#include "method.h"
#include "runtime/alloc.h"
#include "vec_class.h"
#include "textwr.h"
#include "stdlist.h"
#include "class_instn_class.h"
#include "str.h"

#include "common/truefalse.h"

extern void initSignal();
extern void initNull();
extern void initFormal();

#include <stdio.h>
#include <stdlib.h>

class_ ObjType;

/* Must match inline definition in objtype_class.h */
objtype type_as_objtype(type t)
{
    objtype tbumped = BUMP(objtype, t, (DV)t->methods);
    /* XXX The previous line is kind of sleazy because there is
       nothing that guarantees that all implementors of "objtype"
       as a type also inherit from "objtype" (considered as a class).
       For example, Instn implements objtype, and also inherits from
       it by a different path, so it's ok.
    */
#ifndef NDEBUG
    class_ tc = get_obj_class((obj)tbumped);
    assert(tc == ObjType || tc == Instn || tc == Class ||
	   tc == ClassInstn || tc == PClass || tc == PType);
#endif
    return tbumped;
}

type vec_type_fetch(vec v, int i)
{
    return UNPV(type, vec_fetch(v, i));
}

void getMethod(objtype t, fevalue *__retvals, string nm)
{
    objtypedv __dv = t->hdr.methods;
    (*__dv->get_method)(t, __retvals, nm);
}

void objtype_get_method(objtype t, fevalue *__retvals, string name)
{
    FIX(t,objtype);
    objtype_get_method_(t, __retvals, name);
}

void objtype_get_method_(objtype t, fevalue *__retvals, string name)
{
    int i;
    method *methods;
    int num_methods;
    num_methods = vec_length(t->methods_);
    methods = VEC_ITEMS(t->methods_, method);
    for (i=0; i<num_methods; i++) {
	if (string_equal(methods[i]->name, name)) {
	    __retvals[0].o = (obj)methods[i];
	    __retvals[1].o = (obj)t;
	    return;
	}
    }
    {
	int nst = vec_length(t->supertypes_);
	for (i = 0; i<nst; i++) {
	    objtype_get_method(UNPV(objtype, vec_fetch(t->supertypes_, i)), __retvals, name);
	    CATCH {
		assert(exc == &exc_not_found);
		exc = EXC_NONE;
	    } else {
		return;
	    }
	}
    }
    if (t->kind == CLASS_KIND) {
	class_ c = (class_)t;
	if (vec_length(c->superclass)) {
	    class_ sc = UNPV(class_, vec_fetch(c->superclass, 0));
	    objtype_get_method(class_as_objtype(sc), __retvals, name);
	    CATCH {
		assert(exc == &exc_not_found);
		exc = EXC_NONE;
	    } else {
		return;
	    }
	}
    }
    exc = &exc_not_found;
    return;
}

void objtype_get_method_index(objtype t, fevalue *__retvals, int index)
{
    int i, starting_index;
    method *methods;
    int num_methods;
    FIX(t,objtype);
    FIX(t->methods_, vec);
    num_methods = vec_length(t->methods_);
    methods = VEC_ITEMS(t->methods_, method);
    starting_index = (num_methods > 0) ?
	method_index(methods[0]) : -1;

    if (index >= starting_index && index <= starting_index + num_methods) {

	i = index-starting_index;

	assert(method_index(methods[i])==index);

	__retvals[0].o = (obj)methods[i];
	__retvals[1].o = (obj)t;
	return;
    }

    else {
	int nst = vec_length(t->supertypes_);
	objtype *st = VEC_ITEMS(t->supertypes_, objtype);
	
	for (i = 0; i<nst; i++) {
	    objtype_get_method_index(st[i], __retvals, index);
	    CATCH {
		assert(exc == &exc_not_found);
		exc = EXC_NONE;
	    } else {
		return /* __retvals */;
	    }
	}
    }
    if (t->kind == CLASS_KIND) {
	class_ c = (class_)t;
	if (vec_length(c->superclass)) {
	    class_ sc = UNPV(class_, vec_fetch(c->superclass, 0));
	    objtype_get_method_index(class_as_objtype(sc), __retvals, index);
	    CATCH {
		assert(exc == &exc_not_found);
		exc = EXC_NONE;
	    } else {
		return;
	    }
	}
    }
    exc = &exc_not_found;
    return;
}


void objtype_supertypes_(type t_, struct closure cl)
{
    objtype t = (objtype)t_;
    int i;
    int num_s = vec_length(t->supertypes_);
    void (*f)(obj, type) = (void (*)(obj,type))cl.f;
    for (i=0; i<num_s; i++) {
	(*f)(cl.env, vec_type_fetch(t->supertypes_, i));
	CHECK_BREAK_EXC;
    }
}

void objtype_methods_(type t_, struct closure cl)
{
    objtype t = (objtype)t_;
    int i;
    void (*f)(obj, method) = (void (*)(obj,method))cl.f;
    int num_methods = vec_length(t->methods_);
    for (i=0; i<num_methods; i++) {
	(*f)(cl.env, UNPV(method, vec_fetch(t->methods_, i)));
	CHECK_BREAK_EXC;
    }
}

void objtype_all_methods_(type t_, struct closure cl)
{
    objtype t = (objtype)t_;
    int i;
    void (*f)(obj, method) = (void (*)(obj,method))cl.f;
    int num_methods = vec_length(t->methods_);
    if (t == Any) return;
    for (i=0; i<num_methods; i++) {
	(*f)(cl.env, UNPV(method, vec_fetch(t->methods_, i)));
	CHECK_BREAK_EXC;
    }
    {
	int nst = vec_length(t->supertypes_);
	for (i = 0; i<nst; i++) {
	    objtype_all_methods_(UNPV(type, vec_fetch(t->supertypes_, i)), 
				cl);
	    CHECK_BREAK_EXC;
	}
    }

}

bool objtype_isSubtype_(type t1_, type t2)
{
    objtype t1 = (objtype)t1_;
    int i;
    int num_supertypes = 0;
    assert(t1); assert(t2);
    FIX(t1, objtype); FIX(t2, type);
    if ((type)t1 == t2) return TRUE;
    if (t1->supertypes_) num_supertypes = vec_length(t1->supertypes_);
    for (i = 0; i < num_supertypes; i++) {
	if (isSubtype(vec_type_fetch(t1->supertypes_, i), t2)) return TRUE;
    }
    return FALSE;
}

string objtype_name_(type t)
{
    return ((objtype)t)->name;
}

static string method_unparse(method m);
static void unparse_typevec(wr w, vec types);

string objtype_unparse_(type t_)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    objtype t = (objtype)t_;
    int i;
    int num_supertypes;
    FIX(t,objtype);
    FIX(t->supertypes_,vec);
    wr_putString(w, type_name(objtype_as_type(t)));
    num_supertypes = vec_length(t->supertypes_);
    wr_putChars(w, " = ");
    unparse_typevec(w, t->supertypes_);
    wr_putChars(w, " type\n");
    for (i = 0; i < vec_length(t->methods_); i++) {
	wr_putString(w,
			    method_unparse(UNPV(method, vec_fetch(t->methods_,
							     i))));
	wr_putChar(w, '\n');
    }
    wr_putChars(w, "end");
    wr_putString(w, t->name);
    wr_putChar(w, '\n');
    wr_close(w);
    return textwr_toString(tw);
}

struct methoddv_s method_methods = {
    {0, 0, STD_FOFFSET, 0, 0,
     normal_get_address, normal_get_class},
    method_args,
    method_sigs,
    method_rets,
    method_isIter,
    method_name,
    method_unparse,
    method_index,
    method_self_type
  };

DV Method_dh[] = { (DV)&method_methods };

void initMethod()
{
    Method->dh  = Method_dh;
    Method->dhsize = 1;
    method_methods.super.c = Method;
}

static struct dv_s signal_methods = {
    0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class
  };
struct dv_s formal_methods = {
    0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class
  };

DV formal_DH[] = { (DV)&formal_methods };
DV signal_DH[] = { (DV)&signal_methods };

void initFormal()
{
    Formal->dh = formal_DH;
    Formal->dhsize = 1;
    formal_methods.c = Formal;
}

void initSignal()
{
    Signal->dh = signal_DH;
    Signal->dhsize = 1;
    signal_methods.c = Signal;
}
  
signal_ new_signal()
{
    signal_ ret = NEW_META(struct signal_s);
    bool saved = normal_heap;
    normal_heap = FALSE;
    init_obj_hdr_prim(&ret->hdr, 2, 0x3, (DV)&signal_methods);
    normal_heap = saved;
    return ret;
}

formal new_formal()
{
    formal ret = NEW_META(struct formal_s);
    bool saved = normal_heap;
    normal_heap = FALSE;
    init_obj_hdr_prim(&ret->hdr, 2, 0x3, (DV)&formal_methods);
    normal_heap = saved;
    return ret;
}

method new_method()
{
    method ret = NEW_META(struct method_s);
    bool saved = normal_heap;
    normal_heap = FALSE;
    init_obj_hdr_prim(&ret->hdr,
		      METHOD_SLOTS, METHOD_BITFIELD,
		      (DV)&method_methods);
    normal_heap = saved;
    return ret;
}

void method_args(method m, struct closure cl)
{
    int i;
    void (*f)(obj, string, type) = (void(*)(obj, string, type))cl.f;
    vec args;
    int n;
    formal *margs;
    FIX_FAST(m,method, method_methods);
    args = m->arguments;
    margs = VEC_ITEMS(args, formal);
    n = vec_length(args);
    for (i=0; i<n; i++) {
	formal frm = margs[i];
	FIX_FAST(frm, formal, formal_methods);
	(*f)(cl.env, frm->name, frm->t);
	CHECK_BREAK_EXC;
    }
    if (vec_length(m->extra_args)) {
	(*f)(cl.env, string_new("..."), UNPV(type, vec_fetch(m->extra_args, 0)));
	CHECK_BREAK_EXC;
    }
}

void method_sigs(method m, struct closure cl)
{
FIX_FAST(m, method, method_methods);
{
    int i,j;
    vec signals = m->signals;
    int num_sigs = vec_length(signals);
    signal_ *sigs = VEC_ITEMS(signals, signal_);

    
    void (*f)(obj, string, list) = (void (*)(obj,string,list))cl.f;
    for (i = 0; i<num_sigs; i++) {
	list l = empty_list();
	signal_ sig = sigs[i];
	FIX_FAST(sig, signal_, signal_methods);
	for (j = vec_length(sig->returns) - 1; j >= 0; j--) {
	    any a = obj_as_any(UNPV(obj, vec_fetch(sig->returns, j)));
	    l = cons(a, l);
	}
	f(cl.env, sig->name, l);
	CHECK_BREAK_EXC;
    }
}
}

void method_rets(method m, struct closure cl)
{
    FIX_FAST(m, method, method_methods);
    vec_elements(m->returns, cl);
}

bool method_isIter(method m)
{
    FIX_FAST(m, method, method_methods);
    return m->iter;
}

bool method_isParameterized(method m)
{
    FIX_FAST(m, method, method_methods);
    return m->parameterized;
}
string method_name(method m)
{
    FIX_FAST(m, method, method_methods);
    return m->name;
}

int method_index(method m)
{
    FIX_FAST(m, method, method_methods);
    return m->index;
}

type method_self_type(method m)
{
    FIX_FAST(m, method, method_methods);
    return m->self_type;
}

static void unparse_typevec_parens(wr w, vec types) {
    wr_putChar(w, '(');
    unparse_typevec(w, types);
    wr_putChar(w, ')');
}

static void unparse_typevec(wr w, vec types) {
    bool first = TRUE;
    int i, numt = vec_length(types);
    for (i = 0; i < numt; i++) {
	if (!first) wr_putChars(w, ", ");
	first = FALSE;
	wr_putString(w, type_name(UNPV(type, vec_fetch(types, i))));
    }
}

bool null_equal(int n1, int n2)
{
    return TRUE;
}

bool null_similar(int n1, int n2)
{
    return TRUE;
}

int null_copy(int n1)
{
    return n1;
}

string null_unparse(int n1)
{
    return string_new("nil");
}

struct nulldv_s {
	struct dv_s super;
	bool (*equal)(int, int);
	bool (*similar) (int, int);
	int (*copy) (int);
	string (*unparse)(int);
} Null_methods = { 
    {0,0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class},
     null_equal,
     null_similar,
     null_copy,
     null_unparse
    };

DV Null_dh[] = { (DV)& Null_methods };

void initNull()
{
    Null->dh = Null_dh;
    Null->dhsize = 1;
    Null_methods.super.c = Null;
}

static string method_unparse(method m)
{
    int i;
    bool first;
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    FIX_FAST(m,method,method_methods);
    wr_putChars(w, "  ");
    wr_putString(w, method_name(m));
    wr_putChar(w, '(');
    first = TRUE;
    for (i=0; i<vec_length(m->arguments); i++) {
	formal frm = UNPV(formal, vec_fetch(m->arguments, i));
	FIX_FAST(frm, formal, formal_methods);
	if (!first) wr_putChar(w, ',');
	first = FALSE;
	wr_putString(w, frm->name);
	wr_putChars(w, ": ");
	wr_putString(w, type_name(frm->t));
    }
    wr_putChar(w, ')');
    if (vec_length(m->returns)) {
	if (m->iter)
	  wr_putChars(w, " yields");
	else
	  wr_putChars(w, " returns");
	unparse_typevec_parens(w, m->returns);
    }
    if (vec_length(m->signals)) {
	signal_ *sigs = VEC_ITEMS(m->signals, signal_);
	wr_putChars(w, " signals(");
	first = TRUE;
	for (i = 0; i < vec_length(m->signals); i++) {
	    signal_ sig = sigs[i];
	    FIX_FAST(sig, signal_, signal_methods);
	    if (!first) wr_putChar(w, ',');
	    first = FALSE;
	    wr_putString(w, sig->name);
	    if (vec_length(sig->returns)) {
		unparse_typevec_parens(w, sig->returns);
	    }
	}
	wr_putChar(w, ')');
    }
    return textwr_toString(tw);
}

int objtype_kind_(type t)
{
    return ((objtype)t)->kind;
}

objtype new_objtype()
{
    objtype ret = NEW_META(struct objtype_s);
    bool saved = normal_heap;
    normal_heap = FALSE;
    init_type(ret);
    normal_heap = saved;
    return ret;
}

bool objtype_equal_(type ot, type t)
{
    return (ot == t)?TRUE:FALSE;
}

struct objtypedv_s objtype_methods = {
    {{0, 0, STD_FOFFSET, 0, 0,
	normal_get_address, normal_get_class},
       objtype_equal_,
       objtype_supertypes_,
       objtype_isSubtype_,
       objtype_methods_,
       objtype_name_,
       objtype_unparse_,
       objtype_kind_,
     },
    objtype_get_method
};

bool isa_objtype(obj o) {
    DV dv = *o;

    if (dv == (DV)&objtype_methods)	return TRUE;
    if (isa_class(o))			return TRUE;
    /* XXX Do other kind of method vectors ever show up in type objects? */

    return FALSE;
}

bool isa_class(obj o) {
    DV dv = *o;

    if (dv == (DV)&class_methods)	return TRUE;
    if (dv == (DV)&class_instn_methods)	return TRUE;
    /* XXX Do other kind of method vectors ever show up in class objects? */

    return FALSE;
}

void init_type(objtype t)
{
    init_obj_hdr_prim(&t->hdr.inh, OBJTYPE_SLOTS,
		      OBJTYPE_BITFIELD, (DV)&objtype_methods);
/*
    printf(" %d %d %d %d\n", sizeof(struct objtype_s), sizeof(struct core_s),
		OBJTYPE_SLOTS, FE_SLOT_SIZE);
*/
    assert(sizeof(struct objtype_s) - sizeof(struct core_s) ==
	   OBJTYPE_SLOTS * FE_SLOT_SIZE);
    t->kind = OBJECT_KIND;
    t->hdr_size = -1;
    t->dht = 0;
    t->surr_DH = 0;
    t->full_surr_DH = 0;
    t->unswizzled_DH = 0;
    t->overview = string_empty();
    t->kind = OBJECT_KIND;
}

DV ObjType_dh[] = { (DV)&objtype_methods };

void init_ObjType()
{
    ObjType->dh = ObjType_dh;
    ObjType->dhsize = 1;
    objtype_methods.super.super.c = ObjType;
}
