/* Copyright Barbara Liskov 1995 */

/* \section{Object types}

    An "objtype" corresponds to either a Theta type introduced by a
    type specification, or a Theta class. That is, it represents a
    type whose operations are ordinary object methods, accessed through
    an index in the dispatch vector that the object points to. The
    additional methods of "objtype" provide corresponding functionality.
*/

#ifndef _OBJTYPE_H
#define _OBJTYPE_H

#include "type_def.h"
#ifdef __cplusplus
extern "C" {
#endif

void objtype_get_method(objtype, fevalue *__retvals, string name);
/* "get_method(name: string) returns(method, type)" \\ \sl
   
   Return the "method" describing the method named "name", and the
   supertype of "t" in which that method was originally declared.
   Signal "not_found" if no such method exists in "t" or any of its
   supertypes.
*/

void getMethod(objtype, fevalue *__retvals, string name);
/*
	Like the above, but does dispatch...
*/

void objtype_get_method_index(objtype t, fevalue *__retvals, int index);
/* "get_method_index(index: int) returns(method, type)" \\ \sl
   
   Return the "method" describing the method whose index is "index", 
   and the supertype of "t" in which that method was originally declared.
   Signal "not_found" if no such method exists in "t" or any of its
   supertypes.
*/

void objtype_all_methods_(type t_, struct closure cl);

#ifdef __cplusplus
}
#endif
 
#endif /* _OBJTYPE_H */
