/* Copyright Barbara Liskov 1995 */

#include "vec.h"
#include "param.h"
#include "param_class.h"
#include "type.h"
#include "type_meth.h"
#include "runtime/obj_class.h"
#include "common/basic.h"
#include "common/th_assert.h"
#include "runtime/alloc.h"
#include "objtype_class.h"
#include "vec_class.h"

class_ Param;

void param_supertypes(type t, struct closure cl)
{
    return;
}

bool param_isSubtype(type t1, type t2)
{
/* ORIGINAL:
    return (t1 == t2);

    XXX it should be put back, I think -- Andrew
*/
param p1, p2;
int p1count, p2count;
method *p1methods, ithm1;
method *p2methods, ithm2;
string ithm1nm, ithm2nm;
int i, j;
bool found;

    if (t1 == t2) return TRUE;
    if (type_kind(t2) != PARAM_KIND) return FALSE;
    p1 = type_as_param(t1);
    p2 = type_as_param(t2);
    if (string_equal(p1->name, p2->name)) {
		/* check if methods match... */
		p1count = p1->methods_ ? vec_length(p1->methods_) : 0;
		p2count = p2->methods_ ? vec_length(p2->methods_) : 0;
		if (p1count < p2count) return FALSE;
    		p1methods = VEC_ITEMS(p1->methods_, method);
    		p2methods = VEC_ITEMS(p2->methods_, method);
		for (i = 0; i < p2count; i++) {
			ithm2 = p2methods[i];
			ithm2nm = p2methods[i]->name;
			found = FALSE;
			for (j = 0; j < p1count; j++) {
				ithm1 = p1methods[j];
				ithm1nm = p1methods[j]->name;
				if (!string_equal(ithm1nm, ithm2nm)) continue;
				found = param_method_conformant(p1,ithm1,
					p2,ithm2);
				if (found) break;
				}
			if (!found) return FALSE;
			}
    		return TRUE;
		}
    return FALSE;
}

void param_methods(type p_, struct closure cl)
{
    vec_elements(((param)p_)->methods_, cl);
}

void param_get_method_(param p, fevalue *__retvals, string name)
{
    int i;
    method *methods;
    int num_methods;
    num_methods = vec_length(p->methods_);
    methods = VEC_ITEMS(p->methods_, method);
    for (i=0; i<num_methods; i++) {
        if (string_equal(methods[i]->name, name)) {
            __retvals[0].o = (obj)methods[i];
            __retvals[1].o = (obj)p;
            return;
        }
    }
    exc = &exc_not_found;
    return;
}

string param_name(type p_)
{
    return ((param)p_)->name;
}

string param_unparse(type p_)
{
    return ((param)p_)->name;
}

int param_kind(type p_)
{
    return PARAM_KIND;
}

ptype param_ptype(param p)
{
    return p->ptype_;
}

bool param_equal(type t, type p2)
{
    return (same_obj((obj)t, (obj)p2))?TRUE:FALSE;
}

struct paramdv_s param_methods_dv = {
    {{0, 0, STD_FOFFSET, 0, 0,
	normal_get_address,
	normal_get_class},
       param_equal,
       param_supertypes,
       param_isSubtype,
       param_methods,
       param_name,
       param_unparse,
       param_kind
     },
	 param_ptype
       };

#include "class_class.h"

static DV Param_dh[] = {(DV)&param_methods_dv};

void init_Param()
{
    Param->dh = Param_dh;
    Param->dhsize = 1;
    param_methods_dv.super.super.c = Param;
}

param new_param()
{
/* param ret = NEW_META(struct param_s); */
param ret;
bool saved = normal_heap;

	ret = NEW_META(struct param_s);
	normal_heap = FALSE;
	init_param(ret);
	ret->methods_ = 0;
	normal_heap = saved;
	return ret;
}

void init_param(param p)
{
    init_obj_hdr_prim(&p->hdr.inh, PARAM_SLOTS, PARAM_BITFIELD,
		      (DV)&param_methods_dv);
}
