/* Copyright Barbara Liskov 1995 */

#ifndef _PCLASS_H
#define _PCLASS_H

#include "types/ptype.h"

#ifdef __cplusplus
extern "C" {
#endif

extern class_ PClass;
/*
  Overview: A "pclass" is a parameterized class. Instances of it
  are of type "class_instn".
*/

/* ptype pclass_as_ptype(pclass); */
/*
  View this "pclass" as a "ptype".
*/

pclass ptype_as_pclass(ptype t);
/*
  If the "t" is really a "pclass", view it as such. Otherwise,
  signal "not_possible".
*/

void pclass_fields(pclass, struct closure);
/* Theta signature: fields() yields(string, Type). The types yielded
   may be instantiations that have parameters of this pclass as arguments.
*/

class_ pclass_superclass(pclass);
/* Return the superclass of this class, if any. The superclass may be
   an "instn" some of whose arguments are parameters to this pclass. */

extern class_instn pclass_instantiate_(pclass pc, vec args);
/*
	Return the instantiation of a parameterized class with
    the given arguements.
*/

extern string typenm2cnm(type t);
/*
	Return an c name corresponding to a type name.
	(Convert '[' to '_OF_', ']' to nothing, and ',' to '_AND_'.)
*/

extern string typeExtNm2IntNm(string tname);
/*
	Return an c name corresponding to a type name.
	(Convert '[' to '_OF_', ']' to nothing, and ',' to '_AND_'.)
*/

extern string typeExtNm2SimpleNm(string tname);
/*
	Return a string corresponding to the input type name
	but without any parameter information.
*/

#if 0
extern ptype pclass_extension_ptype(pclass);
/*
       Return the declared parameterized type that specifies the extension
    operations of this class. This parameterized type ordinarily will not
    be related to the type that the class implements.  Signal "not_possible"
    if this parameterized class does not provide a parameterized extension.

    The parameter types that are parameters of this pclass must all
    be parameters of the ptype that is returned.
*/

extern pclass pclass_extension_pclass(pclass);
/*
       Return the parameterized class that implements the extension
    operations of this class. This parameterized class ordinarily will not
    be subtype- or subclass-related to this class.  Signal "not_possible"
    if this parameterized class does not provide a parameterized extension.
*/

#endif

#ifdef __cplusplus
}
#endif

#ifndef __cplusplus
#define pclass_as_ptype(pc) ((ptype)pc)
#else
static ptype pclass_as_ptype(pclass pc) { return (ptype)pc; }
#endif

void init_PClass();
/* Initialize the class object "PClass" */


#endif /* _PCLASS_H */
