/* Copyright Barbara Liskov 1995 */

#ifndef _PCLASS_CLASS_H
#define _PCLASS_CLASS_H

#include "ptype_class.h"
#include "pclass.h"

typedef struct pclassdv_s {
    struct ptypedv_s super;
    void (*fields)(pclass, struct closure);
    class_ (*superclass)(pclass);
    class_instn (*instantiate)(pclass, vec);
} *pclassdv;

struct pclass_s {
    union {
	struct ptype_s inh;
	pclassdv methods;
    } hdr;
    vec fields;      /* vec[formal] */
    vec superclass;  /* vec[Class] */
    bool visible;
    bool special;
    string specialText;
};
#define PCLASS_SLOTS (4 + PTYPE_SLOTS)
#define PCLASS_BITFIELD ((0xb << PTYPE_SLOTS) | PTYPE_BITFIELD)

void init_pclass(pclass);
/* Initialize a "pclass" object. */

extern vec PARAMS;
#define SET_PARAM(i,val) vec_store(PARAMS, i, PV(val))


#endif /* _PCLASS_CLASS_H */
