/* Copyright Barbara Liskov 1995 */

#include "type.h"
#include "instn.h"
#include "common/iter.h"
#include "class_class.h"
#include "ptype_class.h"
#include "class_instn_class.h"
#include "pclass.h"
#include "param.h"
#include "param_class.h"
#include "vec_class.h"
#include "list.h"
#include "runtime/alloc.h"
#include "textwr.h"
#include "vec_instns.h"
#include "common/th_assert.h"

extern struct exception_s exc_bounds;
extern bool method_conformant(type self_type, method m1, method m2, ptype pt, vec pargs);
extern bool instn_isSubtype_(type t1, type t2);
extern instn pclass_instantiate2(pclass pc, vec args);

class_ PType, Instn;

#define ptype_as_type(pt) ((type)pt)


struct ptypedv_s ptype_methods_s = {
    {
	{
	    {
		0, 0, STD_FOFFSET, 0, 0,
		normal_get_address, normal_get_class
	    },
	    objtype_equal_,
	    objtype_supertypes_,
	    objtype_isSubtype_,
	    objtype_methods_,
	    objtype_name_,
	    objtype_unparse_,
	    objtype_kind_,
	},
        objtype_get_method_
    },
    ptype_instantiate_,
    ptype_parameters_
};

static string instn_unparse_(instn);
static ptype instn_ptype_(instn ins);
static void instn_pargs_(instn ins, struct closure cl);

struct instndv_s instn_methods_s = {
    {
	{
	    {
		0, 0, STD_FOFFSET, 0, 0,
		normal_get_address,  normal_get_class
	    },
	    objtype_equal_,
	    objtype_supertypes_,
	    instn_isSubtype_,
	    objtype_methods_,
	    objtype_name_,
	    (string (*)(type))instn_unparse_,
	    objtype_kind_
	},
        objtype_get_method
    },
    instn_ptype_,
    instn_pargs_
};

type instn_as_type(instn i) {
    return (type)i;
}

instn type_as_instn(type t) {
    objtype ot = type_as_objtype(t);
    if (ot->kind == INSTN_KIND) return (instn)t;
    if (ot->kind == CLASS_INSTN_KIND) {
	return class_instn_as_instn(BUMP(class_instn, t, (DV)t->methods));
    }
    exc = &exc_not_possible;
    return 0;
}

ptype new_ptype()
{
ptype ret = NEW_META(struct ptype_s);
    bool saved = normal_heap;
    normal_heap = FALSE;
    init_ptype(ret);
    normal_heap = saved;
    return ret;
}

void init_ptype(ptype pt)
{
    init_type(&pt->hdr.inh);
    init_obj_hdr_prim(&pt->hdr.inh.hdr.inh, PTYPE_SLOTS, PTYPE_BITFIELD,
		      (DV)&ptype_methods_s);
    pt->hdr.inh.kind = PTYPE_KIND;
/*
    printf("%d %d %d %d\n", sizeof(struct ptype_s), sizeof(struct core_s),
		PTYPE_SLOTS, FE_SLOT_SIZE);
*/
    assert(sizeof(struct ptype_s) == sizeof(struct core_s) +
	   PTYPE_SLOTS * FE_SLOT_SIZE);
}


void ptype_parameters(ptype pt, struct closure cl) {
    pt->hdr.methods->parameters(pt, cl);
}

void ptype_parameters_(ptype pt, struct closure cl) {
    DISCOVER(pt->params, vec);
    vec_elements(pt->params, cl);
}

instn ptype_instantiate(ptype pt, vec args){
     return pt->hdr.methods->instantiate(pt, args);
}

instn ptype_instantiate2(ptype pt, vec args){
     if (type_kind(ptype_as_type(pt)) == PCLASS_KIND) {
	return pclass_instantiate2(ptype_as_pclass(pt), args);
	}
     return pt->hdr.methods->instantiate(pt, args);
}

instn ptype_instantiate_(ptype pt, vec args)
{
objtype objins;

    instn ret = new_instn(pt, args);
    RESIGNAL_ANY_EXC;
    objins = type_as_objtype(instn_as_type(ret));
    ret->valid = validate_instn(objins, ret->ptype_, ret->pargs);
    RESIGNAL_ANY_EXC;
    complete_instn(objins, ret->ptype_, ret->pargs);
    RESIGNAL_ANY_EXC;
    return ret;
}

string ptype_name(ptype pt)
{
    return type_name(ptype_as_type(pt));
}

string ptype_unparse(ptype pt)
{
    return type_unparse(ptype_as_type(pt));
}

void ptype_methods(ptype pt, struct closure cl)
{
    type_methods(ptype_as_type(pt), cl);
}


DV PType_dh[] = {(DV)&ptype_methods_s};

void init_PType()
{
    PType->dh = PType_dh;
    PType->dhsize = 1;
    ptype_methods_s.super.super.super.c = PType;
}

DV Instn_dh[] = {(DV)&instn_methods_s};

void init_Instn()
{
    Instn->dh = Instn_dh;
    Instn->dhsize = 1;
    instn_methods_s.super.super.super.c = Instn;
}

/*
   Return a new instantiation without checking whether the argument
   types match the parameters.
*/

instn new_instn(ptype pt, vec args)
{
    instn ret = NEW_META(struct instn_s);
    bool saved = normal_heap;
    normal_heap = FALSE;
    init_instn(ret, pt, args);
    normal_heap = saved;
    return ret;
}

void init_instn_name(ptype pt, objtype ret, vec pargs)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putString(w, pt->hdr.inh.name);
    wr_putChar(w, '[');
    {
	int i, n = vec_length(pargs);
	param *p = VEC_ITEMS(pargs, param);
	for (i = 0; i < n; i++) {
	    if (i > 0) wr_putChars(w, ", ");
	    wr_putString(w, type_name((type)(p[i])));
	}
    }
    wr_putChar(w, ']');
    wr_close(w);
    ret->name = textwr_toString(tw);
}
    
void init_instn(instn ret, ptype pt, vec args)
{
    int n = vec_length(args);
    FIX(pt, ptype);
    th_assert(pt->params, "Cannot instantiate ptype: params not defined yet");
    if (n != vec_length(pt->params)) {
	exc = &exc_bounds;
	return;
    }
    init_type(&ret->hdr.inh);
    ret->hdr.inh.kind = INSTN_KIND;
    init_obj_hdr_prim(&ret->hdr.inh.hdr.inh, INSTN_SLOTS, INSTN_BITFIELD,
		      (DV)&instn_methods_s);
    assert(sizeof(struct instn_s) == sizeof(struct core_s) +
	   INSTN_SLOTS * FE_SLOT_SIZE);
    {
	int i;
	ret->ptype_ = pt;
	ret->pargs = make_vec_Type(n, FALSE);
	for (i = 0; i < n; i++) {
	    vec_store(ret->pargs, i, vec_fetch(args, i));
	}
	ret->valid = FALSE;
    }
    init_instn_name(pt, &ret->hdr.inh, ret->pargs);
}

static string instn_unparse_(instn ins)
{
    return type_name(instn_as_type(ins));
}

ptype instn_ptype(instn ins)
{
    return ins->hdr.methods->get_ptype(ins);
}

static ptype instn_ptype_(instn ins) {
    return ins->ptype_;
}

void instn_pargs(instn ins, struct closure cl)
{
    ins->hdr.methods->pargs(ins, cl);
}

static void instn_pargs_(instn ins, struct closure cl) {
    void (*f)(void *env, type) = (void (*)(void *, type))cl.f;
    void *env = cl.env;
    vec_elements(ins->pargs, cl);
}

bool instn_isSubtype_(type t1, type t2)
{
vec pargs1, pargs2;
int i, size;
type parg1, parg2;
instn ins1, ins2;
DV dv2;
type t2bumped;

     /* pretty rudimentary so far:
     		really only does equality, rather then subtype */
     /* now also handles Any */
     if (t2 == objtype_as_type(Any)) return TRUE;
     ins1 = type_as_instn(t1);
     if (type_kind(t2) == INSTN_KIND) {
	 dv2 = (DV)t2->methods;
	 t2bumped = BUMP(type, t2, dv2);
	 ins2 = type_as_instn(t2bumped);
	 if (ins1 == ins2) return TRUE;
         if (ins1->ptype_ != ins2->ptype_) return FALSE;
         pargs1 = ins1->pargs;
         pargs2 = ins2->pargs;
         size = vec_length(pargs1);
         if (size != vec_length(pargs2)) return FALSE;
         for (i = 0; i < size ; i++) {
	    parg1 = UNPV(type, vec_fetch(pargs1, i));
	    parg2 = UNPV(type, vec_fetch(pargs2, i));
	    /* 4/11/96 dwc: removed so that this method *does* subtyping,
				not equality... */
	    /* if (!isSubtype(parg1, parg2)) return FALSE; */
	    if (!isSubtype(parg2, parg1)) return FALSE;
         }
         return TRUE;
         }
     else return FALSE;
}


void complete_instn(objtype objins, ptype pt, vec pargs)
{
int i, num_meth, num_st;
vec v;
objtype objpt; 
type self_type;

/*	need to move pt to objtype to look at methods_	*/
	objpt = type_as_objtype(ptype_as_type(pt));

/*	need to move objins to objtype to build good methods	*/
	self_type = objtype_as_type(objins);

/*	make new vec for instantiated methods	*/
	num_meth = vec_length(objpt->methods_);
	v = make_vec_Method(num_meth, FALSE);
	objins->methods_ = v;

/*	loop through methods		*/
	for (i = 0 ; i < num_meth ; i++ ) {
		method m = UNPV(method, vec_fetch(objpt->methods_, i));
		method newm = method_instantiate(m, self_type, pt->params, 
							pargs);
		vec_store(v, i, PV(newm));
		}

/* make new vec for supertypes */
	num_st = vec_length(objpt->supertypes_);
	v = make_vec_Type(num_st, FALSE);
	objins->supertypes_ = v;
	for (i = 0 ; i < num_st ; i++ ) {
		objtype ost = UNPV(objtype, vec_fetch(objpt->supertypes_, i));
		switch (ost->kind) {
		  case PTYPE_KIND: {
			ptype st = type_as_ptype(objtype_as_type(ost));
			/*
			ptype newst = new_ptype();
			objtype onewst = type_as_objtype(ptype_as_type(newst));
			onewst->name = ost->name;
			newst->params = st->params;
			*/
			instn ninstn = ptype_instantiate(st, pargs);
			vec_store(v, i, PV(ninstn));
			break;
		  }
		  case INSTN_KIND: {
			/* view objtype as type and then type as instn */
			type otype = objtype_as_type(ost);
			instn oinstn = type_as_instn(otype);
			/* fetch ptype from it */
			ptype st = oinstn->ptype_;
			instn ninstn = ptype_instantiate(st, pargs);
			vec_store(v, i, PV(ninstn));
			break;
		  }
		  case PCLASS_KIND: {
			ptype st = type_as_ptype(objtype_as_type(ost));
			/* instn ninstn = ptype_instantiate(st, pargs); */
			/* vec_store(v, i, PV(ninstn)); */
			/* unclear whether to go through ptype or pclass... */
			pclass pc = ptype_as_pclass(st);
			class_instn ci = pclass_instantiate_(pc, pargs);
			vec_store(v, i, PV(ci));
			break;
		  }
		  default: {
			/* probably simplistic: mostly appropriate for OBJECT_KIND */
			vec_store(v, i, PV(ost));
			break;
		  }
		}
	}
}

method method_instantiate(method m, type self_type, vec params, vec pargs)
{
int j, k, num_arg, num_ret, num_sig, num_meth, num_vals;
type r, t;
vec va, vr, vs, newv;

	method newm = new_method();
	newm->index = m->index;
	newm->name = m->name;
	newm->iter = m->iter;
	newm->spec = m->spec;
	newm->self_type = self_type;
	newm->def_type = self_type;	/* probably not correct */
	newm->parameterized = TRUE;
/* do args	*/
	num_arg = vec_length(m->arguments);
	va = make_vec_Formal(num_arg, FALSE);
	newm->arguments = va;
	for (j = 0; j < num_arg ; j++) {
		formal a = UNPV(formal, vec_fetch(m->arguments, j));
		formal newa = new_formal();
		newa->name = a->name;
		newa->t = instantiate(a->t, self_type, params, pargs);
		vec_store(va, j, PV(newa));
	}
	newm->extra_args = make_vec_simple(Type,0);
/* do rets	*/
	num_ret = vec_length(m->returns);
	vr = make_vec_Type(num_ret, FALSE);
	newm->returns = vr;
	for (j = 0; j < num_ret ; j++) {
		r = UNPV(type, vec_fetch(m->returns, j));
		t = instantiate(r, self_type, params, pargs);
		vec_store(vr, j, PV(t));
	}
/* do sigs 	*/
	num_sig = vec_length(m->signals);
	vs = make_vec_Type(num_sig, FALSE);
	newm->signals = vs;
	for (j = 0; j < num_sig ; j++) {
		signal_ s = UNPV(signal_, vec_fetch(m->signals, j));
		signal_ news = new_signal();
		vec_store(vs, j, PV(news));
		news->name = s->name;
		num_vals = vec_length(s->returns);
		newv = make_vec_Type(num_vals, FALSE);
		news->returns = newv;
		for (k = 0; k < num_vals ; k++) {
			r = UNPV(type, vec_fetch(s->returns, k));
			t = instantiate(r, self_type, params, pargs);
			vec_store(newv, k, PV(t));
			
		}
	}
	return newm;
}

bool validate_instn(objtype objins, ptype pt, vec pargs)
{
int size, mcount, ncount, i, j, k, found;
type self_type = objtype_as_type(objins);

/* find formals */
    vec params = pt->params;

/*  do basic size checks */
    if (params == 0) {
		if (pargs == 0) return TRUE;
    		else {exc = &exc_not_possible; return FALSE;}
		}
    size = vec_length(params);
    if (!pargs || size != vec_length(pargs)) {
    		exc = &exc_not_possible; return FALSE;
		}
    
/*  loop through pargs and params */
    for (i = 0; i < size; i++) {
	param pm = UNPV(param, vec_fetch(params, i));
	type pargt = UNPV(type, vec_fetch(pargs, i));
	vec parg_methods;
	if (type_kind(pargt) == PARAM_KIND) {
		param pargparm = type_as_param(pargt);
		parg_methods = pargparm->methods_;
		}
	else {
		objtype parg = type_as_objtype(pargt);
		parg_methods = parg->methods_;
		}
	/* loop through param methods
		checking that parg has method with the
		same signature */
	if (!pm->methods_) continue;
	mcount = vec_length(pm->methods_);
	if (mcount == 0) continue;
	for (j = 0; j < mcount ; j++) {
		method m1 = UNPV(method, vec_fetch(pm->methods_, j));
		string m1_name = m1->name;
		found = 0;
		if (!parg_methods) {exc = &exc_not_possible; return FALSE;}
		ncount = vec_length(parg_methods);
		for (k = 0; k < ncount; k++) {
			method m2 =  UNPV(method, vec_fetch(parg_methods, k));
			string m2_name = m2->name;
			if (string_equal(m1_name, m2_name)){
				found = 1;
				if (!method_conformant(
					self_type, m2, m1, pt, pargs)) {
					exc = &exc_not_possible; return FALSE;
					}
				}
			}
		if (!found) {exc = &exc_not_possible; return FALSE;}
		}
	}
    return TRUE;
}

struct insert_env {
	vec pargs;
	int i;
	vec formals;
	vec actuals;
	type self_type;
};

void insert_type(struct insert_env *env, pval t)
{
	type nt = instantiate((type)t, env->self_type, env->formals,
					env->actuals);
	env->pargs->items[env->i] = PV(nt);
	env->i++;
	}

type instantiate(type f, type self_type, vec fparms, vec aparms)
{
/*
 match f to fparms if found return corr aparm
  matching:
	either force Param to type and do equality ==
	or (still force Param) and do isSubtype both ways
 else return f
*/

int i, j;

	switch (type_kind(f)) {
		case PRIMITIVE_KIND: {
			return f;
			break;
			}

		case CLASS_KIND: {
			return f;
			break;
			}

		case PARAM_KIND: {
			for (i = 0 ; i < vec_length(fparms) ; i++) {
				param fp = UNPV(param, vec_fetch(fparms, i));
				type ft = param_as_type(fp);
				if (ft == f ||
					string_equal(type_name(f), 
						type_name(ft))) {
					type at = UNPV(type, 
						vec_fetch(aparms, i));
					return at;
					}
				}
			/* shouldn't get here... */
			return f;	
			break;
			}
		case CLASS_INSTN_KIND: {
			class_instn ci = type_as_class_instn(f);
			class_instn self_ci = 0;
			instn ins = class_instn_as_instn(ci);
			instn self_ins = 0;
			instn ni;
			ptype pt = ins->hdr.methods->get_ptype(ins);
			ptype self_pt = 0;
			int size = vec_length(ci->pargs);
			vec pargs;
			vec self_pargs = 0;
			struct insert_env env;
			struct closure cl;
			if (self_type) self_ci = type_as_class_instn(self_type);
			if (self_ci && class_instn_isSubtype_(ci, self_ci)
				&& class_instn_isSubtype_(self_ci, ci))
				return instn_as_type(ins);
			if (self_ci) {
				self_ins = class_instn_as_instn(self_ci);
				self_pargs = self_ci->pargs;
				}
			if (self_ins) self_pt = self_ins->
					hdr.methods->get_ptype(ins);
			pargs = make_vec_Type(size, FALSE);
			env.i = 0;
			env.pargs = pargs;
			env.formals = fparms;
			env.actuals = aparms;
			env.self_type = self_type;
			cl.env = &env;
			cl.f = (ifunc)insert_type;
			ins->hdr.methods->pargs(ins, cl);
			/* now check proposed instantiation against
				self_type
			   return self_type if match
			*/
			if (self_pt && isSubtype(ptype_as_type(pt), 
						ptype_as_type(self_pt))
				    && isSubtype(ptype_as_type(self_pt), 
						ptype_as_type(pt))) {
				bool match = TRUE;
				if (self_pargs && 
					vec_length(self_pargs) == size) {
					for (i = 0 ; i < size ; i++) {
						type sith = UNPV(type,
							vec_fetch(self_pargs,
								i));
						type ith = UNPV(type,
							vec_fetch(pargs,
								i));
						bool a = isSubtype(sith,ith);
						bool b = isSubtype(ith, sith);
						if (!(a&b)) match = FALSE;
						}
					if (match) return instn_as_type(self_ins);
					}
				}
			ni = pt->hdr.methods->instantiate(pt, pargs);
			return instn_as_type(ni);
			break;
			}
		default: {
			/*  shouldn't get here... */
			return f;	
			break;
			}
		}
}


bool method_conformant(type self_type, method m1, method m2, ptype pt, vec pargs)
{
int num_arg1, num_arg2, i, j, k;
int num_ret1, num_ret2, num_sig1, num_sig2;
type r1, r2;

/*	do args		*/
		num_arg1 = vec_length(m1->arguments);
		num_arg2 = vec_length(m2->arguments);
		if (num_arg1!= num_arg2) return FALSE;
		for (j = 0; j < num_arg1 ; j++) {
			formal a1 = UNPV(formal, vec_fetch(m1->arguments, j));
			formal a2 = UNPV(formal, vec_fetch(m2->arguments, j));
			type at1 = a1->t;
			type at2 = instantiate(a2->t, self_type, pt->params, pargs);
			if (!isSubtype(at2, at1)) return FALSE;
		}
/*	do rets		*/
		num_ret1 = vec_length(m1->returns);
		num_ret2 = vec_length(m2->returns);
		if (num_ret1 != num_ret2) return FALSE;
		for (j = 0; j < num_ret1 ; j++) {
			r1 = UNPV(type, vec_fetch(m1->returns, j));
			r2 = UNPV(type, vec_fetch(m2->returns, j));
			r2 = instantiate(r2, self_type, pt->params, pargs);
			if (!isSubtype(r1, r2)) return FALSE;
		}
/*	do sigs 	*/
		num_sig1 = vec_length(m1->signals);
		num_sig2 = vec_length(m2->signals);
		if (num_sig1 > num_sig2) return FALSE;
		for (j = 0; j < num_sig1 ; j++) {
			signal_ s1 = UNPV(signal_, vec_fetch(m1->signals, j));
			string s1_name = s1->name;
			int num_vals1 = s1->returns ? vec_length(s1->returns):0;
			int found = 0;
			for (i = 0; i < num_sig2; i++) {
			  signal_ s2 = UNPV(signal_, vec_fetch(m2->signals, i));
			  string s2_name = s2->name;
			  if (string_equal(s1_name, s2_name)) {
				int num_vals2 = s2->returns ?
						vec_length(s2->returns):0;
				found = 1;
				if (num_vals1 != num_vals2) return FALSE;
				for (k = 0; k < num_vals1 ; k++) {
				   r1 = UNPV(type, vec_fetch(s1->returns, k));
				   r2 = UNPV(type, vec_fetch(s2->returns, k));
				   r2 = instantiate(r2, self_type, pt->params, pargs);
				   if (!isSubtype(r1,r2)) return FALSE;
				   }
				}
			}
			if (!found) return FALSE;
		}
	return TRUE;
	}
				
bool param_method_conformant(type t1, method m1, type t2, method m2)
{
int num_arg1, num_arg2, i, j, k;
int num_ret1, num_ret2, num_sig1, num_sig2;
type r1, r2;

/*	do args		*/
		num_arg1 = vec_length(m1->arguments);
		num_arg2 = vec_length(m2->arguments);
		if (num_arg1!= num_arg2) return FALSE;
		for (j = 0; j < num_arg1 ; j++) {
			formal a1 = UNPV(formal, vec_fetch(m1->arguments, j));
			formal a2 = UNPV(formal, vec_fetch(m2->arguments, j));
			type at1 = a1->t;
			type at2 = a2->t;
			if (at1 == t1 && at2 == t2) continue;
			if (!isSubtype(at2, at1)) return FALSE;
		}
/*	do rets		*/
		num_ret1 = vec_length(m1->returns);
		num_ret2 = vec_length(m2->returns);
		if (num_ret1 != num_ret2) return FALSE;
		for (j = 0; j < num_ret1 ; j++) {
			r1 = UNPV(type, vec_fetch(m1->returns, j));
			r2 = UNPV(type, vec_fetch(m2->returns, j));
			if (r1 == t1 && r2 == t2) continue;
			if (!isSubtype(r1, r2)) return FALSE;
		}
/*	do sigs 	*/
		num_sig1 = vec_length(m1->signals);
		num_sig2 = vec_length(m2->signals);
		if (num_sig1 > num_sig2) return FALSE;
		for (j = 0; j < num_sig1 ; j++) {
			signal_ s1 = UNPV(signal_, vec_fetch(m1->signals, j));
			string s1_name = s1->name;
			int num_vals1 = s1->returns ? vec_length(s1->returns):0;
			int found = 0;
			for (i = 0; i < num_sig2; i++) {
			  signal_ s2 = UNPV(signal_, vec_fetch(m2->signals, i));
			  string s2_name = s2->name;
			  if (string_equal(s1_name, s2_name)) {
				int num_vals2 = s2->returns ?
						vec_length(s2->returns):0;
				found = 1;
				if (num_vals1 != num_vals2) return FALSE;
				for (k = 0; k < num_vals1 ; k++) {
				   r1 = UNPV(type, vec_fetch(s1->returns, k));
				   r2 = UNPV(type, vec_fetch(s2->returns, k));
				   if (r1 == t1 && r2 == t2) continue;
				   if (!isSubtype(r1,r2)) return FALSE;
				   }
				}
			}
			if (!found) return FALSE;
		}
	return TRUE;
	}
				
