/* Copyright Barbara Liskov 1995 */

#ifndef _PTYPE_H
#define _PTYPE_H

#include "common/iter.h"
#include "types/type_def.h"
#include "types/vec_def.h"
#include "types/ptype_def.h"

#ifdef __cplusplus
extern "C" {
#endif

extern class_ PType;
extern void init_PType();

/*
   Overview: A "ptype" represents a parameterized type generator.
*/

#if 0
type primary_type(paramBinding);
/* Return the primary type mentioned in a parameter binding. */

void renamings(paramBinding, struct closure cl);
/* Yield the list of renamings specified in a parameter binding. */
#endif

instn ptype_instantiate(ptype pt, vec args);
/*
    Theta signature: "instantiate(args: vec[Type]) returns(Instn)"

    Effect: Return a type that is the result of instantiating
    "pt" on the types specified in "args[0 .. nargs - 1]". If
    the types in "args" do not conform to the parameters of
    "pt", signal "not_possible(type, string)" with a type that
    is the parameter that was not satisfied and the string
    containing the name of the method that was not satisfied.

    If the number of arguments does not match the size of the
    formal parameter list, the exception "bounds" is raised.
*/

instn ptype_instantiate2(ptype pt, vec args);
/*
    Like above, but more correct implementation (uses parameter
    ==, rather than parameter subtyping in looking up matches in
    list of existing instantiations.
*/

void ptype_parameters(ptype, struct closure);
/*
    Signature: "parameters() yields(param)"
    
    Yield the parameters of this parameterized type.
    The names of these types will be the same as the names of
    the corresponding formal parameters.
*/

string ptype_name(ptype);
/*
    Return the name of the parameterized type.
*/

void ptype_supertypes(ptype, struct closure);
/* Theta signature: supertypes() yields(Type)
    
    Effect: Yield the supertypes of this parameterized type. The supertypes
    may be instantiations that use types returned by "ptype_parameters"
    as arguments.
*/

string ptype_unparse(ptype);
/*
    Return a textual representation of this "ptype".
*/

void ptype_methods(ptype, struct closure);
/*  Theta signature: methods() yields(method)

    Effect: Yield the methods. If this parameterized type is mentioned
	    in the methods, it will always be in the form of an
	    instantiation where the arguments used for instantiation
	    are the conformant types yielded by "parameters".
*/

void ptype_wheres(ptype, struct closure);
/* Theta signature: wheres() yields(method)

   Effect: yield descriptions of the where clauses.

*/

#define ptype_as_type(pt) ((type)pt)

#define type_as_ptype(t) ((ptype)t)
/* raises (in principle) exception "not_possible" */

extern void init_instn_name(ptype pt, objtype t, vec pargs);
/*
   Set the name of "t" as if it were an instantiation of
   the ptype "pt", with parameters "pargs".
*/


#ifdef __cplusplus
}
#endif


#endif /* _PTYPE_H */
