/* Copyright Barbara Liskov 1995 */

#include "stdlist.h"
#include "list_meth.h"
#include "stdlib.h"
#include "runtime/obj.h"
#include "runtime/obj_class.h"
#include "common/iter.h"
#include "type.h"
#include "runtime/alloc.h"
#include "class_class.h"
#include "runtime/except.h"
#include "cache/gc_register.h"
#include "config/vdefs/EDGE_MARKING.h"

class_ EmptyList, FullList;

typedef struct empty_s *empty;
typedef struct full_s *full;

extern struct exception_s exc_bounds;

struct empty_s {
    union {
	struct core_s inh;
	struct listdv_s *methods;
    } hdr;
};

struct full_s {
    union {
	struct core_s inh;
	struct listdv_s *methods;
    } hdr;
    any head;
    list tail;
};

static any full_first(list l)
{
    full f;
    any tmp;
    f = (full)l;
    FIXUPREAD(&f->hdr.inh);
    return DISCOVER_FAST(f->head, any, tmp);
}

static list full_rest(list l)
{
    full f;
    list tmp;
    f = (full)l;
    FIXUPREAD(&f->hdr.inh);
    return DISCOVER_FAST(f->tail, list, tmp);
}

static void full_set_first(list l, any a)
{
    full f;
    f  = (full)l;
    f->head = a;
    FIXUPWRITE(&f->hdr.inh);
}

static void full_set_rest(list x, list y)
{
    full f;
    f  = (full)x;
    f->tail = y;
    FIXUPWRITE(&f->hdr.inh);
}

static any empty_first(list l)
{
    exc = &exc_empty;
}

static list empty_rest(list l)
{
    exc = &exc_empty;
}

static void empty_set_first(list l, any a)
{
    exc = &exc_empty;
}

static void empty_set_rest(list x, list y)
{
    exc = &exc_empty;
}

class_ empty_list_get_class(obj l)
{
    return EmptyList;
}
class_ full_list_get_class(obj l)
{
    return FullList;
}

struct listdv_s full_methods = {
    {0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class},
    full_first,
    full_rest,
    full_set_first,
    full_set_rest
  };

struct listdv_s empty_methods = {
    {0, 0, STD_FOFFSET, 0, 0, normal_get_address, normal_get_class},
    empty_first,
    empty_rest,
    empty_set_first,
    empty_set_rest
  };

DV full_DH[] = {
    (DV)&full_methods
  };

DV empty_DH[] = {
    (DV)&empty_methods
  };

void initLists()
{
    FullList->dh = full_DH;
    FullList->dhsize = 1;
    EmptyList->dh = empty_DH;
    EmptyList->dhsize = 1;
    full_methods.super.c = FullList;
    empty_methods.super.c = EmptyList;
}

list cons(any head, list tail)
{
    full ret = NEW(struct full_s);
    init_obj_hdr_prim(&ret->hdr.inh, 2, 0x3, (DV)&full_methods);
    ret->head = head;
    ret->tail = tail;
    return (list)ret;
}

struct empty_s *the_empty_list;

void initEmptyList()
{
    the_empty_list = NEW(struct empty_s);
    init_obj_hdr_prim(&the_empty_list->hdr.inh, 0, 0x0, (DV)&empty_methods);
    gc_register_root((obj *)&the_empty_list);
}

list empty_list()
{
    assert(the_empty_list);
    return (list)the_empty_list;
}

list stdlist_reverse(list l)
{
    list ret = empty_list();
    loop {
	any a = first(l); /* Will automatically result in setting the
			     read bit in stamp*/
	CATCH {
	    exc = EXC_NONE;
	    return ret;
	}
	ret = cons(a, ret);
	l = rest(l);
    }
}

void stdlist_elements(list l, struct closure cl)
{
    any a;
    void (*f)(void *env, any) = (void (*)(void *, any))cl.f;
    loop {
	a = first(l);  /* Will automatically result in setting the 
			  read bit in stamp */
	CATCH {
	    exc = EXC_NONE;
	    return;
	}
	(*f)(cl.env, a);
	CHECK_BREAK_EXC;
	l = rest(l);
    }
}

int stdlist_length(list l)
{
    int count = 0;
    loop {
	l = rest(l);  /* Will automatically result in setting the
			 read bit in stamp */
	CATCH {
	    exc = EXC_NONE;
	    return count;
	}
	count++;
    }
}

any stdlist_nth(list l, int i)
{
    int count;
    if (i < 0) {
	exc = &exc_bounds;
    } else {
	any ret;
        for (count = 0; count < i; count++) {
            l = rest(l); /* Will automatically result in setting the
			    read bit in stamp */
	    CATCH {
		exc = &exc_bounds;
		return 0;
	    }
        }
	ret = first(l);
	CATCH { exc = &exc_bounds; return 0; }
	return ret;
    }
}
