/* Copyright Barbara Liskov 1995 */

#ifndef _STRING_CLASS_H
#define _STRING_CLASS_H

#include "types/str.h"
#include "runtime/obj_class.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct stringdv_s {
    struct dv_s super;
    int (*length)(string);
    string (*concat)(string, string);
    bool (*equal)(string, string);
    void (*chars)(string, struct closure);
    char (*fetch)(string, int);
    string (*unparse)(string);
    bool (*empty)(string);
    string (*first) (string, int);
    string (*rest) (string, int);
    string (*append) (string, char);
    string (*extract) (string, int, int);
    bool (*lt) (string, string);
    bool (*gt) (string, string);
    bool (*le) (string, string);
    bool (*ge) (string, string);
    bool (*similar) (string, string);
    string (*copy) (string);
} *stringdv;

extern struct stringdv_s string_methods;

struct string_s {
    union {
        struct core_s inh;
	stringdv methods;
    } hdr;
    int size;
    char chars[1];
};

/* Invariant: "chars" is a character array that is actually "size + 1" in
   length. If "size == 0", then "chars == empty".

   Even though we know the implementation of all string methods, a
   dispatch header is still needed because a string could be a surrogate.
   If this possibility is removed, strings can become 8 bytes smaller.
*/

#ifdef __cplusplus
}
#endif

#endif /* _STRING_CLASS_H */
