/* Copyright Barbara Liskov 1995 */

#include "char.h"
#include "str.h"
#include "string_class.h"
#include "textwr.h"
#include <ctype.h>
#include <stdio.h>

string int_unparse(int i)
{
    char buf[100];
    sprintf(buf, "%d", i);
    return string_new(buf);
}

static void unparse_char_prim(wr w, char c);
			 
string char_unparse_fancy(char c)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChar(w, '\'');
    unparse_char_prim(w, c);
    wr_putChar(w, '\'');
    wr_close(w);
    return textwr_toString(tw);
}

string string_unparse_fancy(string s)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    int i;
    char const *ch = string_charp(s);
    wr_putChar(w, '\"');
    for (i = 0; i<string_length(s); i++)
      unparse_char_prim(w, ch[i]);
    wr_putChar(w, '\"');
    wr_close(w);
    return textwr_toString(tw);
}
string char_unparse(char c)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
/*     wr_putChar(w, '\''); */
    unparse_char_prim(w, c);
/*  wr_putChar(w, '\''); */
    wr_close(w);
    return textwr_toString(tw);
}

string string_unparse(string s)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    int i;
    char const *ch = string_charp(s);
/*    wr_putChar(w, '\"'); */
    for (i = 0; i<string_length(s); i++)
      unparse_char_prim(w, ch[i]);
/*    wr_putChar(w, '\"'); */
    wr_close(w);
    return textwr_toString(tw);
}

void wr_putChars(wr w, char const *c)
{
    while (*c) {
	wr_putChar(w, *c++);
    }
}

static void unparse_char_prim(wr w, char c)
{
    switch (c) {
      case '\a': wr_putChars(w, "\\a"); break;
      case '\b': wr_putChars(w, "\\b"); break;
      case '\f': wr_putChars(w, "\\f"); break;
      case '\n': wr_putChars(w, "\\n"); break;
      case '\r': wr_putChars(w, "\\r"); break;
      case '\t': wr_putChars(w, "\\t"); break;
      case '\v': wr_putChars(w, "\\v"); break;
      case '\'': wr_putChars(w, "\\\'"); break;
      case '\"': wr_putChars(w, "\\\""); break;
      case '\\': wr_putChars(w, "\\\\"); break;
      default:
	if (isascii(c) && isprint(c)) {
	    wr_putChar(w, c);
	} else {
	    int x = c & 0377;
	    wr_putChar(w, '\\');
	    wr_putChar(w, ((x>>6)&7) + '0');
	    wr_putChar(w, ((x>>3)&7) + '0');
	    wr_putChar(w, (x&7) + '0');
	}
	break;
    }
}
