/* Copyright Barbara Liskov 1995 */

#include "vec_class.h"
#include "runtime/alloc.h"
#include "type.h"
#include "runtime/except.h"
#include "runtime/obj_class.h"
#include "class.h"
#include "class_class.h"
#include "objtype_class.h"
#include "class_instn.h"
#include "class_instn_class.h"
#include "vec_instns.h"
#include "pclass.h"
#include "config/vdefs/EDGE_MARKING.h"
#include "cache/gc_register.h"

pclass Vec;
pclass VecE_class;

extern struct exception_s exc_bounds;

struct vec_dv_s vec_prim_methods = {
  { 0, 0, STD_FOFFSET, 0, 
	0, /* To be overridden by instances */
	normal_get_address,
	normal_get_class,
      },
    vec_fetch_,
    vec_store_,
    vec_length_,
    vec_elements_
  };

struct vecE_dv_s {
    struct dv_s super;
    vec (*empty)(vecE);
    vec (*fill)(vecE, int, pval);
    vec (*from_iter)(vecE, struct closure);
    type param_t;
    class_ vec_class;
};
/* Dispatch vector for a "vecE" */

struct vecE_s {
    union {
	struct vecE_dv_s *methods;
	struct core_s inh;
    } hdr;
};

vec vecE_empty(vecE ext) {
    vecE_fill(ext, 0, 0);
}
    
vec vecE_fill(vecE ext, int length, pval item)
{
    struct vecE_dv_s *vem = ext->hdr.methods;
    int i;
    vec ret = make_vec_prim(PRIMITIVE_KIND == type_kind(vem->param_t),
			    length);
    inst_obj_hdr((obj)ret, vem->vec_class);
    for(i = 0; i < length; i++) {
	ret->items[i] = item;
    }
}

vec vec_new(obj dummy, class_instn vci, int size)
{
bool prim = FALSE;
vec ret = NEWVEC(size);
struct vec_dv_s *vm;
type t;

    /* do instantiation work 
    vec_store(pargs, 0, PV(vpb->t));
    vci = pclass_instantiate_(Vec, pargs);
    vm = NEW(struct vec_dv_s);
    bcopy((char*)&vec_prim_methods, (char*)vm, sizeof(struct vec_dv_s));
    vm->super.c = class_instn_as_class(vci);
    */

    /* initialize header */
    t = UNPV(type, vec_fetch(vci->pargs, 0));
    if (type_kind(t) == PRIMITIVE_KIND) prim = TRUE;
    init_obj_hdr_prim(&ret->hdr.inh, size,
                prim ? OBJ_BF_ALLDATA : OBJ_BF_ALLREFS,
                (DV)(*(class_instn_as_class(vci)->dh)));

    return ret;
}

vec make_vec_prim(bool primitive, int length)
{
    int i;
    vec ret;
    if (normal_heap)
      ret = NEWVEC(length);
    else
      ret = NEW_META_VEC(length);
    init_obj_hdr_prim(&ret->hdr.inh,
		      length,
		      primitive ? OBJ_BF_ALLDATA :
			          OBJ_BF_ALLREFS,
		      (DV)&vec_prim_methods);
    return ret;
}

pval vec_fetch(vec v, int i) {
    vecdv __dv;
    DISCOVER(v, vec)
    __dv = v->hdr.methods;
    return (*__dv->fetch)(v, i);
}

pval vec_fetch_(vec v, int i) {
    FIXUPREAD(&v->hdr.inh);
    if (i < v->hdr.inh.size && i >= 0) {
        DISCOVER(v->items[i], pval)
        return v->items[i];
    }
    else exc = &exc_bounds;
}

void vec_store(vec v, int i, pval fv) {
    vecdv __dv;
    DISCOVER(v, vec)
    __dv = v->hdr.methods;
    (*__dv->store)(v, i, fv);
}

void vec_store_(vec v, int i, pval fv) {
    FIXUPWRITE(&v->hdr.inh);
    if (i < v->hdr.inh.size && i >= 0) v->items[i] = fv;
    else exc = &exc_bounds;
}

int vec_length(vec v)
{
    vecdv __dv;
    DISCOVER(v, vec)
    __dv = v->hdr.methods;
    return (*__dv->length)(v);
}

int vec_length_(vec v)
{
    FIXUPREAD(&v->hdr.inh);
    return v->hdr.inh.size;
}

pval *vec_items(vec v)
{
    FIXUPREAD(&v->hdr.inh);
    FIX(v, vec);
    return v->items;
}

void vec_elements(vec v, struct closure cl)
{
    v->hdr.methods->elements(v,cl);
}

void vec_elements_(vec v, struct closure cl)
{

    void (*f)(void *, pval) = (void (*)(void *, pval))cl.f;
    void *env = cl.env;

    FIXUPREAD(&v->hdr.inh);

    {
	int i, n = v->hdr.inh.size;
	pval *items = v->items;
	for (i = 0; i < n; i++) {
	    (*f)(env, *items++);
	    CHECK_BREAK_EXC;
	}
    }
}

static vec vec_superc = 0;
extern vec no_slottypes;

DV *vec_dhs(class_instn vci, vec pargs)
{
class_ c = class_instn_as_class(vci);
vec vec_ivars;
formal f;
type t = UNPV(type, vec_fetch(pargs, 0));
bool prim;
vec bf;
bool saved;

	DV *dh = (DV *)malloc(1*sizeof(DV));
        struct vec_dv_s *vm = (struct vec_dv_s *)malloc(
			sizeof(struct vec_dv_s));
        bcopy((char*)&vec_prim_methods, (char*)vm, sizeof(struct vec_dv_s));
        vm->super.c = class_instn_as_class(vci);
	gc_register_meta_root((obj*)&vm->super.c);
	vm->t = t;
	gc_register_meta_root((obj*)&vm->t);
        c->special = TRUE;
        c->specialText = string_empty();
        if (!vec_superc) {
                vec_superc = make_vec_Type(0, FALSE);
		gc_register_meta_root((obj*)&vec_superc);
                }
        c->superclass = vec_superc;
	vec_ivars = make_vec_Formal(1, FALSE);
	c->fields = vec_ivars;
	f = new_formal();
	f->name = string_new("elems");
	f->t = t;
	vec_store(vec_ivars, 0, PV(f));
    	if (type_kind(t) == PRIMITIVE_KIND) prim = TRUE;
	saved = normal_heap;
	normal_heap = FALSE;
	bf = make_vec_Int(1, FALSE);
	normal_heap = saved;
	if (prim) vec_store(bf, 0, PV(OBJ_BF_ALLDATA));
	else vec_store(bf, 0, PV(OBJ_BF_ALLREFS));
	c->bitfields = bf;

        if (!no_slottypes) {
            no_slottypes = make_vec_ObjType(0, FALSE);
            gc_register_root((obj*)&no_slottypes);
        }
        c->slottypes = no_slottypes;
	*dh = (DV)vm;
        return dh;
	}









