/* Copyright Barbara Liskov 1995 */

#ifndef _VEC_CLASS_H
#define _VEC_CLASS_H

#include "types/vec.h"
#include "runtime/obj_class.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct vec_dv_s {
    struct dv_s super;
    pval (*fetch)(vec, int);
    void (*store)(vec, int, obj);
    int (*length)(vec);
    void (*elements)(vec, struct closure cl);
    type t;
    vecE ext;
} *vecdv;
/* Dispatch vector for a "vec" */


struct vec_s {
    union {
	struct core_s inh;
	struct vec_dv_s *methods;
    } hdr;
    pval items[1]; /* Actual length specified at initialization */
};

pval *vec_items(vec v);
/* 
   Return a pointer to the actual storage of the "vec", so that
   C code can manipulate the elements conveniently. Needless to say,
   this is a dangerous procedure. It does perform a surrogate check.
*/

#define VEC_ITEMS(v, t) ((t *)vec_items(v))

vec make_vec_copy(type t, int length, void *address);
/*
   Make a vec and copy the region of memory starting at "address" and
   extending for "length" elements into it. A dangerous, yet fast,
   procedure.
*/

vec make_vec_prim(bool primitive, int length);
/*
   Make a vec of some unspecified type T, with length "length".
   The argument "primitive" indicates whether the type is a
   primitive, non-pointer type. This operation is reserved for
   the FE bootstrap process.

   XXX The object created by this process will cause a core dump if
   XXX its class is asked for.  A mechanism for patching these objects
   XXX needs to be designed.
*/


extern pval vec_fetch_(vec v, int i);
extern void vec_store_(vec v, int i, pval e);
extern int vec_length_(vec v);
extern void vec_elements_(vec v, struct closure);
/* 
   Non-surrogate-checking versions of the methods, for use by subclasses only
*/

#ifdef __cplusplus
}
#endif

#endif /* _VEC_CLASS_H */
