/* Copyright Barbara Liskov 1995 */

#ifndef _WR_H
#define _WR_H

#include "runtime/obj.h"

/* Overview: A "wr" is just like a Modula-3 "Wr.T" */

typedef struct wr_s *wr;

#ifdef __cplusplus
extern "C" {
#endif
    
void wr_putChar(wr w, char c);
void wr_putString(wr w, string s);
void wr_seek(wr w, int posn);
int wr_length(wr w);
int wr_index(wr w);
void wr_flush(wr w);
void wr_close(wr w);


extern void wr_putChars(wr w, char const *c);
/* For internal clients only. Puts characters until a 0 is encountered. */

#ifdef __cplusplus
}
#endif

#endif /* _WR_H */
