
#define TRUE 1
#define FALSE 0

#include <stdio.h>
#include <malloc.h>

#define BSIZ 1000
char buf[BSIZ];

extern int line_member(char *line);
extern void line_save(char *line);

/* Program to remove redundant lines while preserving order. */

main(int argc, char **argv)
{
FILE *fin;
char *ptr;
int exists;

/* make sure argument is ok */
if (argc != 2) {
	printf("Usage: \"uniq-ordered filename\"\n");
	exit(-1);
	}

/* open file for reading */
	fin = fopen(argv[1], "r");
	if (fin == NULL) {
		perror("uniq-ordered: ");
		exit(-1);
		}

	while (1) {
		/* get a line */
		ptr = fgets(buf, BSIZ, fin);
		if (ptr == NULL) {
			fclose(fin);
			exit(0);
			}

		/* check lines against existing lines */
		exists = line_member(buf);

		/* if already there, do nothing */
		if (exists) continue;

		/* else output it and save it */
		line_save(buf);
		printf("%s", buf);
		}
	}

#define MAX_LINES 20000

char *lines[MAX_LINES];
int  line_count = 0;

void line_save(char *line)
{
char *line_copy;
int len;

	len = strlen(line) + 1;
	line_copy = (char *)malloc(strlen(line) + 1);
	bcopy(line, line_copy, len);
	lines[line_count] = line_copy;
	line_count++;
	if (line_count >= MAX_LINES) {
		fprintf(stderr, "uniq-ordered: too many lines\n");
		exit(-1);
		}
	}

int line_member(char *line)
{
int i;
	for (i = 0; i < line_count; i++) {
		if (!strcmp(line, lines[i])) return TRUE;
		}
	return FALSE;
	}
