/* Copyright Barbara Liskov, MIT, 1996 */
#ifndef _CREATE_OO7_H
#define _CREATE_OO7_H

// Returns a new OO7 Thor db with the specified params.

class create_OO7 {
  public:

    // oo7 parameters.
    int NumAtomicPerComp;
    int NumConnPerAtomic;
    int DocumentSize;
    int ManualSize;
    int NumCompPerModule;
    int NumAssmPerAssm;
    int NumAssmLevels;
    int NumCompPerAssm;
    int NumModules;

    create_OO7 () {
	set_small();
	trace_flag = 0;
    }

    void set_small () {
        // Sets the parameters for small oo7.
	NumAtomicPerComp = 20;
	NumConnPerAtomic = 3;
	DocumentSize = 2000;
	ManualSize = 100*1000;
	NumCompPerModule = 500;
	NumAssmPerAssm = 3;
	NumAssmLevels = 7;
	NumCompPerAssm  = 3;
	NumModules = 1;
    }

    void set_medium () {
	// Sets the parameters for medium oo7.
	set_small();
	NumAtomicPerComp = 200;
	DocumentSize = 20*1000;
	ManualSize = 100*1000; //XXXXshould be 1000*1000
    }

    void set_large () {
	// Sets the parameters for large oo7.
	set_medium();
	NumModules = 10;
    }

    th_oo7db DB ();
    // Returns a new Thor oo7 db with the set params.
    // The database created includes the assembly tree(s),
    // but the parts below must be created separately.
    // This avoids creation of large number of non-persistent objects.

    void Composites (th_oo7db db);
    // Modifies db by appending the composite parts.
    // Commits transaction after creating every composite part.
    // Requires that the params did not change since the db was created.


    // Whether oo7 creation be traced for debugging (0 for no)
    int trace_flag;

  private:
    th_oo7module Module ();
    th_assembly Assemblies (int level);

    void Composites (th_assembly as, th_compositepart *cparts);
    // Modifies as by appending composite parts below the assembly tree.
    // Base assemblies are attached to parts chosen from "cparts" at random.
    // Parts are created in cparts as required.
    // Requires that the params did not change since the db was created.

    th_compositepart Composite ();
    th_atomicpart *Atomics(th_compositepart cpart, int docId);
    void connect_parts (th_atomicpart *aparts, int i, int j);
    th_string random_string (int length);
    // Returns a new Thor string of the specified length.
    
    void trace (char *kind, th_any any);
    // traces creation of oo7 part "any" and kind "kind"  on stderr

};

#endif /* _CREATE_OO7_H */
