/* Copyright Barbara Liskov, MIT, 1996 */
#include "common/th_assert.h"
#include "common/intset.h"

#include "thor.h"

#include "th_Class.h"
#include "th_list.h"
#include "th_oo7module.h"
#include "th_designobj.h"
#include "th_complexassembly.h"
#include "th_baseassembly.h"
#include "th_compositepart.h"
#include "th_atomicpart.h"
#include "th_connection.h"

#include "traverse_OO7.h"

int traverse_OO7::DB()
{
    int result = 0;
    for (int i = 0; i < NumModules; i++) {
	result += Module(db_.mod(i+1));
    }
    return result;
}

int traverse_OO7::Module(th_oo7module m)
{
    int result = 0;
    th_assembly as = m.rootassembly();
    return Assembly(as);
}

int traverse_OO7::Assembly(th_assembly as)
{
    int result = 0;
    th_complexassembly cs = th_force(as, th_complexassembly);

    if (!th_catch("wrong_type")) {
	for (int i = 0; i < NumAssmPerAssm; i++) {
	    result += Assembly(cs.subassembly(i+1));
	}
    } else { // is a base assembly
        static int composites = 0;  // Used to determine commit freq.

	th_baseassembly bs = th_force(as, th_baseassembly);
	for (int i = 0; i < NumCompPerAssm; i++) {
            if (Where) 
		// Traverse composite part in Thor
                result += bs.subpart(i+1).traverse(trav);
            else 
                // Traverse composite part in the application.
	        result += CompositePart(bs.subpart(i+1));
	}
        // Commit transaction for traversals inside thor. Due
        // to limitations on eviction of objects used by a transaction.
        if (Where && !(composites++%20)) 
             th_commit();
    } 

    return result;
}


int traverse_OO7::CompositePart(th_compositepart cp)
{
    int result = 0;
    th_atomicpart root = cp.subpart(1);
    IntSet *visited = new IntSet; // set of visited atomic parts
    
    result = AtomicPart(root, visited, trav.kind());

    delete visited;
    return result;
}


int traverse_OO7::AtomicPart(th_atomicpart a, IntSet *visited, int kind)
{ 
  // Visit only the root atomic part in traversal T6.
  if (kind == 6 || kind == 102) { 
    return 1;
  };

  int id  = a.id();
  int result = 1;

  if (visited->contains(id))	
    return 0;
   
  if (kind == 1 || kind == 101) {
    a.donothing();
  } else if (kind == 21) {
    if (visited->size() == 0) {
      // This is the first part
      a.swapxy();
    } 
  } else if (kind == 22) {
    a.swapxy();
  } else if (kind == 23) {
    result = 4;
    a.swapxy();
    a.swapxy();
    a.swapxy();
    a.swapxy();
  }
  visited->insert(id);
	
  for (int i=0; i < NumConnPerAtomic; i++) {
    th_connection con = a.outconnection(i+1);
    result += AtomicPart(con.to(), visited, kind);
  }
  return result;
    
}
















