/* Copyright Barbara Liskov, MIT, 1996 */
#ifndef _TRAVERSE_OO7_H
#define _TRAVERSE_OO7_H

// Traversing OO7.

#include "common/intset.h"

#include "th_traversal.h"
#include "th_traversal_create.h"
#include "th_complexassembly.h"
#include "th_compositepart.h"
#include "th_assembly.h"
#include "th_oo7module.h"
#include "th_oo7db.h"

class traverse_OO7 {
  private:
    th_oo7db db_;

    // oo7 parameters.
    int NumAtomicPerComp;
    int NumConnPerAtomic;
    int DocumentSize;
    int ManualSize;
    int NumCompPerModule;
    int NumAssmPerAssm;
    int NumAssmLevels;
    int NumCompPerAssm;
    int NumModules;

    int Where;  // Whether to traverse composite parts using theta
                // code running in the FE.

    th_traversal trav;  // Traversal object that stores the kind.

  public:
    traverse_OO7 (th_oo7db db, int where, int kind) {
	// Parameters from the oo7 object
	NumAtomicPerComp = db.numatomicpercomp();
	NumConnPerAtomic = db.numconnperatomic();
	DocumentSize = db.documentsize();
	ManualSize = db.manualsize();
	NumCompPerModule = db.numcomppermodule();
	NumAssmPerAssm = db.numassmperassm();
	NumAssmLevels = db.numassmlevels();
	NumCompPerAssm  = db.numcompperassm();
	NumModules = db.nummodules();
	db_ = db;
        Where = where;
	trav = th_traversal_create(kind, NumAtomicPerComp*3);
    }

    // The following methods traverse oo7 parts below the given part.
    // Value returned is the number of atomic parts visited.
    virtual int DB ();
    virtual int Module (th_oo7module m);
    virtual int Assembly (th_assembly a);
    virtual int CompositePart (th_compositepart cp);
    virtual int AtomicPart (th_atomicpart ap, IntSet *visited, int kind);
};

#endif /*  _TRAVERSE_OO7_H */
