/* Copyright Barbara Liskov, MIT, 1996 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <unistd.h>

#include "common/th_assert.h"

#include "thor.h"

#include "th_any.h"
#include "th_string.h"

#include "th_directory.h"
#include "th_Class.h"
#include "th_list.h"

#include "th_test_bools.h"
#include "th_test_chars.h"
#include "th_test_ints.h"
#include "th_test_nulls.h"
#include "th_test_strings.h"

//#include "th_instantiations.h"

//#define debugging 1

#define BOOLTEST
#define CHARTEST
#define INTTEST
#define NULLTEST
#define STRINGTEST

#ifdef debugging
#define dprintf printf
#else
void dprintf( ... ) {}
#endif

extern int optind;


char *usage = "Usage: %s -[option] [string]\n";

char const* exc_name;		// For th_catch_any

static char *fe_spec=0;

int process_command_line(int argc, char **argv);

void main(int argc, char **argv)
{

  th_directory Thor_Root;
  int H, L, Sz;
  int proc;
  char ch;

  if (!th_init()) exit(EXIT_FAILURE);

#ifdef SHM
  printf("SHM defined and is %d\n", SHM);
#else /* SHM */
  printf("SHM NOT defined\n");
#endif // SHM

  disable_futures();

  if (argc == 1)
    th_abort();
  proc = process_command_line(argc, argv);

  Thor_Root = th_get_root();

  dprintf("Got root directory\n");

#ifdef BOOLTEST
  printf("Testing bools\n");
  if (! th_test_bools()) {
     printf("test_bools failed\n");
     exit(1);
   }
#endif // BOOLTEST

#ifdef CHARTEST
  printf("Testing chars\n");
  if (! th_test_chars()) {
     printf("test_chars failed\n");
     exit(1);
   }
#endif // CHARTEST

#ifdef INTTEST
  printf("Testing ints\n");
  if (! th_test_ints()) {
     printf("test_ints failed\n");
     exit(1);
   }
#endif // INTTEST

#ifdef NULLTEST
  printf("Testing nulls\n");
  if (! th_test_nulls()) {
     printf("test_nulls failed\n");
     exit(1);
   }
#endif // NULLTEST

#ifdef STRINGTEST
  printf("Testing strings\n");
  if (! th_test_strings()) {
     printf("test_strings failed\n");
     exit(1);
   }
#endif // STRINGTEST
  th_assert_no_exceptions();

  th_shutdown();

  printf("Tests ran successfully.\n");

}


int process_command_line(int argc, char **argv)
{                                   
  int opt; 
  int value = 0;
  static char fe_spec_buff[256];
  while ((opt = getopt(argc, argv, "a:c:f:")) != EOF)  {
	switch (opt) {
	case 'f':                    //run at a specify fe
	  strcpy(fe_spec_buff, "FE_LOCATION=");
	  strcat(fe_spec_buff, optarg);
	  fe_spec = fe_spec_buff;
	  printf("fe_spec = %s\n", fe_spec);
	  putenv(fe_spec);
	  break;
      	default: 
	  printf(usage, argv[0]);
	  exit(1); 
	}
      }
  return value;
  
}

void Complain(char *The_Case, char *The_Complaint)
{
  printf("For %s: %s\n", The_Case, The_Complaint);
}

