/* Copyright Barbara Liskov, MIT, 1996 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <unistd.h>

#include "common/th_assert.h"

#include "thor.h"

#include "th_any.h"
#include "th_string.h"

#include "th_directory.h"
#include "th_Class.h"
#include "th_list.h"

#include "th_thing.h"
#include "th_stuff.h"
#include "th_make_thing.h"
#include "th_make_stuff.h"

#include "th_make_aa.h"
#include "th_make_ab.h"
#include "th_make_ac.h"
#include "th_make_ai.h"
#include "th_make_an.h"
#include "th_make_as.h"

#include "th_make_va.h"
#include "th_make_vb.h"
#include "th_make_vc.h"
#include "th_make_vi.h"
#include "th_make_vn.h"
#include "th_make_vs.h"

#include "th_make_ma_value.h"
#include "th_make_ma_empty.h"
#include "th_make_mb_value.h"
#include "th_make_mb_empty.h"
#include "th_make_mc_value.h"
#include "th_make_mc_empty.h"
#include "th_make_mi_value.h"
#include "th_make_mi_empty.h"
#include "th_make_mn_value.h"
#include "th_make_mn_empty.h"
#include "th_make_ms_value.h"
#include "th_make_ms_empty.h"

#include "th_test_ai_iters.h"
#include "th_test_vi_iters.h"

#include "th_instantiations.h"

//#define debugging 1

#define USERTEST
#define INTTEST
#define CHARTEST
#define BOOLTEST
#define NULLTEST
#define ITERTEST

#ifdef debugging
#define dprintf printf
#else
void dprintf( ... ) {}
#endif

extern int optind;


char *usage = "Usage: %s -[option] [string]\n";

char const* exc_name;		// For th_catch_any

static char *fe_spec=0;

int process_command_line(int argc, char **argv);

#ifdef INTTEST
bool test_arrayI(th_array<int> The_Array, bool Is_Empty, int The_Length,
		int The_Low, int The_Bottom, int The_Top,
		char *The_Case);

bool test_vectorI(th_vector<int> The_Vector, int The_Length,
		int The_First, int The_Last, char *The_Case);

bool test_maybeI(th_maybe<int> The_Maybe, bool Is_Empty,
		int The_Value, char *The_Case);
#endif // INTTEST

#ifdef CHARTEST
bool test_arrayC(th_array<char> The_Array, bool Is_Empty, int The_Length,
		int The_Low, char The_Bottom, char The_Top,
		char *The_Case);

bool test_vectorC(th_vector<char> The_Vector, int The_Length,
		char The_First, char The_Last, char *The_Case);

bool test_maybeC(th_maybe<char> The_Maybe, bool Is_Empty,
		char The_Value, char *The_Case);
#endif // CHARTEST

#ifdef BOOLTEST
bool test_arrayB(th_array<bool> The_Array, bool Is_Empty, int The_Length,
		int The_Low, bool The_Bottom, bool The_Top,
		char *The_Case);

bool test_vectorB(th_vector<bool> The_Vector, int The_Length,
		bool The_First, bool The_Last, char *The_Case);

bool test_maybeB(th_maybe<bool> The_Maybe, bool Is_Empty,
		bool The_Value, char *The_Case);
#endif // BOOLTEST

#ifdef NULLTEST
bool test_arrayN(th_array<null> The_Array, bool Is_Empty, int The_Length,
		int The_Low, null The_Bottom, null The_Top,
		char *The_Case);

bool test_vectorN(th_vector<null> The_Vector, int The_Length,
		null The_First, null The_Last, char *The_Case);

bool test_maybeN(th_maybe<null> The_Maybe, bool Is_Empty,
		null The_Value, char *The_Case);
#endif // NULLTEST

void main(int argc, char **argv)
{

  th_directory Thor_Root;
  int H, L, Sz;
  int proc;
  char ch;

  if (!th_init()) exit(EXIT_FAILURE);

#ifdef SHM
  printf("SHM defined and is %d\n", SHM);
#else /* SHM */
  printf("SHM NOT defined\n");
#endif // SHM

  disable_futures();

  if (argc == 1)
    th_abort();
  proc = process_command_line(argc, argv);

  Thor_Root = th_get_root();

  dprintf("Got root directory\n");

#ifdef USERTEST
  printf("Test user defined type as param\n");

  char *Nm = argv[optind];
  if (Nm == 0)
    Nm = "TestString";
  dprintf("making thing named %s\n", Nm);

  th_string str = th_chars_to_string(Nm);
  th_thing Th1 = th_make_thing(str); 
  dprintf("made a thing with name %s\n", th_string_to_chars(Th1.name()));
  dprintf("making stuff\n");
  th_stuff St = th_make_stuff();
  dprintf("made some stuff\n");

  if (th_catch_any(exc_name)) {
      printf("Exception: %s\n", exc_name);
      exit(1);
    }
  th_commit();

  th_array<th_thing> Ths = St.things();
  dprintf("got things\n");

  H = Ths.high();
  if (th_catch_any(exc_name)) {
    printf("Exception from high: %s\n", exc_name);
    exit(1);
  }
  dprintf("got high %d\n", L);

  L = Ths.low();
  if (th_catch_any(exc_name)) {
    printf("Exception from low: %s\n", exc_name);
    exit(1);
  }
  dprintf("got low %d\n", L);

  Sz = Ths.length();
  if (th_catch_any(exc_name)) {
    printf("Exception from length: %s\n", exc_name);
    exit(1);
  }
  dprintf("got length %d\n", Sz);

  th_vector<th_thing> No_VTh = St.vthings();
  if (th_catch("no_things")) {
    dprintf("New stuff object is empty (VThings).\n");
  } else {
    printf("New stuff object is NOT empty (VThings)!\n");
  }

  th_maybe<th_thing> No_MTh = St.mthing();
  if (th_catch("no_things")) {
    dprintf("New stuff object is empty (MThing).\n");
  } else {
    printf("New stuff object is NOT empty (MThing)!\n");
  }

  St.add_thing(Th1);
  if (th_catch_any(exc_name)) {
    printf("Exception from add_thing: %s\n", exc_name);
    exit(1);
  }
  dprintf("appended a thing\n");
  L = Ths.low();
  if (th_catch_any(exc_name)) {
    printf("Exception from low: %s\n", exc_name);
    exit(1);
  }
  dprintf("got low %d\n", L);

  Sz = Ths.length();
  if (th_catch_any(exc_name)) {
    printf("Exception from length: %s\n", exc_name);
    exit(1);
  }
  dprintf("got length %d\n", Sz);

  th_thing Th = Ths.bottom();
  if (th_catch_any(exc_name)) {
    printf("Exception from bottom: %s\n", exc_name);
    exit(1);
  }
  dprintf("got bottom thing with name %s\n", th_string_to_chars(Th.name()));

  Th = Ths.fetch(L);
  if (th_catch_any(exc_name)) {
    printf("Exception from fetch: %s\n", exc_name);
    exit(1);
  }
  dprintf("did fetch of thing with %s\n", th_string_to_chars(Th.name()));

  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }

  th_string Th_Str = th_chars_to_string("Things");
  if (th_catch_any(exc_name)) {
    printf("Exception from th_chars_to_string: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got a string: %s\n", th_string_to_chars(Th_Str));

  th_any Things_as_any = th_force(Ths, th_any);
  if (th_catch_any(exc_name)) {
    printf("Exception from th_force to th_any: %s\n", exc_name);
    exit(1);
  }
  dprintf("Forced Ths to any\n");

  Thor_Root.lookup(Th_Str);
  if (! th_catch("not_found")) {
    printf("Something already exists as Things\n");
  } else {
    dprintf("Verified that nothing exists as Things\n");
  }

  Thor_Root.insert(Th_Str, Things_as_any);
  if (th_catch("exists")) {
    Thor_Root.remove(Th_Str);
    Thor_Root.insert(Th_Str, Things_as_any);
  }
  if (th_catch_any(exc_name)) {
    printf("Exception from insert: %s\n", exc_name);
    exit(1);
  }
  dprintf("Inserted things in root directory\n");
  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }

  Things_as_any = Thor_Root.lookup(th_chars_to_string("Things"));
  if (th_catch_any(exc_name)) {
    printf("Exception from lookup: %s\n", exc_name);
    exit(1);
  }
  dprintf("Looked up things (as th_any) in root directory\n");
  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }

  th_array<th_thing> Things = th_force(Things_as_any, th_array<th_thing>);
  if (th_catch_any(exc_name)) {
    printf("Exception from th_force: %s\n", exc_name);
    exit(1);
  }
  dprintf("Force Things_as_any to Things\n");
  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }

  Th = Things.bottom();
  if (th_catch_any(exc_name)) {
    printf("Exception from bottom: %s\n", exc_name);
    exit(1);
  }
  dprintf("got bottom thing with name %s\n", th_string_to_chars(Th.name()));
  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }

  th_vector<th_thing> VThings = St.vthings();
  if (th_catch_any(exc_name)) {
    printf("Exception from vthings: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got vector[thing] from vthings\n");
  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }

  th_thing Th2 = VThings.fetch(1);
  if (th_catch_any(exc_name)) {
    printf("Exception from vector fetch: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got did vector fetch to get thing named %s\n",
	 th_string_to_chars(Th2.name()));
  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }

  th_maybe<th_thing>  MThing  = St.mthing();
  if (th_catch_any(exc_name)) {
    printf("Exception from MThing: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got maybe[thing] from mthing\n");
  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }

  th_thing Th3 = MThing.value_full();
  if (th_catch_any(exc_name)) {
    printf("Exception from value_full: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got value of thing named %s\n",
	 th_string_to_chars(Th3.name()));
  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }


  th_maybe<th_thing>  EMThing = St.emthing();
  if (th_catch_any(exc_name)) {
    printf("Exception from emthing: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got maybe[thing] from emthing\n");
  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }

  if (EMThing.is_empty()) {
    dprintf("Empty maybe is empty.\n");
  } else {
    printf("Empty maybe is NOT empty!!\n");
  }

  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }
  th_array<th_vector<th_maybe<th_array<th_vector<th_maybe<th_thing> > > > > >
    Wierd = St.wierd();
  if (th_catch_any(exc_name)) {
    printf("Exception from wierd: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got a wierd\n");


  th_vector<th_maybe<th_array<th_vector<th_maybe<th_thing> > > > >
    WV = Wierd.bottom();
  if (th_catch_any(exc_name)) {
    printf("Exception from Wierd.bottom: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got the 1st vector\n");
  
  th_maybe<th_array<th_vector<th_maybe<th_thing> > > >
    WM = WV.fetch(1);
  if (th_catch_any(exc_name)) {
    printf("Exception from WV.fetch: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got the 1st maybe\n");
  
  th_array<th_vector<th_maybe<th_thing> > >
    WA = WM.value_full();
  if (th_catch_any(exc_name)) {
    printf("Exception from WM.value_full: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got the array\n");
  
  th_vector<th_maybe<th_thing> >
    WV2 = WA.fetch(WA.low());
  if (th_catch_any(exc_name)) {
    printf("Exception from WA.fetch(WA.low()): %s\n", exc_name);
    exit(1);
  }
  dprintf("Got the second vector\n");
  
  th_maybe<th_thing>
    WM2 = WV2.fetch(1);
  if (th_catch_any(exc_name)) {
    printf("Exception from WV2.fetch: %s\n", exc_name);
    exit(1);
  }
  dprintf("Got the second maybe\n");
  
  if (WM2.is_empty()) {
    dprintf("Empty maybe is empty.\n");
  } else {
    printf("Empty maybe is NOT empty!!\n");
  }

  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }
  
  

  //  Finish off by getting rid of the things.

  dprintf("Removing Things\n");
  Thor_Root.remove(Th_Str);
  if (th_catch_any(exc_name)) {
    printf("Exception from remove: %s\n", exc_name);
    exit(1);
  }
  dprintf("Removed it\n");
  th_commit();
  if (th_catch_any(exc_name)) {
    printf("Exception from commit: %s\n", exc_name);
    exit(1);
  }
#endif // USERTEST

#ifdef INTTEST
  printf("Test int  as param: ");

  // Now test array[int]
  printf("array[int]  ");

  th_array<int> AofI = th_make_ai();
  if (! test_arrayI(AofI, TRUE, 0, 1, 0, 0, "Initial empty array"))
    exit(1);

  AofI.append(1);
  if (! test_arrayI(AofI, FALSE, 1, 1, 1, 1, "Array with 1"))
    exit(1);

  AofI.store(1, 2);
  if (! test_arrayI(AofI, FALSE, 1, 1, 2, 2, "Array with 2"))
    exit(1);
  AofI.store(0, 1);
  if (! th_catch("bounds")) {
    printf("Array[int]: Store below low did not signal bounds");
    exit(1);
  }
  AofI.store(2, 1);
  if (! th_catch("bounds")) {
    printf("Array[int]: Store above high did not signal bounds");
    exit(1);
  }

  AofI.store(1, 1);
  if (! test_arrayI(AofI, FALSE, 1, 1, 1, 1, "Array with 1 (2nd time)"))
    exit(1);

  AofI.set_low(10);
  if (! test_arrayI(AofI, FALSE, 1, 10, 1, 1, "Array with 1 and low of 10"))
    exit(1);

  AofI.set_low(-10);
  if (! test_arrayI(AofI, FALSE, 1, -10, 1, 1, "Array with 1 and low of -10"))
    exit(1);

  AofI.append_low(0);
  if (! test_arrayI(AofI, FALSE, 2, -11, 0, 1, "Array with 0,1 and low of -11"))
    exit(1);

  if (AofI.remove() != 1) {
    printf("remove did not return top element\n");
    exit(1);
  }
  th_assert_no_exceptions();
  if (! test_arrayI(AofI, FALSE, 1, -11, 0, 0, "Array with 0 and low of -11"))
    exit(1);

  if (AofI.remove_low() != 0) {
    printf("remove_low did not return bottom element\n");
    exit(1);
  }
  th_assert_no_exceptions();
  if (! test_arrayI(AofI, TRUE, 0, -10, 0, 0, "Empty array with low of -10"))
    exit(1);

  AofI.remove();
  if (! th_catch("bounds")) {
    printf("Array[int]: remove of empty array did not signal bounds");
    exit(1);
  }
  if (! test_arrayI(AofI, TRUE, 0, -10, 0, 0, "2nd empty array with low of -10"))
    exit(1);

  AofI.remove_low();
  if (! th_catch("bounds")) {
    printf("Array[int]: remove_low of empty array did not signal bounds");
    exit(1);
  }
  if (! test_arrayI(AofI, TRUE, 0, -10, 0, 0, "3rd empty array with low of -10"))
    exit(1);

  AofI.predict(-10);
  th_assert_no_exceptions();
  if (! test_arrayI(AofI, TRUE, 0, -10, 0, 0, "4th empty array with low of -10"))
    exit(1);

  AofI.predict(10);
  th_assert_no_exceptions();
  if (! test_arrayI(AofI, TRUE, 0, -10, 0, 0, "5th empty array with low of -10"))
    exit(1);

  AofI.append(3);
  if (! test_arrayI(AofI, FALSE, 1, -10, 3, 3, "Array with 3 with low of -10"))
    exit(1);
  AofI.append_low(2);
  if (! test_arrayI(AofI, FALSE, 2, -11, 2, 3, "Array with 2,3 with low of -11"))
    exit(1);
  AofI.append(4);
  if (! test_arrayI(AofI, FALSE, 3, -11, 2, 4, "Array with 2,3,4 with low of -11"))
    exit(1);
  AofI.append_low(1);
  if (! test_arrayI(AofI, FALSE, 4, -12, 1, 4, "Array with 1,2,3,4 with low of -12"))
    exit(1);
  AofI.append(5);
  if (! test_arrayI(AofI, FALSE, 5, -12, 1, 5, "Array with 1,2,3,4,5 with low of -12"))
    exit(1);
  AofI.set_low(1);
  if (! test_arrayI(AofI, FALSE, 5, 1, 1, 5, "Array with 1,2,3,4,5 and low of 1"))
    exit(1);

  AofI.trim(1, -1);
  if (! th_catch("negative_size")) {
    printf("Array[int]: trim with negative count did not signal negative_size");
    exit(1);
  }
  if (! test_arrayI(AofI, FALSE, 5, 1, 1, 5, "2nd array with 1,2,3,4,5 and low of 1"))
    exit(1);

  AofI.trim(0, 3);
  if (! th_catch("bounds")) {
    printf("Array[int]: trim with lb < low() did not signal bounds");
    exit(1);
  }
  if (! test_arrayI(AofI, FALSE, 5, 1, 1, 5, "3rd array with 1,2,3,4,5 and low of 1"))
    exit(1);

  AofI.trim(7, 3);
  if (! th_catch("bounds")) {
    printf("Array[int]: trim with lb > high()+1 did not signal bounds");
    exit(1);
  }
  if (! test_arrayI(AofI, FALSE, 5, 1, 1, 5, "4th array with 1,2,3,4,5 and low of 1"))
    exit(1);

  th_array<int> AofI2 = AofI;
  if (! AofI2.equal(AofI)) {
    printf("Array[int]: equal failed");
    exit(1);
  }
// Now test vector[int]
  printf("vector[int]  ");

  th_vector<int> VofI = th_make_vi(0, 0);
  if (! test_vectorI(VofI, 0, 0, 0, "Empty vector"))
    exit(1);
  
  th_assert_no_exceptions();
  VofI = th_make_vi(1, 1);
  th_assert_no_exceptions();
  if (! test_vectorI(VofI, 1, 1, 1, "Vector [1]"))
    exit(1);

  th_assert_no_exceptions();
  VofI = th_make_vi(2, 1);
  if (! test_vectorI(VofI, 2, 1, 1, "Vector [1, 1]"))
    exit(1);

  th_assert_no_exceptions();
  VofI.store(2, 2);
  if (! test_vectorI(VofI, 2, 1, 2, "Vector [1, 2]"))
    exit(1);

  th_assert_no_exceptions();

// Now test maybe[int]
  printf("maybe[int]\n");

  th_maybe<int> MofI = th_make_mi_empty();
  if (! test_maybeI(MofI, TRUE, 0, "Empty maybe"))
    exit(1);
  th_assert_no_exceptions();

  MofI = th_make_mi_value(1);
  if (! test_maybeI(MofI, FALSE, 1, "Maybe of 1"))
    exit(1);
  th_assert_no_exceptions();

#endif // INTTEST

#ifdef CHARTEST
  printf("Test char as param: ");

  // Now test array[char]
  printf("array[char] ");

  th_array<char> AofC = th_make_ac();
  if (! test_arrayC(AofC, TRUE, 0, 1, '\000', '\000', "Initial empty array"))
    exit(1);

  AofC.append('b');
  if (! test_arrayC(AofC, FALSE, 1, 1, 'b', 'b', "Array with b"))
    exit(1);

  AofC.set_low(10);
  if (! test_arrayC(AofC, FALSE, 1, 10, 'b', 'b', "Array with b and low of 10"))
    exit(1);

  AofC.set_low(-10);
  if (! test_arrayC(AofC, FALSE, 1, -10, 'b', 'b', "Array with b and low of -10"))
    exit(1);

  AofC.append_low('a');
  if (! test_arrayC(AofC, FALSE, 2, -11, 'a', 'b', "Array with a,b and low of -11"))
    exit(1);

  if (AofC.remove() != 'b') {
    printf("remove did not return top element\n");
    exit(1);
  }
  th_assert_no_exceptions();
  if (! test_arrayC(AofC, FALSE, 1, -11, 'a', 'a', "Array with a and low of -11"))
    exit(1);

// Now test vector[char]
  printf("vector[char] ");

  th_vector<char> VofC = th_make_vc(0, 0);
  if (! test_vectorC(VofC, 0, '\000', '\000', "Empty vector"))
    exit(1);
  
  th_assert_no_exceptions();
  VofC = th_make_vc(1, 'a');
  th_assert_no_exceptions();
  if (! test_vectorC(VofC, 1, 'a', 'a', "Vector [a]"))
    exit(1);

  th_assert_no_exceptions();
  VofC = th_make_vc(2, 'a');
  if (! test_vectorC(VofC, 2, 'a', 'a', "Vector [a, a]"))
    exit(1);

  th_assert_no_exceptions();
  VofC.store(2, 'b');
  if (! test_vectorC(VofC, 2, 'a', 'b', "Vector [a, b]"))
    exit(1);

  th_assert_no_exceptions();

// Now test maybe[char]
  printf("maybe[char]\n");

  th_maybe<char> MofC = th_make_mc_empty();
  if (! test_maybeC(MofC, TRUE, '\000', "Empty maybe"))
    exit(1);
  th_assert_no_exceptions();

  MofC = th_make_mc_value('a');
  if (! test_maybeC(MofC, FALSE, 'a', "Maybe of a"))
    exit(1);
  th_assert_no_exceptions();

#endif // CHARTEST

#ifdef BOOLTEST
  printf("Test bool as param: ");

  // Now test array[bool]
  printf("array[bool] ");

  th_array<bool> AofB = th_make_ab();
  if (! test_arrayB(AofB, TRUE, 0, 1, FALSE, FALSE, "Initial empty array"))
    exit(1);

  AofB.append(TRUE);
  if (! test_arrayB(AofB, FALSE, 1, 1, TRUE, TRUE, "Array with TRUE"))
    exit(1);

  AofB.set_low(10);
  if (! test_arrayB(AofB, FALSE, 1, 10, TRUE, TRUE, "Array with TRUE and low of 10"))
    exit(1);

  AofB.set_low(-10);
  if (! test_arrayB(AofB, FALSE, 1, -10, TRUE, TRUE, "Array with TRUE and low of -10"))
    exit(1);

  AofB.append_low(FALSE);
  if (! test_arrayB(AofB, FALSE, 2, -11, FALSE, TRUE, "Array with FALSE,TRUE and low of -11"))
    exit(1);

  if (AofB.remove() != TRUE) {
    printf("remove did not return top element\n");
    exit(1);
  }
  th_assert_no_exceptions();
  if (! test_arrayB(AofB, FALSE, 1, -11, FALSE, FALSE, "Array with FALSE and low of -11"))
    exit(1);

// Now test vector[bool
  printf("vector[bool] ");

  th_vector<bool> VofB = th_make_vb(0, 0);
  if (! test_vectorB(VofB, 0, FALSE, FALSE, "Empty vector"))
    exit(1);
  
  th_assert_no_exceptions();
  VofB = th_make_vb(1, FALSE);
  th_assert_no_exceptions();
  if (! test_vectorB(VofB, 1, FALSE, FALSE, "Vector [FALSE]"))
    exit(1);

  th_assert_no_exceptions();
  VofB = th_make_vb(2, FALSE);
  if (! test_vectorB(VofB, 2, FALSE, FALSE, "Vector [FALSE, FALSE]"))
    exit(1);

  th_assert_no_exceptions();
  VofB.store(2, TRUE);
  if (! test_vectorB(VofB, 2, FALSE, TRUE, "Vector [FALSE, TRUE]"))
    exit(1);

  th_assert_no_exceptions();

  // Now test maybe[bool]
  printf("maybe[bool]\n");

  th_maybe<bool> MofB = th_make_mb_empty();
  if (! test_maybeB(MofB, TRUE, FALSE, "Empty maybe"))
    exit(1);
  th_assert_no_exceptions();

  MofB = th_make_mb_value(TRUE);
  if (! test_maybeB(MofB, FALSE, TRUE, "Maybe of TRUE"))
    exit(1);
  th_assert_no_exceptions();

#endif // BOOLTEST


#ifdef NULLTEST
  printf("Test null as param: ");

  // Now test array[null]
  printf("array[null] ");

  th_array<null> AofN = th_make_an();
  if (! test_arrayN(AofN, TRUE, 0, 1, th_nil, th_nil, "Initial empty array"))
    exit(1);

  AofN.append(th_nil);
  if (! test_arrayN(AofN, FALSE, 1, 1, th_nil, th_nil, "Array with th_nil"))
    exit(1);

  AofN.set_low(10);
  if (! test_arrayN(AofN, FALSE, 1, 10, th_nil, th_nil, "Array with th_nil and low of 10"))
    exit(1);

  AofN.set_low(-10);
  if (! test_arrayN(AofN, FALSE, 1, -10, th_nil, th_nil, "Array with th_nil and low of -10"))
    exit(1);

  AofN.append_low(th_nil);
  if (! test_arrayN(AofN, FALSE, 2, -11, th_nil, th_nil, "Array with th_nil,th_nil and low of -11"))
    exit(1);

  if (AofN.remove() != th_nil) {
    printf("remove did not return top element\n");
    exit(1);
  }
  th_assert_no_exceptions();
  if (! test_arrayN(AofN, FALSE, 1, -11, th_nil, th_nil, "Array with th_nil and low of -11"))
    exit(1);

// Now test vector[null]
  printf("vector[null] ");

  th_vector<null> VofN = th_make_vn(0, 0);
  if (! test_vectorN(VofN, 0, th_nil, th_nil, "Empty vector"))
    exit(1);

  th_assert_no_exceptions();
  VofN = th_make_vn(1, th_nil);
  th_assert_no_exceptions();
  if (! test_vectorN(VofN, 1, th_nil, th_nil, "Vector [th_nil]"))
    exit(1);

  th_assert_no_exceptions();
  VofN = th_make_vn(2, th_nil);
  if (! test_vectorN(VofN, 2, th_nil, th_nil, "Vector [th_nil, th_nil]"))
    exit(1);

  th_assert_no_exceptions();
  VofN.store(2, th_nil);
  if (! test_vectorN(VofN, 2, th_nil, th_nil, "Vector [th_nil, th_nil]"))
    exit(1);

  th_assert_no_exceptions();

  // Now test maybe[null]
  printf("maybe[null]\n");

  th_maybe<null> MofN = th_make_mn_empty();
  if (! test_maybeN(MofN, TRUE, th_nil, "Empty maybe"))
    exit(1);
  th_assert_no_exceptions();

  MofN = th_make_mn_value(th_nil);
  if (! test_maybeN(MofN, FALSE, th_nil, "Maybe of th_nil"))
    exit(1);
  th_assert_no_exceptions();

#endif // NULLTEST

  th_assert_no_exceptions();


#ifdef ITERTEST
  printf("Test iterators of ");

  printf("array[int] ");
  th_array<int> AI = th_make_ai();
  th_assert_no_exceptions();
  if (! th_test_ai_iters(AI)) {
    printf("array[int] iter tests failed for empty array\n");
    exit(1);
  }
  th_assert_no_exceptions();
  AI.append(1);
  AI.append(2);
  AI.append(3);
  AI.append(4);
  th_assert_no_exceptions();
  if (! th_test_ai_iters(AI)) {
    printf("array[int] iter tests failed for array[1:1,2,3,4]\n");
    exit(1);
  }
  th_assert_no_exceptions();
  AI.append_low(0);
  AI.append(-1);
  AI.append(-2);
  AI.append(-3);
  th_assert_no_exceptions();
  if (! th_test_ai_iters(AI)) {
    printf("array[int] iter tests failed for array[-3:-3,-2,-1,01,2,3,4]\n");
    exit(1);
  }
  th_assert_no_exceptions();

  printf("vector[int]\n");
  th_vector<int> VI = th_make_vi(0, 0);
  th_assert_no_exceptions();
  if (! th_test_vi_iters(VI)) {
    printf("vector[int] iter tests failed for empty vector\n");
    exit(1);
  }
  th_assert_no_exceptions();
  VI = th_make_vi(1, 1);
  th_assert_no_exceptions();
  if (! th_test_vi_iters(VI)) {
    printf("vector[int] iter tests failed for vector[1]\n");
    exit(1);
  }
  th_assert_no_exceptions();
  VI = th_make_vi(10, 1);
  VI.store(2, 2);
  VI.store(3, 3);
  VI.store(4, 4);
  VI.store(5, 5);
  VI.store(6, 6);
  VI.store(7, 7);
  VI.store(8, 8);
  VI.store(9, 9);
  VI.store(10, 10);
  th_assert_no_exceptions();
  if (! th_test_vi_iters(VI)) {
    printf("vector[int] iter tests failed for empty vector[1, 2... 10]\n");
    exit(1);
  }
  th_assert_no_exceptions();

#endif // ITERTEST

  th_shutdown();

  printf("Tests ran successfully.\n");

}


int process_command_line(int argc, char **argv)
{                                   
  int opt; 
  int value = 0;
  static char fe_spec_buff[256];
  while ((opt = getopt(argc, argv, "a:c:f:")) != EOF)  {
	switch (opt) {
	case 'f':                    //run at a specify fe
	  strcpy(fe_spec_buff, "FE_LOCATION=");
	  strcat(fe_spec_buff, optarg);
	  fe_spec = fe_spec_buff;
	  printf("fe_spec = %s\n", fe_spec);
	  putenv(fe_spec);
	  break;
      	default: 
	  printf(usage, argv[0]);
	  exit(1); 
	}
      }
  return value;
  
}

void Complain(char *The_Case, char *The_Complaint)
{
  printf("For %s: %s\n", The_Case, The_Complaint);
}

#ifdef INTTEST
bool test_arrayI(th_array<int> The_Array, bool Is_Empty, int The_Length,
		int The_Low, int The_Bottom, int The_Top,
		char *The_Case)
{
  bool Not_Good = FALSE;
  int  The_High = (The_Low + The_Length - 1);
  int  T = 0;
  int  B = 0;
  int  Tf = 0;
  int  Bf = 0;

  th_assert_no_exceptions();

  if (Is_Empty) {
    if (! The_Array.empty()) {
      Complain(The_Case, "Array should be empty and is not");
      Not_Good = TRUE;
    }
  } else {
    if (The_Array.empty()) {
      Complain(The_Case, "Array should not be empty and is");
      Not_Good = TRUE;
    }
  };

  th_assert_no_exceptions();

  if (The_Length != The_Array.length()) {
    Complain(The_Case, "Length of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_Low != The_Array.low()) {
    Complain(The_Case, "Low of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_High != The_Array.high()) {
    Complain(The_Case, "High of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (Is_Empty) {
    B = The_Array.bottom();
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to bottom");
      Not_Good = TRUE;
    }
    Bf = The_Array.fetch(The_Low);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal fetch at low");
      Not_Good = TRUE;
    }
  } else {
    B = The_Array.bottom();
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to bottom");
      Not_Good = TRUE;
    } else {
      if (The_Bottom != B) {
	Complain(The_Case, "Bottom of array is not correct");
	Not_Good = TRUE;
     }
    }
    Bf = The_Array.fetch(The_Low);
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to fetch at low");
      Not_Good = TRUE;
    } else {
      if (The_Bottom != Bf) {
	Complain(The_Case, "Low element of array is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Is_Empty) {
    T = The_Array.top();
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to top");
      Not_Good = TRUE;
    }
    Tf = The_Array.fetch(The_High);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to fetch at high");
      Not_Good = TRUE;
    }
  } else {
    T = The_Array.top();
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to top");
      Not_Good = TRUE;
    } else {
      if (The_Top != T) {
	Complain(The_Case, "Top of array is not correct");
	Not_Good = TRUE;
      }
    }
    Tf = The_Array.fetch(The_High);
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to fetch at high");
      Not_Good = TRUE;
    } else {
      if (The_Top != Tf) {
	Complain(The_Case, "High element of array is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Not_Good) {
    if (Is_Empty)
      printf("Given: Empty, Low %d, Length %d, High %d\n",
	     The_Low, The_Length, The_High);
    else
      printf("Given: Non-Empty, Low %d, Length %d, High %d, Bottom %d, Top %d\n",
	     The_Low, The_Length, The_High, The_Bottom, The_Top);
    if (The_Array.empty())
      printf("Found: Empty, Low %d, Length %d, High %d\n",
	     The_Array.low(), The_Array.length(), The_Array.high());
    else
      printf("Found: Non-Empty, Low %d, Length %d, High %d, Bottom %d, Top %d, LowE %d, HighE %d\n",
	     The_Array.low(), The_Array.length(), The_Array.high(), B, T, Bf, Tf);
  }
  return (! Not_Good);
}

bool test_vectorI(th_vector<int> The_Vector, int The_Length,
		int The_First, int The_Last, char *The_Case)
{
  bool Not_Good = FALSE;
  int  F = 0;
  int  L = 0;

  th_assert_no_exceptions();

  if (The_Length != The_Vector.length()) {
    Complain(The_Case, "Length of vector is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_Length == 0) {
    F = The_Vector.fetch(1);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty vector did not signal bounds to fetch");
      Not_Good = TRUE;
    }
  } else {

  th_assert_no_exceptions();

    int th_F =The_Vector.fetch(1);

  th_assert_no_exceptions();

  F = th_F;
  th_assert_no_exceptions();

    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty vector did signal bounds to fetch(1)");
      Not_Good = TRUE;
    } else {

  th_assert_no_exceptions();

      if (The_First != F) {
	Complain(The_Case, "First element of vector is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (The_Length != 0) {
    L = The_Vector.fetch(The_Length); 
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty vector did signal bounds to fetch(Length)");
      Not_Good = TRUE;
    } else {
      if (The_Last != L) {
	Complain(The_Case, "Last element of vector is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Not_Good) {
    if (The_Length == 0)
      printf("Given: Length %d\n",
	     The_Length);
    else
      printf("Given: Length %d, First %d, Last %d\n",
	     The_Length, The_First, The_Last);

    if (The_Vector.length() == 0)
      printf("Found: Length %d\n",
	     The_Vector.length());
    else
      printf("Found: Length %d, First %d, Last %d\n",
	     The_Vector.length(), F, L);
  }
  return (! Not_Good);
}


bool test_maybeI(th_maybe<int> The_Maybe, bool Is_Empty,
		int The_Value, char *The_Case)
{
  bool Not_Good = FALSE;
  int  V = 0;

  th_assert_no_exceptions();

  if (Is_Empty) {
    if (! The_Maybe.is_empty()) {
      Complain(The_Case, "Empty maybe returns FALSE to is_empty");
      Not_Good = TRUE;
    }
    
    th_assert_no_exceptions();

    if (The_Maybe.is_full()) {
      Complain(The_Case, "Empty maybe returns TRUE to is_full");
    }

    th_assert_no_exceptions();

    if (The_Maybe.value_empty() != th_nil) {
      Complain(The_Case, "Empty maybe has value not = nil");
    }

    th_assert_no_exceptions();

    int V2 = The_Maybe.value_full();
    if (!th_catch("wrong_tag")) {
      Complain(The_Case, "Empty maybe does not signal wrong_tag to value_full");
    }

    th_assert_no_exceptions();

  } else {
    if (The_Maybe.is_empty()) {
      Complain(The_Case, "Full maybe returns TRUE to is_empty");
      Not_Good = TRUE;
    }
    
    th_assert_no_exceptions();

    if (! The_Maybe.is_full()) {
      Complain(The_Case, "Full maybe returns FALSE to is_full");
    }

    th_assert_no_exceptions();

    null N = The_Maybe.value_empty();
    if (!th_catch("wrong_tag")) {
      Complain(The_Case, "Full maybe does not signal wrong_tag to value_empty");
  }

    th_assert_no_exceptions();

    if (The_Maybe.value_full() != The_Value) {
      Complain(The_Case, "Full maybe returns wrong value to value__full");
    }
  }
  if (Not_Good) {
    if (Is_Empty)
      printf("Given: Empty\n");
    else
      printf("Given: Full, Value %d\n", The_Value);

    if (The_Maybe.is_empty())
      printf("Found: Empty, Value %d\n", The_Maybe.value_empty());
    else
      printf("Found: Full, Value %d\n", The_Maybe.value_full());
  }
  return (! Not_Good);
}
#endif // INTTEST

#ifdef CHARTEST
bool test_arrayC(th_array<char> The_Array, bool Is_Empty, int The_Length,
		int The_Low, char The_Bottom, char The_Top,
		char *The_Case)
{
  bool Not_Good = FALSE;
  int  The_High = (The_Low + The_Length - 1);
  char  T = '\000';
  char  B = '\000';
  char  Tf = '\000';
  char  Bf = '\000';

  th_assert_no_exceptions();

  if (Is_Empty) {
    if (! The_Array.empty()) {
      Complain(The_Case, "Array should be empty and is not");
      Not_Good = TRUE;
    }
  } else {
    if (The_Array.empty()) {
      Complain(The_Case, "Array should not be empty and is");
      Not_Good = TRUE;
    }
  };

  th_assert_no_exceptions();

  if (The_Length != The_Array.length()) {
    Complain(The_Case, "Length of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_Low != The_Array.low()) {
    Complain(The_Case, "Low of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_High != The_Array.high()) {
    Complain(The_Case, "High of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (Is_Empty) {
    B = The_Array.bottom();
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to bottom");
      Not_Good = TRUE;
    }
    Bf = The_Array.fetch(The_Low);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal fetch at low");
      Not_Good = TRUE;
    }
  } else {
    B = The_Array.bottom();
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to bottom");
      Not_Good = TRUE;
    } else {
      if (The_Bottom != B) {
	Complain(The_Case, "Bottom of array is not correct");
	Not_Good = TRUE;
     }
    }
    Bf = The_Array.fetch(The_Low);
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to fetch at low");
      Not_Good = TRUE;
    } else {
      if (The_Bottom != Bf) {
	Complain(The_Case, "Low element of array is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Is_Empty) {
    T = The_Array.top();
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to top");
      Not_Good = TRUE;
    }
    Tf = The_Array.fetch(The_High);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to fetch at high");
      Not_Good = TRUE;
    }
  } else {
    T = The_Array.top();
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to top");
      Not_Good = TRUE;
    } else {
      if (The_Top != T) {
	Complain(The_Case, "Top of array is not correct");
	Not_Good = TRUE;
      }
    }
    Tf = The_Array.fetch(The_High);
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to fetch at high");
      Not_Good = TRUE;
    } else {
      if (The_Top != Tf) {
	Complain(The_Case, "High element of array is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Not_Good) {
    if (Is_Empty)
      printf("Given: Empty, Low %d, Length %d, High %d\n",
	     The_Low, The_Length, The_High);
    else
      printf("Given: Non-Empty, Low %d, Length %d, High %d, Bottom %c, Top %c\n",
	     The_Low, The_Length, The_High, The_Bottom, The_Top);
    if (The_Array.empty())
      printf("Found: Empty, Low %d, Length %d, High %d\n",
	     The_Array.low(), The_Array.length(), The_Array.high());
    else
      printf("Found: Non-Empty, Low %d, Length %d, High %d, Bottom %c, Top %c, LowE %c, HighE %c\n",
	     The_Array.low(), The_Array.length(), The_Array.high(), B, T, Bf, Tf);
  }
  return (! Not_Good);
}

bool test_vectorC(th_vector<char> The_Vector, int The_Length,
		char The_First, char The_Last, char *The_Case)
{
  bool Not_Good = FALSE;
  char  F = '\000';
  char  L = '\000';

  th_assert_no_exceptions();

  if (The_Length != The_Vector.length()) {
    Complain(The_Case, "Length of vector is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_Length == 0) {
    F = The_Vector.fetch(1);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty vector did not signal bounds to fetch");
      Not_Good = TRUE;
    }
  } else {

  th_assert_no_exceptions();

    int th_F =The_Vector.fetch(1);

  th_assert_no_exceptions();

  F = th_F;
  th_assert_no_exceptions();

    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty vector did signal bounds to fetch(1)");
      Not_Good = TRUE;
    } else {

  th_assert_no_exceptions();

      if (The_First != F) {
	Complain(The_Case, "First element of vector is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (The_Length != 0) {
    L = The_Vector.fetch(The_Length); 
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty vector did signal bounds to fetch(Length)");
      Not_Good = TRUE;
    } else {
      if (The_Last != L) {
	Complain(The_Case, "Last element of vector is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Not_Good) {
    if (The_Length == 0)
      printf("Given: Length %d\n",
	     The_Length);
    else
      printf("Given: Length %d, First %c, Last %c\n",
	     The_Length, The_First, The_Last);

    if (The_Vector.length() == 0)
      printf("Found: Length %d\n",
	     The_Vector.length());
    else
      printf("Found: Length %d, First %c, Last %c\n",
	     The_Vector.length(), F, L);
  }
  return (! Not_Good);
}


bool test_maybeC(th_maybe<char> The_Maybe, bool Is_Empty,
		char The_Value, char *The_Case)
{
  bool Not_Good = FALSE;
  char V = '\000';

  th_assert_no_exceptions();

  if (Is_Empty) {
    if (! The_Maybe.is_empty()) {
      Complain(The_Case, "Empty maybe returns FALSE to is_empty");
      Not_Good = TRUE;
    }
    
    th_assert_no_exceptions();

    if (The_Maybe.is_full()) {
      Complain(The_Case, "Empty maybe returns TRUE to is_full");
    }

    th_assert_no_exceptions();

    if (The_Maybe.value_empty() != th_nil) {
      Complain(The_Case, "Empty maybe has value not = nil");
    }

    th_assert_no_exceptions();

    char V2 = The_Maybe.value_full();
    if (!th_catch("wrong_tag")) {
      Complain(The_Case, "Empty maybe does not signal wrong_tag to value_full");
    }

    th_assert_no_exceptions();

  } else {
    if (The_Maybe.is_empty()) {
      Complain(The_Case, "Full maybe returns TRUE to is_empty");
      Not_Good = TRUE;
    }
    
    th_assert_no_exceptions();

    if (! The_Maybe.is_full()) {
      Complain(The_Case, "Full maybe returns FALSE to is_full");
    }

    th_assert_no_exceptions();

    null N = The_Maybe.value_empty();
    if (!th_catch("wrong_tag")) {
      Complain(The_Case, "Full maybe does not signal wrong_tag to value_empty");
  }

    th_assert_no_exceptions();

    if (The_Maybe.value_full() != The_Value) {
      Complain(The_Case, "Full maybe returns wrong value to value__full");
    }
  }
  if (Not_Good) {
    if (Is_Empty)
      printf("Given: Empty\n");
    else
      printf("Given: Full, Value %c\n", The_Value);

    if (The_Maybe.is_empty())
      printf("Found: Empty, Value %d\n", The_Maybe.value_empty());
    else
      printf("Found: Full, Value %c\n", The_Maybe.value_full());
  }
  return (! Not_Good);
}
#endif // CHARTEST

#ifdef BOOLTEST
bool test_arrayB(th_array<bool> The_Array, bool Is_Empty, int The_Length,
		int The_Low, bool The_Bottom, bool The_Top,
		char *The_Case)
{
  bool Not_Good = FALSE;
  int  The_High = (The_Low + The_Length - 1);
  bool  T = FALSE;
  bool  B = FALSE;
  bool  Tf = FALSE;
  bool  Bf = FALSE;

  th_assert_no_exceptions();

  if (Is_Empty) {
    if (! The_Array.empty()) {
      Complain(The_Case, "Array should be empty and is not");
      Not_Good = TRUE;
    }
  } else {
    if (The_Array.empty()) {
      Complain(The_Case, "Array should not be empty and is");
      Not_Good = TRUE;
    }
  };

  th_assert_no_exceptions();

  if (The_Length != The_Array.length()) {
    Complain(The_Case, "Length of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_Low != The_Array.low()) {
    Complain(The_Case, "Low of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_High != The_Array.high()) {
    Complain(The_Case, "High of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (Is_Empty) {
    B = The_Array.bottom();
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to bottom");
      Not_Good = TRUE;
    }
    Bf = The_Array.fetch(The_Low);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal fetch at low");
      Not_Good = TRUE;
    }
  } else {
    B = The_Array.bottom();
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to bottom");
      Not_Good = TRUE;
    } else {
      if (The_Bottom != B) {
	Complain(The_Case, "Bottom of array is not correct");
	Not_Good = TRUE;
     }
    }
    Bf = The_Array.fetch(The_Low);
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to fetch at low");
      Not_Good = TRUE;
    } else {
      if (The_Bottom != Bf) {
	Complain(The_Case, "Low element of array is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Is_Empty) {
    T = The_Array.top();
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to top");
      Not_Good = TRUE;
    }
    Tf = The_Array.fetch(The_High);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to fetch at high");
      Not_Good = TRUE;
    }
  } else {
    T = The_Array.top();
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to top");
      Not_Good = TRUE;
    } else {
      if (The_Top != T) {
	Complain(The_Case, "Top of array is not correct");
	Not_Good = TRUE;
      }
    }
    Tf = The_Array.fetch(The_High);
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to fetch at high");
      Not_Good = TRUE;
    } else {
      if (The_Top != Tf) {
	Complain(The_Case, "High element of array is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Not_Good) {
    if (Is_Empty)
      printf("Given: Empty, Low %d, Length %d, High %d\n",
	     The_Low, The_Length, The_High);
    else
      printf("Given: Non-Empty, Low %d, Length %d, High %d, Bottom %c, Top %c\n",
	     The_Low, The_Length, The_High, The_Bottom, The_Top);
    if (The_Array.empty())
      printf("Found: Empty, Low %d, Length %d, High %d\n",
	     The_Array.low(), The_Array.length(), The_Array.high());
    else
      printf("Found: Non-Empty, Low %d, Length %d, High %d, Bottom %d, Top %d, LowE %d, HighE %d\n",
	     The_Array.low(), The_Array.length(), The_Array.high(), B, T, Bf, Tf);
  }
  return (! Not_Good);
}

bool test_vectorB(th_vector<bool> The_Vector, int The_Length,
		bool The_First, bool The_Last, char *The_Case)
{
  bool Not_Good = FALSE;
  bool  F = FALSE;
  bool  L = FALSE;

  th_assert_no_exceptions();

  if (The_Length != The_Vector.length()) {
    Complain(The_Case, "Length of vector is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_Length == 0) {
    F = The_Vector.fetch(1);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty vector did not signal bounds to fetch");
      Not_Good = TRUE;
    }
  } else {

  th_assert_no_exceptions();

    int th_F =The_Vector.fetch(1);

  th_assert_no_exceptions();

  F = th_F;
  th_assert_no_exceptions();

    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty vector did signal bounds to fetch(1)");
      Not_Good = TRUE;
    } else {

  th_assert_no_exceptions();

      if (The_First != F) {
	Complain(The_Case, "First element of vector is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (The_Length != 0) {
    L = The_Vector.fetch(The_Length); 
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty vector did signal bounds to fetch(Length)");
      Not_Good = TRUE;
    } else {
      if (The_Last != L) {
	Complain(The_Case, "Last element of vector is not correct");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Not_Good) {
    if (The_Length == 0)
      printf("Given: Length %d\n",
	     The_Length);
    else
      printf("Given: Length %d, First %c, Last %c\n",
	     The_Length, The_First, The_Last);

    if (The_Vector.length() == 0)
      printf("Found: Length %d\n",
	     The_Vector.length());
    else
      printf("Found: Length %d, First %d, Last %d\n",
	     The_Vector.length(), F, L);
  }
  return (! Not_Good);
}


bool test_maybeB(th_maybe<bool> The_Maybe, bool Is_Empty,
		bool The_Value, char *The_Case)
{
  bool Not_Good = FALSE;
  bool V = FALSE;

  th_assert_no_exceptions();

  if (Is_Empty) {
    if (! The_Maybe.is_empty()) {
      Complain(The_Case, "Empty maybe returns FALSE to is_empty");
      Not_Good = TRUE;
    }
    
    th_assert_no_exceptions();

    if (The_Maybe.is_full()) {
      Complain(The_Case, "Empty maybe returns TRUE to is_full");
    }

    th_assert_no_exceptions();

    if (The_Maybe.value_empty() != th_nil) {
      Complain(The_Case, "Empty maybe has value not = nil");
    }

    th_assert_no_exceptions();

    bool V2 = The_Maybe.value_full();
    if (!th_catch("wrong_tag")) {
      Complain(The_Case, "Empty maybe does not signal wrong_tag to value_full");
    }

    th_assert_no_exceptions();

  } else {
    if (The_Maybe.is_empty()) {
      Complain(The_Case, "Full maybe returns TRUE to is_empty");
      Not_Good = TRUE;
    }
    
    th_assert_no_exceptions();

    if (! The_Maybe.is_full()) {
      Complain(The_Case, "Full maybe returns FALSE to is_full");
    }

    th_assert_no_exceptions();

    null N = The_Maybe.value_empty();
    if (!th_catch("wrong_tag")) {
      Complain(The_Case, "Full maybe does not signal wrong_tag to value_empty");
  }

    th_assert_no_exceptions();

    if (The_Maybe.value_full() != The_Value) {
      Complain(The_Case, "Full maybe returns wrong value to value__full");
    }
  }
  if (Not_Good) {
    if (Is_Empty)
      printf("Given: Empty\n");
    else
      printf("Given: Full, Value %d\n", The_Value);

    if (The_Maybe.is_empty())
      printf("Found: Empty, Value %d\n", The_Maybe.value_empty());
    else
      printf("Found: Full, Value %d\n", The_Maybe.value_full());
  }
  return (! Not_Good);
}
#endif // BOOLTEST


#ifdef NULLTEST
bool test_arrayN(th_array<null> The_Array, bool Is_Empty, int The_Length,
		int The_Low, null The_Bottom, null The_Top,
		char *The_Case)
{
  bool Not_Good = FALSE;
  int  The_High = (The_Low + The_Length - 1);
  null  T = th_nil;
  null  B = th_nil;
  null  Tf = th_nil;
  null  Bf = th_nil;

  th_assert_no_exceptions();

  if (Is_Empty) {
    if (! The_Array.empty()) {
      Complain(The_Case, "Array should be empty and is not");
      Not_Good = TRUE;
    }
  } else {
    if (The_Array.empty()) {
      Complain(The_Case, "Array should not be empty and is");
      Not_Good = TRUE;
    }
  };

  th_assert_no_exceptions();

  if (The_Length != The_Array.length()) {
    Complain(The_Case, "Length of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_Low != The_Array.low()) {
    Complain(The_Case, "Low of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_High != The_Array.high()) {
    Complain(The_Case, "High of array is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (Is_Empty) {
    B = The_Array.bottom();
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to bottom");
      Not_Good = TRUE;
    }
    Bf = The_Array.fetch(The_Low);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal fetch at low");
      Not_Good = TRUE;
    }
  } else {
    B = The_Array.bottom();
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to bottom");
      Not_Good = TRUE;
    } else {
      if (The_Bottom != B) {
	Complain(The_Case, "Bottom of array is not correct");
	Not_Good = TRUE;
     }
    }
    Bf = The_Array.fetch(The_Low);
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to fetch at low");
      Not_Good = TRUE;
    } else {
      if (The_Bottom != Bf) {
	Complain(The_Case, "Low element of array is not correct");
	Not_Good = TRUE;
      }
    }
    Tf = The_Array.fetch(The_Low-1);
    if (! th_catch("overflow")) {
      if (! th_catch("bounds")) {
	Complain(The_Case, "Non empty array did not signal bounds to fetch at Low-1");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Is_Empty) {
    T = The_Array.top();
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to top");
      Not_Good = TRUE;
    }
    Tf = The_Array.fetch(The_High);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty array did not signal bounds to fetch at high");
      Not_Good = TRUE;
    }
  } else {
    T = The_Array.top();
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to top");
      Not_Good = TRUE;
    } else {
      if (The_Top != T) {
	Complain(The_Case, "Top of array is not correct");
	Not_Good = TRUE;
      }
    }
    Tf = The_Array.fetch(The_High);
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty array did signal bounds to fetch at high");
      Not_Good = TRUE;
    } else {
      if (The_Top != Tf) {
	Complain(The_Case, "High element of array is not correct");
	Not_Good = TRUE;
      }
    }
    Tf = The_Array.fetch(The_High+1);
    if (! th_catch("overflow")) {
      if (! th_catch("bounds")) {
	Complain(The_Case, "Non empty array did not signal bounds to fetch at high+1");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Not_Good) {
    if (Is_Empty)
      printf("Given: Empty, Low %d, Length %d, High %d\n",
	     The_Low, The_Length, The_High);
    else
      printf("Given: Non-Empty, Low %d, Length %d, High %d, Bottom %c, Top %c\n",
	     The_Low, The_Length, The_High, The_Bottom, The_Top);
    if (The_Array.empty())
      printf("Found: Empty, Low %d, Length %d, High %d\n",
	     The_Array.low(), The_Array.length(), The_Array.high());
    else
      printf("Found: Non-Empty, Low %d, Length %d, High %d, Bottom %d, Top %d, LowE %d, HighE %d\n",
	     The_Array.low(), The_Array.length(), The_Array.high(), B, T, Bf, Tf);
  }
  return (! Not_Good);
}

bool test_vectorN(th_vector<null> The_Vector, int The_Length,
		null The_First, null The_Last, char *The_Case)
{
  bool Not_Good = FALSE;
  null  F = th_nil;
  null  L = th_nil;

  th_assert_no_exceptions();

  if (The_Length != The_Vector.length()) {
    Complain(The_Case, "Length of vector is not correct");
    Not_Good = TRUE;
  }

  th_assert_no_exceptions();

  if (The_Length == 0) {
    F = The_Vector.fetch(1);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Empty vector did not signal bounds to fetch");
      Not_Good = TRUE;
    }
  } else {

    th_assert_no_exceptions();

    F =The_Vector.fetch(1);
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty vector did signal bounds to fetch(1)");
      Not_Good = TRUE;
    } else {

      th_assert_no_exceptions();

      if (The_First != F) {
	Complain(The_Case, "First element of vector is not correct");
	Not_Good = TRUE;
      }
    }
    F = The_Vector.fetch(0);
    if (! th_catch("bounds")) {
      Complain(The_Case, "Non empty vector did not signal bounds to fetch(0)");
      Not_Good = TRUE;
    }
  }

  th_assert_no_exceptions();

  if (The_Length != 0) {
    L = The_Vector.fetch(The_Length); 
    if (th_catch("bounds")) {
      Complain(The_Case, "Non empty vector did signal bounds to fetch(Length)");
      Not_Good = TRUE;
    } else {
      if (The_Last != L) {
	Complain(The_Case, "Last element of vector is not correct");
	Not_Good = TRUE;
      }
    }
    L = The_Vector.fetch(The_Length+1);
    if (! th_catch("overflow")) {
      if (! th_catch("bounds")) {
	Complain(The_Case, "Non empty vector did not signal bounds to fetch(Length+1)");
	Not_Good = TRUE;
      }
    }
  }

  th_assert_no_exceptions();

  if (Not_Good) {
    if (The_Length == 0)
      printf("Given: Length %d\n",
	     The_Length);
    else
      printf("Given: Length %d, First %c, Last %c\n",
	     The_Length, The_First, The_Last);

    if (The_Vector.length() == 0)
      printf("Found: Length %d\n",
	     The_Vector.length());
    else
      printf("Found: Length %d, First %d, Last %d\n",
	     The_Vector.length(), F, L);
  }
  return (! Not_Good);
}


bool test_maybeN(th_maybe<null> The_Maybe, bool Is_Empty,
		null The_Value, char *The_Case)
{
  bool Not_Good = FALSE;
  null V = th_nil;

  th_assert_no_exceptions();

  if (Is_Empty) {
    if (! The_Maybe.is_empty()) {
      Complain(The_Case, "Empty maybe returns FALSE to is_empty");
      Not_Good = TRUE;
    }
    
    th_assert_no_exceptions();

    if (The_Maybe.is_full()) {
      Complain(The_Case, "Empty maybe returns TRUE to is_full");
    }

    th_assert_no_exceptions();

    if (The_Maybe.value_empty() != th_nil) {
      Complain(The_Case, "Empty maybe has value not = nil");
    }

    th_assert_no_exceptions();

    null V2 = The_Maybe.value_full();
    if (!th_catch("wrong_tag")) {
      Complain(The_Case, "Empty maybe does not signal wrong_tag to value_full");
    }

    th_assert_no_exceptions();

  } else {
    if (The_Maybe.is_empty()) {
      Complain(The_Case, "Full maybe returns TRUE to is_empty");
      Not_Good = TRUE;
    }
    
    th_assert_no_exceptions();

    if (! The_Maybe.is_full()) {
      Complain(The_Case, "Full maybe returns FALSE to is_full");
    }

    th_assert_no_exceptions();

    null N = The_Maybe.value_empty();
    if (!th_catch("wrong_tag")) {
      Complain(The_Case, "Full maybe does not signal wrong_tag to value_empty");
  }

    th_assert_no_exceptions();

    if (The_Maybe.value_full() != The_Value) {
      Complain(The_Case, "Full maybe returns wrong value to value__full");
    }
  }
  if (Not_Good) {
    if (Is_Empty)
      printf("Given: Empty\n");
    else
      printf("Given: Full, Value %d\n", The_Value);

    if (The_Maybe.is_empty())
      printf("Found: Empty, Value %d\n", The_Maybe.value_empty());
    else
      printf("Found: Full, Value %d\n", The_Maybe.value_full());
  }
  return (! Not_Good);
}
#endif // NULLTEST
