/* Copyright Barbara Liskov, MIT, 1996 */

/*
    This program tests whether failure works properly in the binary veneer.
    Warning: requires PROMISES, because otherwise basic values need to work.
*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "common/th_assert.h"
#include "thor.h"
#include "th_int.h"

void try_exc()
{
    th_int *i = new th_int(300);
    char ch = i->toChar();

    char exc[100];

    if (th_catch_any(exc))
      printf("Exception: %s\n", exc);
    else
      printf("Character 300 is %c\n", ch);
}

void main(int argc, char **argv)
{
    int c;
    char *fe_spec=0;
    while (EOF != (c = getopt(argc, argv, "f:"))) {
	switch (c) {
	    case 'f': fe_spec = optarg; break;
	    default:
		fprintf(stderr, "Usage: %s [-f fespec]\n", argv[0]);
		exit(EXIT_FAILURE);
		break;
	}
    }

    if (!open_frontend (fe_spec, "")) exit(1);

    try_exc();
    try_exc();
}
