/* Copyright Barbara Liskov, MIT, 1996 */

#ifndef _THETA_H
#define _THETA_H

/*
    PUBLIC_THETA_OR defines the name of the node on which the compiler's
    OR (Object Repository) is running.  The format is 

	THOR=<nodename>:<portnumber>

    where nodename is installation specific, i.e., you NEED TO CHANGE
    "note" to something else.
*/

#define PUBLIC_THETA_OR "clef:42"
#define PRIVATE_THETA_OR "clef:97"

enum Action {NONE, PARSE, CHECK, COMPILE, INIT, SHOW, EXPUNGE};
enum ErrorOption {MINIMAL, ONE, SURROUND};

#include "binary_veneer.h"
#include "th_Compiler.h"
#include "th_list.h"
#include "th_Class.h"
#include "th_string.h"
#include <unistd.h>

typedef char *Token;
typedef char *Result;

class Executor {
public:
	int expunge();
	int show();
	int compile(Token fname);
	int parse(Token fname);
	int check(Token fname);
	void done();
	int init(char *fe_spec);
	void set_err_opt(ErrorOption eopt) { err_opt = eopt; }
	Executor() {
		fe_open = FALSE;
		err_opt = MINIMAL;
		}
private:
	int handle_fname(Token fname, th_string &th_fname);
	int process_result(Result result, char *fname);
	th_Compiler cmp;
	bool fe_open;
	ErrorOption err_opt;
};

class Processor {
public:
	int done();
	int process_token(Token t);
	Processor() {
		executor = new Executor();
		action = NONE;
		}
private:
	Executor *executor;
	Action action;
};

class UserIo {
public:
	int get_next_token(Token *tp);

	UserIo(int argc_, char **argv_) {
		argc = argc_;
		argv = argv_;
		argindex = 1;
		}
private:
	int argc;
	char **argv;
	int argindex;
};

#endif /* _THETA_H */
